/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.synchronization;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.synchronization.ChangeNumber;
import org.opends.server.synchronization.SynchronizationDomain;
import org.opends.server.synchronization.SynchronizationMessage;
import org.opends.server.synchronization.UpdateMessage;

public class AckMessage
extends SynchronizationMessage
implements Serializable {
    private static final long serialVersionUID = -8695651898339602441L;
    private ChangeNumber changeNumber;

    public AckMessage(ChangeNumber changeNumber) {
        this.changeNumber = changeNumber;
    }

    public AckMessage(byte[] byArray) throws DataFormatException {
        try {
            if (byArray[0] != 5) {
                throw new DataFormatException("byte[] is not a valid modify msg");
            }
            int n = 1;
            String string = new String(byArray, n, 24, "UTF-8");
            this.changeNumber = new ChangeNumber(string);
            n += 24;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public ChangeNumber getChangeNumber() {
        return this.changeNumber;
    }

    public UpdateMessage processReceive(SynchronizationDomain synchronizationDomain) {
        synchronizationDomain.receiveAck(this);
        return null;
    }

    public byte[] getBytes() {
        try {
            int n = 25;
            byte[] byArray = new byte[n];
            int n2 = 1;
            byArray[0] = 5;
            byte[] byArray2 = this.getChangeNumber().toString().getBytes("UTF-8");
            int n3 = 0;
            while (n3 < 24) {
                byArray[n2] = byArray2[n3];
                ++n3;
                ++n2;
            }
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

