/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;

public class UUIDEqualityMatchingRule
extends EqualityMatchingRule {
    private static final String CLASS_NAME = "org.opends.server.schema.UUIDEqualityMatchingRule";

    public UUIDEqualityMatchingRule() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeMatchingRule(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMatchingRule", String.valueOf(configEntry)));
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return "uuidMatch";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.1.16.2";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return null;
    }

    public String getSyntaxOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxOID", new String[0]));
        return "1.3.6.1.1.16.1";
    }

    public ByteString normalizeValue(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "normalizeValue", String.valueOf(byteString)));
        byte[] byArray = byteString.value();
        if (byArray.length != 36) {
            int n = 6422764;
            String string = MessageHandler.getMessage(n, byteString.stringValue(), byArray.length);
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string, n);
                }
                case WARN: {
                    Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.MILD_ERROR, string, n);
                    return new ASN1OctetString(byArray);
                }
            }
            return new ASN1OctetString(byArray);
        }
        byte[] byArray2 = new byte[36];
        System.arraycopy(byArray, 0, byArray2, 0, 36);
        block24: for (int i = 0; i < 36; ++i) {
            switch (i) {
                case 8: 
                case 13: 
                case 18: 
                case 23: {
                    if (byArray2[i] == 45) continue block24;
                    int n = 6422765;
                    String string = MessageHandler.getMessage(n, byteString.stringValue(), i, String.valueOf(byArray2[i]));
                    switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                        case REJECT: {
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string, n);
                        }
                        case WARN: {
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.MILD_ERROR, string, n);
                            return new ASN1OctetString(byArray);
                        }
                    }
                    return new ASN1OctetString(byArray);
                }
                default: {
                    switch (byArray2[i]) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: {
                            continue block24;
                        }
                        case 65: {
                            byArray2[i] = 97;
                            continue block24;
                        }
                        case 66: {
                            byArray2[i] = 98;
                            continue block24;
                        }
                        case 67: {
                            byArray2[i] = 99;
                            continue block24;
                        }
                        case 68: {
                            byArray2[i] = 100;
                            continue block24;
                        }
                        case 69: {
                            byArray2[i] = 101;
                            continue block24;
                        }
                        case 70: {
                            byArray2[i] = 102;
                            continue block24;
                        }
                    }
                    int n = 6422766;
                    String string = MessageHandler.getMessage(n, byteString.stringValue(), i, String.valueOf(byArray2[i]));
                    switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                        case REJECT: {
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string, n);
                        }
                        case WARN: {
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.MILD_ERROR, string, n);
                            return new ASN1OctetString(byArray);
                        }
                    }
                    return new ASN1OctetString(byArray);
                }
            }
        }
        return new ASN1OctetString(byArray2);
    }

    public boolean areEqual(ByteString byteString, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "areEqual", String.valueOf(byteString), String.valueOf(byteString2)));
        return Arrays.equals(byteString.value(), byteString2.value());
    }
}

