/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;

public class IntegerEqualityMatchingRule
extends EqualityMatchingRule {
    private static final String CLASS_NAME = "org.opends.server.schema.IntegerEqualityMatchingRule";

    public IntegerEqualityMatchingRule() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeMatchingRule(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMatchingRule", String.valueOf(configEntry)));
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return "integerMatch";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "2.5.13.14";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return null;
    }

    public String getSyntaxOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.27";
    }

    public ByteString normalizeValue(ByteString byteString) throws DirectoryException {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "normalizeValue", String.valueOf(byteString)));
        byte[] byArray = byteString.value();
        int n2 = byArray.length;
        StringBuilder stringBuilder = new StringBuilder(n2);
        boolean bl = false;
        block41: for (n = 0; n < n2; ++n) {
            switch (byArray[n]) {
                case 48: {
                    String string;
                    int n3;
                    switch (stringBuilder.length()) {
                        case 0: {
                            if (n == n2 - 1) {
                                stringBuilder.append("0");
                                continue block41;
                            }
                            n3 = 6422571;
                            string = MessageHandler.getMessage(n3, byteString.stringValue());
                            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                                case REJECT: {
                                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string, n3);
                                }
                                case WARN: {
                                    if (bl) break;
                                    bl = true;
                                    Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n3);
                                }
                            }
                            continue block41;
                        }
                        case 1: {
                            if (stringBuilder.charAt(0) == '-') {
                                n3 = 6422571;
                                string = MessageHandler.getMessage(n3, byteString.stringValue());
                                switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                                    case REJECT: {
                                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string, n3);
                                    }
                                    case WARN: {
                                        if (bl) break;
                                        bl = true;
                                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n3);
                                    }
                                }
                                continue block41;
                            }
                            stringBuilder.append("0");
                            continue block41;
                        }
                    }
                    stringBuilder.append("0");
                    continue block41;
                }
                case 49: {
                    stringBuilder.append('1');
                    continue block41;
                }
                case 50: {
                    stringBuilder.append('2');
                    continue block41;
                }
                case 51: {
                    stringBuilder.append('3');
                    continue block41;
                }
                case 52: {
                    stringBuilder.append('4');
                    continue block41;
                }
                case 53: {
                    stringBuilder.append('5');
                    continue block41;
                }
                case 54: {
                    stringBuilder.append('6');
                    continue block41;
                }
                case 55: {
                    stringBuilder.append('7');
                    continue block41;
                }
                case 56: {
                    stringBuilder.append('8');
                    continue block41;
                }
                case 57: {
                    stringBuilder.append('9');
                    continue block41;
                }
                case 45: {
                    if (stringBuilder.length() == 0) {
                        stringBuilder.append("-");
                        continue block41;
                    }
                    int n3 = 6422572;
                    String string = MessageHandler.getMessage(n3, byteString.stringValue());
                    switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                        case REJECT: {
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string, n3);
                        }
                        case WARN: {
                            if (bl) break;
                            bl = true;
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n3);
                        }
                    }
                    continue block41;
                }
                default: {
                    int n3 = 6422573;
                    String string = MessageHandler.getMessage(n3, byteString.stringValue(), Character.valueOf((char)byArray[n]), n);
                    switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                        case REJECT: {
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string, n3);
                        }
                        case WARN: {
                            if (bl) continue block41;
                            bl = true;
                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n3);
                        }
                    }
                }
            }
        }
        if (stringBuilder.length() == 0) {
            n = 6422574;
            String string = MessageHandler.getMessage(n, byteString.stringValue());
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string, n);
                }
                case WARN: {
                    if (!bl) {
                        bl = true;
                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n);
                    }
                    stringBuilder.append("0");
                    break;
                }
                default: {
                    stringBuilder.append("0");
                    break;
                }
            }
        } else if (stringBuilder.length() == 1 && stringBuilder.charAt(0) == '-') {
            n = 6422575;
            String string = MessageHandler.getMessage(n, byteString.stringValue());
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string, n);
                }
                case WARN: {
                    if (!bl) {
                        bl = true;
                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n);
                    }
                    stringBuilder.setCharAt(0, '0');
                    break;
                }
                default: {
                    stringBuilder.setCharAt(0, '0');
                }
            }
        }
        return new ASN1OctetString(stringBuilder.toString());
    }

    public boolean areEqual(ByteString byteString, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "areEqual", String.valueOf(byteString), String.valueOf(byteString2)));
        return Arrays.equals(byteString.value(), byteString2.value());
    }
}

