/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;

public class GeneralizedTimeSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.GeneralizedTimeSyntax";
    private static ReentrantLock dateFormatLock;
    private static SimpleDateFormat dateFormat;
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    public GeneralizedTimeSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.27");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.27", "GeneralizedTime");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.28");
        if (this.defaultOrderingMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.28", "GeneralizedTime");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "GeneralizedTime");
        }
    }

    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "GeneralizedTime";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.24";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "Generalized Time";
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return this.defaultOrderingMatchingRule;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return this.defaultSubstringMatchingRule;
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        char c;
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        String string = byteString.stringValue().toUpperCase();
        int n = string.length();
        if (n < 11) {
            int n2 = 6422541;
            String string2 = MessageHandler.getMessage(n2, string);
            stringBuilder.append(string2);
            return false;
        }
        block64: for (c = '\u0000'; c < '\u0004'; ++c) {
            switch (string.charAt(c)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block64;
                }
                default: {
                    int n3 = 6422542;
                    String string3 = MessageHandler.getMessage(n3, string, Character.valueOf(string.charAt(c)));
                    stringBuilder.append(string3);
                    return false;
                }
            }
        }
        c = string.charAt(4);
        char c2 = string.charAt(5);
        block3 : switch (c) {
            case '0': {
                switch (c2) {
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block3;
                    }
                }
                int n4 = 6422543;
                String string4 = MessageHandler.getMessage(n4, string, string.substring(4, 6));
                stringBuilder.append(string4);
                return false;
            }
            case '1': {
                switch (c2) {
                    case '0': 
                    case '1': 
                    case '2': {
                        break block3;
                    }
                }
                int n5 = 6422543;
                String string5 = MessageHandler.getMessage(n5, string, string.substring(4, 6));
                stringBuilder.append(string5);
                return false;
            }
            default: {
                int n6 = 6422543;
                String string6 = MessageHandler.getMessage(n6, string, string.substring(4, 6));
                stringBuilder.append(string6);
                return false;
            }
        }
        char c3 = string.charAt(6);
        char c4 = string.charAt(7);
        block13 : switch (c3) {
            case '0': {
                switch (c4) {
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block13;
                    }
                }
                int n7 = 6422544;
                String string7 = MessageHandler.getMessage(n7, string, string.substring(6, 8));
                stringBuilder.append(string7);
                return false;
            }
            case '1': 
            case '2': {
                switch (c4) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block13;
                    }
                }
                int n8 = 6422544;
                String string8 = MessageHandler.getMessage(n8, string, string.substring(6, 8));
                stringBuilder.append(string8);
                return false;
            }
            case '3': {
                switch (c4) {
                    case '0': 
                    case '1': {
                        break block13;
                    }
                }
                int n9 = 6422544;
                String string9 = MessageHandler.getMessage(n9, string, string.substring(6, 8));
                stringBuilder.append(string9);
                return false;
            }
            default: {
                int n10 = 6422544;
                String string10 = MessageHandler.getMessage(n10, string, string.substring(6, 8));
                stringBuilder.append(string10);
                return false;
            }
        }
        char c5 = string.charAt(8);
        char c6 = string.charAt(9);
        block27 : switch (c5) {
            case '0': 
            case '1': {
                switch (c6) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block27;
                    }
                }
                int n11 = 6422545;
                String string11 = MessageHandler.getMessage(n11, string, string.substring(8, 10));
                stringBuilder.append(string11);
                return false;
            }
            case '2': {
                switch (c6) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': {
                        break block27;
                    }
                }
                int n12 = 6422545;
                String string12 = MessageHandler.getMessage(n12, string, string.substring(8, 10));
                stringBuilder.append(string12);
                return false;
            }
            default: {
                int n13 = 6422545;
                String string13 = MessageHandler.getMessage(n13, string, string.substring(8, 10));
                stringBuilder.append(string13);
                return false;
            }
        }
        c = string.charAt(10);
        block37 : switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                if (n < 13) {
                    int n14 = 6422551;
                    String string14 = MessageHandler.getMessage(n14, string, Character.valueOf(c), 10);
                    stringBuilder.append(string14);
                    return false;
                }
                switch (string.charAt(11)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block37;
                    }
                }
                int n15 = 6422546;
                String string15 = MessageHandler.getMessage(n15, string, string.substring(10, 12));
                stringBuilder.append(string15);
                return false;
            }
            case 'Z': {
                if (n == 11) {
                    return true;
                }
                int n16 = 6422551;
                String string16 = MessageHandler.getMessage(n16, string, Character.valueOf(c), 10);
                stringBuilder.append(string16);
                return false;
            }
            case '+': 
            case '-': {
                if (n == 13 || n == 15) {
                    return this.hasValidOffset(string, 11, stringBuilder);
                }
                int n17 = 6422551;
                String string17 = MessageHandler.getMessage(n17, string, Character.valueOf(c), 10);
                stringBuilder.append(string17);
                return false;
            }
            default: {
                int n18 = 6422551;
                String string18 = MessageHandler.getMessage(n18, string, Character.valueOf(c), 10);
                stringBuilder.append(string18);
                return false;
            }
        }
        char c7 = string.charAt(12);
        block45 : switch (c7) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                if (n < 15) {
                    int n19 = 6422551;
                    String string19 = MessageHandler.getMessage(n19, string, Character.valueOf(c7), 12);
                    stringBuilder.append(string19);
                    return false;
                }
                switch (string.charAt(13)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block45;
                    }
                }
                int n20 = 6422547;
                String string20 = MessageHandler.getMessage(n20, string, string.substring(12, 14));
                stringBuilder.append(string20);
                return false;
            }
            case '6': {
                if (n < 15) {
                    int n21 = 6422551;
                    String string21 = MessageHandler.getMessage(n21, string, Character.valueOf(c7), 12);
                    stringBuilder.append(string21);
                    return false;
                }
                if (string.charAt(13) == '0') break;
                int n22 = 6422547;
                String string22 = MessageHandler.getMessage(n22, string, string.substring(12, 14));
                stringBuilder.append(string22);
                return false;
            }
            case 'Z': {
                if (n == 13) {
                    return true;
                }
                int n23 = 6422551;
                String string23 = MessageHandler.getMessage(n23, string, Character.valueOf(c7), 12);
                stringBuilder.append(string23);
                return false;
            }
            case '+': 
            case '-': {
                if (n == 15 || n == 17) {
                    return this.hasValidOffset(string, 13, stringBuilder);
                }
                int n24 = 6422551;
                String string24 = MessageHandler.getMessage(n24, string, Character.valueOf(c7), 12);
                stringBuilder.append(string24);
                return false;
            }
            default: {
                int n25 = 6422551;
                String string25 = MessageHandler.getMessage(n25, string, Character.valueOf(c7), 12);
                stringBuilder.append(string25);
                return false;
            }
        }
        switch (string.charAt(14)) {
            case ',': 
            case '.': {
                boolean bl = false;
                block65: for (int i = 15; i < n; ++i) {
                    switch (string.charAt(i)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            if (i <= 17) continue block65;
                            int n26 = 6422549;
                            String string26 = MessageHandler.getMessage(n26, byteString);
                            stringBuilder.append(string26);
                            return false;
                        }
                        case 'Z': {
                            if (i == 15) {
                                int n27 = 6422548;
                                String string27 = MessageHandler.getMessage(n27, byteString);
                                stringBuilder.append(string27);
                                return false;
                            }
                            if (i != n - 1) {
                                int n28 = 6422551;
                                String string28 = MessageHandler.getMessage(n28, string, Character.valueOf(string.charAt(i)), i);
                                stringBuilder.append(string28);
                                return false;
                            }
                            return true;
                        }
                        case '+': 
                        case '-': {
                            if (i == 15) {
                                int n29 = 6422548;
                                String string29 = MessageHandler.getMessage(n29, byteString);
                                stringBuilder.append(string29);
                                return false;
                            }
                            if (n != 17 && n != 19) {
                                int n30 = 6422551;
                                String string30 = MessageHandler.getMessage(n30, string, Character.valueOf(string.charAt(i)), i);
                                stringBuilder.append(string30);
                                return false;
                            }
                            return this.hasValidOffset(string, i + 1, stringBuilder);
                        }
                        default: {
                            int n31 = 6422551;
                            String string31 = MessageHandler.getMessage(n31, string, Character.valueOf(string.charAt(i)), i);
                            stringBuilder.append(string31);
                            return false;
                        }
                    }
                }
                if (n >= 16) break;
                int n32 = 6422551;
                String string32 = MessageHandler.getMessage(n32, string, Character.valueOf(c7), 12);
                stringBuilder.append(string32);
                return false;
            }
            case 'Z': {
                if (n == 15) {
                    return true;
                }
                int n33 = 6422551;
                String string33 = MessageHandler.getMessage(n33, string, Character.valueOf(string.charAt(14)), 14);
                stringBuilder.append(string33);
                return false;
            }
            case '+': 
            case '-': {
                if (n == 17 || n == 19) {
                    return this.hasValidOffset(string, 15, stringBuilder);
                }
                int n34 = 6422551;
                String string34 = MessageHandler.getMessage(n34, string, Character.valueOf(string.charAt(14)), 14);
                stringBuilder.append(string34);
                return false;
            }
            default: {
                int n35 = 6422551;
                String string35 = MessageHandler.getMessage(n35, string, Character.valueOf(string.charAt(14)), 14);
                stringBuilder.append(string35);
                return false;
            }
        }
        return true;
    }

    private boolean hasValidOffset(String string, int n, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "hasValidOffset", String.valueOf(string), String.valueOf(n), "java.lang.StringBuilder"));
        int n2 = string.length() - n;
        if (n2 < 2) {
            int n3 = 6422541;
            String string2 = MessageHandler.getMessage(n3, string);
            stringBuilder.append(string2);
            return false;
        }
        block0 : switch (string.charAt(n)) {
            case '0': 
            case '1': {
                switch (string.charAt(n + 1)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block0;
                    }
                }
                int n4 = 6422550;
                String string3 = MessageHandler.getMessage(n4, string, string.substring(n, n + n2));
                stringBuilder.append(string3);
                return false;
            }
            case '2': {
                switch (string.charAt(n + 1)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': {
                        break block0;
                    }
                }
                int n5 = 6422550;
                String string4 = MessageHandler.getMessage(n5, string, string.substring(n, n + n2));
                stringBuilder.append(string4);
                return false;
            }
            default: {
                int n6 = 6422550;
                String string5 = MessageHandler.getMessage(n6, string, string.substring(n, n + n2));
                stringBuilder.append(string5);
                return false;
            }
        }
        if (n2 == 4) {
            block10 : switch (string.charAt(n + 2)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': {
                    switch (string.charAt(n + 3)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break block10;
                        }
                    }
                    int n7 = 6422550;
                    String string6 = MessageHandler.getMessage(n7, string, string.substring(n, n + n2));
                    stringBuilder.append(string6);
                    return false;
                }
                default: {
                    int n8 = 6422550;
                    String string7 = MessageHandler.getMessage(n8, string, string.substring(n, n + n2));
                    stringBuilder.append(string7);
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(Date date) {
        assert (Debug.debugEnter(CLASS_NAME, "formatGeneralizedTime", String.valueOf(date)));
        dateFormatLock.lock();
        try {
            String string = dateFormat.format(date);
            return string;
        }
        finally {
            dateFormatLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(long l) {
        assert (Debug.debugEnter(CLASS_NAME, "formatGeneralizedTime", String.valueOf(l)));
        dateFormatLock.lock();
        try {
            String string = dateFormat.format(new Date(l));
            return string;
        }
        finally {
            dateFormatLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttributeValue createGeneralizedTimeValue(long l) {
        String string;
        assert (Debug.debugEnter(CLASS_NAME, "createGeneralizedTimeValue", String.valueOf(l)));
        dateFormatLock.lock();
        try {
            string = dateFormat.format(new Date(l));
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createGeneralizedTimeValue", exception));
            string = null;
        }
        finally {
            dateFormatLock.unlock();
        }
        return new AttributeValue(new ASN1OctetString(string), (ByteString)new ASN1OctetString(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long decodeGeneralizedTimeValue(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "decodeGeneralizedTimeValue", String.valueOf(byteString)));
        String string = byteString.stringValue();
        try {
            dateFormatLock.lock();
            try {
                long l = dateFormat.parse(string).getTime();
                return l;
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                dateFormatLock.unlock();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeGeneralizedTimeValue", exception));
            int n = 6422552;
            String string2 = MessageHandler.getMessage(n, string, String.valueOf(exception));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n, exception);
        }
    }

    static {
        dateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
        dateFormat.setLenient(false);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        dateFormatLock = new ReentrantLock();
    }
}

