/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.Schema;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.DITContentRule;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ObjectClassType;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DITContentRuleSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.DITContentRuleSyntax";
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    public DITContentRuleSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.2", "DITContentRuleDescription");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.3", "DITContentRuleDescription");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "DITContentRuleDescription");
        }
    }

    @Override
    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "DITContentRuleDescription";
    }

    @Override
    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.16";
    }

    @Override
    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "DIT Content Rule Description";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        try {
            DITContentRuleSyntax.decodeDITContentRule(byteString, DirectoryServer.getSchema());
            return true;
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "valueIsAcceptable", directoryException));
            stringBuilder.append(directoryException.getErrorMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static DITContentRule decodeDITContentRule(ByteString byteString, Schema schema) throws DirectoryException {
        String string;
        int n;
        char c;
        int n2;
        assert (Debug.debugEnter(CLASS_NAME, "decodeDITContentRule", String.valueOf(byteString)));
        String string2 = byteString.stringValue();
        String string3 = StaticUtils.toLowerCase(string2);
        int n3 = string2.length();
        for (n2 = 0; n2 < n3 && string2.charAt(n2) == ' '; ++n2) {
        }
        if (n2 >= n3) {
            int n4 = 6488183;
            String string4 = MessageHandler.getMessage(n4);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n4);
        }
        if ((c = string2.charAt(n2++)) != '(') {
            int n5 = 6488184;
            String string5 = MessageHandler.getMessage(n5, string2, n2 - 1, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n5);
        }
        while (n2 < n3 && (c = string2.charAt(n2)) == ' ') {
            ++n2;
        }
        if (n2 >= n3) {
            int n6 = 6488185;
            String string6 = MessageHandler.getMessage(n6, string2);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string6, n6);
        }
        int n7 = n2;
        if (!StaticUtils.isDigit(c)) {
            while (n2 < n3 && (c = string2.charAt(n2++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) continue;
                int n8 = 6488188;
                String string7 = MessageHandler.getMessage(n8, string2, Character.valueOf(c), n2 - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string7, n8);
            }
        } else {
            boolean bl = false;
            while (n2 < n3 && (c = string2.charAt(n2++)) != ' ') {
                if (c == '.') {
                    if (bl) {
                        int n9 = 6488186;
                        String string8 = MessageHandler.getMessage(n9, string2, n2 - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string8, n9);
                    }
                    bl = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    int n10 = 6488187;
                    String string9 = MessageHandler.getMessage(n10, string2, Character.valueOf(c), n2 - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string9, n10);
                }
                bl = false;
            }
        }
        if (n2 >= n3) {
            int n11 = 6488185;
            String string10 = MessageHandler.getMessage(n11, string2);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string10, n11);
        }
        String string11 = string3.substring(n7, n2 - 1);
        ObjectClass objectClass = schema.getObjectClass(string11);
        if (objectClass == null) {
            n = 6488191;
            string = MessageHandler.getMessage(n, string2, string11);
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n);
            objectClass = DirectoryServer.getDefaultObjectClass(string11);
        } else if (objectClass.getObjectClassType() != ObjectClassType.STRUCTURAL) {
            n = 6488192;
            string = MessageHandler.getMessage(n, string2, string11, objectClass.getNameOrOID(), String.valueOf((Object)objectClass.getObjectClassType()));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n);
        }
        while (n2 < n3 && (c = string2.charAt(n2)) == ' ') {
            ++n2;
        }
        if (n2 >= n3) {
            n = 6488185;
            string = MessageHandler.getMessage(n, string2);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string, n);
        }
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        string = null;
        boolean bl = false;
        CopyOnWriteArraySet<ObjectClass> copyOnWriteArraySet = new CopyOnWriteArraySet<ObjectClass>();
        CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet2 = new CopyOnWriteArraySet<AttributeType>();
        CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet3 = new CopyOnWriteArraySet<AttributeType>();
        CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet4 = new CopyOnWriteArraySet<AttributeType>();
        ConcurrentHashMap<String, CopyOnWriteArrayList<String>> concurrentHashMap2 = new ConcurrentHashMap<String, CopyOnWriteArrayList<String>>();
        block5: while (true) {
            Serializable serializable;
            block48: {
                String string12;
                int n12;
                Object object;
                CharSequence charSequence;
                block58: {
                    block47: {
                        block56: {
                            block46: {
                                block54: {
                                    block45: {
                                        block52: {
                                            block50: {
                                                String string13;
                                                block57: {
                                                    String string14;
                                                    block55: {
                                                        block53: {
                                                            block51: {
                                                                block49: {
                                                                    StringBuilder stringBuilder = new StringBuilder();
                                                                    n2 = DITContentRuleSyntax.readTokenName(string2, stringBuilder, n2);
                                                                    string13 = stringBuilder.toString();
                                                                    string14 = StaticUtils.toLowerCase(string13);
                                                                    if (string13.equals(")")) {
                                                                        if (n2 >= n3) return new DITContentRule(objectClass, concurrentHashMap, string, copyOnWriteArraySet, copyOnWriteArraySet2, copyOnWriteArraySet3, copyOnWriteArraySet4, bl, concurrentHashMap2);
                                                                        int n13 = 6488189;
                                                                        charSequence = MessageHandler.getMessage(n13, string2, n2 - 1);
                                                                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, (String)charSequence, n13);
                                                                    }
                                                                    if (!string14.equals("name")) break block49;
                                                                    if ((c = string2.charAt(n2++)) == '\'') {
                                                                        serializable = new StringBuilder();
                                                                        charSequence = new StringBuilder();
                                                                        n2 = DITContentRuleSyntax.readQuotedString(string2, string3, (StringBuilder)serializable, (StringBuilder)charSequence, n2 - 1);
                                                                        concurrentHashMap.put(((StringBuilder)charSequence).toString(), ((StringBuilder)serializable).toString());
                                                                        continue;
                                                                    }
                                                                    if (c != '(') {
                                                                        int n14 = 6488190;
                                                                        charSequence = MessageHandler.getMessage(n14, string2, Character.valueOf(c), n2 - 1);
                                                                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, (String)charSequence, n14);
                                                                    }
                                                                    break block50;
                                                                }
                                                                if (string14.equals("desc")) {
                                                                    serializable = new StringBuilder();
                                                                    n2 = DITContentRuleSyntax.readQuotedString(string2, (StringBuilder)serializable, n2);
                                                                    string = ((StringBuilder)serializable).toString();
                                                                    continue;
                                                                }
                                                                if (string14.equals("obsolete")) {
                                                                    bl = true;
                                                                    continue;
                                                                }
                                                                if (!string14.equals("aux")) break block51;
                                                                serializable = new LinkedList();
                                                                if ((c = string2.charAt(n2++)) == '(') break block52;
                                                                charSequence = new StringBuilder();
                                                                n2 = DITContentRuleSyntax.readWOID(string3, (StringBuilder)charSequence, n2 - 1);
                                                                object = schema.getObjectClass(((StringBuilder)charSequence).toString());
                                                                if (object == null) {
                                                                    n12 = 6488193;
                                                                    string12 = MessageHandler.getMessage(n12, string2, ((StringBuilder)charSequence).toString());
                                                                    Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string12, n12);
                                                                    object = DirectoryServer.getDefaultObjectClass(((StringBuilder)charSequence).toString());
                                                                } else if (((ObjectClass)object).getObjectClassType() != ObjectClassType.AUXILIARY) {
                                                                    n12 = 6488194;
                                                                    string12 = MessageHandler.getMessage(n12, string2, ((StringBuilder)charSequence).toString());
                                                                    Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string12, n12);
                                                                }
                                                                ((LinkedList)serializable).add(object);
                                                                break block45;
                                                            }
                                                            if (!string14.equals("must")) break block53;
                                                            serializable = new LinkedList();
                                                            if ((c = string2.charAt(n2++)) == '(') break block54;
                                                            charSequence = new StringBuilder();
                                                            n2 = DITContentRuleSyntax.readWOID(string3, (StringBuilder)charSequence, n2 - 1);
                                                            object = schema.getAttributeType(((StringBuilder)charSequence).toString());
                                                            if (object == null) {
                                                                n12 = 6488195;
                                                                string12 = MessageHandler.getMessage(n12, string2, ((StringBuilder)charSequence).toString());
                                                                Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string12, n12);
                                                                object = DirectoryServer.getDefaultAttributeType(((StringBuilder)charSequence).toString());
                                                            }
                                                            ((LinkedList)serializable).add(object);
                                                            break block46;
                                                        }
                                                        if (!string14.equals("may")) break block55;
                                                        serializable = new LinkedList();
                                                        if ((c = string2.charAt(n2++)) == '(') break block56;
                                                        charSequence = new StringBuilder();
                                                        n2 = DITContentRuleSyntax.readWOID(string3, (StringBuilder)charSequence, n2 - 1);
                                                        object = schema.getAttributeType(((StringBuilder)charSequence).toString());
                                                        if (object == null) {
                                                            n12 = 6488196;
                                                            string12 = MessageHandler.getMessage(n12, string2, ((StringBuilder)charSequence).toString());
                                                            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string12, n12);
                                                            object = DirectoryServer.getDefaultAttributeType(((StringBuilder)charSequence).toString());
                                                        }
                                                        ((LinkedList)serializable).add(object);
                                                        break block47;
                                                    }
                                                    if (!string14.equals("not")) break block57;
                                                    serializable = new LinkedList();
                                                    if ((c = string2.charAt(n2++)) == '(') break block58;
                                                    charSequence = new StringBuilder();
                                                    n2 = DITContentRuleSyntax.readWOID(string3, (StringBuilder)charSequence, n2 - 1);
                                                    object = schema.getAttributeType(((StringBuilder)charSequence).toString());
                                                    if (object == null) {
                                                        n12 = 6488197;
                                                        string12 = MessageHandler.getMessage(n12, string2, ((StringBuilder)charSequence).toString());
                                                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string12, n12);
                                                        object = DirectoryServer.getDefaultAttributeType(((StringBuilder)charSequence).toString());
                                                    }
                                                    ((LinkedList)serializable).add(object);
                                                    break block48;
                                                }
                                                serializable = new CopyOnWriteArrayList();
                                                n2 = DITContentRuleSyntax.readExtraParameterValues(string2, (CopyOnWriteArrayList<String>)serializable, n2);
                                                concurrentHashMap2.put(string13, (CopyOnWriteArrayList<String>)serializable);
                                                continue;
                                            }
                                            serializable = new StringBuilder();
                                            charSequence = new StringBuilder();
                                            n2 = DITContentRuleSyntax.readQuotedString(string2, string3, (StringBuilder)serializable, (StringBuilder)charSequence, n2);
                                            concurrentHashMap.put(((StringBuilder)charSequence).toString(), ((StringBuilder)serializable).toString());
                                            while (true) {
                                                if (string2.charAt(n2) == ')') {
                                                    ++n2;
                                                    while (true) {
                                                        if (n2 >= n3 || (c = string2.charAt(n2)) != ' ') continue block5;
                                                        ++n2;
                                                    }
                                                }
                                                serializable = new StringBuilder();
                                                charSequence = new StringBuilder();
                                                n2 = DITContentRuleSyntax.readQuotedString(string2, string3, (StringBuilder)serializable, (StringBuilder)charSequence, n2);
                                                concurrentHashMap.put(((StringBuilder)charSequence).toString(), ((StringBuilder)serializable).toString());
                                            }
                                        }
                                        do {
                                            charSequence = new StringBuilder();
                                            n2 = DITContentRuleSyntax.readWOID(string3, (StringBuilder)charSequence, n2);
                                            object = schema.getObjectClass(((StringBuilder)charSequence).toString());
                                            if (object == null) {
                                                n12 = 6488193;
                                                string12 = MessageHandler.getMessage(n12, string2, ((StringBuilder)charSequence).toString());
                                                Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string12, n12);
                                                object = DirectoryServer.getDefaultObjectClass(((StringBuilder)charSequence).toString());
                                            } else if (((ObjectClass)object).getObjectClassType() != ObjectClassType.AUXILIARY) {
                                                n12 = 6488194;
                                                string12 = MessageHandler.getMessage(n12, string2, ((StringBuilder)charSequence).toString());
                                                Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string12, n12);
                                            }
                                            ((LinkedList)serializable).add(object);
                                            c = string2.charAt(n2++);
                                            if (c == ')') break block45;
                                        } while (c == '$');
                                        n12 = 6488190;
                                        string12 = MessageHandler.getMessage(n12, string2, Character.valueOf(c), n2 - 1);
                                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string12, n12);
                                    }
                                    copyOnWriteArraySet.addAll((Collection<ObjectClass>)((Object)serializable));
                                    continue;
                                }
                                do {
                                    charSequence = new StringBuilder();
                                    n2 = DITContentRuleSyntax.readWOID(string3, (StringBuilder)charSequence, n2);
                                    object = schema.getAttributeType(((StringBuilder)charSequence).toString());
                                    if (object == null) {
                                        n12 = 6488195;
                                        string12 = MessageHandler.getMessage(n12, string2, ((StringBuilder)charSequence).toString());
                                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string12, n12);
                                        object = DirectoryServer.getDefaultAttributeType(((StringBuilder)charSequence).toString());
                                    }
                                    ((LinkedList)serializable).add(object);
                                    c = string2.charAt(n2++);
                                    if (c == ')') break block46;
                                } while (c == '$');
                                n12 = 6488190;
                                string12 = MessageHandler.getMessage(n12, string2, Character.valueOf(c), n2 - 1);
                                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string12, n12);
                            }
                            copyOnWriteArraySet2.addAll((Collection<AttributeType>)((Object)serializable));
                            continue;
                        }
                        do {
                            charSequence = new StringBuilder();
                            n2 = DITContentRuleSyntax.readWOID(string3, (StringBuilder)charSequence, n2);
                            object = schema.getAttributeType(((StringBuilder)charSequence).toString());
                            if (object == null) {
                                n12 = 6488196;
                                string12 = MessageHandler.getMessage(n12, string2, ((StringBuilder)charSequence).toString());
                                Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string12, n12);
                                object = DirectoryServer.getDefaultAttributeType(((StringBuilder)charSequence).toString());
                            }
                            ((LinkedList)serializable).add(object);
                            c = string2.charAt(n2++);
                            if (c == ')') break block47;
                        } while (c == '$');
                        n12 = 6488190;
                        string12 = MessageHandler.getMessage(n12, string2, Character.valueOf(c), n2 - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string12, n12);
                    }
                    copyOnWriteArraySet3.addAll((Collection<AttributeType>)((Object)serializable));
                    continue;
                }
                do {
                    charSequence = new StringBuilder();
                    n2 = DITContentRuleSyntax.readWOID(string3, (StringBuilder)charSequence, n2);
                    object = schema.getAttributeType(((StringBuilder)charSequence).toString());
                    if (object == null) {
                        n12 = 6488197;
                        string12 = MessageHandler.getMessage(n12, string2, ((StringBuilder)charSequence).toString());
                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string12, n12);
                        object = DirectoryServer.getDefaultAttributeType(((StringBuilder)charSequence).toString());
                    }
                    ((LinkedList)serializable).add(object);
                    c = string2.charAt(n2++);
                    if (c == ')') break block48;
                } while (c == '$');
                n12 = 6488190;
                string12 = MessageHandler.getMessage(n12, string2, Character.valueOf(c), n2 - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string12, n12);
            }
            copyOnWriteArraySet4.addAll((Collection<AttributeType>)((Object)serializable));
        }
    }

    private static int readTokenName(String string, StringBuilder stringBuilder, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "readTokenName", String.valueOf(string), "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n2 = string.length();
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n3 = 6488185;
            String string2 = MessageHandler.getMessage(n3, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3);
        }
        while (n < n2 && (c = string.charAt(n++)) != ' ') {
            stringBuilder.append(c);
        }
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        return n;
    }

    private static int readQuotedString(String string, StringBuilder stringBuilder, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "readQuotedString", String.valueOf(string), "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n2 = string.length();
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n3 = 6488185;
            String string2 = MessageHandler.getMessage(n3, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3);
        }
        if (c != '\'') {
            int n4 = 6488198;
            String string3 = MessageHandler.getMessage(n4, string, n, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n4);
        }
        ++n;
        while (n < n2 && (c = string.charAt(n)) != '\'') {
            stringBuilder.append(c);
            ++n;
        }
        ++n;
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n5 = 6488185;
            String string4 = MessageHandler.getMessage(n5, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n5);
        }
        return n;
    }

    private static int readQuotedString(String string, String string2, StringBuilder stringBuilder, StringBuilder stringBuilder2, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "readQuotedString", String.valueOf(string), String.valueOf(string2), "java.lang.StringBuilder", "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n2 = string2.length();
        while (n < n2 && (c = string2.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n3 = 6488185;
            String string3 = MessageHandler.getMessage(n3, string2);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n3);
        }
        if (c != '\'') {
            int n4 = 6488198;
            String string4 = MessageHandler.getMessage(n4, string, n, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n4);
        }
        ++n;
        while (n < n2 && (c = string2.charAt(n)) != '\'') {
            stringBuilder2.append(c);
            stringBuilder.append(string.charAt(n));
            ++n;
        }
        ++n;
        while (n < n2 && (c = string2.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n5 = 6488185;
            String string5 = MessageHandler.getMessage(n5, string2);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n5);
        }
        return n;
    }

    private static int readWOID(String string, StringBuilder stringBuilder, int n) throws DirectoryException {
        int n2;
        assert (Debug.debugEnter(CLASS_NAME, "readWOID", String.valueOf(string), "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n3 = string.length();
        while (n < n3 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n3) {
            int n4 = 6488185;
            String string2 = MessageHandler.getMessage(n4, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n4);
        }
        if (StaticUtils.isDigit(c)) {
            n2 = 0;
            while (n < n3 && (c = string.charAt(n++)) != ' ') {
                if (c == '.') {
                    if (n2 != 0) {
                        int n5 = 6488186;
                        String string3 = MessageHandler.getMessage(n5, string, n - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n5);
                    }
                    stringBuilder.append(c);
                    n2 = 1;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    if (c == ')') {
                        return n - 1;
                    }
                    int n6 = 6488187;
                    String string4 = MessageHandler.getMessage(n6, string, Character.valueOf(c), n - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n6);
                }
                stringBuilder.append(c);
                n2 = 0;
            }
        } else if (StaticUtils.isAlpha(c)) {
            while (n < n3 && (c = string.charAt(n++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) {
                    stringBuilder.append(c);
                    continue;
                }
                if (c == ')') {
                    return n - 1;
                }
                int n7 = 6488188;
                String string5 = MessageHandler.getMessage(n7, string, Character.valueOf(c), n - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n7);
            }
        } else {
            int n8 = 6488190;
            String string6 = MessageHandler.getMessage(n8, string, Character.valueOf(c), n);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string6, n8);
        }
        while (n < n3 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n3) {
            n2 = 6488185;
            String string7 = MessageHandler.getMessage(n2, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string7, n2);
        }
        return n;
    }

    private static int readExtraParameterValues(String string, CopyOnWriteArrayList<String> copyOnWriteArrayList, int n) throws DirectoryException {
        StringBuilder stringBuilder;
        assert (Debug.debugEnter(CLASS_NAME, "readExtraParameterValues", String.valueOf(string), "java.util.concurrent.CopyOnWriteArrayList<String>", String.valueOf(n)));
        int n2 = string.length();
        char c = string.charAt(n++);
        while (n < n2 && c == ' ') {
            c = string.charAt(n++);
        }
        if (n >= n2) {
            int n3 = 6488185;
            String string2 = MessageHandler.getMessage(n3, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3);
        }
        if (c == '\'') {
            stringBuilder = new StringBuilder();
            while (n < n2 && (c = string.charAt(n++)) != '\'') {
                stringBuilder.append(c);
            }
            copyOnWriteArrayList.add(stringBuilder.toString());
        } else if (c == '(') {
            while (true) {
                ++n;
                while (n < n2 && (c = string.charAt(n)) == ' ') {
                    ++n;
                }
                if (n >= n2) {
                    int n4 = 6488185;
                    String string3 = MessageHandler.getMessage(n4, string);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n4);
                }
                if (c != ')') {
                    if (c == '(') {
                        int n5 = 6488190;
                        String string4 = MessageHandler.getMessage(n5, string, Character.valueOf(c), n);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n5);
                    }
                    n = DITContentRuleSyntax.readExtraParameterValues(string, copyOnWriteArrayList, n);
                    continue;
                }
                break;
            }
        } else {
            stringBuilder = new StringBuilder();
            while (n < n2 && (c = string.charAt(n++)) != ' ') {
                stringBuilder.append(c);
            }
            copyOnWriteArrayList.add(stringBuilder.toString());
        }
        while (n < n2 && string.charAt(n) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n6 = 6488185;
            String string5 = MessageHandler.getMessage(n6, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n6);
        }
        return n;
    }
}

