/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.util.StaticUtils;

public class CaseIgnoreOrderingMatchingRule
extends OrderingMatchingRule {
    private static final String CLASS_NAME = "org.opends.server.schema.CaseIgnoreOrderingMatchingRule";
    private static final long serialVersionUID = -8992263058903266096L;

    public CaseIgnoreOrderingMatchingRule() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeMatchingRule(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMatchingRule", String.valueOf(configEntry)));
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return "caseIgnoreOrderingMatch";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "2.5.13.3";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return null;
    }

    public String getSyntaxOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.15";
    }

    public ByteString normalizeValue(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "normalizeValue", String.valueOf(byteString)));
        StringBuilder stringBuilder = new StringBuilder();
        StaticUtils.toLowerCase(byteString.value(), stringBuilder, true);
        int n = stringBuilder.length();
        if (n == 0) {
            if (byteString.value().length > 0) {
                return new ASN1OctetString(" ");
            }
            return new ASN1OctetString();
        }
        for (int i = n - 1; i > 0; --i) {
            if (stringBuilder.charAt(i) != ' ' || stringBuilder.charAt(i - 1) != ' ') continue;
            stringBuilder.delete(i, i + 1);
        }
        return new ASN1OctetString(stringBuilder.toString());
    }

    public int compareValues(ByteString byteString, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "compareValues", String.valueOf(byteString), String.valueOf(byteString2)));
        return this.compare(byteString.value(), byteString2.value());
    }

    public int compare(byte[] byArray, byte[] byArray2) {
        assert (Debug.debugEnter(CLASS_NAME, "compare", String.valueOf(byArray), String.valueOf(byArray2)));
        int n = Math.min(byArray.length, byArray2.length);
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            if (byArray[i] < byArray2[i]) {
                return -1;
            }
            if (byArray[i] <= byArray2[i]) continue;
            return 1;
        }
        if (byArray.length == byArray2.length) {
            return 0;
        }
        if (byArray.length < byArray2.length) {
            return -1;
        }
        return 1;
    }
}

