/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class BitStringSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.BitStringSyntax";
    private EqualityMatchingRule defaultEqualityMatchingRule;

    public BitStringSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.16");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.16", "BitString");
        }
    }

    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "BitString";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.6";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "Bit String";
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return null;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return null;
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        String string = byteString.stringValue().toUpperCase();
        int n = string.length();
        if (n < 3) {
            stringBuilder.append(MessageHandler.getMessage(0x620006, byteString.stringValue()));
            return false;
        }
        if (string.charAt(0) != '\'' || string.charAt(n - 2) != '\'' || string.charAt(n - 1) != 'B') {
            stringBuilder.append(MessageHandler.getMessage(6422535, byteString.stringValue()));
            return false;
        }
        block3: for (int i = 1; i < n - 2; ++i) {
            switch (string.charAt(i)) {
                case '0': 
                case '1': {
                    continue block3;
                }
                default: {
                    stringBuilder.append(MessageHandler.getMessage(6422536, byteString.stringValue(), Character.valueOf(string.charAt(i))));
                    return false;
                }
            }
        }
        return true;
    }

    public static AttributeValue createBitStringValue(byte by) {
        assert (Debug.debugEnter(CLASS_NAME, "createBitStringValue", String.valueOf(by)));
        String string = "'" + StaticUtils.byteToBinary(by) + "'B";
        return new AttributeValue(new ASN1OctetString(string), (ByteString)new ASN1OctetString(string));
    }

    public static AttributeValue createBitStringValue(byte[] byArray) {
        String string;
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "createBitStringValue", String.valueOf(byArray)));
        if (byArray == null || (n = byArray.length) == 0) {
            string = "''B";
        } else {
            StringBuilder stringBuilder = new StringBuilder(3 + 8 * n);
            stringBuilder.append("'");
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(StaticUtils.byteToBinary(byArray[i]));
            }
            stringBuilder.append("'B");
            string = stringBuilder.toString();
        }
        return new AttributeValue(new ASN1OctetString(string), (ByteString)new ASN1OctetString(string));
    }

    public static byte[] decodeBitStringValue(ByteString byteString) throws DirectoryException {
        char c2;
        int n;
        int n2;
        assert (Debug.debugEnter(CLASS_NAME, "decodeBitStringValue", String.valueOf(byteString)));
        String string = byteString.stringValue();
        int n3 = string.length();
        if (n3 < 3) {
            int n4 = 0x620006;
            String string2 = MessageHandler.getMessage(n4, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n4);
        }
        if (string.charAt(0) != '\'' || string.charAt(n3 - 2) != '\'' || string.charAt(n3 - 1) != 'B') {
            if (string.charAt(0) != '\'') {
                boolean bl = false;
            } else if (string.charAt(n3 - 2) != '\'') {
                int n5 = n3 - 2;
            } else {
                int n6 = n3 - 1;
            }
            int n7 = 6422535;
            String string3 = MessageHandler.getMessage(n7, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n7);
        }
        int n8 = n3 - 3;
        int n9 = n2 = n8 / 8;
        int n10 = n8 % 8;
        if (n10 != 0) {
            ++n9;
        }
        byte[] byArray = new byte[n9];
        int n11 = 1;
        for (n = 0; n < n2; ++n) {
            byArray[n] = 0;
            for (c2 = '\u0000'; c2 < '\b'; ++c2) {
                char c;
                if ((c = string.charAt(n11++)) == '0') {
                    int n4 = n;
                    byArray[n4] = (byte)(byArray[n4] << 1);
                    continue;
                }
                if (c == '1') {
                    byArray[n] = (byte)(byArray[n] << 1 | 1);
                    continue;
                }
                int string5 = 6422536;
                String string2 = MessageHandler.getMessage(string5, string, Character.valueOf(c));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, string5);
            }
        }
        if (n10 > 0) {
            byArray[n2] = 0;
            for (n = 0; n < n10; ++n) {
                if ((c2 = (char)string.charAt(n11++)) == '0') {
                    int n5 = n2;
                    byArray[n5] = (byte)(byArray[n5] << 1);
                    continue;
                }
                if (c2 == '1') {
                    byArray[n2] = (byte)(byArray[n2] << 1 | 1);
                    continue;
                }
                int n6 = 6422536;
                String string3 = MessageHandler.getMessage(n6, string, Character.valueOf(c2));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n6);
            }
        }
        return byArray;
    }
}

