/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Boolean;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Enumerated;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.SearchScope;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchRequestProtocolOp
extends ProtocolOp {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.SearchRequestProtocolOp";
    private boolean typesOnly;
    private DereferencePolicy dereferencePolicy;
    private ASN1OctetString baseDN;
    private int sizeLimit;
    private int timeLimit;
    private LDAPFilter filter;
    private LinkedHashSet<String> attributes;
    private SearchScope scope;

    public SearchRequestProtocolOp(ASN1OctetString aSN1OctetString, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, LDAPFilter lDAPFilter, LinkedHashSet<String> linkedHashSet) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(aSN1OctetString), String.valueOf((Object)searchScope), String.valueOf((Object)dereferencePolicy), String.valueOf(n), String.valueOf(n2), String.valueOf(bl), String.valueOf(lDAPFilter), String.valueOf(linkedHashSet)));
        this.baseDN = aSN1OctetString;
        this.scope = searchScope;
        this.dereferencePolicy = dereferencePolicy;
        this.sizeLimit = n;
        this.timeLimit = n2;
        this.typesOnly = bl;
        this.filter = lDAPFilter;
        this.attributes = linkedHashSet == null ? new LinkedHashSet(0) : linkedHashSet;
    }

    public ASN1OctetString getBaseDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getBaseDN", new String[0]));
        return this.baseDN;
    }

    public void setBaseDN(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setBaseDN", String.valueOf(aSN1OctetString)));
        this.baseDN = aSN1OctetString;
    }

    public SearchScope getScope() {
        assert (Debug.debugEnter(CLASS_NAME, "getScope", new String[0]));
        return this.scope;
    }

    public void setScope(SearchScope searchScope) {
        assert (Debug.debugEnter(CLASS_NAME, "setScope", String.valueOf((Object)searchScope)));
        this.scope = searchScope;
    }

    public DereferencePolicy getDereferencePolicy() {
        assert (Debug.debugEnter(CLASS_NAME, "getDereferencePolicy", new String[0]));
        return this.dereferencePolicy;
    }

    public void setDereferencePolicy(DereferencePolicy dereferencePolicy) {
        assert (Debug.debugEnter(CLASS_NAME, "setDereferencePolicy", String.valueOf((Object)dereferencePolicy)));
        this.dereferencePolicy = dereferencePolicy;
    }

    public int getSizeLimit() {
        assert (Debug.debugEnter(CLASS_NAME, "getSizeLimit", new String[0]));
        return this.sizeLimit;
    }

    public void setSizeLimit(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setSizeLimit", String.valueOf(n)));
        this.sizeLimit = n;
    }

    public int getTimeLimit() {
        assert (Debug.debugEnter(CLASS_NAME, "getTimeLimit", new String[0]));
        return this.timeLimit;
    }

    public void setTimeLimit(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setTimeLimit", String.valueOf(n)));
        this.timeLimit = n;
    }

    public boolean getTypesOnly() {
        assert (Debug.debugEnter(CLASS_NAME, "getTypesOnly", new String[0]));
        return this.typesOnly;
    }

    public void setTypesOnly(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setTypesOnly", String.valueOf(bl)));
        this.typesOnly = bl;
    }

    public LDAPFilter getFilter() {
        assert (Debug.debugEnter(CLASS_NAME, "getFilter", new String[0]));
        return this.filter;
    }

    public void setFilter(LDAPFilter lDAPFilter) {
        assert (Debug.debugEnter(CLASS_NAME, "setFilter", String.valueOf(lDAPFilter)));
        this.filter = lDAPFilter;
    }

    public LinkedHashSet<String> getAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributes", new String[0]));
        return this.attributes;
    }

    public void setAttributes(LinkedHashSet<String> linkedHashSet) {
        assert (Debug.debugEnter(CLASS_NAME, "setAttributes", String.valueOf(linkedHashSet)));
        if (linkedHashSet == null) {
            this.attributes.clear();
        } else {
            this.attributes = linkedHashSet;
        }
    }

    @Override
    public byte getType() {
        assert (Debug.debugEnter(CLASS_NAME, "getType", new String[0]));
        return 99;
    }

    @Override
    public String getProtocolOpName() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolOpName", new String[0]));
        return "Search Request";
    }

    @Override
    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(8);
        arrayList.add(this.baseDN);
        arrayList.add(new ASN1Enumerated(this.scope.intValue()));
        arrayList.add(new ASN1Enumerated(this.dereferencePolicy.intValue()));
        arrayList.add(new ASN1Integer(this.sizeLimit));
        arrayList.add(new ASN1Integer(this.timeLimit));
        arrayList.add(new ASN1Boolean(this.typesOnly));
        arrayList.add(this.filter.encode());
        ArrayList<ASN1Element> arrayList2 = new ArrayList<ASN1Element>(this.attributes.size());
        for (String string : this.attributes) {
            arrayList2.add(new ASN1OctetString(string));
        }
        arrayList.add(new ASN1Sequence(arrayList2));
        return new ASN1Sequence(99, arrayList);
    }

    public static SearchRequestProtocolOp decodeSearchRequest(ASN1Element aSN1Element) throws LDAPException {
        LinkedHashSet<String> linkedHashSet;
        LDAPFilter lDAPFilter;
        boolean bl;
        int n;
        int n2;
        DereferencePolicy dereferencePolicy;
        SearchScope searchScope;
        ASN1OctetString aSN1OctetString;
        ArrayList<ASN1Element> arrayList;
        assert (Debug.debugEnter(CLASS_NAME, "decodeSearchRequest", String.valueOf(aSN1Element)));
        try {
            arrayList = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeSearchRequest", exception));
            int n3 = 2293884;
            String string = MessageHandler.getMessage(n3, String.valueOf(exception));
            throw new LDAPException(2, n3, string, exception);
        }
        int n4 = arrayList.size();
        if (n4 != 8) {
            int n5 = 2293885;
            String string = MessageHandler.getMessage(n5, n4);
            throw new LDAPException(2, n5, string);
        }
        try {
            aSN1OctetString = arrayList.get(0).decodeAsOctetString();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeSearchRequest", exception));
            int n6 = 2293886;
            String string = MessageHandler.getMessage(n6, String.valueOf(exception));
            throw new LDAPException(2, n6, string, exception);
        }
        try {
            switch (arrayList.get(1).decodeAsEnumerated().intValue()) {
                case 0: {
                    searchScope = SearchScope.BASE_OBJECT;
                    break;
                }
                case 1: {
                    searchScope = SearchScope.SINGLE_LEVEL;
                    break;
                }
                case 2: {
                    searchScope = SearchScope.WHOLE_SUBTREE;
                    break;
                }
                case 3: {
                    searchScope = SearchScope.SUBORDINATE_SUBTREE;
                    break;
                }
                default: {
                    int n7 = arrayList.get(1).decodeAsEnumerated().intValue();
                    int n8 = 2293887;
                    String string = MessageHandler.getMessage(n8, n7);
                    throw new LDAPException(2, n8, string);
                }
            }
        }
        catch (LDAPException lDAPException) {
            throw lDAPException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeSearchRequest", exception));
            int n9 = 2293888;
            String string = MessageHandler.getMessage(n9, String.valueOf(exception));
            throw new LDAPException(2, n9, string, exception);
        }
        try {
            switch (arrayList.get(2).decodeAsEnumerated().intValue()) {
                case 0: {
                    dereferencePolicy = DereferencePolicy.NEVER_DEREF_ALIASES;
                    break;
                }
                case 1: {
                    dereferencePolicy = DereferencePolicy.DEREF_IN_SEARCHING;
                    break;
                }
                case 2: {
                    dereferencePolicy = DereferencePolicy.DEREF_FINDING_BASE_OBJECT;
                    break;
                }
                case 3: {
                    dereferencePolicy = DereferencePolicy.DEREF_ALWAYS;
                    break;
                }
                default: {
                    int n10 = arrayList.get(2).decodeAsEnumerated().intValue();
                    int n11 = 2293889;
                    String string = MessageHandler.getMessage(n11, n10);
                    throw new LDAPException(2, n11, string);
                }
            }
        }
        catch (LDAPException lDAPException) {
            throw lDAPException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeSearchRequest", exception));
            int n12 = 2293890;
            String string = MessageHandler.getMessage(n12, String.valueOf(exception));
            throw new LDAPException(2, n12, string, exception);
        }
        try {
            n2 = arrayList.get(3).decodeAsInteger().intValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeSearchRequest", exception));
            int n13 = 2293891;
            String string = MessageHandler.getMessage(n13, String.valueOf(exception));
            throw new LDAPException(2, n13, string, exception);
        }
        try {
            n = arrayList.get(4).decodeAsInteger().intValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeSearchRequest", exception));
            int n14 = 2293892;
            String string = MessageHandler.getMessage(n14, String.valueOf(exception));
            throw new LDAPException(2, n14, string, exception);
        }
        try {
            bl = arrayList.get(5).decodeAsBoolean().booleanValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeSearchRequest", exception));
            int n15 = 2293893;
            String string = MessageHandler.getMessage(n15, String.valueOf(exception));
            throw new LDAPException(2, n15, string, exception);
        }
        try {
            lDAPFilter = LDAPFilter.decode(arrayList.get(6));
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeSearchRequest", exception));
            int n16 = 2293894;
            String string = MessageHandler.getMessage(n16, String.valueOf(exception));
            throw new LDAPException(2, n16, string, exception);
        }
        try {
            ArrayList<ASN1Element> arrayList2 = arrayList.get(7).decodeAsSequence().elements();
            linkedHashSet = new LinkedHashSet<String>(arrayList2.size());
            for (ASN1Element aSN1Element2 : arrayList2) {
                linkedHashSet.add(aSN1Element2.decodeAsOctetString().stringValue());
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeSearchRequest", exception));
            int n17 = 2293895;
            String string = MessageHandler.getMessage(n17, String.valueOf(exception));
            throw new LDAPException(2, n17, string, exception);
        }
        return new SearchRequestProtocolOp(aSN1OctetString, searchScope, dereferencePolicy, n2, n, bl, lDAPFilter, linkedHashSet);
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("SearchRequest(baseDN=");
        this.baseDN.toString(stringBuilder);
        stringBuilder.append(", scope=");
        stringBuilder.append(String.valueOf((Object)this.scope));
        stringBuilder.append(", derefPolicy=");
        stringBuilder.append(String.valueOf((Object)this.dereferencePolicy));
        stringBuilder.append(", sizeLimit=");
        stringBuilder.append(this.sizeLimit);
        stringBuilder.append(", timeLimit=");
        stringBuilder.append(this.timeLimit);
        stringBuilder.append(", typesOnly=");
        stringBuilder.append(this.typesOnly);
        stringBuilder.append(", filter=");
        this.filter.toString(stringBuilder);
        stringBuilder.append(", attributes={");
        if (this.attributes != null && !this.attributes.isEmpty()) {
            Iterator iterator = this.attributes.iterator();
            stringBuilder.append((String)iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(", ");
                stringBuilder.append((String)iterator.next());
            }
        }
        stringBuilder.append("})");
    }

    @Override
    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("Search Request");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Base DN:  ");
        this.baseDN.toString(stringBuilder);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Scope:  ");
        stringBuilder.append(String.valueOf((Object)this.scope));
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Dereference Policy:  ");
        stringBuilder.append(String.valueOf((Object)this.dereferencePolicy));
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Size Limit:  ");
        stringBuilder.append(this.sizeLimit);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Time Limit:  ");
        stringBuilder.append(this.timeLimit);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Types Only:  ");
        stringBuilder.append(this.typesOnly);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Filter:  ");
        this.filter.toString(stringBuilder);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Attributes:");
        stringBuilder.append(ServerConstants.EOL);
        if (this.attributes != null) {
            for (String string : this.attributes) {
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder.append("    ");
                stringBuilder.append(string);
                stringBuilder.append(ServerConstants.EOL);
            }
        }
    }
}

