/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPStatistics
extends MonitorProvider {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.LDAPStatistics";
    private long abandonRequests;
    private long addRequests;
    private long addResponses;
    private long bindRequests;
    private long bindResponses;
    private long bytesRead;
    private long bytesWritten;
    private long compareRequests;
    private long compareResponses;
    private long connectionsClosed;
    private long connectionsEstablished;
    private long deleteRequests;
    private long deleteResponses;
    private long extendedRequests;
    private long extendedResponses;
    private long messagesRead;
    private long messagesWritten;
    private long modifyRequests;
    private long modifyResponses;
    private long modifyDNRequests;
    private long modifyDNResponses;
    private long operationsAbandoned;
    private long operationsCompleted;
    private long operationsInitiated;
    private long searchRequests;
    private long searchResultEntries;
    private long searchResultReferences;
    private long searchResultsDone;
    private long unbindRequests;
    private LDAPStatistics parent;
    private ReentrantLock abandonLock;
    private ReentrantLock connectLock;
    private ReentrantLock disconnectLock;
    private ReentrantLock readLock;
    private ReentrantLock writeLock;
    private String instanceName;

    public LDAPStatistics(String string) {
        this(string, null);
        DirectoryServer.registerMonitorProvider(this);
    }

    public LDAPStatistics(String string, LDAPStatistics lDAPStatistics) {
        super("LDAP Statistics Monitor Provider");
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(lDAPStatistics)));
        this.instanceName = string;
        this.parent = lDAPStatistics;
        this.abandonLock = new ReentrantLock();
        this.connectLock = new ReentrantLock();
        this.disconnectLock = new ReentrantLock();
        this.readLock = new ReentrantLock();
        this.writeLock = new ReentrantLock();
        this.abandonRequests = 0L;
        this.addRequests = 0L;
        this.addResponses = 0L;
        this.bindRequests = 0L;
        this.bindResponses = 0L;
        this.bytesRead = 0L;
        this.bytesWritten = 0L;
        this.compareRequests = 0L;
        this.compareResponses = 0L;
        this.connectionsClosed = 0L;
        this.connectionsEstablished = 0L;
        this.deleteRequests = 0L;
        this.deleteResponses = 0L;
        this.extendedRequests = 0L;
        this.extendedResponses = 0L;
        this.messagesRead = 0L;
        this.messagesWritten = 0L;
        this.modifyRequests = 0L;
        this.modifyResponses = 0L;
        this.modifyDNRequests = 0L;
        this.modifyDNResponses = 0L;
        this.operationsAbandoned = 0L;
        this.operationsCompleted = 0L;
        this.operationsInitiated = 0L;
        this.searchRequests = 0L;
        this.searchResultEntries = 0L;
        this.searchResultReferences = 0L;
        this.searchResultsDone = 0L;
        this.unbindRequests = 0L;
    }

    @Override
    public void initializeMonitorProvider(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMonitorProvider", new String[0]));
        int n = 2293972;
        String string = MessageHandler.getMessage(n, String.valueOf(configEntry.getDN()));
        throw new ConfigException(n, string);
    }

    @Override
    public String getMonitorInstanceName() {
        assert (Debug.debugEnter(CLASS_NAME, "getMonitorInstanceName", new String[0]));
        return this.instanceName;
    }

    @Override
    public long getUpdateInterval() {
        assert (Debug.debugEnter(CLASS_NAME, "getUpdateInterval", new String[0]));
        return -1L;
    }

    @Override
    public void updateMonitorData() {
        assert (Debug.debugEnter(CLASS_NAME, "updateMonitorData", new String[0]));
    }

    /*
     * Exception decompiling
     */
    public ArrayList<Attribute> getMonitorData() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [21[CATCHBLOCK], 20[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStatistics() {
        assert (Debug.debugEnter(CLASS_NAME, "clearStatistics", new String[0]));
        this.abandonLock.lock();
        try {
            this.connectLock.lock();
            try {
                this.disconnectLock.lock();
                try {
                    this.writeLock.lock();
                    try {
                        this.readLock.lock();
                        try {
                            this.abandonRequests = 0L;
                            this.addRequests = 0L;
                            this.addResponses = 0L;
                            this.bindRequests = 0L;
                            this.bindResponses = 0L;
                            this.bytesRead = 0L;
                            this.bytesWritten = 0L;
                            this.compareRequests = 0L;
                            this.compareResponses = 0L;
                            this.connectionsClosed = 0L;
                            this.connectionsEstablished = 0L;
                            this.deleteRequests = 0L;
                            this.deleteResponses = 0L;
                            this.extendedRequests = 0L;
                            this.extendedResponses = 0L;
                            this.messagesRead = 0L;
                            this.messagesWritten = 0L;
                            this.modifyRequests = 0L;
                            this.modifyResponses = 0L;
                            this.modifyDNRequests = 0L;
                            this.modifyDNResponses = 0L;
                            this.operationsAbandoned = 0L;
                            this.operationsCompleted = 0L;
                            this.operationsInitiated = 0L;
                            this.searchRequests = 0L;
                            this.searchResultEntries = 0L;
                            this.searchResultReferences = 0L;
                            this.searchResultsDone = 0L;
                            this.unbindRequests = 0L;
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "clearStatistics", exception));
                        }
                        finally {
                            this.readLock.unlock();
                        }
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "clearStatistics", exception));
                    }
                    finally {
                        this.writeLock.unlock();
                    }
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "clearStatistics", exception));
                }
                finally {
                    this.disconnectLock.unlock();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "clearStatistics", exception));
            }
            finally {
                this.connectLock.unlock();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "clearStatistics", exception));
        }
        finally {
            this.abandonLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnect() {
        assert (Debug.debugEnter(CLASS_NAME, "updateConnect", new String[0]));
        this.connectLock.lock();
        try {
            ++this.connectionsEstablished;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "updateConnect", exception));
        }
        finally {
            this.connectLock.unlock();
        }
        if (this.parent != null) {
            this.parent.updateConnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDisconnect() {
        assert (Debug.debugEnter(CLASS_NAME, "updateDisconnect", new String[0]));
        this.disconnectLock.lock();
        try {
            ++this.connectionsClosed;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "updateDisconnect", exception));
        }
        finally {
            this.disconnectLock.unlock();
        }
        if (this.parent != null) {
            this.parent.updateDisconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBytesRead(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "updateBytesRead", String.valueOf(n)));
        this.readLock.lock();
        try {
            this.bytesRead += (long)n;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "updateBytesRead", exception));
        }
        finally {
            this.readLock.unlock();
        }
        if (this.parent != null) {
            this.parent.updateBytesRead(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void updateMessageRead(LDAPMessage var1_1) {
        if (!LDAPStatistics.$assertionsDisabled && !Debug.debugEnter("org.opends.server.protocols.ldap.LDAPStatistics", "updateMessageRead", new String[]{String.valueOf(var1_1), String.valueOf(this.bytesRead)})) {
            throw new AssertionError();
        }
        this.readLock.lock();
        try {
            ++this.messagesRead;
            ++this.operationsInitiated;
            switch (var1_1.getProtocolOp().getType()) {
                case 80: {
                    ++this.abandonRequests;
                    ** break;
lbl11:
                    // 1 sources

                    break;
                }
                case 104: {
                    ++this.addRequests;
                    ** break;
lbl15:
                    // 1 sources

                    break;
                }
                case 96: {
                    ++this.bindRequests;
                    ** break;
lbl19:
                    // 1 sources

                    break;
                }
                case 110: {
                    ++this.compareRequests;
                    ** break;
lbl23:
                    // 1 sources

                    break;
                }
                case 74: {
                    ++this.deleteRequests;
                    ** break;
lbl27:
                    // 1 sources

                    break;
                }
                case 119: {
                    ++this.extendedRequests;
                    ** break;
lbl31:
                    // 1 sources

                    break;
                }
                case 102: {
                    ++this.modifyRequests;
                    ** break;
lbl35:
                    // 1 sources

                    break;
                }
                case 108: {
                    ++this.modifyDNRequests;
                    ** break;
lbl39:
                    // 1 sources

                    break;
                }
                case 99: {
                    ++this.searchRequests;
                    ** break;
lbl43:
                    // 1 sources

                    break;
                }
                case 66: {
                    ++this.unbindRequests;
                    break;
                }
                ** default:
lbl48:
                // 1 sources

                break;
            }
        }
        catch (Exception var2_2) {
            if (!LDAPStatistics.$assertionsDisabled && !Debug.debugException("org.opends.server.protocols.ldap.LDAPStatistics", "updateMessagesRead", var2_2)) {
                throw new AssertionError();
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (this.parent != null) {
            this.parent.updateMessageRead(var1_1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void updateMessageWritten(LDAPMessage var1_1, int var2_2) {
        if (!LDAPStatistics.$assertionsDisabled && !Debug.debugEnter("org.opends.server.protocols.ldap.LDAPStatistics", "updateMessageWritten", new String[]{String.valueOf(var1_1), String.valueOf(var2_2)})) {
            throw new AssertionError();
        }
        this.writeLock.lock();
        try {
            this.bytesWritten += (long)var2_2;
            ++this.messagesWritten;
            switch (var1_1.getProtocolOp().getType()) {
                case 105: {
                    ++this.addResponses;
                    ++this.operationsCompleted;
                    ** break;
lbl12:
                    // 1 sources

                    break;
                }
                case 97: {
                    ++this.bindResponses;
                    ++this.operationsCompleted;
                    ** break;
lbl17:
                    // 1 sources

                    break;
                }
                case 111: {
                    ++this.compareResponses;
                    ++this.operationsCompleted;
                    ** break;
lbl22:
                    // 1 sources

                    break;
                }
                case 107: {
                    ++this.deleteResponses;
                    ++this.operationsCompleted;
                    ** break;
lbl27:
                    // 1 sources

                    break;
                }
                case 120: {
                    ++this.extendedResponses;
                    if (var1_1.getMessageID() <= 0) ** break;
                    ++this.operationsCompleted;
                    ** break;
lbl33:
                    // 1 sources

                    break;
                }
                case 103: {
                    ++this.modifyResponses;
                    ++this.operationsCompleted;
                    ** break;
lbl38:
                    // 1 sources

                    break;
                }
                case 109: {
                    ++this.modifyDNResponses;
                    ++this.operationsCompleted;
                    ** break;
lbl43:
                    // 1 sources

                    break;
                }
                case 100: {
                    ++this.searchResultEntries;
                    ** break;
lbl47:
                    // 1 sources

                    break;
                }
                case 115: {
                    ++this.searchResultReferences;
                    ** break;
lbl51:
                    // 1 sources

                    break;
                }
                case 101: {
                    ++this.searchResultsDone;
                    ++this.operationsCompleted;
                    break;
                }
                ** default:
lbl57:
                // 1 sources

                break;
            }
        }
        catch (Exception var3_3) {
            if (!LDAPStatistics.$assertionsDisabled && !Debug.debugException("org.opends.server.protocols.ldap.LDAPStatistics", "updateMessageWritten", var3_3)) {
                throw new AssertionError();
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (this.parent != null) {
            this.parent.updateMessageWritten(var1_1, var2_2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAbandonedOperation() {
        assert (Debug.debugEnter(CLASS_NAME, "updateAbandonedOperation", new String[0]));
        this.abandonLock.lock();
        try {
            ++this.operationsAbandoned;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "updateAbandonedOperation", exception));
        }
        finally {
            this.abandonLock.unlock();
        }
        if (this.parent != null) {
            this.parent.updateAbandonedOperation();
        }
    }

    private Attribute createAttribute(String string, String string2) {
        assert (Debug.debugEnter(CLASS_NAME, "createAttribute", String.valueOf(string), String.valueOf(string2)));
        AttributeType attributeType = DirectoryServer.getDefaultAttributeType(string);
        ASN1OctetString aSN1OctetString = new ASN1OctetString(string2);
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        try {
            linkedHashSet.add(new AttributeValue(aSN1OctetString, attributeType.normalize(aSN1OctetString)));
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createAttribute", exception));
            linkedHashSet.add(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString));
        }
        return new Attribute(attributeType, string, linkedHashSet);
    }
}

