/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.ConnectionSecurityProvider;
import org.opends.server.api.plugin.PostConnectPluginResult;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigConstants;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.IntegerConfigAttribute;
import org.opends.server.config.IntegerWithUnitConfigAttribute;
import org.opends.server.config.MultiChoiceConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.extensions.NullConnectionSecurityProvider;
import org.opends.server.extensions.TLSConnectionSecurityProvider;
import org.opends.server.loggers.Access;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.ldap.LDAPClientConnection;
import org.opends.server.protocols.ldap.LDAPRequestHandler;
import org.opends.server.protocols.ldap.LDAPStatistics;
import org.opends.server.types.AddressMask;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SSLClientAuthPolicy;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPConnectionHandler
extends ConnectionHandler
implements ConfigurableComponent,
AlertGenerator {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.LDAPConnectionHandler";
    private static final HashMap<String, Double> SIZE_UNITS = new HashMap();
    private static final int MAX_REQUEST_SIZE_LIMIT = Integer.MAX_VALUE;
    private AddressMask[] allowedClients;
    private AddressMask[] deniedClients;
    private boolean allowLDAPv2;
    private boolean allowReuseAddress;
    private boolean allowStartTLS;
    private boolean enabled;
    private boolean keepStats;
    private boolean sendRejectionNotice;
    private boolean shutdownRequested;
    private boolean useKeepAlive;
    private boolean useSSL;
    private boolean useTCPNoDelay;
    private ConnectionSecurityProvider securityProvider;
    private DN configEntryDN;
    private HashSet<InetAddress> listenAddresses;
    private int backlog;
    private int listenPort;
    private int maxRequestSize;
    private int numRequestHandlers;
    private int requestHandlerIndex;
    private LDAPRequestHandler[] requestHandlers;
    private LDAPStatistics statTracker;
    private Selector selector;
    private SSLClientAuthPolicy sslClientAuthPolicy;
    private String handlerName;
    private String securityMechanism;
    private String sslServerCertNickname;
    private String[] enabledSSLCipherSuites;
    private String[] enabledSSLProtocols;
    private Thread connHandlerThread;

    public LDAPConnectionHandler() {
        super("LDAP Connection Handler Thread");
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initializeConnectionHandler(ConfigEntry configEntry) throws ConfigException, InitializationException {
        int n;
        Object object;
        StringConfigAttribute stringConfigAttribute;
        StringConfigAttribute stringConfigAttribute2;
        ConfigAttribute configAttribute;
        Object object2;
        Object object3;
        BooleanConfigAttribute booleanConfigAttribute;
        ConfigAttribute configAttribute2;
        ConfigAttribute configAttribute3;
        BooleanConfigAttribute booleanConfigAttribute2;
        BooleanConfigAttribute booleanConfigAttribute3;
        BooleanConfigAttribute booleanConfigAttribute4;
        ConfigAttribute configAttribute4;
        ConfigAttribute configAttribute5;
        BooleanConfigAttribute booleanConfigAttribute5;
        Object object4;
        StringConfigAttribute stringConfigAttribute3;
        Object object5;
        ConfigAttribute configAttribute6;
        assert (Debug.debugEnter(CLASS_NAME, "initializeConnectionHandler", String.valueOf(configEntry)));
        this.enabled = true;
        this.configEntryDN = configEntry.getDN();
        int n2 = 2097367;
        this.listenAddresses = new HashSet();
        StringConfigAttribute stringConfigAttribute4 = new StringConfigAttribute("ds-cfg-listen-address", MessageHandler.getMessage(n2), true, true, true);
        try {
            configAttribute6 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute4);
            if (configAttribute6 == null || configAttribute6.activeValues().isEmpty()) {
                this.listenAddresses.add(InetAddress.getByName("0.0.0.0"));
            } else {
                for (String string : configAttribute6.activeValues()) {
                    try {
                        this.listenAddresses.add(InetAddress.getByName(string));
                    }
                    catch (UnknownHostException unknownHostException) {
                        assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", unknownHostException));
                        n2 = 2359526;
                        String string2 = MessageHandler.getMessage(n2, string, StaticUtils.stackTraceToSingleLineString(unknownHostException));
                        throw new ConfigException(n2, string2, unknownHostException);
                    }
                }
            }
        }
        catch (ConfigException configException) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", configException));
            throw configException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n2 = 2359527;
            String string = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n2, string, exception);
        }
        n2 = 2097368;
        configAttribute6 = new IntegerConfigAttribute("ds-cfg-listen-port", MessageHandler.getMessage(n2), true, false, true, true, 1L, true, 65535L);
        try {
            object5 = (IntegerConfigAttribute)configEntry.getConfigAttribute(configAttribute6);
            if (object5 == null) {
                n2 = 2359528;
                String string = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN));
                throw new ConfigException(n2, string);
            }
            this.listenPort = ((IntegerConfigAttribute)object5).activeIntValue();
        }
        catch (ConfigException configException) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", configException));
            throw configException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n2 = 2359529;
            String string = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n2, string, exception);
        }
        n2 = 2097471;
        object5 = new IntegerConfigAttribute("ds-cfg-accept-backlog", MessageHandler.getMessage(n2), true, false, true, true, 1L, true, Integer.MAX_VALUE);
        try {
            IntegerConfigAttribute integerConfigAttribute = (IntegerConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object5);
            this.backlog = integerConfigAttribute == null ? 128 : integerConfigAttribute.activeIntValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n2 = 2359616;
            String string = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n2, string, exception);
        }
        this.allowedClients = null;
        n2 = 2097369;
        StringConfigAttribute stringConfigAttribute5 = new StringConfigAttribute("ds-cfg-allowed-client", MessageHandler.getMessage(n2), false, true, false);
        try {
            stringConfigAttribute3 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute5);
            if (stringConfigAttribute3 != null) {
                object4 = stringConfigAttribute3.activeValues();
                this.allowedClients = new AddressMask[object4.size()];
                for (int i = 0; i < this.allowedClients.length; ++i) {
                    try {
                        this.allowedClients[i] = AddressMask.decode(object4.get(i));
                        continue;
                    }
                    catch (ConfigException configException) {
                        assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", configException));
                        n2 = 2359545;
                        String string = MessageHandler.getMessage(n2, object4.get(i), "ds-cfg-allowed-client", String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(configException));
                        throw new ConfigException(n2, string, configException);
                    }
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n2 = 2359530;
            String string = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n2, string, exception);
        }
        this.deniedClients = null;
        n2 = 2097370;
        stringConfigAttribute3 = new StringConfigAttribute("ds-cfg-denied-client", MessageHandler.getMessage(n2), false, true, false);
        try {
            object4 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute3);
            if (object4 != null) {
                List<String> list = ((StringConfigAttribute)object4).activeValues();
                this.deniedClients = new AddressMask[list.size()];
                for (int i = 0; i < this.deniedClients.length; ++i) {
                    try {
                        this.deniedClients[i] = AddressMask.decode(list.get(i));
                        continue;
                    }
                    catch (ConfigException configException) {
                        assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", configException));
                        n2 = 2359545;
                        String string = MessageHandler.getMessage(n2, list.get(i), "ds-cfg-allowed-client", String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(configException));
                        throw new ConfigException(n2, string, configException);
                    }
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n2 = 2359531;
            String string = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n2, string, exception);
        }
        n2 = 2097371;
        object4 = new BooleanConfigAttribute("ds-cfg-allow-ldapv2", MessageHandler.getMessage(n2), false);
        try {
            booleanConfigAttribute5 = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object4);
            this.allowLDAPv2 = booleanConfigAttribute5 == null ? true : booleanConfigAttribute5.activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n2 = 2359532;
            String string = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n2, string, exception);
        }
        n2 = 0x200102;
        booleanConfigAttribute5 = new BooleanConfigAttribute("ds-cfg-keep-stats", MessageHandler.getMessage(n2), false);
        try {
            configAttribute5 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute5);
            this.keepStats = configAttribute5 == null ? true : configAttribute5.activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n2 = 2359555;
            String string = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n2, string, exception);
        }
        n2 = 2097372;
        configAttribute5 = new IntegerConfigAttribute("ds-cfg-num-request-handlers", MessageHandler.getMessage(n2), true, false, true, true, 1L, false, 0L);
        try {
            configAttribute4 = (IntegerConfigAttribute)configEntry.getConfigAttribute(configAttribute5);
            this.numRequestHandlers = configAttribute4 == null ? 1 : configAttribute4.activeIntValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n2 = 2359533;
            String string = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n2, string, exception);
        }
        n2 = 0x2000DD;
        configAttribute4 = new BooleanConfigAttribute("ds-cfg-send-rejection-notice", MessageHandler.getMessage(n2), false);
        try {
            booleanConfigAttribute4 = (BooleanConfigAttribute)configEntry.getConfigAttribute(configAttribute4);
            this.sendRejectionNotice = booleanConfigAttribute4 == null ? true : booleanConfigAttribute4.activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n2 = 2359534;
            String string = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n2, string, exception);
        }
        n2 = 2097374;
        booleanConfigAttribute4 = new BooleanConfigAttribute("ds-cfg-use-tcp-keepalive", MessageHandler.getMessage(n2), false);
        try {
            booleanConfigAttribute3 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute4);
            this.useKeepAlive = booleanConfigAttribute3 == null ? true : booleanConfigAttribute3.activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n2 = 2359535;
            String string = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n2, string, exception);
        }
        n2 = 2097375;
        booleanConfigAttribute3 = new BooleanConfigAttribute("ds-cfg-use-tcp-nodelay", MessageHandler.getMessage(n2), false);
        try {
            booleanConfigAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute3);
            this.useTCPNoDelay = booleanConfigAttribute2 == null ? true : booleanConfigAttribute2.activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n2 = 2359536;
            String string = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n2, string, exception);
        }
        n2 = 0x2000E0;
        booleanConfigAttribute2 = new BooleanConfigAttribute("ds-cfg-allow-tcp-reuse-address", MessageHandler.getMessage(n2), true);
        try {
            configAttribute3 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute2);
            this.allowReuseAddress = configAttribute3 == null ? true : configAttribute3.activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n2 = 2359537;
            String string = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n2, string, exception);
        }
        n2 = 2097377;
        configAttribute3 = new IntegerWithUnitConfigAttribute("ds-cfg-max-request-size", MessageHandler.getMessage(n2), false, SIZE_UNITS, true, 0L, true, Integer.MAX_VALUE);
        try {
            configAttribute2 = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(configAttribute3);
            this.maxRequestSize = configAttribute2 == null ? 0x500000 : (int)configAttribute2.activeCalculatedValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n2 = 2359538;
            String string = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n2, string, exception);
        }
        n2 = 0x2000E2;
        configAttribute2 = new BooleanConfigAttribute("ds-cfg-use-ssl", MessageHandler.getMessage(n2), true);
        try {
            booleanConfigAttribute = (BooleanConfigAttribute)configEntry.getConfigAttribute(configAttribute2);
            this.useSSL = booleanConfigAttribute == null ? false : booleanConfigAttribute.activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n2 = 2359539;
            String string = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n2, string, exception);
        }
        n2 = 2097379;
        booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-allow-start-tls", MessageHandler.getMessage(n2), false);
        try {
            object3 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            this.allowStartTLS = object3 == null ? false : ((BooleanConfigAttribute)object3).activeValue();
            if (this.useSSL && this.allowStartTLS) {
                n2 = 2359540;
                object2 = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, (String)object2, n2);
                this.allowStartTLS = false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n2 = 2359541;
            String string = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n2, string, exception);
        }
        n2 = 2097380;
        object3 = new HashSet(3);
        ((HashSet)object3).add(StaticUtils.toLowerCase(SSLClientAuthPolicy.DISABLED.toString()));
        ((HashSet)object3).add(StaticUtils.toLowerCase(SSLClientAuthPolicy.OPTIONAL.toString()));
        ((HashSet)object3).add(StaticUtils.toLowerCase(SSLClientAuthPolicy.REQUIRED.toString()));
        object2 = new MultiChoiceConfigAttribute("ds-cfg-ssl-client-auth-policy", MessageHandler.getMessage(n2), false, false, true, (Set<String>)object3);
        try {
            configAttribute = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object2);
            if (configAttribute == null) {
                this.sslClientAuthPolicy = ConfigConstants.DEFAULT_SSL_CLIENT_AUTH_POLICY;
            } else {
                this.sslClientAuthPolicy = SSLClientAuthPolicy.policyForName(configAttribute.activeValue());
                if (this.sslClientAuthPolicy == null) {
                    n2 = 2359542;
                    String string = MessageHandler.getMessage(n2, configAttribute.activeValue(), String.valueOf(this.configEntryDN));
                    throw new ConfigException(n2, string);
                }
            }
        }
        catch (ConfigException configException) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", configException));
            throw configException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n2 = 2359543;
            String string = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n2, string, exception);
        }
        n2 = 2097381;
        configAttribute = new StringConfigAttribute("ds-cfg-ssl-cert-nickname", MessageHandler.getMessage(n2), false, false, true);
        try {
            stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(configAttribute);
            this.sslServerCertNickname = stringConfigAttribute2 == null ? "server-cert" : stringConfigAttribute2.activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n2 = 2359544;
            String string = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n2, string, exception);
        }
        this.enabledSSLProtocols = null;
        n2 = 2097417;
        stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-ssl-protocols", MessageHandler.getMessage(n2), false, true, false);
        try {
            stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute2);
            if (stringConfigAttribute != null) {
                this.enabledSSLProtocols = StaticUtils.listToArray(stringConfigAttribute.activeValues());
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n2 = 2359562;
            String string = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n2, string, exception);
        }
        this.enabledSSLCipherSuites = null;
        n2 = 2097419;
        stringConfigAttribute = new StringConfigAttribute("ds-cfg-ssl-cipher-suites", MessageHandler.getMessage(n2), false, true, false);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object != null) {
                this.enabledSSLCipherSuites = StaticUtils.listToArray(((StringConfigAttribute)object).activeValues());
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n2 = 2359564;
            String string = MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n2, string, exception);
        }
        if (this.useSSL) {
            object = new TLSConnectionSecurityProvider();
            ((TLSConnectionSecurityProvider)object).initializeConnectionSecurityProvider(null);
            ((TLSConnectionSecurityProvider)object).setSSLClientAuthPolicy(this.sslClientAuthPolicy);
            ((TLSConnectionSecurityProvider)object).setEnabledProtocols(this.enabledSSLProtocols);
            ((TLSConnectionSecurityProvider)object).setEnabledCipherSuites(this.enabledSSLCipherSuites);
            this.securityProvider = object;
        } else {
            this.securityProvider = new NullConnectionSecurityProvider();
            this.securityProvider.initializeConnectionSecurityProvider(null);
        }
        DirectoryServer.registerConfigurableComponent(this);
        try {
            this.selector = Selector.open();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n2 = 2425009;
            String string = MessageHandler.getMessage(n2, this.configEntryDN, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n2, string, exception);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("LDAP Connection Handler");
        for (InetAddress inetAddress : this.listenAddresses) {
            ((StringBuilder)object).append(" ");
            ((StringBuilder)object).append(inetAddress.getHostAddress());
        }
        ((StringBuilder)object).append(" port ");
        ((StringBuilder)object).append(this.listenPort);
        this.handlerName = ((StringBuilder)object).toString();
        this.securityMechanism = this.useSSL ? "SSL" : null;
        this.connHandlerThread = null;
        this.statTracker = new LDAPStatistics(this.handlerName);
        this.requestHandlers = new LDAPRequestHandler[this.numRequestHandlers];
        for (n = 0; n < this.numRequestHandlers; ++n) {
            this.requestHandlers[n] = new LDAPRequestHandler(this, n);
        }
        n = 0;
        while (n < this.numRequestHandlers) {
            this.requestHandlers[n].start();
            ++n;
        }
        return;
    }

    @Override
    public void finalizeConnectionHandler(String string, boolean bl) {
        block7: {
            assert (Debug.debugEnter(CLASS_NAME, "finalizeConnectionHandler", new String[0]));
            this.shutdownRequested = true;
            DirectoryServer.deregisterConfigurableComponent(this);
            try {
                this.selector.wakeup();
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "finalizeConnectionHandler", exception)) break block7;
                throw new AssertionError();
            }
        }
        if (bl) {
            for (LDAPRequestHandler lDAPRequestHandler : this.requestHandlers) {
                lDAPRequestHandler.processServerShutdown(string);
            }
        } else {
            for (LDAPRequestHandler lDAPRequestHandler : this.requestHandlers) {
                lDAPRequestHandler.registerShutdownListener();
            }
        }
    }

    @Override
    public Collection<ClientConnection> getClientConnections() {
        assert (Debug.debugEnter(CLASS_NAME, "getClientConnections", new String[0]));
        LinkedList<ClientConnection> linkedList = new LinkedList<ClientConnection>();
        for (LDAPRequestHandler lDAPRequestHandler : this.requestHandlers) {
            linkedList.addAll(lDAPRequestHandler.getClientConnections());
        }
        return linkedList;
    }

    @Override
    public void run() {
        assert (Debug.debugEnter(CLASS_NAME, "run", new String[0]));
        this.connHandlerThread = Thread.currentThread();
        this.setName(this.handlerName);
        boolean bl = false;
        while (!this.shutdownRequested) {
            if (!this.enabled) {
                if (bl) {
                    this.cleanUpSelector();
                    bl = false;
                    this.enabled = false;
                    Error.logError(ErrorLogCategory.CONNECTION_HANDLING, ErrorLogSeverity.NOTICE, 2294037, this.handlerName);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                this.cleanUpSelector();
                int n = 0;
                for (InetAddress exception : this.listenAddresses) {
                    try {
                        ServerSocketChannel n3 = ServerSocketChannel.open();
                        n3.socket().setReuseAddress(this.allowReuseAddress);
                        n3.socket().bind(new InetSocketAddress(exception, this.listenPort), this.backlog);
                        n3.configureBlocking(false);
                        n3.register(this.selector, 16);
                        ++n;
                        Error.logError(ErrorLogCategory.CONNECTION_HANDLING, ErrorLogSeverity.NOTICE, 2294036, this.handlerName);
                    }
                    catch (Exception exception3) {
                        assert (Debug.debugException(CLASS_NAME, "run", exception3));
                        Error.logError(ErrorLogCategory.CONNECTION_HANDLING, ErrorLogSeverity.SEVERE_ERROR, 2359474, this.configEntryDN, exception.getHostAddress(), this.listenPort, StaticUtils.stackTraceToSingleLineString(exception3));
                    }
                }
                if (n == 0) {
                    Error.logError(ErrorLogCategory.CONNECTION_HANDLING, ErrorLogSeverity.FATAL_ERROR, 2425011, this.configEntryDN);
                    this.enabled = false;
                    continue;
                }
                bl = true;
                boolean bl2 = false;
                while (this.enabled && !this.shutdownRequested) {
                    Object object;
                    try {
                        if (this.selector.select() > 0) {
                            Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                            while (iterator.hasNext()) {
                                block37: {
                                    SelectionKey selectionKey = iterator.next();
                                    if (selectionKey.isAcceptable()) {
                                        Object object2;
                                        object = (ServerSocketChannel)selectionKey.channel();
                                        SocketChannel socketChannel = ((ServerSocketChannel)object).accept();
                                        LDAPClientConnection lDAPClientConnection = new LDAPClientConnection(this, socketChannel);
                                        InetAddress inetAddress = lDAPClientConnection.getRemoteAddress();
                                        if (this.deniedClients != null && this.deniedClients.length > 0 && AddressMask.maskListContains(inetAddress.getAddress(), inetAddress.getHostName(), this.deniedClients)) {
                                            lDAPClientConnection.disconnect(DisconnectReason.CONNECTION_REJECTED, this.sendRejectionNotice, 2293940, lDAPClientConnection.getClientHostPort(), lDAPClientConnection.getServerHostPort());
                                            iterator.remove();
                                            continue;
                                        }
                                        if (this.allowedClients != null && this.allowedClients.length > 0 && !AddressMask.maskListContains(inetAddress.getAddress(), inetAddress.getHostName(), this.allowedClients)) {
                                            lDAPClientConnection.disconnect(DisconnectReason.CONNECTION_REJECTED, this.sendRejectionNotice, 2293941, lDAPClientConnection.getClientHostPort(), lDAPClientConnection.getServerHostPort());
                                            iterator.remove();
                                            continue;
                                        }
                                        socketChannel.socket().setKeepAlive(this.useKeepAlive);
                                        socketChannel.socket().setTcpNoDelay(this.useTCPNoDelay);
                                        ConnectionSecurityProvider connectionSecurityProvider = this.securityProvider.newInstance(lDAPClientConnection, socketChannel);
                                        lDAPClientConnection.setConnectionSecurityProvider(connectionSecurityProvider);
                                        if (lDAPClientConnection.getConnectionID() < 0L) {
                                            iterator.remove();
                                            continue;
                                        }
                                        try {
                                            PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
                                            PostConnectPluginResult postConnectPluginResult = pluginConfigManager.invokePostConnectPlugins(lDAPClientConnection);
                                            if (postConnectPluginResult.connectionTerminated()) {
                                                iterator.remove();
                                                continue;
                                            }
                                            object2 = this.requestHandlers[this.requestHandlerIndex++];
                                            if (this.requestHandlerIndex >= this.numRequestHandlers) {
                                                this.requestHandlerIndex = 0;
                                            }
                                            if (((LDAPRequestHandler)object2).registerClient(lDAPClientConnection)) {
                                                Access.logConnect(lDAPClientConnection);
                                                break block37;
                                            }
                                            iterator.remove();
                                        }
                                        catch (Exception exception) {
                                            assert (Debug.debugException(CLASS_NAME, "run", exception));
                                            int n2 = 2097334;
                                            object2 = MessageHandler.getMessage(n2, lDAPClientConnection.getClientHostPort(), lDAPClientConnection.getServerHostPort(), StaticUtils.stackTraceToSingleLineString(exception));
                                            Error.logError(ErrorLogCategory.CONNECTION_HANDLING, ErrorLogSeverity.SEVERE_ERROR, (String)object2, n2);
                                            lDAPClientConnection.disconnect(DisconnectReason.SERVER_ERROR, this.sendRejectionNotice, (String)object2, n2);
                                            iterator.remove();
                                        }
                                        continue;
                                    }
                                }
                                iterator.remove();
                            }
                        } else if (this.shutdownRequested) {
                            this.cleanUpSelector();
                            bl = false;
                            this.enabled = false;
                            continue;
                        }
                        bl2 = false;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "run", exception));
                        Error.logError(ErrorLogCategory.CONNECTION_HANDLING, ErrorLogSeverity.SEVERE_WARNING, 2293943, this.configEntryDN, StaticUtils.stackTraceToSingleLineString(exception));
                        if (bl2) {
                            int n3 = 2425016;
                            object = MessageHandler.getMessage(n3, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                            Error.logError(ErrorLogCategory.CONNECTION_HANDLING, ErrorLogSeverity.FATAL_ERROR, (String)object, n3);
                            DirectoryServer.sendAlertNotification(this, "org.opends.server.LDAPHandlerDisabledByConsecutiveFailures", n3, (String)object);
                            this.enabled = false;
                            try {
                                this.cleanUpSelector();
                            }
                            catch (Exception exception2) {}
                            continue;
                        }
                        bl2 = true;
                    }
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "run", exception));
                int n = 2425017;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.CONNECTION_HANDLING, ErrorLogSeverity.SEVERE_ERROR, string, n);
                DirectoryServer.sendAlertNotification(this, "org.opends.server.LDAPHandlerUncaughtError", n, string);
                try {
                    this.cleanUpSelector();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                this.enabled = false;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cleanUpSelector() {
        assert (Debug.debugEnter(CLASS_NAME, "cleanUpSelector", new String[0]));
        try {
            for (SelectionKey selectionKey : this.selector.keys()) {
                block9: {
                    try {
                        selectionKey.cancel();
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "cleanUpSelector", exception)) break block9;
                        throw new AssertionError();
                    }
                }
                try {
                    selectionKey.channel().close();
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "cleanUpSelector", exception));
                    continue;
                    return;
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "cleanUpSelector", exception));
            return;
        }
    }

    public boolean keepStats() {
        assert (Debug.debugEnter(CLASS_NAME, "keepStats", new String[0]));
        return this.keepStats;
    }

    public void setKeepStats(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setKeepStats", String.valueOf(bl)));
        this.keepStats = bl;
    }

    public LDAPStatistics getStatTracker() {
        assert (Debug.debugEnter(CLASS_NAME, "getStatTracker", new String[0]));
        return this.statTracker;
    }

    public boolean allowLDAPv2() {
        assert (Debug.debugEnter(CLASS_NAME, "allowLDAPv2", new String[0]));
        return this.allowLDAPv2;
    }

    public boolean allowStartTLS() {
        assert (Debug.debugEnter(CLASS_NAME, "allowStartTLS", new String[0]));
        return this.allowStartTLS;
    }

    public SSLClientAuthPolicy getSSLClientAuthPolicy() {
        assert (Debug.debugEnter(CLASS_NAME, "getSSLClientAuthPolicy", new String[0]));
        return this.sslClientAuthPolicy;
    }

    public String[] getEnabledSSLProtocols() {
        assert (Debug.debugEnter(CLASS_NAME, "getEnabledSSLProtocols", new String[0]));
        return this.enabledSSLProtocols;
    }

    public String[] getEnabledSSLCipherSuites() {
        assert (Debug.debugEnter(CLASS_NAME, "getEnabledSSLCipherSuites", new String[0]));
        return this.enabledSSLCipherSuites;
    }

    public int getMaxRequestSize() {
        assert (Debug.debugEnter(CLASS_NAME, "getMaxRequestSize", new String[0]));
        return this.maxRequestSize;
    }

    public String getShutdownListenerName() {
        assert (Debug.debugEnter(CLASS_NAME, "getShutdownListenerName", new String[0]));
        return this.handlerName;
    }

    public void processServerShutdown(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "processServerShutdown", new String[0]));
        this.shutdownRequested = true;
        try {
            for (LDAPRequestHandler lDAPRequestHandler : this.requestHandlers) {
                try {
                    lDAPRequestHandler.processServerShutdown(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        AbstractCollection abstractCollection;
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        int n = 2097367;
        ArrayList<String> arrayList = new ArrayList<String>(this.listenAddresses.size());
        for (InetAddress addressMaskArray : this.listenAddresses) {
            arrayList.add(addressMaskArray.getHostAddress());
        }
        linkedList.add(new StringConfigAttribute("ds-cfg-listen-address", MessageHandler.getMessage(n), true, true, true, arrayList));
        n = 2097368;
        linkedList.add(new IntegerConfigAttribute("ds-cfg-listen-port", MessageHandler.getMessage(n), true, false, true, true, 1L, true, 65535L, this.listenPort));
        n = 2097471;
        linkedList.add(new IntegerConfigAttribute("ds-cfg-accept-backlog", MessageHandler.getMessage(n), true, false, true, true, 1L, true, Integer.MAX_VALUE, this.backlog));
        if (this.allowedClients == null) {
            n = 2097369;
            abstractCollection = new ArrayList(0);
            linkedList.add(new StringConfigAttribute("ds-cfg-allowed-client", MessageHandler.getMessage(n), false, true, false, (List<String>)((Object)abstractCollection)));
        } else {
            n = 2097369;
            abstractCollection = new ArrayList<String>(this.allowedClients.length);
            for (AddressMask addressMask : this.allowedClients) {
                ((ArrayList)abstractCollection).add((String)addressMask.toString());
            }
            linkedList.add(new StringConfigAttribute("ds-cfg-allowed-client", MessageHandler.getMessage(n), false, true, false, (List<String>)((Object)abstractCollection)));
        }
        if (this.deniedClients == null) {
            n = 2097370;
            abstractCollection = new ArrayList(0);
            linkedList.add(new StringConfigAttribute("ds-cfg-denied-client", MessageHandler.getMessage(n), false, true, false, (List<String>)((Object)abstractCollection)));
        } else {
            n = 2097370;
            abstractCollection = new ArrayList(this.deniedClients.length);
            for (AddressMask addressMask : this.deniedClients) {
                ((ArrayList)abstractCollection).add((String)addressMask.toString());
            }
            linkedList.add(new StringConfigAttribute("ds-cfg-denied-client", MessageHandler.getMessage(n), false, true, false, (List<String>)((Object)abstractCollection)));
        }
        n = 2097371;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-allow-ldapv2", MessageHandler.getMessage(n), false, this.allowLDAPv2));
        n = 0x200102;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-keep-stats", MessageHandler.getMessage(n), false, this.keepStats));
        n = 2097372;
        linkedList.add(new IntegerConfigAttribute("ds-cfg-num-request-handlers", MessageHandler.getMessage(n), true, false, true, true, 1L, false, 0L, this.numRequestHandlers));
        n = 0x2000DD;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-send-rejection-notice", MessageHandler.getMessage(n), false, this.sendRejectionNotice));
        n = 2097374;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-use-tcp-keepalive", MessageHandler.getMessage(n), false, this.useKeepAlive));
        n = 2097375;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-use-tcp-nodelay", MessageHandler.getMessage(n), false, this.useTCPNoDelay));
        n = 0x2000E0;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-allow-tcp-reuse-address", MessageHandler.getMessage(n), true, this.allowReuseAddress));
        n = 2097377;
        linkedList.add(new IntegerWithUnitConfigAttribute("ds-cfg-max-request-size", MessageHandler.getMessage(n), false, SIZE_UNITS, true, 0L, true, Integer.MAX_VALUE, this.maxRequestSize, "bytes"));
        n = 0x2000E2;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-use-ssl", MessageHandler.getMessage(n), true, this.useSSL));
        n = 2097379;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-allow-start-tls", MessageHandler.getMessage(n), false, this.allowStartTLS));
        n = 2097380;
        abstractCollection = new HashSet(3);
        ((HashSet)abstractCollection).add((String)StaticUtils.toLowerCase(SSLClientAuthPolicy.DISABLED.toString()));
        ((HashSet)abstractCollection).add(StaticUtils.toLowerCase(SSLClientAuthPolicy.OPTIONAL.toString()));
        ((HashSet)abstractCollection).add(StaticUtils.toLowerCase(SSLClientAuthPolicy.REQUIRED.toString()));
        linkedList.add(new MultiChoiceConfigAttribute("ds-cfg-ssl-client-auth-policy", MessageHandler.getMessage(n), false, false, true, (Set<String>)((Object)abstractCollection), this.sslClientAuthPolicy.toString()));
        n = 2097381;
        linkedList.add(new StringConfigAttribute("ds-cfg-ssl-cert-nickname", MessageHandler.getMessage(n), false, false, true, this.sslServerCertNickname));
        n = 2097417;
        linkedList.add(new StringConfigAttribute("ds-cfg-ssl-protocols", MessageHandler.getMessage(n), false, true, false, StaticUtils.arrayToList(this.enabledSSLProtocols)));
        n = 2097419;
        linkedList.add(new StringConfigAttribute("ds-cfg-ssl-cipher-suites", MessageHandler.getMessage(n), false, true, false, StaticUtils.arrayToList(this.enabledSSLCipherSuites)));
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        StringConfigAttribute stringConfigAttribute;
        Object object;
        ConfigAttribute configAttribute;
        Object object2;
        boolean bl;
        BooleanConfigAttribute booleanConfigAttribute;
        ConfigAttribute configAttribute2;
        BooleanConfigAttribute booleanConfigAttribute2;
        BooleanConfigAttribute booleanConfigAttribute3;
        BooleanConfigAttribute booleanConfigAttribute4;
        ConfigAttribute configAttribute3;
        Object object3;
        StringConfigAttribute stringConfigAttribute2;
        Object object6;
        ConfigAttribute configAttribute4;
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
        boolean bl2 = true;
        int n = 2097367;
        StringConfigAttribute stringConfigAttribute3 = new StringConfigAttribute("ds-cfg-listen-address", MessageHandler.getMessage(n), true, true, false);
        try {
            configAttribute4 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute3);
            if (configAttribute4 != null && !configAttribute4.activeValues().isEmpty()) {
                for (String object72 : configAttribute4.activeValues()) {
                    try {
                        InetAddress.getByName(object72);
                    }
                    catch (UnknownHostException unknownHostException) {
                        assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", unknownHostException));
                        n = 2359526;
                        list.add(MessageHandler.getMessage(n, object72, StaticUtils.stackTraceToSingleLineString(unknownHostException)));
                        bl2 = false;
                    }
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 2359527;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl2 = false;
        }
        n = 2097368;
        configAttribute4 = new IntegerConfigAttribute("ds-cfg-listen-port", MessageHandler.getMessage(n), true, false, false, true, 1L, true, 65535L);
        try {
            object6 = (IntegerConfigAttribute)configEntry.getConfigAttribute(configAttribute4);
            if (object6 == null) {
                n = 2359528;
                list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                bl2 = false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 2359529;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl2 = false;
        }
        n = 2097471;
        object6 = new IntegerConfigAttribute("ds-cfg-accept-backlog", MessageHandler.getMessage(n), true, false, true, true, 1L, true, Integer.MAX_VALUE);
        try {
            IntegerConfigAttribute exception = (IntegerConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object6);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 2359616;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl2 = false;
        }
        n = 2097369;
        StringConfigAttribute stringConfigAttribute4 = new StringConfigAttribute("ds-cfg-allowed-client", MessageHandler.getMessage(n), false, true, false);
        try {
            stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute4);
            if (stringConfigAttribute2 != null) {
                for (String string : stringConfigAttribute2.activeValues()) {
                    try {
                        AddressMask.decode(string);
                    }
                    catch (ConfigException configException) {
                        assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", configException));
                        n = 2359545;
                        list.add(MessageHandler.getMessage(n, string, "ds-cfg-allowed-client", String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(configException)));
                        bl2 = false;
                    }
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 2359530;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl2 = false;
        }
        n = 2097370;
        stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-denied-client", MessageHandler.getMessage(n), false, true, false);
        try {
            object3 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute2);
            if (object3 != null) {
                for (String string : ((StringConfigAttribute)object3).activeValues()) {
                    try {
                        AddressMask.decode(string);
                    }
                    catch (ConfigException configException) {
                        assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", configException));
                        n = 2359545;
                        list.add(MessageHandler.getMessage(n, string, "ds-cfg-denied-client", String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(configException)));
                        bl2 = false;
                    }
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 2359531;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl2 = false;
        }
        n = 2097371;
        object3 = new BooleanConfigAttribute("ds-cfg-allow-ldapv2", MessageHandler.getMessage(n), false);
        try {
            BooleanConfigAttribute booleanConfigAttribute5 = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object3);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 2359532;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl2 = false;
        }
        n = 0x200102;
        BooleanConfigAttribute booleanConfigAttribute6 = new BooleanConfigAttribute("ds-cfg-keep-stats", MessageHandler.getMessage(n), false);
        try {
            BooleanConfigAttribute booleanConfigAttribute7 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute6);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 2359555;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl2 = false;
        }
        n = 2097372;
        IntegerConfigAttribute integerConfigAttribute = new IntegerConfigAttribute("ds-cfg-num-request-handlers", MessageHandler.getMessage(n), true, false, true, true, 1L, false, 0L);
        try {
            configAttribute3 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 2359533;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl2 = false;
        }
        n = 0x2000DD;
        configAttribute3 = new BooleanConfigAttribute("ds-cfg-send-rejection-notice", MessageHandler.getMessage(n), false);
        try {
            booleanConfigAttribute4 = (BooleanConfigAttribute)configEntry.getConfigAttribute(configAttribute3);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 2359534;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl2 = false;
        }
        n = 2097374;
        booleanConfigAttribute4 = new BooleanConfigAttribute("ds-cfg-use-tcp-keepalive", MessageHandler.getMessage(n), false);
        try {
            booleanConfigAttribute3 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute4);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 2359535;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl2 = false;
        }
        n = 2097375;
        booleanConfigAttribute3 = new BooleanConfigAttribute("ds-cfg-use-tcp-nodelay", MessageHandler.getMessage(n), false);
        try {
            booleanConfigAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute3);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 2359536;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl2 = false;
        }
        n = 0x2000E0;
        booleanConfigAttribute2 = new BooleanConfigAttribute("ds-cfg-allow-tcp-reuse-address", MessageHandler.getMessage(n), true);
        try {
            configAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 2359537;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl2 = false;
        }
        n = 2097377;
        configAttribute2 = new IntegerWithUnitConfigAttribute("ds-cfg-max-request-size", MessageHandler.getMessage(n), false, SIZE_UNITS, true, 0L, true, Integer.MAX_VALUE);
        try {
            IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(configAttribute2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 2359538;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl2 = false;
        }
        n = 0x2000E2;
        BooleanConfigAttribute booleanConfigAttribute8 = new BooleanConfigAttribute("ds-cfg-use-ssl", MessageHandler.getMessage(n), true);
        try {
            booleanConfigAttribute = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute8);
            bl = booleanConfigAttribute == null ? false : booleanConfigAttribute.pendingValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 2359539;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl2 = false;
            bl = false;
        }
        n = 2097379;
        booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-allow-start-tls", MessageHandler.getMessage(n), false);
        try {
            object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            boolean bl3 = object2 == null ? false : ((BooleanConfigAttribute)object2).activeValue();
            if (bl && bl3) {
                n = 2359540;
                list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                bl2 = false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 2359541;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl2 = false;
        }
        n = 2097380;
        object2 = new HashSet(3);
        ((HashSet)object2).add(StaticUtils.toLowerCase(SSLClientAuthPolicy.DISABLED.toString()));
        ((HashSet)object2).add(StaticUtils.toLowerCase(SSLClientAuthPolicy.OPTIONAL.toString()));
        ((HashSet)object2).add(StaticUtils.toLowerCase(SSLClientAuthPolicy.REQUIRED.toString()));
        MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute("ds-cfg-ssl-client-auth-policy", MessageHandler.getMessage(n), false, false, true, (Set<String>)object2);
        try {
            configAttribute = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute);
            if (configAttribute != null && (object = SSLClientAuthPolicy.policyForName(((MultiChoiceConfigAttribute)configAttribute).activeValue())) == null) {
                n = 2359542;
                list.add(MessageHandler.getMessage(n, ((MultiChoiceConfigAttribute)configAttribute).activeValue(), String.valueOf(this.configEntryDN)));
                bl2 = false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 2359543;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl2 = false;
        }
        n = 2097381;
        configAttribute = new StringConfigAttribute("ds-cfg-ssl-cert-nickname", MessageHandler.getMessage(n), false, false, true);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(configAttribute);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 2359544;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl2 = false;
        }
        n = 2097417;
        object = new StringConfigAttribute("ds-cfg-ssl-protocols", MessageHandler.getMessage(n), false, true, false);
        try {
            stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 2359562;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl2 = false;
        }
        n = 2097419;
        stringConfigAttribute = new StringConfigAttribute("ds-cfg-ssl-cipher-suites", MessageHandler.getMessage(n), false, true, false);
        try {
            StringConfigAttribute stringConfigAttribute5 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 2359564;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl2 = false;
        }
        return bl2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        AddressMask[] addressMaskArray;
        Object object;
        boolean bl2;
        Object object2;
        int n;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        Object object4;
        boolean bl8;
        int n2;
        HashSet<AddressMask> hashSet;
        ArrayList<String> arrayList;
        boolean bl9;
        ResultCode resultCode;
        block102: {
            block101: {
                assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
                resultCode = ResultCode.SUCCESS;
                bl9 = false;
                arrayList = new ArrayList<String>();
                hashSet = null;
                n2 = 2097369;
                StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-allowed-client", MessageHandler.getMessage(n2), false, true, false);
                try {
                    StringConfigAttribute stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                    if (stringConfigAttribute2 != null) {
                        hashSet = new HashSet<AddressMask>();
                        for (String string : stringConfigAttribute2.pendingValues()) {
                            try {
                                hashSet.add(AddressMask.decode(string));
                            }
                            catch (ConfigException configException) {
                                assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", configException));
                                n2 = 2359545;
                                arrayList.add(MessageHandler.getMessage(n2, string, "ds-cfg-allowed-client", String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(configException)));
                                if (resultCode != ResultCode.SUCCESS) continue;
                                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                    n2 = 2359530;
                    arrayList.add(MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                    if (resultCode != ResultCode.SUCCESS) break block101;
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
            bl8 = false;
            if (resultCode == ResultCode.SUCCESS) {
                if (this.allowedClients == null || this.allowedClients.length == 0) {
                    bl8 = hashSet != null && !hashSet.isEmpty();
                } else if (hashSet == null || hashSet.isEmpty()) {
                    bl8 = true;
                } else if (this.allowedClients.length != hashSet.size()) {
                    bl8 = true;
                } else {
                    for (AddressMask object5 : this.allowedClients) {
                        if (hashSet.contains(object5)) continue;
                        bl8 = true;
                        break;
                    }
                }
            }
            object4 = null;
            n2 = 2097370;
            StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-denied-client", MessageHandler.getMessage(n2), false, true, false);
            try {
                StringConfigAttribute stringConfigAttribute3 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                if (stringConfigAttribute3 != null) {
                    object4 = new HashSet();
                    for (String string : stringConfigAttribute3.pendingValues()) {
                        try {
                            ((HashSet)object4).add(AddressMask.decode(string));
                        }
                        catch (ConfigException configException) {
                            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", configException));
                            n2 = 2359545;
                            arrayList.add(MessageHandler.getMessage(n2, string, "ds-cfg-denied-client", String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(configException)));
                            if (resultCode != ResultCode.SUCCESS) continue;
                            resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                        }
                    }
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                n2 = 2359531;
                arrayList.add(MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                if (resultCode != ResultCode.SUCCESS) break block102;
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
        }
        boolean bl10 = false;
        if (resultCode == ResultCode.SUCCESS) {
            if (this.deniedClients == null || this.deniedClients.length == 0) {
                bl10 = object4 != null && !((HashSet)object4).isEmpty();
            } else if (object4 == null || ((HashSet)object4).isEmpty()) {
                bl10 = true;
            } else if (this.deniedClients.length != ((HashSet)object4).size()) {
                bl10 = true;
            } else {
                for (AddressMask addressMask : this.deniedClients) {
                    if (((HashSet)object4).contains(addressMask)) continue;
                    bl10 = true;
                    break;
                }
            }
        }
        n2 = 2097371;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-allow-ldapv2", MessageHandler.getMessage(n2), false);
        try {
            BooleanConfigAttribute booleanConfigAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (booleanConfigAttribute2 == null) {
                boolean bl7 = true;
            } else {
                boolean bl11 = booleanConfigAttribute2.pendingValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n2 = 2359532;
            arrayList.add(MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            boolean bl12 = true;
        }
        n2 = 0x200102;
        BooleanConfigAttribute booleanConfigAttribute3 = new BooleanConfigAttribute("ds-cfg-keep-stats", MessageHandler.getMessage(n2), false);
        try {
            BooleanConfigAttribute booleanConfigAttribute4 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute3);
            bl6 = booleanConfigAttribute4 == null ? true : booleanConfigAttribute4.pendingValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n2 = 2359555;
            arrayList.add(MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            bl6 = true;
        }
        n2 = 0x2000DD;
        BooleanConfigAttribute booleanConfigAttribute5 = new BooleanConfigAttribute("ds-cfg-send-rejection-notice", MessageHandler.getMessage(n2), false);
        try {
            BooleanConfigAttribute booleanConfigAttribute6 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute5);
            bl5 = booleanConfigAttribute6 == null ? true : booleanConfigAttribute6.pendingValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n2 = 2359534;
            arrayList.add(MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            bl5 = true;
        }
        n2 = 2097374;
        BooleanConfigAttribute booleanConfigAttribute7 = new BooleanConfigAttribute("ds-cfg-use-tcp-keepalive", MessageHandler.getMessage(n2), false);
        try {
            BooleanConfigAttribute booleanConfigAttribute8 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute7);
            bl4 = booleanConfigAttribute8 == null ? true : booleanConfigAttribute8.pendingValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n2 = 2359535;
            arrayList.add(MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            bl4 = true;
        }
        n2 = 2097375;
        BooleanConfigAttribute booleanConfigAttribute9 = new BooleanConfigAttribute("ds-cfg-use-tcp-nodelay", MessageHandler.getMessage(n2), false);
        try {
            BooleanConfigAttribute booleanConfigAttribute10 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute9);
            bl3 = booleanConfigAttribute10 == null ? true : booleanConfigAttribute10.pendingValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n2 = 2359536;
            arrayList.add(MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            bl3 = true;
        }
        n2 = 2097377;
        IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute = new IntegerWithUnitConfigAttribute("ds-cfg-max-request-size", MessageHandler.getMessage(n2), false, SIZE_UNITS, true, 0L, true, Integer.MAX_VALUE);
        try {
            IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute2 = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(integerWithUnitConfigAttribute);
            n = integerWithUnitConfigAttribute2 == null ? 0x500000 : (int)integerWithUnitConfigAttribute2.pendingCalculatedValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n2 = 2359538;
            arrayList.add(MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            n = 0x500000;
        }
        n2 = 2097379;
        BooleanConfigAttribute booleanConfigAttribute11 = new BooleanConfigAttribute("ds-cfg-allow-start-tls", MessageHandler.getMessage(n2), false);
        try {
            object2 = (Object[])configEntry.getConfigAttribute(booleanConfigAttribute11);
            bl2 = object2 == null ? false : object2.pendingValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n2 = 2359541;
            arrayList.add(MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            bl2 = false;
        }
        n2 = 2097417;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-ssl-protocols", MessageHandler.getMessage(n2), false, true, false);
        try {
            object = (Object[])configEntry.getConfigAttribute(stringConfigAttribute);
            object2 = object == null ? null : StaticUtils.listToArray(object.pendingValues());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n2 = 2359562;
            arrayList.add(MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            object2 = null;
        }
        n2 = 2097419;
        StringConfigAttribute stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-ssl-cipher-suites", MessageHandler.getMessage(n2), false, true, false);
        try {
            addressMaskArray = (AddressMask[])configEntry.getConfigAttribute(stringConfigAttribute2);
            object = addressMaskArray == null ? null : StaticUtils.listToArray(addressMaskArray.pendingValues());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n2 = 2359564;
            arrayList.add(MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            object = null;
        }
        if (resultCode == ResultCode.SUCCESS) {
            void var13_30;
            if (bl8) {
                if (hashSet == null || hashSet.isEmpty()) {
                    addressMaskArray = null;
                } else {
                    addressMaskArray = new AddressMask[hashSet.size()];
                    hashSet.toArray(addressMaskArray);
                }
                this.allowedClients = addressMaskArray;
                if (bl) {
                    arrayList.add(MessageHandler.getMessage(2097402, String.valueOf(this.configEntryDN)));
                }
            }
            if (bl10) {
                if (object4 == null || ((HashSet)object4).isEmpty()) {
                    addressMaskArray = null;
                } else {
                    addressMaskArray = new AddressMask[((HashSet)object4).size()];
                    ((HashSet)object4).toArray(addressMaskArray);
                }
                this.deniedClients = addressMaskArray;
                if (bl) {
                    arrayList.add(MessageHandler.getMessage(2097403, String.valueOf(this.configEntryDN)));
                }
            }
            if (this.allowLDAPv2 != var13_30) {
                this.allowLDAPv2 = var13_30;
                if (this.allowLDAPv2) {
                    if (this.statTracker == null) {
                        this.statTracker = new LDAPStatistics(this.handlerName);
                    } else {
                        this.statTracker.clearStatistics();
                    }
                }
                if (bl) {
                    arrayList.add(MessageHandler.getMessage(2097404, String.valueOf((boolean)var13_30), String.valueOf(this.configEntryDN)));
                }
            }
            if (this.keepStats != bl6) {
                this.keepStats = bl6;
                if (bl) {
                    arrayList.add(MessageHandler.getMessage(2097412, String.valueOf(bl6), String.valueOf(this.configEntryDN)));
                }
            }
            if (this.sendRejectionNotice != bl5) {
                this.sendRejectionNotice = bl5;
                if (bl) {
                    arrayList.add(MessageHandler.getMessage(2097405, String.valueOf(bl5), String.valueOf(this.configEntryDN)));
                }
            }
            if (this.useKeepAlive != bl4) {
                this.useKeepAlive = bl4;
                if (bl) {
                    arrayList.add(MessageHandler.getMessage(2097406, String.valueOf(bl4), String.valueOf(this.configEntryDN)));
                }
            }
            if (this.useTCPNoDelay != bl3) {
                this.useTCPNoDelay = bl3;
                if (bl) {
                    arrayList.add(MessageHandler.getMessage(0x2000FF, String.valueOf(bl3), String.valueOf(this.configEntryDN)));
                }
            }
            if (this.maxRequestSize != n) {
                this.maxRequestSize = n;
                if (bl) {
                    arrayList.add(MessageHandler.getMessage(0x200100, String.valueOf(n), String.valueOf(this.configEntryDN)));
                }
            }
            if (this.allowStartTLS != bl2) {
                this.allowStartTLS = bl2;
                if (bl) {
                    arrayList.add(MessageHandler.getMessage(0x200101, String.valueOf(bl2), String.valueOf(this.configEntryDN)));
                }
            }
            if (!Arrays.equals(this.enabledSSLProtocols, object2)) {
                this.enabledSSLProtocols = object2;
                if (bl) {
                    arrayList.add(MessageHandler.getMessage(2097421, Arrays.toString(object2), String.valueOf(this.configEntryDN)));
                }
            }
            if (!Arrays.equals(this.enabledSSLCipherSuites, object)) {
                this.enabledSSLCipherSuites = object;
                if (bl) {
                    arrayList.add(MessageHandler.getMessage(2097422, Arrays.toString(object), String.valueOf(this.configEntryDN)));
                }
            }
        }
        return new ConfigChangeResult(resultCode, bl9, arrayList);
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append(this.handlerName);
    }

    @Override
    public DN getComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public String getClassName() {
        assert (Debug.debugEnter(CLASS_NAME, "getClassName", new String[0]));
        return CLASS_NAME;
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        assert (Debug.debugEnter(CLASS_NAME, "getAlerts", new String[0]));
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("org.opends.server.LDAPHandlerDisabledByConsecutiveFailures", "This alert type will be used to notify administrators of consecutive failures that have occurred in the LDAP connection handler that have caused it to become disabled.");
        linkedHashMap.put("org.opends.server.LDAPHandlerUncaughtError", "This alert type will be used to notify administrators of uncaught errors in the LDAP connection handler that have caused it to become disabled.");
        return linkedHashMap;
    }

    static {
        SIZE_UNITS.put("b", 1.0);
        SIZE_UNITS.put("bytes", 1.0);
        SIZE_UNITS.put("kb", 1000.0);
        SIZE_UNITS.put("kilobytes", 1000.0);
        SIZE_UNITS.put("mb", 1000000.0);
        SIZE_UNITS.put("megabytes", 1000000.0);
        SIZE_UNITS.put("gb", 1.0E9);
        SIZE_UNITS.put("gigabytes", 1.0E9);
        SIZE_UNITS.put("kib", 1024.0);
        SIZE_UNITS.put("kibibytes", 1024.0);
        SIZE_UNITS.put("mib", 1048576.0);
        SIZE_UNITS.put("mebibytes", 1048576.0);
        SIZE_UNITS.put("gib", 1.073741824E9);
        SIZE_UNITS.put("gibibytes", 1.073741824E9);
    }
}

