/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Enumerated;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.DN;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareResponseProtocolOp
extends ProtocolOp {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.CompareResponseProtocolOp";
    private DN matchedDN;
    private int resultCode;
    private List<String> referralURLs;
    private String errorMessage;

    public CompareResponseProtocolOp(int n) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(n)));
        this.resultCode = n;
        this.errorMessage = null;
        this.matchedDN = null;
        this.referralURLs = null;
    }

    public CompareResponseProtocolOp(int n, String string) {
        assert (Debug.debugEnter(CLASS_NAME, String.valueOf(n), String.valueOf(string)));
        this.resultCode = n;
        this.errorMessage = string;
        this.matchedDN = null;
        this.referralURLs = null;
    }

    public CompareResponseProtocolOp(int n, String string, DN dN, List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, String.valueOf(n), String.valueOf(string), String.valueOf(dN), String.valueOf(list)));
        this.resultCode = n;
        this.errorMessage = string;
        this.matchedDN = dN;
        this.referralURLs = list;
    }

    public int getResultCode() {
        assert (Debug.debugEnter(CLASS_NAME, "getResultCode", new String[0]));
        return this.resultCode;
    }

    public void setResultCode(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setResultCode", String.valueOf(n)));
        this.resultCode = n;
    }

    public String getErrorMessage() {
        assert (Debug.debugEnter(CLASS_NAME, "getErrorMessage", new String[0]));
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setErrorMessage", String.valueOf(string)));
        this.errorMessage = string;
    }

    public DN getMatchedDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchedDN", new String[0]));
        return this.matchedDN;
    }

    public void setMatchedDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "setMatchedDN", String.valueOf(dN)));
        this.matchedDN = dN;
    }

    public List<String> getReferralURLs() {
        assert (Debug.debugEnter(CLASS_NAME, "getReferralURLs", new String[0]));
        return this.referralURLs;
    }

    public void setReferralURLs(List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, "setReferralURLs", String.valueOf(list)));
        this.referralURLs = list;
    }

    @Override
    public byte getType() {
        assert (Debug.debugEnter(CLASS_NAME, "getType", new String[0]));
        return 111;
    }

    @Override
    public String getProtocolOpName() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolOpName", new String[0]));
        return "Compare Response";
    }

    @Override
    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(4);
        arrayList.add(new ASN1Enumerated(this.resultCode));
        if (this.matchedDN == null) {
            arrayList.add(new ASN1OctetString());
        } else {
            arrayList.add(new ASN1OctetString(this.matchedDN.toString()));
        }
        arrayList.add(new ASN1OctetString(this.errorMessage));
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            ArrayList<ASN1Element> arrayList2 = new ArrayList<ASN1Element>(this.referralURLs.size());
            for (String string : this.referralURLs) {
                arrayList2.add(new ASN1OctetString(string));
            }
            arrayList.add(new ASN1Sequence(-93, arrayList2));
        }
        return new ASN1Sequence(111, arrayList);
    }

    public static CompareResponseProtocolOp decodeCompareResponse(ASN1Element aSN1Element) throws LDAPException {
        ArrayList<String> arrayList;
        DN dN;
        String string;
        int n;
        ArrayList<ASN1Element> arrayList2;
        assert (Debug.debugEnter(CLASS_NAME, "decodeCompareResponse", String.valueOf(aSN1Element)));
        try {
            arrayList2 = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeCompareResponse", exception));
            int n2 = 2293820;
            String string2 = MessageHandler.getMessage(n2, String.valueOf(exception));
            throw new LDAPException(2, n2, string2, exception);
        }
        int n3 = arrayList2.size();
        if (n3 < 3 || n3 > 4) {
            int n4 = 2293821;
            String string3 = MessageHandler.getMessage(n4, n3);
            throw new LDAPException(2, n4, string3);
        }
        try {
            n = arrayList2.get(0).decodeAsInteger().intValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeCompareResponse", exception));
            int n5 = 2293822;
            String string4 = MessageHandler.getMessage(n5, String.valueOf(exception));
            throw new LDAPException(2, n5, string4, exception);
        }
        try {
            string = arrayList2.get(1).decodeAsOctetString().stringValue();
            dN = string.length() == 0 ? null : DN.decode(string);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeCompareResponse", exception));
            int n6 = 2293823;
            String string5 = MessageHandler.getMessage(n6, String.valueOf(exception));
            throw new LDAPException(2, n6, string5, exception);
        }
        try {
            string = arrayList2.get(2).decodeAsOctetString().stringValue();
            if (string.length() == 0) {
                string = null;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeCompareResponse", exception));
            int n7 = 2293824;
            String string6 = MessageHandler.getMessage(n7, String.valueOf(exception));
            throw new LDAPException(2, n7, string6, exception);
        }
        if (n3 == 3) {
            arrayList = null;
        } else {
            try {
                ArrayList<ASN1Element> arrayList3 = arrayList2.get(3).decodeAsSequence().elements();
                arrayList = new ArrayList<String>(arrayList3.size());
                for (ASN1Element aSN1Element2 : arrayList3) {
                    arrayList.add(aSN1Element2.decodeAsOctetString().stringValue());
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "decodeCompareResponse", exception));
                int n8 = 2293825;
                String string7 = MessageHandler.getMessage(n8, String.valueOf(exception));
                throw new LDAPException(2, n8, string7, exception);
            }
        }
        return new CompareResponseProtocolOp(n, string, dN, arrayList);
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("CompareResponse(resultCode=");
        stringBuilder.append(this.resultCode);
        if (this.errorMessage != null && this.errorMessage.length() > 0) {
            stringBuilder.append(", errorMessage=");
            stringBuilder.append(this.errorMessage);
        }
        if (this.matchedDN != null) {
            stringBuilder.append(", matchedDN=");
            stringBuilder.append(this.matchedDN.toString());
        }
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            stringBuilder.append(", referralURLs={");
            Iterator<String> iterator = this.referralURLs.iterator();
            stringBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(", ");
                stringBuilder.append(iterator.next());
            }
            stringBuilder.append("}");
        }
        stringBuilder.append(")");
    }

    @Override
    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("Compare Response");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Result Code:  ");
        stringBuilder.append(this.resultCode);
        stringBuilder.append(ServerConstants.EOL);
        if (this.errorMessage != null) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  Error Message:  ");
            stringBuilder.append(this.errorMessage);
            stringBuilder.append(ServerConstants.EOL);
        }
        if (this.matchedDN != null) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  Matched DN:  ");
            this.matchedDN.toString(stringBuilder);
            stringBuilder.append(ServerConstants.EOL);
        }
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  Referral URLs:  ");
            stringBuilder.append(ServerConstants.EOL);
            for (String string : this.referralURLs) {
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder.append("  ");
                stringBuilder.append(string);
                stringBuilder.append(ServerConstants.EOL);
            }
        }
    }
}

