/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.jmx;

import java.io.IOException;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import org.opends.server.protocols.jmx.DirectoryRMIClientSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpendsJmxConnector
implements JMXConnector {
    private JMXConnector jmxc = null;
    private Map<String, Object> environment = null;
    private JMXServiceURL serviceURL = null;
    private String serverHostname = null;

    public OpendsJmxConnector(String string, int n, Map<String, Object> map) throws IOException {
        this.serviceURL = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + string + ":" + n + "/org.opends.server.protocols.jmx.client-unknown");
        this.jmxc = JMXConnectorFactory.newJMXConnector(this.serviceURL, map);
        this.serverHostname = string;
        this.environment = map;
    }

    public Map getConnectionEnv() {
        return this.environment;
    }

    @Override
    public void connect() throws IOException, SecurityException {
        this.connect(null);
    }

    @Override
    public void connect(Map<String, ?> map) throws IOException, SecurityException {
        DirectoryRMIClientSocketFactory.setServerHostname(this.serverHostname);
        if (map != null) {
            this.updateCredentials(map);
        }
        DirectoryRMIClientSocketFactory.setConnectionEnv(this.environment);
        this.jmxc.connect(map);
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() throws IOException {
        return this.jmxc.getMBeanServerConnection();
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(Subject subject) throws IOException {
        return this.jmxc.getMBeanServerConnection(subject);
    }

    @Override
    public void close() throws IOException {
        this.jmxc.close();
    }

    @Override
    public void addConnectionNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws NullPointerException {
        this.jmxc.addConnectionNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException, NullPointerException {
        this.jmxc.removeConnectionNotificationListener(notificationListener);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.jmxc.removeConnectionNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public String getConnectionId() throws IOException {
        return this.jmxc.getConnectionId();
    }

    private void updateCredentials(Map map) throws IOException {
        if (!map.containsKey("jmx.remote.credentials")) {
            return;
        }
        Object v = map.get("jmx.remote.credentials");
        this.environment.put("jmx.remote.credentials", v);
    }
}

