/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.jmx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.IntegerConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.jmx.RmiConnector;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxConnectionHandler
extends ConnectionHandler
implements ConfigurableComponent,
ConfigChangeListener,
ConfigDeleteListener,
ConfigAddListener,
AlertGenerator {
    private static final String CLASS_NAME = "org.opends.server.protocols.jmx.JMXConnectionHandler";
    private DN configEntryDN;
    private static final String KeyManagerRDN = "cn=Key Manager Provider";
    protected boolean enabled;
    protected boolean useSSL;
    BooleanConfigAttribute useSslAtt;
    protected String sslServerCertNickname;
    StringConfigAttribute sslServerCertNickNameAtt;
    private String handlerName;
    protected RmiConnector rmiConnector;
    protected int listenPort;
    private IntegerConfigAttribute listenPortAtt;
    protected KeyManagerProvider jmxKeyManager;
    public static final String TRUST_MANAGER_ARRAY_KEY = "org.opends.server.protocol.jmx.ssl.trust.manager.array";
    private LinkedList<ConfigAttribute> configAttrs = new LinkedList();
    protected LinkedList<ClientConnection> connectionList = new LinkedList();

    public JmxConnectionHandler() {
        super("JMX Connection Handler Thread");
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public boolean configAddIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configAddIsAcceptable", new String[0]));
        if (this.jmxKeyManager != null) {
            return false;
        }
        DN dN = null;
        try {
            dN = DN.decode("cn=Key Manager Provider, " + this.configEntryDN);
        }
        catch (Exception exception) {
            return false;
        }
        return dN.equals(configEntry.getDN());
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationAdd", new String[0]));
        this.jmxKeyManager = this.getJmxKeyManager(configEntry);
        if (this.useSSL) {
            this.applyNewConfiguration(this.listenPort, this.useSSL, this.sslServerCertNickname);
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public boolean configDeleteIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        return !this.useSSL;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(ConfigEntry configEntry) {
        this.jmxKeyManager = null;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public boolean configChangeIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        if (configEntry.getDN().compareTo(this.configEntryDN) == 0) {
            return true;
        }
        return !this.useSSL;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ConfigEntry configEntry) {
        if (configEntry.getDN().compareTo(this.configEntryDN) == 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            return new ConfigChangeResult(ResultCode.SUCCESS, false, arrayList);
        }
        this.jmxKeyManager = this.getJmxKeyManager(configEntry);
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public void initializeConnectionHandler(ConfigEntry configEntry) throws ConfigException, InitializationException {
        Object object;
        assert (Debug.debugEnter(CLASS_NAME, "initializeConnectionHandler", String.valueOf(configEntry)));
        this.enabled = true;
        this.configEntryDN = configEntry.getDN();
        this.listenPortAtt = this.getListenPort(configEntry);
        this.configAttrs.add(this.listenPortAtt);
        this.listenPort = this.listenPortAtt.activeIntValue();
        this.useSslAtt = this.getUseSSL(configEntry);
        this.configAttrs.add(this.useSslAtt);
        this.useSSL = this.useSslAtt.activeValue();
        this.sslServerCertNickNameAtt = this.getServerCertNickname(configEntry);
        this.configAttrs.add(this.sslServerCertNickNameAtt);
        this.sslServerCertNickname = this.sslServerCertNickNameAtt.activeValue();
        configEntry.registerDeleteListener(this);
        configEntry.registerChangeListener(this);
        configEntry.registerAddListener(this);
        if (this.useSSL) {
            try {
                object = DN.decode("cn=Key Manager Provider, " + this.configEntryDN);
                ConfigEntry configEntry2 = DirectoryServer.getConfigEntry((DN)object);
                this.jmxKeyManager = this.getJmxKeyManager(configEntry2);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408181, StaticUtils.stackTraceToSingleLineString(exception));
                configEntry.registerAddListener(this);
                this.jmxKeyManager = null;
            }
        } else {
            this.jmxKeyManager = null;
        }
        this.rmiConnector = new RmiConnector(DirectoryServer.getJMXMBeanServer(), this);
        DirectoryServer.registerConfigurableComponent(this);
        if (this.useSSL && this.jmxKeyManager == null) {
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 3408186);
            int n = 2359647;
            object = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), "");
            throw new InitializationException(n, (String)object);
        }
    }

    @Override
    public void finalizeConnectionHandler(String string, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeConnectionHandler", new String[0]));
        this.rmiConnector.finalizeConnectionHandler(bl);
    }

    @Override
    public Collection<ClientConnection> getClientConnections() {
        assert (Debug.debugEnter(CLASS_NAME, "getClientConnections", new String[0]));
        return this.connectionList;
    }

    @Override
    public void run() {
        this.rmiConnector.initialize();
    }

    public String getShutdownListenerName() {
        assert (Debug.debugEnter(CLASS_NAME, "getShutdownListenerName", new String[0]));
        return this.handlerName;
    }

    public void processServerShutdown(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "processServerShutdown", new String[0]));
        this.rmiConnector.finalizeConnectionHandler(true);
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        return this.configAttrs;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
        boolean bl = true;
        try {
            this.getListenPort(configEntry);
        }
        catch (Exception exception) {
            n = 2359645;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl = false;
        }
        try {
            boolean bl2 = this.getUseSSL(configEntry).activeValue();
            if (bl2 && this.jmxKeyManager == null) {
                n = 2097502;
                list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), null));
                bl = false;
            }
        }
        catch (Exception exception) {
            n = 2097502;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl = false;
        }
        try {
            this.getServerCertNickname(configEntry);
        }
        catch (Exception exception) {
            bl = false;
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 2359649;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
        }
        return bl;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.listenPort;
        try {
            n = this.getListenPort(configEntry).activeIntValue();
            if (n != this.listenPort) {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            int n2 = 2359645;
            arrayList.add(MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        boolean bl3 = this.useSSL;
        try {
            bl3 = this.getUseSSL(configEntry).activeValue();
            if (bl3 != this.useSSL) {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            int n3 = 2097502;
            arrayList.add(MessageHandler.getMessage(n3, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        String string = this.sslServerCertNickname;
        try {
            string = this.getServerCertNickname(configEntry).activeValue();
            if (string != this.sslServerCertNickname) {
                bl2 = true;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            int n4 = 2359649;
            arrayList.add(MessageHandler.getMessage(n4, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        if (bl2) {
            this.applyNewConfiguration(n, bl3, string);
        }
        return new ConfigChangeResult(resultCode, false, arrayList);
    }

    private void applyNewConfiguration(int n, boolean bl, String string) {
        this.finalizeConnectionHandler("new config", true);
        if (this.listenPort != n) {
            try {
                this.listenPortAtt.setValue(n);
                this.listenPort = n;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.useSSL != bl) {
            this.useSSL = bl;
            this.useSslAtt.setValue(bl);
        }
        if (this.sslServerCertNickname != string) {
            try {
                this.sslServerCertNickNameAtt.setValue(string);
                this.sslServerCertNickname = string;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.rmiConnector.initialize();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append(this.handlerName);
    }

    @Override
    public DN getComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public String getClassName() {
        assert (Debug.debugEnter(CLASS_NAME, "getClassName", new String[0]));
        return CLASS_NAME;
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        assert (Debug.debugEnter(CLASS_NAME, "getAlerts", new String[0]));
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        return linkedHashMap;
    }

    private IntegerConfigAttribute getListenPort(ConfigEntry configEntry) throws InitializationException, ConfigException {
        int n = 2097499;
        IntegerConfigAttribute integerConfigAttribute = new IntegerConfigAttribute("ds-cfg-listen-port", MessageHandler.getMessage(n), true, false, false, true, 1L, true, 65535L);
        IntegerConfigAttribute integerConfigAttribute2 = null;
        try {
            integerConfigAttribute2 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute);
            if (integerConfigAttribute2 == null) {
                n = 2359644;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
                throw new ConfigException(n, string);
            }
        }
        catch (ConfigException configException) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", configException));
            throw configException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n = 2359645;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        return integerConfigAttribute2;
    }

    private BooleanConfigAttribute getUseSSL(ConfigEntry configEntry) throws InitializationException {
        int n = 2097502;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-use-ssl", MessageHandler.getMessage(n), false);
        BooleanConfigAttribute booleanConfigAttribute2 = null;
        try {
            booleanConfigAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (booleanConfigAttribute2 == null) {
                booleanConfigAttribute2 = new BooleanConfigAttribute("ds-cfg-use-ssl", MessageHandler.getMessage(n), false, false, false);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n = 2359647;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        return booleanConfigAttribute2;
    }

    private StringConfigAttribute getServerCertNickname(ConfigEntry configEntry) throws InitializationException {
        int n = 2097504;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-ssl-cert-nickname", MessageHandler.getMessage(n), false, false, false);
        StringConfigAttribute stringConfigAttribute2 = null;
        try {
            stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (stringConfigAttribute2 == null) {
                stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-ssl-cert-nickname", MessageHandler.getMessage(n), false, false, false, "server-cert");
            }
            return stringConfigAttribute2;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeConnectionHandler", exception));
            n = 2359649;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
    }

    private KeyManagerProvider getJmxKeyManager(ConfigEntry configEntry) {
        KeyManagerProvider keyManagerProvider;
        Object object;
        Object object2;
        boolean bl = false;
        if (configEntry == null) {
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 3408182);
            return null;
        }
        int n = 3408185;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-key-manager-provider-enabled", MessageHandler.getMessage(n), false);
        try {
            object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (object2 == null) {
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 3408186);
                bl = true;
            } else if (!((BooleanConfigAttribute)object2).activeValue()) {
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_WARNING, 3408187);
                bl = true;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408188, StaticUtils.stackTraceToSingleLineString(exception));
            return null;
        }
        n = 3408189;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-key-manager-provider-class", MessageHandler.getMessage(n), true, false, false);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object == null) {
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408190);
                return null;
            }
            object2 = ((StringConfigAttribute)object).activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408191, StaticUtils.stackTraceToSingleLineString(exception));
            return null;
        }
        try {
            object = Class.forName((String)object2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408192, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception));
            return null;
        }
        try {
            keyManagerProvider = (KeyManagerProvider)((Class)object).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408193, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception));
            return null;
        }
        try {
            keyManagerProvider.initializeKeyManagerProvider(configEntry);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 3408194, String.valueOf(object2), exception.getMessage());
            return null;
        }
        if (bl) {
            return null;
        }
        return keyManagerProvider;
    }
}

