/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.jmx;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMIServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.opends.server.loggers.Debug;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;

public class DirectoryRMIServerSocketFactory
implements RMIServerSocketFactory {
    private SSLSocketFactory sslSocketFactory = null;
    private final boolean needClientCertificate;
    private static final String CLASS_NAME = "org.opends.server.protocols.jmx.DirectoryRMIServerSocketFactory";

    public DirectoryRMIServerSocketFactory(SSLSocketFactory sSLSocketFactory, boolean bl) {
        this.needClientCertificate = bl;
        this.sslSocketFactory = sSLSocketFactory;
    }

    public final boolean getNeedClientCertificate() {
        return this.needClientCertificate;
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        return new ServerSocket(n, 0, InetAddress.getByName("0.0.0.0")){

            public Socket accept() throws IOException {
                Socket socket = super.accept();
                assert (Debug.debugMessage(DebugLogCategory.CONNECTION_HANDLING, DebugLogSeverity.VERBOSE, DirectoryRMIServerSocketFactory.CLASS_NAME, "createServerSocket", "host/port:" + socket.getInetAddress().getHostName() + "/" + socket.getPort()));
                SSLSocket sSLSocket = (SSLSocket)DirectoryRMIServerSocketFactory.this.sslSocketFactory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), true);
                sSLSocket.setUseClientMode(false);
                sSLSocket.setNeedClientAuth(DirectoryRMIServerSocketFactory.this.needClientCertificate);
                return sSLSocket;
            }
        };
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof DirectoryRMIServerSocketFactory)) {
            return false;
        }
        DirectoryRMIServerSocketFactory directoryRMIServerSocketFactory = (DirectoryRMIServerSocketFactory)object;
        return this.getClass().equals(directoryRMIServerSocketFactory.getClass()) && this.checkParameters(directoryRMIServerSocketFactory);
    }

    private boolean checkParameters(DirectoryRMIServerSocketFactory directoryRMIServerSocketFactory) {
        if (this.needClientCertificate != directoryRMIServerSocketFactory.needClientCertificate) {
            return false;
        }
        return this.sslSocketFactory.equals(directoryRMIServerSocketFactory.sslSocketFactory);
    }

    public int hashCode() {
        return this.getClass().hashCode() + (this.needClientCertificate ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode()) + this.sslSocketFactory.hashCode();
    }
}

