/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1Element;

public class ASN1Writer {
    private static final String CLASS_NAME = "org.opends.server.protocols.asn1.ASN1Writer";
    private OutputStream outputStream;
    private Socket socket;

    public ASN1Writer(Socket socket) throws IOException {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(socket)));
        this.socket = socket;
        this.outputStream = socket.getOutputStream();
    }

    public ASN1Writer(OutputStream outputStream) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(outputStream)));
        this.outputStream = outputStream;
        this.socket = null;
    }

    public int writeElement(ASN1Element aSN1Element) throws IOException {
        assert (Debug.debugEnter(CLASS_NAME, "writeElement", String.valueOf(aSN1Element)));
        byte[] byArray = aSN1Element.encode();
        this.outputStream.write(byArray);
        this.outputStream.flush();
        return byArray.length;
    }

    public void close() {
        block6: {
            block5: {
                try {
                    this.outputStream.close();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "close", exception)) break block5;
                    throw new AssertionError();
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "close", exception)) break block6;
                    throw new AssertionError();
                }
            }
        }
    }
}

