/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins.profiler;

import java.util.ArrayList;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;

public class ProfileStack {
    private static final String CLASS_NAME = "org.opends.server.plugins.profiler.ProfileStack";
    public static final int LINE_NUMBER_UNKNOWN = -1;
    public static final int LINE_NUMBER_NATIVE = -2;
    private int numFrames;
    private int[] lineNumbers;
    private String[] classNames;
    private String[] methodNames;

    public ProfileStack(StackTraceElement[] stackTraceElementArray) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(stackTraceElementArray)));
        this.numFrames = stackTraceElementArray.length;
        this.classNames = new String[this.numFrames];
        this.methodNames = new String[this.numFrames];
        this.lineNumbers = new int[this.numFrames];
        int n = 0;
        int n2 = this.numFrames - 1;
        while (n < this.numFrames) {
            this.classNames[n] = stackTraceElementArray[n2].getClassName();
            this.methodNames[n] = stackTraceElementArray[n2].getMethodName();
            this.lineNumbers[n] = stackTraceElementArray[n2].getLineNumber();
            if (this.lineNumbers[n] <= 0) {
                this.lineNumbers[n] = stackTraceElementArray[n2].isNativeMethod() ? -2 : -1;
            }
            ++n;
            --n2;
        }
    }

    private ProfileStack(String[] stringArray, String[] stringArray2, int[] nArray) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(stringArray), String.valueOf(stringArray2), String.valueOf(nArray)));
        this.numFrames = stringArray.length;
        this.classNames = stringArray;
        this.methodNames = stringArray2;
        this.lineNumbers = nArray;
    }

    public int getNumFrames() {
        assert (Debug.debugEnter(CLASS_NAME, "getDepth", new String[0]));
        return this.numFrames;
    }

    public String[] getClassNames() {
        assert (Debug.debugEnter(CLASS_NAME, "getClassNames", new String[0]));
        return this.classNames;
    }

    public String getClassName(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "getClassName", String.valueOf(n)));
        return this.classNames[n];
    }

    public String[] getMethodNames() {
        assert (Debug.debugEnter(CLASS_NAME, "getMethodNames", new String[0]));
        return this.methodNames;
    }

    public String getMethodName(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "getMethodName", String.valueOf(n)));
        return this.methodNames[n];
    }

    public int[] getLineNumbers() {
        assert (Debug.debugEnter(CLASS_NAME, "getLineNumbers", new String[0]));
        return this.lineNumbers;
    }

    public int getLineNumber(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "getLineNumber", String.valueOf(n)));
        return this.lineNumbers[n];
    }

    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        if (this.numFrames == 0) {
            return 0;
        }
        return this.classNames[0].hashCode() + this.methodNames[0].hashCode() + this.lineNumbers[0];
    }

    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", String.valueOf(object)));
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        try {
            ProfileStack profileStack = (ProfileStack)object;
            if (this.numFrames != profileStack.numFrames) {
                return false;
            }
            for (int i = 0; i < this.numFrames; ++i) {
                if (this.lineNumbers[i] == profileStack.lineNumbers[i] && this.classNames[i].equals(profileStack.classNames[i]) && this.methodNames[i].equals(profileStack.methodNames[i])) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "equals", exception));
            return false;
        }
    }

    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(3 * this.numFrames);
        for (int i = 0; i < this.numFrames; ++i) {
            arrayList.add(new ASN1OctetString(this.classNames[i]));
            arrayList.add(new ASN1OctetString(this.methodNames[i]));
            arrayList.add(new ASN1OctetString(String.valueOf(this.lineNumbers[i])));
        }
        return new ASN1Sequence(arrayList);
    }

    public static ProfileStack decode(ASN1Element aSN1Element) {
        assert (Debug.debugEnter(CLASS_NAME, "decode", String.valueOf(aSN1Element)));
        try {
            ArrayList<ASN1Element> arrayList = aSN1Element.decodeAsSequence().elements();
            int n = arrayList.size() / 3;
            String[] stringArray = new String[n];
            String[] stringArray2 = new String[n];
            int[] nArray = new int[n];
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                stringArray[n2] = arrayList.get(n3).decodeAsOctetString().stringValue();
                stringArray2[n2] = arrayList.get(n3 + 1).decodeAsOctetString().stringValue();
                nArray[n2] = Integer.parseInt(arrayList.get(n3 + 2).decodeAsOctetString().stringValue());
                ++n2;
                n3 += 3;
            }
            return new ProfileStack(stringArray, stringArray2, nArray);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decode", exception));
            return null;
        }
    }
}

