/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.api.plugin.PreOperationPluginResult;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastModPlugin
extends DirectoryServerPlugin {
    private static final String CLASS_NAME = "org.opends.server.plugins.LastModPlugin";
    private AttributeType createTimestampType;
    private AttributeType creatorsNameType;
    private AttributeType modifiersNameType;
    private AttributeType modifyTimestampType;

    public LastModPlugin() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializePlugin(DirectoryServer directoryServer, Set<PluginType> set, ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializePlugin", String.valueOf(directoryServer), String.valueOf(set), String.valueOf(configEntry)));
        block3: for (PluginType pluginType : set) {
            switch (pluginType) {
                case PRE_OPERATION_ADD: 
                case PRE_OPERATION_MODIFY: 
                case PRE_OPERATION_MODIFY_DN: {
                    continue block3;
                }
            }
            int n = 7602227;
            String string = MessageHandler.getMessage(n, pluginType.toString());
            throw new ConfigException(n, string);
        }
        this.createTimestampType = DirectoryServer.getAttributeType("createtimestamp");
        if (this.createTimestampType == null) {
            this.createTimestampType = DirectoryServer.getDefaultAttributeType("createTimestamp");
        }
        this.creatorsNameType = DirectoryServer.getAttributeType("creatorsname");
        if (this.creatorsNameType == null) {
            this.creatorsNameType = DirectoryServer.getDefaultAttributeType("creatorsName");
        }
        this.modifiersNameType = DirectoryServer.getAttributeType("modifiersname");
        if (this.modifiersNameType == null) {
            this.modifiersNameType = DirectoryServer.getDefaultAttributeType("modifiersName");
        }
        this.modifyTimestampType = DirectoryServer.getAttributeType("modifytimestamp");
        if (this.modifyTimestampType == null) {
            this.modifyTimestampType = DirectoryServer.getDefaultAttributeType("modifyTimestamp");
        }
    }

    @Override
    public PreOperationPluginResult doPreOperation(AddOperation addOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "doPreOperation", String.valueOf(addOperation)));
        Map<AttributeType, List<Attribute>> map = addOperation.getOperationalAttributes();
        DN dN = addOperation.getAuthorizationDN();
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        if (dN == null) {
            linkedHashSet.add(new AttributeValue(this.creatorsNameType, (ByteString)new ASN1OctetString()));
        } else {
            linkedHashSet.add(new AttributeValue(this.creatorsNameType, (ByteString)new ASN1OctetString(dN.toString())));
        }
        Attribute attribute = new Attribute(this.creatorsNameType, "creatorsName", linkedHashSet);
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
        arrayList.add(attribute);
        map.put(this.creatorsNameType, arrayList);
        LinkedHashSet<AttributeValue> linkedHashSet2 = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet2.add(new AttributeValue(this.createTimestampType, (ByteString)new ASN1OctetString(TimeThread.getUTCTime())));
        Attribute attribute2 = new Attribute(this.createTimestampType, "createTimestamp", linkedHashSet2);
        ArrayList<Attribute> arrayList2 = new ArrayList<Attribute>(1);
        arrayList2.add(attribute2);
        map.put(this.createTimestampType, arrayList2);
        return new PreOperationPluginResult();
    }

    @Override
    public PreOperationPluginResult doPreOperation(ModifyOperation modifyOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "doPreOperation", String.valueOf(modifyOperation)));
        List<Modification> list = modifyOperation.getModifications();
        Entry entry = modifyOperation.getModifiedEntry();
        DN dN = modifyOperation.getAuthorizationDN();
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        if (dN == null) {
            linkedHashSet.add(new AttributeValue(this.modifiersNameType, (ByteString)new ASN1OctetString()));
        } else {
            linkedHashSet.add(new AttributeValue(this.modifiersNameType, (ByteString)new ASN1OctetString(dN.toString())));
        }
        Attribute attribute = new Attribute(this.modifiersNameType, "modifiersName", linkedHashSet);
        list.add(new Modification(ModificationType.REPLACE, attribute));
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
        arrayList.add(attribute);
        entry.putAttribute(this.modifiersNameType, arrayList);
        LinkedHashSet<AttributeValue> linkedHashSet2 = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet2.add(new AttributeValue(this.modifyTimestampType, (ByteString)new ASN1OctetString(TimeThread.getUTCTime())));
        Attribute attribute2 = new Attribute(this.modifyTimestampType, "modifyTimestamp", linkedHashSet2);
        list.add(new Modification(ModificationType.REPLACE, attribute2));
        ArrayList<Attribute> arrayList2 = new ArrayList<Attribute>(1);
        arrayList2.add(attribute2);
        entry.putAttribute(this.modifyTimestampType, arrayList2);
        return new PreOperationPluginResult();
    }

    @Override
    public PreOperationPluginResult doPreOperation(ModifyDNOperation modifyDNOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "doPreOperation", String.valueOf(modifyDNOperation)));
        List<Modification> list = modifyDNOperation.getModifications();
        DN dN = modifyDNOperation.getAuthorizationDN();
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        if (dN == null) {
            linkedHashSet.add(new AttributeValue(this.modifiersNameType, (ByteString)new ASN1OctetString()));
        } else {
            linkedHashSet.add(new AttributeValue(this.modifiersNameType, (ByteString)new ASN1OctetString(dN.toString())));
        }
        Attribute attribute = new Attribute(this.modifiersNameType, "modifiersName", linkedHashSet);
        list.add(new Modification(ModificationType.REPLACE, attribute));
        LinkedHashSet<AttributeValue> linkedHashSet2 = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet2.add(new AttributeValue(this.modifyTimestampType, (ByteString)new ASN1OctetString(TimeThread.getUTCTime())));
        Attribute attribute2 = new Attribute(this.modifyTimestampType, "modifyTimestamp", linkedHashSet2);
        list.add(new Modification(ModificationType.REPLACE, attribute2));
        return new PreOperationPluginResult();
    }
}

