/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.LDIFPluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.api.plugin.PreOperationPluginResult;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeUsage;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryUUIDPlugin
extends DirectoryServerPlugin {
    private static final String CLASS_NAME = "org.opends.server.plugins.EntryUUIDPlugin";
    private static final String ENTRYUUID = "entryuuid";
    private AttributeType entryUUIDType;

    public EntryUUIDPlugin() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializePlugin(DirectoryServer directoryServer, Set<PluginType> set, ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializePlugin", String.valueOf(directoryServer), String.valueOf(set), String.valueOf(configEntry)));
        block3: for (PluginType pluginType : set) {
            switch (pluginType) {
                case LDIF_IMPORT: 
                case PRE_OPERATION_ADD: {
                    continue block3;
                }
            }
            int n = 7602238;
            String string = MessageHandler.getMessage(n, pluginType.toString());
            throw new ConfigException(n, string);
        }
        this.entryUUIDType = DirectoryServer.getAttributeType(ENTRYUUID);
        if (this.entryUUIDType == null) {
            this.entryUUIDType = new AttributeType(ENTRYUUID, Collections.singleton(ENTRYUUID), ENTRYUUID, null, null, DirectoryServer.getDefaultAttributeSyntax(), AttributeUsage.DIRECTORY_OPERATION, false, true, false, true);
        }
    }

    @Override
    public LDIFPluginResult doLDIFImport(LDIFImportConfig lDIFImportConfig, Entry entry) {
        assert (Debug.debugEnter(CLASS_NAME, "doLDIFImport", String.valueOf(lDIFImportConfig), String.valueOf(entry)));
        List<Attribute> list = entry.getAttribute(this.entryUUIDType);
        if (list != null) {
            return new LDIFPluginResult();
        }
        byte[] byArray = StaticUtils.getBytes(entry.getDN().toNormalizedString());
        UUID uUID = UUID.nameUUIDFromBytes(byArray);
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet.add(new AttributeValue(this.entryUUIDType, (ByteString)new ASN1OctetString(uUID.toString())));
        list = new ArrayList<Attribute>(1);
        Attribute attribute = new Attribute(this.entryUUIDType, "entryUUID", linkedHashSet);
        list.add(attribute);
        entry.putAttribute(this.entryUUIDType, list);
        return new LDIFPluginResult();
    }

    @Override
    public PreOperationPluginResult doPreOperation(AddOperation addOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "doPreOperation", String.valueOf(addOperation)));
        Map<AttributeType, List<Attribute>> map = addOperation.getOperationalAttributes();
        List<Attribute> list = map.get(this.entryUUIDType);
        if (list != null) {
            return new PreOperationPluginResult();
        }
        UUID uUID = UUID.randomUUID();
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet.add(new AttributeValue(this.entryUUIDType, (ByteString)new ASN1OctetString(uUID.toString())));
        list = new ArrayList<Attribute>(1);
        Attribute attribute = new Attribute(this.entryUUIDType, "entryUUID", linkedHashSet);
        list.add(attribute);
        map.put(this.entryUUIDType, list);
        return new PreOperationPluginResult();
    }
}

