/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.util.ArrayList;
import org.opends.server.api.DirectoryThread;
import org.opends.server.config.ConfigEntry;
import org.opends.server.loggers.ActionType;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.EncryptAction;
import org.opends.server.loggers.GZIPAction;
import org.opends.server.loggers.PostRotationAction;
import org.opends.server.loggers.RotationConfigUtil;
import org.opends.server.loggers.SignatureAction;
import org.opends.server.loggers.ZIPAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotationActionThread
extends DirectoryThread {
    private static final String CLASS_NAME = "org.opends.server.loggers.RotationActionThread";
    private ArrayList<ActionType> actions;
    private String filename;
    private ConfigEntry configEntry;

    public RotationActionThread(String string, ArrayList<ActionType> arrayList, ConfigEntry configEntry) {
        super("Logger Rotation Action Thread");
        this.filename = string;
        this.actions = arrayList;
        this.configEntry = configEntry;
    }

    @Override
    public void run() {
        block9: {
            try {
                for (ActionType actionType : this.actions) {
                    boolean bl;
                    PostRotationAction postRotationAction = null;
                    switch (actionType) {
                        case GZIP_COMPRESS: {
                            String string = this.filename + ".gz";
                            postRotationAction = new GZIPAction(this.filename, string, true);
                            break;
                        }
                        case ZIP_COMPRESS: {
                            String string = this.filename + ".zip";
                            postRotationAction = new ZIPAction(this.filename, string, true);
                            break;
                        }
                        case SIGN: {
                            String string = RotationConfigUtil.getCertificateAlias(this.configEntry);
                            postRotationAction = new SignatureAction(this.filename, string);
                            break;
                        }
                        case ENCRYPT: {
                            String string = this.filename + ".enc";
                            String string2 = RotationConfigUtil.getCertificateAlias(this.configEntry);
                            postRotationAction = new EncryptAction(this.filename, string, false, string2, "RSA");
                            break;
                        }
                        default: {
                            System.err.println("Invalid post rollover action:" + (Object)((Object)actionType));
                        }
                    }
                    if (postRotationAction == null || (bl = postRotationAction.execute())) continue;
                    System.err.println("Post rotation action failed.");
                }
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "run", exception)) break block9;
                throw new AssertionError();
            }
        }
    }
}

