/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.PostRotationAction;

public class GZIPAction
implements PostRotationAction {
    private static final String CLASS_NAME = "org.opends.server.loggers.GZIPAction";
    private File originalFile;
    private File newFile;
    private boolean deleteOriginal;

    public GZIPAction(String string, String string2, boolean bl) {
        this.originalFile = new File(string);
        this.newFile = new File(string2);
        this.deleteOriginal = bl;
    }

    public boolean execute() {
        FileInputStream fileInputStream = null;
        DeflaterOutputStream deflaterOutputStream = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            int n;
            if (!this.originalFile.exists()) {
                System.err.println("Source file does not exist:" + this.originalFile);
                return false;
            }
            fileInputStream = new FileInputStream(this.originalFile);
            bl = true;
            FileOutputStream fileOutputStream = new FileOutputStream(this.newFile);
            deflaterOutputStream = new GZIPOutputStream(fileOutputStream);
            bl2 = true;
            byte[] byArray = new byte[8192];
            while ((n = fileInputStream.read(byArray)) != -1) {
                ((GZIPOutputStream)deflaterOutputStream).write(byArray, 0, n);
            }
            deflaterOutputStream.close();
            bl2 = false;
            fileInputStream.close();
            bl = false;
            if (this.deleteOriginal && !this.originalFile.delete()) {
                System.err.println("Cannot delete original file:" + this.originalFile);
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            block13: {
                block12: {
                    assert (Debug.debugException(CLASS_NAME, "execute", iOException));
                    if (bl) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Exception exception) {
                            if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "execute", exception)) break block12;
                            throw new AssertionError();
                        }
                    }
                }
                if (bl2) {
                    try {
                        deflaterOutputStream.close();
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "execute", exception)) break block13;
                        throw new AssertionError();
                    }
                }
            }
            return false;
        }
    }
}

