/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.util.GregorianCalendar;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.RotationPolicy;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;
import org.opends.server.util.TimeThread;

public class FixedTimeRotationPolicy
implements RotationPolicy {
    private static final String CLASS_NAME = "org.opends.server.loggers.FixedTimeRotationPolicy";
    private static final long NEXT_DAY = 86400000L;
    private long[] rotationTimes;
    private long nextRotationTime = 0L;

    public FixedTimeRotationPolicy(int[] nArray) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(nArray)));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(14, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(11, 0);
        long l = gregorianCalendar.getTime().getTime();
        this.rotationTimes = new long[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i] / 100;
            int n2 = nArray[i] - n * 100;
            this.rotationTimes[i] = l + (long)(n * 3600 * 1000) + (long)(n2 * 60 * 1000);
        }
        long l2 = TimeThread.getTime();
        this.nextRotationTime = this.getNextRotationTime(l2, 0L);
    }

    public boolean rotateFile() {
        assert (Debug.debugEnter(CLASS_NAME, "rotateFile", new String[0]));
        long l = TimeThread.getTime();
        assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.INFO, CLASS_NAME, "rotateFile", "Rotation at fixed time:" + l + " nextRotationTime:" + this.nextRotationTime));
        if (l > this.nextRotationTime) {
            this.nextRotationTime = this.getNextRotationTime(l, this.nextRotationTime);
            return true;
        }
        return false;
    }

    private long getNextRotationTime(long l, long l2) {
        int n;
        long l3 = l2;
        for (n = 0; n < this.rotationTimes.length; ++n) {
            if (l >= this.rotationTimes[n]) continue;
            l2 = this.rotationTimes[n];
            break;
        }
        if (l2 == l3) {
            n = 0;
            while (n < this.rotationTimes.length) {
                int n2 = n++;
                this.rotationTimes[n2] = this.rotationTimes[n2] + 86400000L;
            }
            l2 = this.rotationTimes[0];
        }
        return l2;
    }
}

