/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.util.Arrays;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.FileComparator;
import org.opends.server.loggers.LogFileFilter;
import org.opends.server.loggers.RetentionPolicy;

public class FileNumberRetentionPolicy
implements RetentionPolicy {
    private static final String CLASS_NAME = "org.opends.server.loggers.FileNumberRetentionPolicy";
    private int numFiles = 0;
    private File directory = null;
    private String prefix = null;

    public FileNumberRetentionPolicy(String string, String string2, int n) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(string2), String.valueOf(n)));
        this.numFiles = n;
        this.directory = new File(string);
        this.prefix = string2;
    }

    public int deleteFiles() {
        assert (Debug.debugEnter(CLASS_NAME, "deleteFiles", new String[0]));
        int n = 0;
        File[] fileArray = this.directory.listFiles(new LogFileFilter(this.prefix));
        if (fileArray.length <= this.numFiles) {
            return 0;
        }
        Arrays.sort(fileArray, new FileComparator());
        for (int i = this.numFiles; i < fileArray.length; ++i) {
            fileArray[i].delete();
            ++n;
        }
        return n;
    }
}

