/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import org.opends.server.api.Backend;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.EntryCache;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.IntegerWithUnitConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.core.LockManager;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.CacheEntry;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.LockType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftReferenceEntryCache
extends EntryCache
implements ConfigurableComponent,
Runnable {
    private static final String CLASS_NAME = "org.opends.server.extensions.SoftReferenceEntryCache";
    private static final LinkedHashMap<String, Double> timeUnits = new LinkedHashMap();
    private ConcurrentHashMap<DN, SoftReference<CacheEntry>> dnMap;
    private ConcurrentHashMap<Backend, ConcurrentHashMap<Long, SoftReference<CacheEntry>>> idMap;
    private DN configEntryDN;
    private HashSet<SearchFilter> excludeFilters;
    private HashSet<SearchFilter> includeFilters;
    private long lockTimeout;
    private ReferenceQueue<CacheEntry> referenceQueue;

    public SoftReferenceEntryCache() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.dnMap = new ConcurrentHashMap();
        this.idMap = new ConcurrentHashMap();
        this.excludeFilters = new HashSet();
        this.includeFilters = new HashSet();
        this.lockTimeout = 3000L;
        this.referenceQueue = new ReferenceQueue();
        Thread thread = new Thread((Runnable)this, "Soft Reference Entry Cache Cleaner");
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void initializeEntryCache(ConfigEntry configEntry) throws ConfigException, InitializationException {
        Object object;
        Object object2;
        Object object3;
        StringConfigAttribute stringConfigAttribute;
        ConfigAttribute configAttribute;
        assert (Debug.debugEnter(CLASS_NAME, "initializeEntryCache", String.valueOf(configEntry)));
        this.dnMap.clear();
        this.idMap.clear();
        this.configEntryDN = configEntry.getDN();
        int n = 0x100116;
        IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute = new IntegerWithUnitConfigAttribute("ds-cfg-lock-timeout", MessageHandler.getMessage(n), false, timeUnits, true, 0L, false, 0L);
        try {
            configAttribute = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(integerWithUnitConfigAttribute);
            if (configAttribute != null) {
                this.lockTimeout = configAttribute.activeCalculatedValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 1310999, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception), this.lockTimeout);
        }
        this.includeFilters = new HashSet();
        n = 0x100118;
        configAttribute = new StringConfigAttribute("ds-cfg-include-filter", MessageHandler.getMessage(n), false, true, false);
        try {
            stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(configAttribute);
            if (stringConfigAttribute != null && (object3 = stringConfigAttribute.activeValues()) != null && !object3.isEmpty()) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    try {
                        this.includeFilters.add(SearchFilter.createFilterFromString((String)object));
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
                        Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 1179929, String.valueOf(this.configEntryDN), object, StaticUtils.stackTraceToSingleLineString(exception));
                    }
                }
                if (this.includeFilters.isEmpty()) {
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 1179930, String.valueOf(this.configEntryDN));
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 1311003, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
        }
        this.excludeFilters = new HashSet();
        n = 0x10011C;
        stringConfigAttribute = new StringConfigAttribute("ds-cfg-exclude-filter", MessageHandler.getMessage(n), false, true, false);
        try {
            object3 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object3 != null && (object2 = ((StringConfigAttribute)object3).activeValues()) != null && !object2.isEmpty()) {
                object = object2.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    try {
                        this.excludeFilters.add(SearchFilter.createFilterFromString(string));
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
                        Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 1179933, String.valueOf(this.configEntryDN), string, StaticUtils.stackTraceToSingleLineString(exception));
                    }
                }
                if (this.excludeFilters.isEmpty()) {
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 1179934, String.valueOf(this.configEntryDN));
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 1311007, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
        }
    }

    @Override
    public void finalizeEntryCache() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeEntryCache", new String[0]));
        this.dnMap.clear();
        this.idMap.clear();
    }

    @Override
    public boolean containsEntry(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "containsEntry", String.valueOf(dN)));
        return this.dnMap.containsKey(dN);
    }

    @Override
    public Entry getEntry(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getEntry", String.valueOf(dN)));
        SoftReference<CacheEntry> softReference = this.dnMap.get(dN);
        if (softReference == null) {
            return null;
        }
        CacheEntry cacheEntry = softReference.get();
        if (cacheEntry == null) {
            return null;
        }
        return cacheEntry.getEntry();
    }

    @Override
    public long getEntryID(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getEntryID", String.valueOf(dN)));
        SoftReference<CacheEntry> softReference = this.dnMap.get(dN);
        if (softReference == null) {
            return -1L;
        }
        CacheEntry cacheEntry = softReference.get();
        if (cacheEntry == null) {
            return -1L;
        }
        return cacheEntry.getEntryID();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Entry getEntry(DN dN, LockType lockType, List<Lock> list) {
        assert (Debug.debugEnter(CLASS_NAME, "getEntry", String.valueOf(dN), String.valueOf((Object)lockType), "java.util.List<Lock>"));
        SoftReference<CacheEntry> softReference = this.dnMap.get(dN);
        if (softReference == null) {
            return null;
        }
        CacheEntry cacheEntry = softReference.get();
        if (cacheEntry == null) {
            return null;
        }
        switch (lockType) {
            case READ: {
                Lock lock = LockManager.lockRead(dN);
                if (lock == null) {
                    return null;
                }
                try {
                    list.add(lock);
                    return cacheEntry.getEntry();
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "getEntry", exception));
                    try {
                        LockManager.unlock(dN, lock);
                        return null;
                    }
                    catch (Exception exception2) {
                        assert (Debug.debugException(CLASS_NAME, "getEntry", exception2));
                        return null;
                    }
                }
            }
            case WRITE: {
                Lock lock = LockManager.lockWrite(dN);
                if (lock == null) {
                    return null;
                }
                try {
                    list.add(lock);
                    return cacheEntry.getEntry();
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "getEntry", exception));
                    try {
                        LockManager.unlock(dN, lock);
                        return null;
                    }
                    catch (Exception exception3) {
                        assert (Debug.debugException(CLASS_NAME, "getEntry", exception3));
                        return null;
                    }
                }
            }
            case NONE: {
                return cacheEntry.getEntry();
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Entry getEntry(Backend backend, long l, LockType lockType, List<Lock> list) {
        assert (Debug.debugEnter(CLASS_NAME, "getEntry", String.valueOf(backend), String.valueOf(l), String.valueOf((Object)lockType), "java.util.List<Lock>"));
        ConcurrentHashMap<Long, SoftReference<CacheEntry>> concurrentHashMap = this.idMap.get(backend);
        if (concurrentHashMap == null) {
            return null;
        }
        SoftReference<CacheEntry> softReference = concurrentHashMap.get(l);
        if (softReference == null) {
            return null;
        }
        CacheEntry cacheEntry = softReference.get();
        if (cacheEntry == null) {
            return null;
        }
        switch (lockType) {
            case READ: {
                Lock lock = LockManager.lockRead(cacheEntry.getDN());
                if (lock == null) {
                    return null;
                }
                try {
                    list.add(lock);
                    return cacheEntry.getEntry();
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "getEntry", exception));
                    try {
                        LockManager.unlock(cacheEntry.getDN(), lock);
                        return null;
                    }
                    catch (Exception exception2) {
                        assert (Debug.debugException(CLASS_NAME, "getEntry", exception2));
                        return null;
                    }
                }
            }
            case WRITE: {
                Lock lock = LockManager.lockWrite(cacheEntry.getDN());
                if (lock == null) {
                    return null;
                }
                try {
                    list.add(lock);
                    return cacheEntry.getEntry();
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "getEntry", exception));
                    try {
                        LockManager.unlock(cacheEntry.getDN(), lock);
                        return null;
                    }
                    catch (Exception exception3) {
                        assert (Debug.debugException(CLASS_NAME, "getEntry", exception3));
                        return null;
                    }
                }
            }
            case NONE: {
                return cacheEntry.getEntry();
            }
        }
        return null;
    }

    @Override
    public void putEntry(Entry entry, Backend backend, long l) {
        ConcurrentHashMap<Long, SoftReference<CacheEntry>> concurrentHashMap;
        assert (Debug.debugEnter(CLASS_NAME, "putEntry", String.valueOf(entry), String.valueOf(backend), String.valueOf(l)));
        if (!this.excludeFilters.isEmpty()) {
            for (SearchFilter softReference22 : this.excludeFilters) {
                try {
                    if (!softReference22.matchesEntry(entry)) continue;
                    return;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "putEntry", exception));
                    return;
                }
            }
        }
        if (!this.includeFilters.isEmpty()) {
            boolean bl = false;
            for (SearchFilter searchFilter : this.includeFilters) {
                try {
                    if (!searchFilter.matchesEntry(entry)) continue;
                    bl = true;
                    break;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "putEntry", exception));
                }
            }
            if (!bl) {
                return;
            }
        }
        CacheEntry cacheEntry = new CacheEntry(entry, backend, l);
        SoftReference<CacheEntry> softReference = new SoftReference<CacheEntry>(cacheEntry, this.referenceQueue);
        SoftReference<CacheEntry> softReference2 = this.dnMap.put(entry.getDN(), softReference);
        if (softReference2 != null) {
            softReference2.clear();
        }
        if ((concurrentHashMap = this.idMap.get(backend)) == null) {
            concurrentHashMap = new ConcurrentHashMap();
            concurrentHashMap.put(l, softReference);
        } else {
            SoftReference<CacheEntry> softReference3 = concurrentHashMap.put(l, softReference);
            if (softReference3 != null) {
                softReference3.clear();
            }
        }
    }

    @Override
    public boolean putEntryIfAbsent(Entry entry, Backend backend, long l) {
        assert (Debug.debugEnter(CLASS_NAME, "putIfAbsent", String.valueOf(entry), String.valueOf(backend), String.valueOf(l)));
        if (!this.excludeFilters.isEmpty()) {
            for (SearchFilter softReference2 : this.excludeFilters) {
                try {
                    if (!softReference2.matchesEntry(entry)) continue;
                    return true;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "putEntry", exception));
                    return false;
                }
            }
        }
        if (!this.includeFilters.isEmpty()) {
            boolean bl = false;
            for (SearchFilter searchFilter : this.includeFilters) {
                try {
                    if (!searchFilter.matchesEntry(entry)) continue;
                    bl = true;
                    break;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "putEntry", exception));
                }
            }
            if (!bl) {
                return true;
            }
        }
        if (this.dnMap.containsKey(entry.getDN())) {
            return false;
        }
        CacheEntry cacheEntry = new CacheEntry(entry, backend, l);
        SoftReference<CacheEntry> softReference = new SoftReference<CacheEntry>(cacheEntry, this.referenceQueue);
        this.dnMap.put(entry.getDN(), softReference);
        ConcurrentHashMap<Long, SoftReference<CacheEntry>> concurrentHashMap = this.idMap.get(backend);
        if (concurrentHashMap == null) {
            ConcurrentHashMap<Long, SoftReference<CacheEntry>> concurrentHashMap2 = new ConcurrentHashMap<Long, SoftReference<CacheEntry>>();
            concurrentHashMap2.put(l, softReference);
            this.idMap.put(backend, concurrentHashMap2);
        } else {
            concurrentHashMap.put(l, softReference);
        }
        return true;
    }

    @Override
    public void removeEntry(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "removeEntry", String.valueOf(dN)));
        SoftReference<CacheEntry> softReference = this.dnMap.remove(dN);
        if (softReference != null) {
            Backend backend;
            ConcurrentHashMap<Long, SoftReference<CacheEntry>> concurrentHashMap;
            softReference.clear();
            CacheEntry cacheEntry = softReference.get();
            if (cacheEntry != null && (concurrentHashMap = this.idMap.get(backend = cacheEntry.getBackend())) != null && (softReference = concurrentHashMap.remove(cacheEntry.getEntryID())) != null) {
                softReference.clear();
            }
        }
    }

    @Override
    public void clear() {
        assert (Debug.debugEnter(CLASS_NAME, "clear", new String[0]));
        this.dnMap.clear();
        this.idMap.clear();
    }

    @Override
    public void clearBackend(Backend backend) {
        assert (Debug.debugEnter(CLASS_NAME, "clearBackend", String.valueOf(backend)));
        ConcurrentHashMap<Long, SoftReference<CacheEntry>> concurrentHashMap = this.idMap.remove(backend);
        if (concurrentHashMap != null) {
            for (SoftReference<CacheEntry> softReference : concurrentHashMap.values()) {
                CacheEntry cacheEntry = softReference.get();
                if (cacheEntry != null) {
                    this.dnMap.remove(cacheEntry.getDN());
                }
                softReference.clear();
            }
            concurrentHashMap.clear();
        }
    }

    @Override
    public void clearSubtree(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "clearSubtree", String.valueOf(dN)));
        Backend backend = DirectoryServer.getBackend(dN);
        if (backend == null) {
            return;
        }
        this.clearBackend(backend);
    }

    @Override
    public void handleLowMemory() {
        assert (Debug.debugEnter(CLASS_NAME, "handleLowMemory", new String[0]));
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        int n = 0x100116;
        IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute = new IntegerWithUnitConfigAttribute("ds-cfg-lock-timeout", MessageHandler.getMessage(n), false, timeUnits, true, 0L, false, 0L, this.lockTimeout, "milliseconds");
        linkedList.add(integerWithUnitConfigAttribute);
        n = 0x100118;
        ArrayList<String> arrayList = new ArrayList<String>(this.includeFilters.size());
        for (SearchFilter object2 : this.includeFilters) {
            arrayList.add(object2.toString());
        }
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-include-filter", MessageHandler.getMessage(n), false, true, false, arrayList);
        linkedList.add(stringConfigAttribute);
        n = 0x10011C;
        ArrayList<String> arrayList2 = new ArrayList<String>(this.excludeFilters.size());
        for (SearchFilter searchFilter : this.excludeFilters) {
            arrayList2.add(searchFilter.toString());
        }
        StringConfigAttribute stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-exclude-filter", MessageHandler.getMessage(n), false, true, false, arrayList2);
        linkedList.add(stringConfigAttribute2);
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        Object object;
        Object object2;
        Object object3;
        StringConfigAttribute stringConfigAttribute;
        ConfigAttribute configAttribute;
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
        boolean bl = true;
        int n = 0x100116;
        IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute = new IntegerWithUnitConfigAttribute("ds-cfg-lock-timeout", MessageHandler.getMessage(n), false, timeUnits, true, 0L, false, 0L);
        try {
            configAttribute = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(integerWithUnitConfigAttribute);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            n = 1311008;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl = false;
        }
        n = 0x100118;
        configAttribute = new StringConfigAttribute("ds-cfg-include-filter", MessageHandler.getMessage(n), false, true, false);
        try {
            stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(configAttribute);
            if (stringConfigAttribute != null && (object3 = stringConfigAttribute.activeValues()) != null && !object3.isEmpty()) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    try {
                        SearchFilter.createFilterFromString((String)object);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
                        n = 1311009;
                        list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), object, StaticUtils.stackTraceToSingleLineString(exception)));
                        bl = false;
                    }
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            n = 1311010;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl = false;
        }
        n = 0x10011C;
        stringConfigAttribute = new StringConfigAttribute("ds-cfg-exclude-filter", MessageHandler.getMessage(n), false, true, false);
        try {
            object3 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object3 != null && (object2 = ((StringConfigAttribute)object3).activeValues()) != null && !object2.isEmpty()) {
                object = object2.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    try {
                        SearchFilter.createFilterFromString(string);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
                        n = 1311011;
                        list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), string, StaticUtils.stackTraceToSingleLineString(exception)));
                        bl = false;
                    }
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            n = 1311012;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl = false;
        }
        return bl;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl3 = true;
        long l = 3000L;
        int n = 0x100116;
        IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute = new IntegerWithUnitConfigAttribute("ds-cfg-lock-timeout", MessageHandler.getMessage(n), false, timeUnits, true, 0L, false, 0L);
        try {
            object5 = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(integerWithUnitConfigAttribute);
            if (object5 != null) {
                l = ((IntegerWithUnitConfigAttribute)object5).pendingCalculatedValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n = 1311008;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
            }
            bl3 = false;
        }
        object5 = new HashSet();
        n = 0x100118;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-include-filter", MessageHandler.getMessage(n), false, true, false);
        try {
            object4 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object4 != null && (object3 = ((StringConfigAttribute)object4).activeValues()) != null && !object3.isEmpty()) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    try {
                        ((HashSet)object5).add(SearchFilter.createFilterFromString((String)object));
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                        n = 1311009;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), object, StaticUtils.stackTraceToSingleLineString(exception)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                        }
                        bl3 = false;
                    }
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n = 1311010;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
            }
            bl3 = false;
        }
        object4 = new HashSet();
        n = 0x10011C;
        object3 = new StringConfigAttribute("ds-cfg-exclude-filter", MessageHandler.getMessage(n), false, true, false);
        try {
            object2 = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object3);
            if (object2 != null && (object = ((StringConfigAttribute)object2).activeValues()) != null && !object.isEmpty()) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    try {
                        ((HashSet)object4).add(SearchFilter.createFilterFromString(string));
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                        n = 1311011;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), string, StaticUtils.stackTraceToSingleLineString(exception)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                        }
                        bl3 = false;
                    }
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n = 1311012;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
            }
            bl3 = false;
        }
        if (bl3) {
            if (this.lockTimeout != l) {
                this.lockTimeout = l;
                if (bl) {
                    arrayList.add(MessageHandler.getMessage(1048869, this.lockTimeout));
                }
            }
            if (!this.includeFilters.equals(object5)) {
                this.includeFilters = object5;
                if (bl) {
                    arrayList.add(MessageHandler.getMessage(1048870));
                }
            }
            if (!this.excludeFilters.equals(object4)) {
                this.excludeFilters = object4;
                if (bl) {
                    arrayList.add(MessageHandler.getMessage(1048871));
                }
            }
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    SoftReference<CacheEntry> softReference;
                    CacheEntry cacheEntry;
                    if ((cacheEntry = this.referenceQueue.remove().get()) == null || (softReference = this.dnMap.remove(cacheEntry.getDN())) == null) {
                        continue;
                    }
                    CacheEntry cacheEntry2 = softReference.get();
                    if (cacheEntry2 != cacheEntry) {
                        this.dnMap.putIfAbsent(cacheEntry.getDN(), softReference);
                        continue;
                    }
                    softReference.clear();
                    ConcurrentHashMap<Long, SoftReference<CacheEntry>> concurrentHashMap = this.idMap.get(cacheEntry.getBackend());
                    if (concurrentHashMap == null || (softReference = concurrentHashMap.remove(cacheEntry.getEntryID())) == null) continue;
                    softReference.clear();
                }
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "run", exception)) continue;
                throw new AssertionError();
            }
            break;
        }
    }

    static {
        timeUnits.put("ms", 1.0);
        timeUnits.put("milliseconds", 1.0);
        timeUnits.put("s", 1000.0);
        timeUnits.put("seconds", 1000.0);
    }
}

