/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Base64;
import org.opends.server.util.StaticUtils;

public class SaltedSHA256PasswordStorageScheme
extends PasswordStorageScheme {
    private static final String CLASS_NAME = "org.opends.server.extensions.SaltedSHA256PasswordStorageScheme";
    private static final int NUM_SALT_BYTES = 8;
    private MessageDigest messageDigest;
    private ReentrantLock digestLock;
    private SecureRandom random;

    public SaltedSHA256PasswordStorageScheme() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializePasswordStorageScheme(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializePasswordStorageScheme", String.valueOf(configEntry)));
        try {
            this.messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializePasswordStorageScheme", exception));
            int n = 0x140001;
            String string = MessageHandler.getMessage(n, "SHA-256", String.valueOf(exception));
            throw new InitializationException(n, string, exception);
        }
        this.digestLock = new ReentrantLock();
        this.random = new SecureRandom();
    }

    public String getStorageSchemeName() {
        assert (Debug.debugEnter(CLASS_NAME, "getStorageSchemeName", new String[0]));
        return "SSHA256";
    }

    public ByteString encodePassword(ByteString byteString) throws DirectoryException {
        byte[] byArray;
        assert (Debug.debugEnter(CLASS_NAME, "encodePassword", "ByteString"));
        byte[] byArray2 = byteString.value();
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[byArray2.length + 8];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        this.digestLock.lock();
        try {
            this.random.nextBytes(byArray3);
            System.arraycopy(byArray3, 0, byArray4, byArray2.length, 8);
            byArray = this.messageDigest.digest(byArray4);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "encodePassword", exception));
            int n = 1245189;
            String string = MessageHandler.getMessage(n, CLASS_NAME, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, exception);
        }
        finally {
            this.digestLock.unlock();
        }
        byte[] byArray5 = new byte[byArray.length + 8];
        System.arraycopy(byArray, 0, byArray5, 0, byArray.length);
        System.arraycopy(byArray3, 0, byArray5, byArray.length, 8);
        return new ASN1OctetString(Base64.encode(byArray5));
    }

    public ByteString encodePasswordWithScheme(ByteString byteString) throws DirectoryException {
        byte[] byArray;
        assert (Debug.debugEnter(CLASS_NAME, "encodePasswordWithScheme", "ByteString"));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        stringBuilder.append("SSHA256");
        stringBuilder.append('}');
        byte[] byArray2 = byteString.value();
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[byArray2.length + 8];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        this.digestLock.lock();
        try {
            this.random.nextBytes(byArray3);
            System.arraycopy(byArray3, 0, byArray4, byArray2.length, 8);
            byArray = this.messageDigest.digest(byArray4);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "encodePassword", exception));
            int n = 1245189;
            String string = MessageHandler.getMessage(n, CLASS_NAME, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, exception);
        }
        finally {
            this.digestLock.unlock();
        }
        byte[] byArray5 = new byte[byArray.length + 8];
        System.arraycopy(byArray, 0, byArray5, 0, byArray.length);
        System.arraycopy(byArray3, 0, byArray5, byArray.length, 8);
        stringBuilder.append(Base64.encode(byArray5));
        return new ASN1OctetString(stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean passwordMatches(ByteString byteString, ByteString byteString2) {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        assert (Debug.debugEnter(CLASS_NAME, "passwordMatches", String.valueOf(byteString), String.valueOf(byteString2)));
        byte[] byArray4 = new byte[8];
        try {
            byArray3 = Base64.decode(byteString2.stringValue());
            int n = byArray3.length - 8;
            byArray2 = new byte[n];
            System.arraycopy(byArray3, 0, byArray2, 0, n);
            System.arraycopy(byArray3, n, byArray4, 0, 8);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "passwordMatches", exception));
            int n = 1245186;
            String string = MessageHandler.getMessage(n, byteString2.stringValue(), String.valueOf(exception));
            Error.logError(ErrorLogCategory.EXTENSIONS, ErrorLogSeverity.MILD_ERROR, string, n);
            return false;
        }
        byArray3 = byteString.value();
        byte[] byArray5 = new byte[byArray3.length + 8];
        System.arraycopy(byArray3, 0, byArray5, 0, byArray3.length);
        System.arraycopy(byArray4, 0, byArray5, byArray3.length, 8);
        this.digestLock.lock();
        try {
            byArray = this.messageDigest.digest(byArray5);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "passwordMatches", exception));
            boolean bl = false;
            return bl;
        }
        finally {
            this.digestLock.unlock();
        }
        return Arrays.equals(byArray2, byArray);
    }

    public boolean supportsAuthPasswordSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsAuthPasswordSyntax", new String[0]));
        return true;
    }

    public String getAuthPasswordSchemeName() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthPasswordSchemeName", new String[0]));
        return "SHA256";
    }

    public ByteString encodeAuthPassword(ByteString byteString) throws DirectoryException {
        byte[] byArray;
        assert (Debug.debugEnter(CLASS_NAME, "encodeAuthPassword", String.valueOf(byteString)));
        byte[] byArray2 = byteString.value();
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[byArray2.length + 8];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        this.digestLock.lock();
        try {
            this.random.nextBytes(byArray3);
            System.arraycopy(byArray3, 0, byArray4, byArray2.length, 8);
            byArray = this.messageDigest.digest(byArray4);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "encodePassword", exception));
            int n = 1245189;
            String string = MessageHandler.getMessage(n, CLASS_NAME, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, exception);
        }
        finally {
            this.digestLock.unlock();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SHA256");
        stringBuilder.append('$');
        stringBuilder.append(Base64.encode(byArray3));
        stringBuilder.append('$');
        stringBuilder.append(Base64.encode(byArray));
        return new ASN1OctetString(stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authPasswordMatches(ByteString byteString, String string, String string2) {
        byte[] byArray;
        byte[] byArray2;
        assert (Debug.debugEnter(CLASS_NAME, "authPasswordMatches", String.valueOf(byteString), String.valueOf(string), String.valueOf(string2)));
        try {
            byArray2 = Base64.decode(string);
            byArray = Base64.decode(string2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "authPasswordMatches", exception));
            return false;
        }
        byte[] byArray3 = byteString.value();
        byte[] byArray4 = new byte[byArray3.length + byArray2.length];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        System.arraycopy(byArray2, 0, byArray4, byArray3.length, byArray2.length);
        this.digestLock.lock();
        try {
            boolean bl = Arrays.equals(byArray, this.messageDigest.digest(byArray4));
            return bl;
        }
        finally {
            this.digestLock.unlock();
        }
    }

    public boolean isReversible() {
        assert (Debug.debugEnter(CLASS_NAME, "isReversible", new String[0]));
        return false;
    }

    public ByteString getPlaintextValue(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getPlaintextValue", String.valueOf(byteString)));
        int n = 0x130003;
        String string = MessageHandler.getMessage(n, "SSHA256");
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
    }

    public ByteString getAuthPasswordPlaintextValue(String string, String string2) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthPasswordPlaintextValue", String.valueOf(string), String.valueOf(string2)));
        int n = 0x130003;
        String string3 = MessageHandler.getMessage(n, "SHA256");
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string3, n);
    }

    public boolean isStorageSchemeSecure() {
        assert (Debug.debugEnter(CLASS_NAME, "isStorageSchemeSecure", new String[0]));
        return true;
    }
}

