/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.MessageDigest;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Base64;
import org.opends.server.util.StaticUtils;

public class SHA1PasswordStorageScheme
extends PasswordStorageScheme {
    private static final String CLASS_NAME = "org.opends.server.extensions.SHA1PasswordStorageScheme";
    private MessageDigest messageDigest;
    private ReentrantLock digestLock;

    public SHA1PasswordStorageScheme() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializePasswordStorageScheme(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializePasswordStorageScheme", String.valueOf(configEntry)));
        try {
            this.messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializePasswordStorageScheme", exception));
            int n = 0x140001;
            String string = MessageHandler.getMessage(n, "SHA-1", String.valueOf(exception));
            throw new InitializationException(n, string, exception);
        }
        this.digestLock = new ReentrantLock();
    }

    public String getStorageSchemeName() {
        assert (Debug.debugEnter(CLASS_NAME, "getStorageSchemeName", new String[0]));
        return "SHA";
    }

    public ByteString encodePassword(ByteString byteString) throws DirectoryException {
        byte[] byArray;
        assert (Debug.debugEnter(CLASS_NAME, "encodePassword", String.valueOf(byteString)));
        this.digestLock.lock();
        try {
            byArray = this.messageDigest.digest(byteString.value());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "encodePassword", exception));
            int n = 1245189;
            String string = MessageHandler.getMessage(n, CLASS_NAME, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, exception);
        }
        finally {
            this.digestLock.unlock();
        }
        return new ASN1OctetString(Base64.encode(byArray));
    }

    public ByteString encodePasswordWithScheme(ByteString byteString) throws DirectoryException {
        byte[] byArray;
        assert (Debug.debugEnter(CLASS_NAME, "encodePasswordWithScheme", "ByteString"));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        stringBuilder.append("SHA");
        stringBuilder.append('}');
        this.digestLock.lock();
        try {
            byArray = this.messageDigest.digest(byteString.value());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "encodePassword", exception));
            int n = 1245189;
            String string = MessageHandler.getMessage(n, CLASS_NAME, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, exception);
        }
        finally {
            this.digestLock.unlock();
        }
        stringBuilder.append(Base64.encode(byArray));
        return new ASN1OctetString(stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean passwordMatches(ByteString byteString, ByteString byteString2) {
        byte[] byArray;
        byte[] byArray2;
        assert (Debug.debugEnter(CLASS_NAME, "passwordMatches", String.valueOf(byteString), String.valueOf(byteString2)));
        this.digestLock.lock();
        try {
            byArray2 = this.messageDigest.digest(byteString.value());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "passwordMatches", exception));
            boolean bl = false;
            return bl;
        }
        finally {
            this.digestLock.unlock();
        }
        try {
            byArray = Base64.decode(byteString2.stringValue());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "passwordMatches", exception));
            Error.logError(ErrorLogCategory.EXTENSIONS, ErrorLogSeverity.MILD_ERROR, 1245186, byteString2.stringValue(), String.valueOf(exception));
            return false;
        }
        return Arrays.equals(byArray2, byArray);
    }

    public boolean supportsAuthPasswordSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsAuthPasswordSyntax", new String[0]));
        return false;
    }

    public ByteString encodeAuthPassword(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "encodeAuthPassword", String.valueOf(byteString)));
        int n = 1245514;
        String string = MessageHandler.getMessage(n, this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    public boolean authPasswordMatches(ByteString byteString, String string, String string2) {
        assert (Debug.debugEnter(CLASS_NAME, "authPasswordMatches", String.valueOf(byteString), String.valueOf(string), String.valueOf(string2)));
        return false;
    }

    public boolean isReversible() {
        assert (Debug.debugEnter(CLASS_NAME, "isReversible", new String[0]));
        return false;
    }

    public ByteString getPlaintextValue(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getPlaintextValue", String.valueOf(byteString)));
        int n = 0x130003;
        String string = MessageHandler.getMessage(n, "SHA");
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
    }

    public ByteString getAuthPasswordPlaintextValue(String string, String string2) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthPasswordPlaintextValue", String.valueOf(string), String.valueOf(string2)));
        int n = 1245514;
        String string3 = MessageHandler.getMessage(n, this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string3, n);
    }

    public boolean isStorageSchemeSecure() {
        assert (Debug.debugEnter(CLASS_NAME, "isStorageSchemeSecure", new String[0]));
        return true;
    }
}

