/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.api.IdentityMapper;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.InitializationException;
import org.opends.server.core.LockManager;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordModifyExtendedOperation
extends ExtendedOperationHandler
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.extensions.PasswordModifyExtendedOperation";
    private DN configEntryDN;
    private DN identityMapperDN;
    private IdentityMapper identityMapper;

    public PasswordModifyExtendedOperation() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeExtendedOperationHandler(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeExtendedOperationHandler", String.valueOf(configEntry)));
        this.configEntryDN = configEntry.getDN();
        int n = 1048942;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-identity-mapper-dn", MessageHandler.getMessage(n), true, false, false);
        try {
            DNConfigAttribute dNConfigAttribute2 = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (dNConfigAttribute2 == null) {
                n = 1245551;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
                throw new ConfigException(n, string);
            }
            this.identityMapperDN = dNConfigAttribute2.activeValue();
            this.identityMapper = DirectoryServer.getIdentityMapper(this.identityMapperDN);
            if (this.identityMapper == null) {
                n = 1245552;
                String string = MessageHandler.getMessage(n, String.valueOf(this.identityMapperDN), String.valueOf(this.configEntryDN));
                throw new ConfigException(n, string);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeExtendedOperationHandler", exception));
            n = 1245553;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        DirectoryServer.registerConfigurableComponent(this);
        DirectoryServer.registerSupportedExtension("1.3.6.1.4.1.4203.1.11.1", this);
    }

    @Override
    public void finalizeExtendedOperationHandler() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeExtendedOperationHandler", new String[0]));
        DirectoryServer.deregisterConfigurableComponent(this);
        DirectoryServer.deregisterSupportedExtension("1.3.6.1.4.1.4203.1.11.1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void processExtendedOperation(ExtendedOperation var1_1) {
        block139: {
            block140: {
                block138: {
                    block134: {
                        block137: {
                            block135: {
                                block136: {
                                    block131: {
                                        block132: {
                                            block133: {
                                                block129: {
                                                    block130: {
                                                        block127: {
                                                            block128: {
                                                                block125: {
                                                                    block126: {
                                                                        block123: {
                                                                            block124: {
                                                                                block118: {
                                                                                    block122: {
                                                                                        block120: {
                                                                                            block121: {
                                                                                                block117: {
                                                                                                    block119: {
                                                                                                        block110: {
                                                                                                            block116: {
                                                                                                                block113: {
                                                                                                                    block114: {
                                                                                                                        block115: {
                                                                                                                            block111: {
                                                                                                                                block112: {
                                                                                                                                    block108: {
                                                                                                                                        block109: {
                                                                                                                                            block106: {
                                                                                                                                                block107: {
                                                                                                                                                    block104: {
                                                                                                                                                        block105: {
                                                                                                                                                            if (!PasswordModifyExtendedOperation.$assertionsDisabled && !Debug.debugEnter("org.opends.server.extensions.PasswordModifyExtendedOperation", "processExtendedOperation", new String[]{String.valueOf(var1_1)})) {
                                                                                                                                                                throw new AssertionError();
                                                                                                                                                            }
                                                                                                                                                            var2_2 = null;
                                                                                                                                                            var3_3 = null;
                                                                                                                                                            var4_4 = null;
                                                                                                                                                            var5_5 = var1_1.getRequestValue();
                                                                                                                                                            if (var5_5 != null) {
                                                                                                                                                                try {
                                                                                                                                                                    var6_6 = ASN1Sequence.decodeAsSequence(var5_5.value());
                                                                                                                                                                    block47: for (ASN1Element var8_10 : var6_6.elements()) {
                                                                                                                                                                        switch (var8_10 /* !! */ .getType()) {
                                                                                                                                                                            case -128: {
                                                                                                                                                                                var2_2 = var8_10 /* !! */ .decodeAsOctetString();
                                                                                                                                                                                continue block47;
                                                                                                                                                                            }
                                                                                                                                                                            case -127: {
                                                                                                                                                                                var3_3 = var8_10 /* !! */ .decodeAsOctetString();
                                                                                                                                                                                continue block47;
                                                                                                                                                                            }
                                                                                                                                                                            case -126: {
                                                                                                                                                                                var4_4 = var8_10 /* !! */ .decodeAsOctetString();
                                                                                                                                                                                continue block47;
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                        var1_1.setResultCode(ResultCode.PROTOCOL_ERROR);
                                                                                                                                                                        var9_12 = 1245216;
                                                                                                                                                                        var1_1.appendErrorMessage(MessageHandler.getMessage(var9_12, new Object[]{StaticUtils.byteToHex(var8_10 /* !! */ .getType())}));
                                                                                                                                                                        return;
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                                catch (ASN1Exception var6_7) {
                                                                                                                                                                    if (!PasswordModifyExtendedOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.extensions.PasswordModifyExtendedOperation", "processExtendedOperation", var6_7)) {
                                                                                                                                                                        throw new AssertionError();
                                                                                                                                                                    }
                                                                                                                                                                    var1_1.setResultCode(ResultCode.PROTOCOL_ERROR);
                                                                                                                                                                    var7_9 = 1245217;
                                                                                                                                                                    var8_11 = MessageHandler.getMessage(var7_9, new Object[]{StaticUtils.stackTraceToSingleLineString(var6_7)});
                                                                                                                                                                    var1_1.appendErrorMessage(var8_11);
                                                                                                                                                                    return;
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                            var6_6 = var1_1.getAuthorizationDN();
                                                                                                                                                            var7_8 = null;
                                                                                                                                                            var8_10 /* !! */  = null;
                                                                                                                                                            var9_13 = null;
                                                                                                                                                            if (var2_2 != null) ** GOTO lbl75
                                                                                                                                                            var10_14 = var1_1.getClientConnection();
                                                                                                                                                            var11_15 = var10_14.getAuthenticationInfo();
                                                                                                                                                            if (var11_15.isAuthenticated() && var6_6 != null && !var6_6.isNullDN()) break block104;
                                                                                                                                                            var1_1.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                                                                                                            var12_18 = 1245218;
                                                                                                                                                            var1_1.appendErrorMessage(MessageHandler.getMessage(var12_18));
                                                                                                                                                            if (var9_13 == null) break block105;
                                                                                                                                                            LockManager.unlock((DN)var7_8, var9_13);
                                                                                                                                                        }
                                                                                                                                                        return;
                                                                                                                                                    }
                                                                                                                                                    var7_8 = var6_6;
                                                                                                                                                    for (var12_19 = 0; var12_19 < 3 && (var9_13 = LockManager.lockWrite((DN)var7_8)) == null; ++var12_19) {
                                                                                                                                                    }
                                                                                                                                                    if (var9_13 != null) break block106;
                                                                                                                                                    var1_1.setResultCode(DirectoryServer.getServerErrorResultCode());
                                                                                                                                                    var12_19 = 1310755;
                                                                                                                                                    var13_39 = MessageHandler.getMessage(var12_19, new Object[]{String.valueOf(var7_8)});
                                                                                                                                                    var1_1.appendErrorMessage(var13_39);
                                                                                                                                                    if (var9_13 == null) break block107;
                                                                                                                                                    LockManager.unlock((DN)var7_8, var9_13);
                                                                                                                                                }
                                                                                                                                                return;
                                                                                                                                            }
                                                                                                                                            var8_10 /* !! */  = this.getEntryByDN(var1_1, (DN)var7_8);
                                                                                                                                            if (var8_10 /* !! */  != null) break block108;
                                                                                                                                            if (var9_13 == null) break block109;
                                                                                                                                            LockManager.unlock((DN)var7_8, var9_13);
                                                                                                                                        }
                                                                                                                                        return;
                                                                                                                                    }
                                                                                                                                    break block110;
lbl75:
                                                                                                                                    // 1 sources

                                                                                                                                    var10_14 = var2_2.stringValue();
                                                                                                                                    var11_15 = StaticUtils.toLowerCase((String)var10_14);
                                                                                                                                    if (!var11_15.startsWith("dn:")) ** GOTO lbl102
                                                                                                                                    try {
                                                                                                                                        var7_8 = DN.decode(var10_14.substring(3));
                                                                                                                                    }
                                                                                                                                    catch (DirectoryException var12_20) {
                                                                                                                                        if (!PasswordModifyExtendedOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.extensions.PasswordModifyExtendedOperation", "processExtendedOperation", var12_20)) {
                                                                                                                                            throw new AssertionError();
                                                                                                                                        }
                                                                                                                                        var1_1.setResultCode(ResultCode.INVALID_DN_SYNTAX);
                                                                                                                                        var13_40 = 1245220;
                                                                                                                                        var1_1.appendErrorMessage(MessageHandler.getMessage(var13_40, new Object[]{var10_14}));
                                                                                                                                        if (var9_13 != null) {
                                                                                                                                            LockManager.unlock((DN)var7_8, var9_13);
                                                                                                                                        }
                                                                                                                                        return;
                                                                                                                                    }
                                                                                                                                    var12_21 = DirectoryServer.getActualRootBindDN((DN)var7_8);
                                                                                                                                    if (var12_21 != null) {
                                                                                                                                        var7_8 = var12_21;
                                                                                                                                    }
                                                                                                                                    if ((var8_10 /* !! */  = this.getEntryByDN(var1_1, (DN)var7_8)) != null) break block111;
                                                                                                                                    if (var9_13 == null) break block112;
                                                                                                                                    LockManager.unlock((DN)var7_8, var9_13);
                                                                                                                                }
                                                                                                                                return;
                                                                                                                            }
                                                                                                                            break block110;
lbl102:
                                                                                                                            // 1 sources

                                                                                                                            if (!var11_15.startsWith("u:")) break block113;
                                                                                                                            var8_10 /* !! */  = this.identityMapper.getEntryForID(var10_14.substring(2));
                                                                                                                            if (var8_10 /* !! */  != null) break block114;
                                                                                                                            if (var3_3 == null) {
                                                                                                                                var1_1.setResultCode(ResultCode.NO_SUCH_OBJECT);
                                                                                                                                var12_22 = 1245554;
                                                                                                                                var1_1.appendErrorMessage(MessageHandler.getMessage(var12_22, new Object[]{var10_14}));
                                                                                                                            } else {
                                                                                                                                var1_1.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                                                                                                var12_23 = 1245554;
                                                                                                                                var1_1.appendAdditionalLogMessage(MessageHandler.getMessage(var12_23, new Object[]{var10_14}));
                                                                                                                            }
                                                                                                                            if (var9_13 == null) break block115;
                                                                                                                            LockManager.unlock((DN)var7_8, var9_13);
                                                                                                                        }
                                                                                                                        return;
                                                                                                                    }
                                                                                                                    var7_8 = var8_10 /* !! */ .getDN();
                                                                                                                    break block110;
                                                                                                                    {
                                                                                                                        catch (DirectoryException var12_24) {
                                                                                                                            if (!PasswordModifyExtendedOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.extensions.PasswordModifyExtendedOperation", "processExtendedOperation", var12_24)) {
                                                                                                                                throw new AssertionError();
                                                                                                                            }
                                                                                                                            if (var3_3 == null) {
                                                                                                                                var1_1.setResultCode(var12_24.getResultCode());
                                                                                                                                var13_41 = 1245555;
                                                                                                                                var1_1.appendErrorMessage(MessageHandler.getMessage(var13_41, new Object[]{var10_14, var12_24.getErrorMessage()}));
                                                                                                                            } else {
                                                                                                                                var1_1.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                                                                                                var13_42 = 1245555;
                                                                                                                                var1_1.appendAdditionalLogMessage(MessageHandler.getMessage(var13_42, new Object[]{var10_14, var12_24.getErrorMessage()}));
                                                                                                                            }
                                                                                                                            if (var9_13 != null) {
                                                                                                                                LockManager.unlock((DN)var7_8, var9_13);
                                                                                                                            }
                                                                                                                            return;
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                                var1_1.setResultCode(ResultCode.PROTOCOL_ERROR);
                                                                                                                var12_25 = 1245221;
                                                                                                                var1_1.appendErrorMessage(MessageHandler.getMessage(var12_25, new Object[]{var10_14}));
                                                                                                                if (var9_13 == null) break block116;
                                                                                                                LockManager.unlock((DN)var7_8, var9_13);
                                                                                                            }
                                                                                                            return;
                                                                                                        }
                                                                                                        try {
                                                                                                            var10_14 = new PasswordPolicyState((Entry)var8_10 /* !! */ , false, false);
                                                                                                        }
                                                                                                        catch (DirectoryException var11_16) {
                                                                                                            if (!PasswordModifyExtendedOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.extensions.PasswordModifyExtendedOperation", "processExtendedOperation", var11_16)) {
                                                                                                                throw new AssertionError();
                                                                                                            }
                                                                                                            var1_1.setResultCode(DirectoryServer.getServerErrorResultCode());
                                                                                                            var12_26 = 1245538;
                                                                                                            var1_1.appendErrorMessage(MessageHandler.getMessage(var12_26, new Object[]{String.valueOf(var7_8), var11_16.getErrorMessage()}));
                                                                                                            if (var9_13 != null) {
                                                                                                                LockManager.unlock((DN)var7_8, var9_13);
                                                                                                            }
                                                                                                            return;
                                                                                                        }
                                                                                                        v0 = var11_17 = var2_2 == null || var6_6 == null || var7_8.equals(var6_6) != false;
                                                                                                        if (var3_3 != null) break block117;
                                                                                                        if (!var11_17 || !var10_14.requireCurrentPassword()) break block118;
                                                                                                        var1_1.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                                                        var12_27 = 1245539;
                                                                                                        var1_1.appendErrorMessage(MessageHandler.getMessage(var12_27));
                                                                                                        if (var9_13 == null) break block119;
                                                                                                        LockManager.unlock((DN)var7_8, var9_13);
                                                                                                    }
                                                                                                    return;
                                                                                                }
                                                                                                if (!var10_14.requireSecureAuthentication() || var1_1.getClientConnection().isSecure()) break block120;
                                                                                                var1_1.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                                                                var12_28 = 1245540;
                                                                                                var1_1.appendAdditionalLogMessage(MessageHandler.getMessage(var12_28));
                                                                                                if (var9_13 == null) break block121;
                                                                                                LockManager.unlock((DN)var7_8, var9_13);
                                                                                            }
                                                                                            return;
                                                                                        }
                                                                                        if (var10_14.passwordMatches(var3_3)) break block118;
                                                                                        var1_1.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                                                        var12_29 = 1245225;
                                                                                        var1_1.appendAdditionalLogMessage(MessageHandler.getMessage(var12_29));
                                                                                        if (var9_13 == null) break block122;
                                                                                        LockManager.unlock((DN)var7_8, var9_13);
                                                                                    }
                                                                                    return;
                                                                                }
                                                                                if (!var11_17 || var10_14.allowUserPasswordChanges()) break block123;
                                                                                if (var3_3 == null) {
                                                                                    var1_1.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                                    var12_30 = 1245541;
                                                                                    var1_1.appendErrorMessage(MessageHandler.getMessage(var12_30));
                                                                                } else {
                                                                                    var1_1.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                                                    var12_31 = 1245541;
                                                                                    var1_1.appendAdditionalLogMessage(MessageHandler.getMessage(var12_31));
                                                                                }
                                                                                if (var9_13 == null) break block124;
                                                                                LockManager.unlock((DN)var7_8, var9_13);
                                                                            }
                                                                            return;
                                                                        }
                                                                        if (!var10_14.requireSecurePasswordChanges() || var1_1.getClientConnection().isSecure()) break block125;
                                                                        if (var3_3 == null) {
                                                                            var1_1.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                            var12_32 = 1245542;
                                                                            var1_1.appendErrorMessage(MessageHandler.getMessage(var12_32));
                                                                        } else {
                                                                            var1_1.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                                            var12_33 = 1245542;
                                                                            var1_1.appendAdditionalLogMessage(MessageHandler.getMessage(var12_33));
                                                                        }
                                                                        if (var9_13 == null) break block126;
                                                                        LockManager.unlock((DN)var7_8, var9_13);
                                                                    }
                                                                    return;
                                                                }
                                                                if (!var11_17 || !var10_14.isWithinMinimumAge()) break block127;
                                                                if (var3_3 == null) {
                                                                    var1_1.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                    var12_34 = 1245543;
                                                                    var1_1.appendErrorMessage(MessageHandler.getMessage(var12_34));
                                                                } else {
                                                                    var1_1.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                                    var12_35 = 1245543;
                                                                    var1_1.appendAdditionalLogMessage(MessageHandler.getMessage(var12_35));
                                                                }
                                                                if (var9_13 == null) break block128;
                                                                LockManager.unlock((DN)var7_8, var9_13);
                                                            }
                                                            return;
                                                        }
                                                        if (!var11_17 || !var10_14.isPasswordExpired() || var10_14.allowExpiredPasswordChanges()) break block129;
                                                        if (var3_3 == null) {
                                                            var1_1.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                            var12_36 = 1245544;
                                                            var1_1.appendErrorMessage(MessageHandler.getMessage(var12_36));
                                                        } else {
                                                            var1_1.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                            var12_37 = 1245544;
                                                            var1_1.appendAdditionalLogMessage(MessageHandler.getMessage(var12_37));
                                                        }
                                                        if (var9_13 == null) break block130;
                                                        LockManager.unlock((DN)var7_8, var9_13);
                                                    }
                                                    return;
                                                }
                                                var12_38 = false;
                                                var13_43 = false;
                                                if (var4_4 != null) break block131;
                                                var4_4 = var10_14.generatePassword();
                                                if (var4_4 != null) break block132;
                                                if (var3_3 == null) {
                                                    var1_1.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                    var14_44 = 1245545;
                                                    var1_1.appendErrorMessage(MessageHandler.getMessage(var14_44));
                                                } else {
                                                    var1_1.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                    var14_45 = 1245545;
                                                    var1_1.appendAdditionalLogMessage(MessageHandler.getMessage(var14_45));
                                                }
                                                if (var9_13 == null) break block133;
                                                LockManager.unlock((DN)var7_8, var9_13);
                                            }
                                            return;
                                        }
                                        var12_38 = true;
                                        break block134;
                                        {
                                            catch (DirectoryException var14_46) {
                                                if (!PasswordModifyExtendedOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.extensions.PasswordModifyExtendedOperation", "processExtendedOperation", var14_46)) {
                                                    throw new AssertionError();
                                                }
                                                if (var3_3 == null) {
                                                    var1_1.setResultCode(var14_46.getResultCode());
                                                    var15_50 = 1245546;
                                                    var1_1.appendErrorMessage(MessageHandler.getMessage(var15_50, new Object[]{var14_46.getErrorMessage()}));
                                                } else {
                                                    var1_1.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                    var15_51 = 1245546;
                                                    var1_1.appendAdditionalLogMessage(MessageHandler.getMessage(var15_51, new Object[]{var14_46.getErrorMessage()}));
                                                }
                                                if (var9_13 != null) {
                                                    LockManager.unlock((DN)var7_8, var9_13);
                                                }
                                                return;
                                            }
                                        }
                                    }
                                    if (!var10_14.passwordIsPreEncoded(var4_4)) break block135;
                                    var13_43 = true;
                                    if (var10_14.allowPreEncodedPasswords()) break block134;
                                    if (var3_3 == null) {
                                        var1_1.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                        var14_47 = 1245547;
                                        var1_1.appendErrorMessage(MessageHandler.getMessage(var14_47));
                                    } else {
                                        var1_1.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                        var14_48 = 1245547;
                                        var1_1.appendAdditionalLogMessage(MessageHandler.getMessage(var14_48));
                                    }
                                    if (var9_13 == null) break block136;
                                    LockManager.unlock((DN)var7_8, var9_13);
                                }
                                return;
                            }
                            if (!var11_17 && var10_14.skipValidationForAdministrators() || var10_14.passwordIsAcceptable(var1_1, (Entry)var8_10 /* !! */ , var4_4, (StringBuilder)(var14_49 = new StringBuilder()))) break block134;
                            if (var3_3 == null) {
                                var1_1.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                var15_52 = 1245548;
                                var1_1.appendErrorMessage(MessageHandler.getMessage(var15_52, new Object[]{String.valueOf(var14_49)}));
                            } else {
                                var1_1.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                var15_53 = 1245548;
                                var1_1.appendAdditionalLogMessage(MessageHandler.getMessage(var15_53, new Object[]{String.valueOf(var14_49)}));
                            }
                            if (var9_13 == null) break block137;
                            LockManager.unlock((DN)var7_8, var9_13);
                        }
                        return;
                    }
                    if (var13_43) {
                        var14_49 = new ArrayList<E>(1);
                        var14_49.add(var4_4);
                        break block138;
                    }
                    try {
                        var14_49 = var10_14.encodePassword(var4_4);
                    }
                    catch (DirectoryException var15_54) {
                        if (!PasswordModifyExtendedOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.extensions.PasswordModifyExtendedOperation", "processExtendedOperation", var15_54)) {
                            throw new AssertionError();
                        }
                        if (var3_3 == null) {
                            var1_1.setResultCode(var15_54.getResultCode());
                            var16_56 = 1245549;
                            var1_1.appendErrorMessage(MessageHandler.getMessage(var16_56, new Object[]{var15_54.getErrorMessage()}));
                        } else {
                            var1_1.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            var16_57 = 1245549;
                            var1_1.appendAdditionalLogMessage(MessageHandler.getMessage(var16_57, new Object[]{var15_54.getErrorMessage()}));
                        }
                        if (var9_13 != null) {
                            LockManager.unlock((DN)var7_8, var9_13);
                        }
                        return;
                    }
                }
                try {
                    var15_55 = var10_14.getPasswordAttribute();
                    var16_58 = new ArrayList<Modification>();
                    if (var3_3 != null) {
                        var17_59 = var10_14.getPasswordValues();
                        var18_61 = new LinkedHashSet<E>(var17_59.size());
                        if (var10_14.usesAuthPasswordSyntax()) {
                            for (Object var20_63 : var17_59) {
                                try {
                                    var21_64 /* !! */  = AuthPasswordSyntax.decodeAuthPassword(var20_63.getStringValue());
                                    var22_67 = DirectoryServer.getAuthPasswordStorageScheme(var21_64 /* !! */ [0].toString());
                                    if (var22_67 == null) {
                                        var18_61.add(var20_63);
                                        continue;
                                    }
                                    if (!var22_67.authPasswordMatches(var3_3, var21_64 /* !! */ [1].toString(), var21_64 /* !! */ [2].toString())) continue;
                                    var18_61.add(var20_63);
                                }
                                catch (DirectoryException var21_65) {
                                    if (!PasswordModifyExtendedOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.extensions.PasswordModifyExtendedOperation", "processExtendedOperation", var21_65)) {
                                        throw new AssertionError();
                                    }
                                    var18_61.add(var20_63);
                                }
                            }
                        } else {
                            for (Object var20_63 : var17_59) {
                                try {
                                    var21_64 /* !! */  = UserPasswordSyntax.decodeUserPassword(var20_63.getStringValue());
                                    var22_67 = DirectoryServer.getPasswordStorageScheme(StaticUtils.toLowerCase(var21_64 /* !! */ [0].toString()));
                                    if (var22_67 == null) {
                                        var18_61.add(var20_63);
                                        continue;
                                    }
                                    if (!var22_67.passwordMatches(var3_3, new ASN1OctetString((String)var21_64 /* !! */ [1]))) continue;
                                    var18_61.add(var20_63);
                                }
                                catch (DirectoryException var21_66) {
                                    if (!PasswordModifyExtendedOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.extensions.PasswordModifyExtendedOperation", "processExtendedOperation", var21_66)) {
                                        throw new AssertionError();
                                    }
                                    var18_61.add(var20_63);
                                }
                            }
                        }
                        var19_62 = new Attribute(var15_55, var15_55.getNameOrOID(), (LinkedHashSet<AttributeValue>)var18_61);
                        var16_58.add(new Modification(ModificationType.DELETE, (Attribute)var19_62));
                        var20_63 = new LinkedHashSet<E>(var14_49.size());
                        var21_64 /* !! */  = var14_49.iterator();
                        while (var21_64 /* !! */ .hasNext()) {
                            var22_67 = (ByteString)var21_64 /* !! */ .next();
                            var20_63.add(new AttributeValue(var15_55, (ByteString)var22_67));
                        }
                        var21_64 /* !! */  = new Attribute(var15_55, var15_55.getNameOrOID(), (LinkedHashSet<AttributeValue>)var20_63);
                        var16_58.add(new Modification(ModificationType.ADD, (Attribute)var21_64 /* !! */ ));
                    } else {
                        var17_59 = new LinkedHashSet<E>(var14_49.size());
                        var18_61 = var14_49.iterator();
                        while (var18_61.hasNext()) {
                            var19_62 = (ByteString)var18_61.next();
                            var17_59.add(new AttributeValue(var15_55, (ByteString)var19_62));
                        }
                        var18_61 = new Attribute(var15_55, var15_55.getNameOrOID(), var17_59);
                        var16_58.add(new Modification(ModificationType.REPLACE, (Attribute)var18_61));
                    }
                    var10_14.setPasswordChangedTime();
                    if (var11_17) {
                        var10_14.setMustChangePassword(false);
                    } else {
                        var10_14.setMustChangePassword(var10_14.forceChangeOnReset());
                    }
                    var10_14.clearAuthFailureTimes();
                    var10_14.clearFailureLockout();
                    var10_14.clearGraceLoginTimes();
                    var10_14.clearWarnedTime();
                    var16_58.addAll(var10_14.getModifications());
                    var17_60 = DirectoryServer.isRootDN((DN)var6_6);
                    var18_61 = new AuthenticationInfo((DN)var6_6, var17_60);
                    var19_62 = new InternalClientConnection((AuthenticationInfo)var18_61);
                    var20_63 = var19_62.processModify((DN)var7_8, var16_58);
                    var21_64 /* !! */  = var20_63.getResultCode();
                    if (var21_64 /* !! */  == ResultCode.SUCCESS) break block139;
                    var1_1.setResultCode((ResultCode)var21_64 /* !! */ );
                    var1_1.setErrorMessage(var20_63.getErrorMessage());
                    var1_1.setReferralURLs(var20_63.getReferralURLs());
                    if (var9_13 == null) break block140;
                }
                catch (Throwable var25_70) {
                    if (var9_13 != null) {
                        LockManager.unlock(var7_8, var9_13);
                    }
                    throw var25_70;
                }
                LockManager.unlock((DN)var7_8, var9_13);
            }
            return;
        }
        var1_1.setResultCode(ResultCode.SUCCESS);
        if (var12_38) {
            var22_67 = new ArrayList<ASN1Element>(1);
            var23_68 = new ASN1OctetString(-128, var4_4.value());
            var22_67.add(var23_68);
            var24_69 = new ASN1Sequence(var22_67);
            var1_1.setResponseValue(new ASN1OctetString(var24_69.encode()));
        }
        if (var11_17 && var18_61.getAuthenticationDN() != null && var18_61.getAuthenticationDN().equals(var7_8)) {
            var1_1.getClientConnection().setMustChangePassword(false);
        }
        ** if (var9_13 == null) goto lbl-1000
lbl-1000:
        // 1 sources

        {
            LockManager.unlock((DN)var7_8, var9_13);
        }
lbl-1000:
        // 2 sources

        {
        }
    }

    private Entry getEntryByDN(ExtendedOperation extendedOperation, DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getEntryByDN", String.valueOf(extendedOperation), String.valueOf(dN)));
        try {
            Entry entry = DirectoryServer.getEntry(dN);
            if (entry == null) {
                extendedOperation.setResultCode(ResultCode.NO_SUCH_OBJECT);
                int n = 1245222;
                extendedOperation.appendErrorMessage(MessageHandler.getMessage(n, String.valueOf(dN)));
                for (DN dN2 = dN.getParent(); dN2 != null; dN2 = dN2.getParent()) {
                    try {
                        if (!DirectoryServer.entryExists(dN2)) continue;
                        extendedOperation.setMatchedDN(dN2);
                        break;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "getEntryByDN", exception));
                        break;
                    }
                }
                return null;
            }
            return entry;
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "getEntryByDN", directoryException));
            extendedOperation.setResultCode(directoryException.getResultCode());
            extendedOperation.appendErrorMessage(directoryException.getErrorMessage());
            extendedOperation.setMatchedDN(directoryException.getMatchedDN());
            extendedOperation.setReferralURLs(directoryException.getReferralURLs());
            return null;
        }
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        int n = 1048942;
        linkedList.add(new DNConfigAttribute("ds-cfg-identity-mapper-dn", MessageHandler.getMessage(n), true, false, false, this.identityMapperDN));
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "List<String>"));
        int n = 1048942;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-identity-mapper-dn", MessageHandler.getMessage(n), true, false, false);
        try {
            DNConfigAttribute dNConfigAttribute2 = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (dNConfigAttribute2 == null) {
                n = 1245551;
                String string = MessageHandler.getMessage(n, String.valueOf(configEntry.getDN()));
                list.add(string);
                return false;
            }
            DN dN = dNConfigAttribute2.pendingValue();
            IdentityMapper identityMapper = DirectoryServer.getIdentityMapper(dN);
            if (identityMapper == null) {
                n = 1245552;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(configEntry.getDN()));
                list.add(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 1245553;
            String string = MessageHandler.getMessage(n, String.valueOf(configEntry.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
            list.add(string);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        DN dN = null;
        IdentityMapper identityMapper = null;
        int n = 1048942;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-identity-mapper-dn", MessageHandler.getMessage(n), true, false, false);
        try {
            DNConfigAttribute dNConfigAttribute2 = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (dNConfigAttribute2 == null) {
                resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                n = 1245551;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(configEntry.getDN())));
            } else {
                dN = dNConfigAttribute2.pendingValue();
                identityMapper = DirectoryServer.getIdentityMapper(dN);
                if (identityMapper == null) {
                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                    n = 1245552;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(configEntry.getDN())));
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            resultCode = DirectoryServer.getServerErrorResultCode();
            n = 1245553;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(configEntry.getDN()), StaticUtils.stackTraceToSingleLineString(exception)));
        }
        if (resultCode == ResultCode.SUCCESS && !this.identityMapperDN.equals(dN)) {
            this.identityMapper = identityMapper;
            this.identityMapperDN = dN;
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }
}

