/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKCS11KeyManagerProvider
extends KeyManagerProvider
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.extensions.PKCS11KeyManagerProvider";
    public static final String PKCS11_KEYSTORE_TYPE = "PKCS11";
    private DN configEntryDN;
    private char[] keyStorePIN;
    private String keyStorePINEnVar;
    private String keyStorePINFile;
    private String keyStorePINProperty;

    public PKCS11KeyManagerProvider() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeKeyManagerProvider(ConfigEntry configEntry) throws ConfigException, InitializationException {
        Object object;
        int n;
        block28: {
            StringConfigAttribute stringConfigAttribute;
            block30: {
                StringConfigAttribute stringConfigAttribute2;
                block29: {
                    StringConfigAttribute stringConfigAttribute3;
                    block27: {
                        assert (Debug.debugEnter(CLASS_NAME, "initializeKeyManagerProvider", String.valueOf(configEntry)));
                        this.configEntryDN = configEntry.getDN();
                        this.keyStorePIN = null;
                        this.keyStorePINEnVar = null;
                        this.keyStorePINFile = null;
                        this.keyStorePINProperty = null;
                        n = 1048643;
                        object = new StringConfigAttribute("ds-cfg-key-store-pin-property", MessageHandler.getMessage(n), false, false, false);
                        try {
                            stringConfigAttribute3 = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object);
                            if (stringConfigAttribute3 == null) break block27;
                            String string = stringConfigAttribute3.activeValue();
                            String string2 = System.getProperty(string);
                            if (string2 == null) {
                                n = 0x140044;
                                String string3 = MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(this.configEntryDN));
                                throw new InitializationException(n, string3);
                            }
                            this.keyStorePIN = string2.toCharArray();
                            this.keyStorePINProperty = string;
                            break block28;
                        }
                        catch (InitializationException initializationException) {
                            assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", initializationException));
                            throw initializationException;
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
                            n = 1310789;
                            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                            throw new InitializationException(n, string, exception);
                        }
                    }
                    n = 1048646;
                    stringConfigAttribute3 = new StringConfigAttribute("ds-cfg-key-store-pin-environment-variable", MessageHandler.getMessage(n), false, false, false);
                    try {
                        stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute3);
                        if (stringConfigAttribute2 == null) break block29;
                        String string = stringConfigAttribute2.activeValue();
                        String string4 = System.getenv(string);
                        if (string4 == null) {
                            n = 1310791;
                            String string5 = MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(this.configEntryDN));
                            throw new InitializationException(n, string5);
                        }
                        this.keyStorePIN = string4.toCharArray();
                        this.keyStorePINEnVar = string;
                        break block28;
                    }
                    catch (InitializationException initializationException) {
                        assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", initializationException));
                        throw initializationException;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
                        n = 1310792;
                        String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                        throw new InitializationException(n, string, exception);
                    }
                }
                n = 1048649;
                stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-key-store-pin-file", MessageHandler.getMessage(n), false, false, false);
                try {
                    String string;
                    Object object2;
                    stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute2);
                    if (stringConfigAttribute == null) break block30;
                    String string6 = stringConfigAttribute.activeValue();
                    File file = StaticUtils.getFileForPath(string6);
                    if (!file.exists()) {
                        n = 1310794;
                        String string7 = MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN));
                        throw new InitializationException(n, string7);
                    }
                    try {
                        object2 = new BufferedReader(new FileReader(file));
                        string = ((BufferedReader)object2).readLine();
                        ((BufferedReader)object2).close();
                    }
                    catch (IOException iOException) {
                        n = 1310795;
                        String string8 = MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(iOException));
                        throw new InitializationException(n, string8, iOException);
                    }
                    if (string == null) {
                        n = 1310796;
                        object2 = MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN));
                        throw new InitializationException(n, (String)object2);
                    }
                    this.keyStorePIN = string.toCharArray();
                    this.keyStorePINFile = string6;
                    break block28;
                }
                catch (InitializationException initializationException) {
                    assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", initializationException));
                    throw initializationException;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
                    n = 1310797;
                    String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                    throw new InitializationException(n, string, exception);
                }
            }
            n = 1048654;
            stringConfigAttribute = new StringConfigAttribute("ds-cfg-key-store-pin", MessageHandler.getMessage(n), false, false, false);
            try {
                StringConfigAttribute stringConfigAttribute4 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                if (stringConfigAttribute4 != null) {
                    this.keyStorePIN = stringConfigAttribute4.activeValue().toCharArray();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
                n = 1310799;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
        }
        if (this.keyStorePIN == null) {
            n = 1310800;
            object = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
            throw new ConfigException(n, (String)object);
        }
        DirectoryServer.registerConfigurableComponent(this);
    }

    @Override
    public void finalizeKeyManagerProvider() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeKeyManagerProvider", new String[0]));
        DirectoryServer.deregisterConfigurableComponent(this);
    }

    @Override
    public KeyManager[] getKeyManagers() throws DirectoryException {
        KeyStore keyStore;
        assert (Debug.debugEnter(CLASS_NAME, "getKeyManagers", new String[0]));
        try {
            keyStore = KeyStore.getInstance(PKCS11_KEYSTORE_TYPE);
            keyStore.load(null, this.keyStorePIN);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getKeyManagers", exception));
            int n = 1310801;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, exception);
        }
        try {
            String string = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string);
            keyManagerFactory.init(keyStore, this.keyStorePIN);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getKeyManagers", exception));
            int n = 1310804;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, exception);
        }
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        int n = 1048643;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-key-store-pin-property", MessageHandler.getMessage(n), false, false, false, this.keyStorePINProperty);
        linkedList.add(stringConfigAttribute);
        n = 1048646;
        StringConfigAttribute stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-key-store-pin-environment-variable", MessageHandler.getMessage(n), false, false, false, this.keyStorePINEnVar);
        linkedList.add(stringConfigAttribute2);
        n = 1048649;
        StringConfigAttribute stringConfigAttribute3 = new StringConfigAttribute("ds-cfg-key-store-pin-file", MessageHandler.getMessage(n), false, false, false, this.keyStorePINFile);
        linkedList.add(stringConfigAttribute3);
        String string = this.keyStorePINProperty == null && this.keyStorePINEnVar == null && this.keyStorePINFile == null ? new String(this.keyStorePIN) : null;
        n = 1048654;
        StringConfigAttribute stringConfigAttribute4 = new StringConfigAttribute("ds-cfg-key-store-pin", MessageHandler.getMessage(n), false, false, false, string);
        linkedList.add(stringConfigAttribute4);
        return linkedList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        Object object;
        int n;
        block22: {
            StringConfigAttribute stringConfigAttribute;
            block24: {
                StringConfigAttribute stringConfigAttribute2;
                block23: {
                    StringConfigAttribute stringConfigAttribute3;
                    block21: {
                        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
                        n = 1048643;
                        object = new StringConfigAttribute("ds-cfg-key-store-pin-property", MessageHandler.getMessage(n), false, false, false);
                        try {
                            stringConfigAttribute3 = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object);
                            if (stringConfigAttribute3 == null) break block21;
                            String string = stringConfigAttribute3.activeValue();
                            String string2 = System.getProperty(string);
                            if (string2 == null) {
                                n = 0x140044;
                                String string3 = MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(this.configEntryDN));
                                list.add(string3);
                                return false;
                            }
                            break block22;
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
                            n = 1310789;
                            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                            list.add(string);
                            return false;
                        }
                    }
                    n = 1048646;
                    stringConfigAttribute3 = new StringConfigAttribute("ds-cfg-key-store-pin-environment-variable", MessageHandler.getMessage(n), false, false, false);
                    try {
                        stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute3);
                        if (stringConfigAttribute2 == null) break block23;
                        String string = stringConfigAttribute2.activeValue();
                        String string4 = System.getenv(string);
                        if (string4 == null) {
                            n = 1310791;
                            String string5 = MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(this.configEntryDN));
                            list.add(string5);
                            return false;
                        }
                        break block22;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
                        n = 1310792;
                        String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                        list.add(string);
                        return false;
                    }
                }
                n = 1048649;
                stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-key-store-pin-file", MessageHandler.getMessage(n), false, false, false);
                try {
                    String string;
                    Object object2;
                    stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute2);
                    if (stringConfigAttribute == null) break block24;
                    String string6 = stringConfigAttribute.activeValue();
                    File file = StaticUtils.getFileForPath(string6);
                    if (!file.exists()) {
                        n = 1310794;
                        String string7 = MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN));
                        list.add(string7);
                        return false;
                    }
                    try {
                        object2 = new BufferedReader(new FileReader(file));
                        string = ((BufferedReader)object2).readLine();
                        ((BufferedReader)object2).close();
                    }
                    catch (IOException iOException) {
                        n = 1310795;
                        String string8 = MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(iOException));
                        list.add(string8);
                        return false;
                    }
                    if (string == null) {
                        n = 1310796;
                        object2 = MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN));
                        list.add((String)object2);
                        return false;
                    }
                    break block22;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
                    n = 1310797;
                    String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                    list.add(string);
                    return false;
                }
            }
            n = 1048654;
            stringConfigAttribute = new StringConfigAttribute("ds-cfg-key-store-pin", MessageHandler.getMessage(n), false, false, false);
            try {
                StringConfigAttribute stringConfigAttribute4 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                if (stringConfigAttribute4 == null) {
                    // empty if block
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
                n = 1310799;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                list.add(string);
                return false;
            }
        }
        if (this.keyStorePIN == null) {
            n = 1310800;
            object = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
            list.add((String)object);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        int n;
        String string;
        String string2;
        String string3;
        char[] cArray;
        ArrayList<String> arrayList;
        boolean bl2;
        ResultCode resultCode;
        block33: {
            StringConfigAttribute stringConfigAttribute;
            block35: {
                StringConfigAttribute stringConfigAttribute2;
                block34: {
                    StringConfigAttribute stringConfigAttribute3;
                    block32: {
                        assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
                        resultCode = ResultCode.SUCCESS;
                        bl2 = false;
                        arrayList = new ArrayList<String>();
                        cArray = null;
                        string3 = null;
                        string2 = null;
                        string = null;
                        n = 1048643;
                        StringConfigAttribute stringConfigAttribute4 = new StringConfigAttribute("ds-cfg-key-store-pin-property", MessageHandler.getMessage(n), false, false, false);
                        try {
                            stringConfigAttribute3 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute4);
                            if (stringConfigAttribute3 == null) break block32;
                            String string4 = stringConfigAttribute3.activeValue();
                            String string5 = System.getProperty(string4);
                            if (string5 == null) {
                                n = 0x140044;
                                arrayList.add(MessageHandler.getMessage(n, String.valueOf(string4), String.valueOf(this.configEntryDN)));
                                if (resultCode == ResultCode.SUCCESS) {
                                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                                }
                                break block33;
                            }
                            cArray = string5.toCharArray();
                            string = string4;
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                            n = 1310789;
                            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                            if (resultCode == ResultCode.SUCCESS) {
                                resultCode = DirectoryServer.getServerErrorResultCode();
                            }
                            break block33;
                        }
                    }
                    n = 1048646;
                    stringConfigAttribute3 = new StringConfigAttribute("ds-cfg-key-store-pin-environment-variable", MessageHandler.getMessage(n), false, false, false);
                    try {
                        stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute3);
                        if (stringConfigAttribute2 == null) break block34;
                        String string6 = stringConfigAttribute2.activeValue();
                        String string7 = System.getenv(string6);
                        if (string7 == null) {
                            n = 1310791;
                            arrayList.add(MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN)));
                            if (resultCode == ResultCode.SUCCESS) {
                                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                            }
                            break block33;
                        }
                        cArray = string7.toCharArray();
                        string3 = string6;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                        n = 1310792;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = DirectoryServer.getServerErrorResultCode();
                        }
                        break block33;
                    }
                }
                n = 1048649;
                stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-key-store-pin-file", MessageHandler.getMessage(n), false, false, false);
                try {
                    String string8;
                    stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute2);
                    if (stringConfigAttribute == null) break block35;
                    String string9 = stringConfigAttribute.activeValue();
                    File file = StaticUtils.getFileForPath(string9);
                    if (!file.exists()) {
                        n = 1310794;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(string9), String.valueOf(this.configEntryDN)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = ResultCode.CONSTRAINT_VIOLATION;
                        }
                        break block33;
                    }
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                        string8 = bufferedReader.readLine();
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        n = 1310795;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(string9), String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(iOException)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = DirectoryServer.getServerErrorResultCode();
                        }
                        break block33;
                    }
                    if (string8 == null) {
                        n = 1310796;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(string9), String.valueOf(this.configEntryDN)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = ResultCode.CONSTRAINT_VIOLATION;
                        }
                        break block33;
                    }
                    cArray = string8.toCharArray();
                    string2 = string9;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                    n = 1310797;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                    if (resultCode == ResultCode.SUCCESS) {
                        resultCode = DirectoryServer.getServerErrorResultCode();
                    }
                    break block33;
                }
            }
            n = 1048654;
            stringConfigAttribute = new StringConfigAttribute("ds-cfg-key-store-pin", MessageHandler.getMessage(n), false, false, false);
            try {
                StringConfigAttribute stringConfigAttribute5 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                if (stringConfigAttribute5 != null) {
                    cArray = stringConfigAttribute5.activeValue().toCharArray();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                n = 1310799;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                if (resultCode != ResultCode.SUCCESS) break block33;
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
        }
        if (cArray == null) {
            n = 1310800;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
            }
        }
        if (resultCode == ResultCode.SUCCESS && !Arrays.equals(this.keyStorePIN, cArray)) {
            this.keyStorePIN = cArray;
            this.keyStorePINProperty = string;
            this.keyStorePINEnVar = string3;
            this.keyStorePINFile = string2;
            if (bl) {
                n = 1048658;
                arrayList.add(MessageHandler.getMessage(n));
            }
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }
}

