/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslServer;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.extensions.GSSAPISASLMechanismHandler;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.Entry;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSSAPIStateInfo
implements PrivilegedExceptionAction<Boolean>,
CallbackHandler {
    private static final String CLASS_NAME = "org.opends.server.extensions.GSSAPIStateInfo";
    private BindOperation bindOperation;
    private ClientConnection clientConnection;
    private Entry userEntry;
    private GSSAPISASLMechanismHandler gssapiHandler;
    private LoginContext loginContext;
    private SaslServer saslServer;
    private String protocol;
    private String serverFQDN;

    public GSSAPIStateInfo(GSSAPISASLMechanismHandler gSSAPISASLMechanismHandler, BindOperation bindOperation, String string) throws InitializationException {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(bindOperation), String.valueOf(string)));
        this.gssapiHandler = gSSAPISASLMechanismHandler;
        this.bindOperation = bindOperation;
        this.serverFQDN = string;
        this.clientConnection = bindOperation.getClientConnection();
        this.protocol = StaticUtils.toLowerCase(this.clientConnection.getProtocol());
        this.userEntry = null;
        try {
            this.loginContext = new LoginContext(GSSAPISASLMechanismHandler.class.getName(), this);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "<init>", exception));
            int n = 1245455;
            String string2 = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string2, exception);
        }
        try {
            this.loginContext.login();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "<init>", exception));
            int n = 0x130110;
            String string3 = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string3, exception);
        }
        this.saslServer = null;
    }

    public void setBindOperation(BindOperation bindOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "setBindOperation", String.valueOf(bindOperation)));
        this.bindOperation = bindOperation;
    }

    public Entry getUserEntry() {
        assert (Debug.debugEnter(CLASS_NAME, "getUserEntry", new String[0]));
        return this.userEntry;
    }

    public void dispose() {
        block2: {
            try {
                this.saslServer.dispose();
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "dispose", exception)) break block2;
                throw new AssertionError();
            }
        }
    }

    public void processAuthenticationStage() {
        block3: {
            assert (Debug.debugEnter(CLASS_NAME, "processAuthenticationStage", new String[0]));
            try {
                Subject.doAs(this.loginContext.getSubject(), this);
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "processAuthenticationStage", exception)) break block3;
                throw new AssertionError();
            }
        }
    }

    @Override
    public Boolean run() {
        block28: {
            ASN1OctetString aSN1OctetString;
            Object object;
            ASN1OctetString aSN1OctetString2;
            Object object2;
            assert (Debug.debugEnter(CLASS_NAME, "run", new String[0]));
            if (this.saslServer == null) {
                try {
                    object2 = new HashMap<String, String>();
                    ((HashMap)object2).put("javax.security.sasl.qop", "auth");
                    ((HashMap)object2).put("javax.security.sasl.reuse", "false");
                    this.saslServer = Sasl.createSaslServer("GSSAPI", this.protocol, this.serverFQDN, object2, this);
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "run", exception));
                    int n = 1245445;
                    String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
                    this.clientConnection.setSASLAuthStateInfo(null);
                    this.bindOperation.setAuthFailureReason(n, string);
                    this.bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    return false;
                }
            }
            object2 = (aSN1OctetString2 = this.bindOperation.getSASLCredentials()) == null ? (Object)new byte[0] : (Object)aSN1OctetString2.value();
            try {
                object = this.saslServer.evaluateResponse((byte[])object2);
                aSN1OctetString = object == null ? null : new ASN1OctetString((byte[])object);
            }
            catch (Exception exception) {
                block24: {
                    assert (Debug.debugException(CLASS_NAME, "run", exception));
                    try {
                        this.saslServer.dispose();
                    }
                    catch (Exception exception2) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "run", exception2)) break block24;
                        throw new AssertionError();
                    }
                }
                int n = 1245446;
                String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
                this.clientConnection.setSASLAuthStateInfo(null);
                this.bindOperation.setAuthFailureReason(n, string);
                this.bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                return false;
            }
            if (!this.saslServer.isComplete()) {
                this.clientConnection.setSASLAuthStateInfo(this.saslServer);
                this.bindOperation.setResultCode(ResultCode.SASL_BIND_IN_PROGRESS);
                this.bindOperation.setServerSASLCredentials(aSN1OctetString);
                return true;
            }
            object = this.saslServer.getAuthorizationID();
            if (object == null || ((String)object).length() == 0) {
                block25: {
                    try {
                        this.saslServer.dispose();
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "run", exception)) break block25;
                        throw new AssertionError();
                    }
                }
                int n = 1245447;
                String string = MessageHandler.getMessage(n);
                this.clientConnection.setSASLAuthStateInfo(null);
                this.bindOperation.setAuthFailureReason(n, string);
                this.bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                return false;
            }
            try {
                this.userEntry = this.gssapiHandler.getUserForAuthzID(this.bindOperation, (String)object);
            }
            catch (DirectoryException directoryException) {
                block26: {
                    assert (Debug.debugException(CLASS_NAME, "run", directoryException));
                    try {
                        this.saslServer.dispose();
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "run", exception)) break block26;
                        throw new AssertionError();
                    }
                }
                this.bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                this.bindOperation.setAuthFailureReason(directoryException.getErrorMessageID(), directoryException.getErrorMessage());
                this.clientConnection.setSASLAuthStateInfo(null);
                return false;
            }
            if (this.userEntry == null) {
                block27: {
                    try {
                        this.saslServer.dispose();
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "run", exception)) break block27;
                        throw new AssertionError();
                    }
                }
                int n = 1245450;
                String string = MessageHandler.getMessage(n, object);
                this.clientConnection.setSASLAuthStateInfo(null);
                this.bindOperation.setAuthFailureReason(n, string);
                this.bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                return false;
            }
            this.bindOperation.setSASLAuthUserEntry(this.userEntry);
            AuthenticationInfo authenticationInfo = new AuthenticationInfo(this.userEntry.getDN(), "GSSAPI", DirectoryServer.isRootDN(this.userEntry.getDN()));
            this.clientConnection.setAuthenticationInfo(authenticationInfo);
            this.bindOperation.setResultCode(ResultCode.SUCCESS);
            this.clientConnection.setSASLAuthStateInfo(null);
            try {
                this.saslServer.dispose();
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "run", exception)) break block28;
                throw new AssertionError();
            }
        }
        return true;
    }

    @Override
    public void handle(Callback[] callbackArray) throws UnsupportedCallbackException {
        assert (Debug.debugEnter(CLASS_NAME, "handle", String.valueOf(callbackArray)));
        for (Callback callback : callbackArray) {
            String string;
            Object object;
            if (callback instanceof NameCallback) {
                object = StaticUtils.toLowerCase(this.clientConnection.getProtocol()) + "/" + this.serverFQDN;
                ((NameCallback)callback).setName((String)object);
                continue;
            }
            if (callback instanceof AuthorizeCallback) {
                String string2;
                object = (AuthorizeCallback)callback;
                string = ((AuthorizeCallback)object).getAuthenticationID();
                if (string.equals(string2 = ((AuthorizeCallback)object).getAuthorizationID())) {
                    ((AuthorizeCallback)object).setAuthorizedID(string2);
                    ((AuthorizeCallback)object).setAuthorized(true);
                    continue;
                }
                int n = 0x140114;
                String string3 = MessageHandler.getMessage(n, string, string2);
                this.bindOperation.setAuthFailureReason(n, string3);
                ((AuthorizeCallback)object).setAuthorized(false);
                continue;
            }
            int n = 0x1000FF;
            string = MessageHandler.getMessage(n, String.valueOf(callback));
            throw new UnsupportedCallbackException(callback, string);
        }
    }
}

