/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.List;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.CancelRequest;
import org.opends.server.core.CancelResult;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.Operation;
import org.opends.server.core.OperationType;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.loggers.Access;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.Control;
import org.opends.server.types.DisconnectReason;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnbindOperation
extends Operation {
    private static final String CLASS_NAME = "org.opends.server.core.UnbindOperation";

    public UnbindOperation(ClientConnection clientConnection, long l, int n, ArrayList<Control> arrayList) {
        super(clientConnection, l, n, arrayList);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(l), String.valueOf(n), String.valueOf(arrayList)));
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.UNBIND;
    }

    @Override
    public String[][] getRequestLogElements() {
        return new String[0][];
    }

    @Override
    public String[][] getResponseLogElements() {
        return new String[0][];
    }

    @Override
    public List<Control> getResponseControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getResponseControls", new String[0]));
        return NO_RESPONSE_CONTROLS;
    }

    @Override
    public void run() {
        assert (Debug.debugEnter(CLASS_NAME, "run", new String[0]));
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        boolean bl = false;
        pluginConfigManager.invokePreParseUnbindPlugins(this);
        Access.logUnbind(this);
        this.getClientConnection().disconnect(DisconnectReason.UNBIND, false, null, -1);
        pluginConfigManager.invokePostOperationUnbindPlugins(this);
    }

    @Override
    public CancelResult cancel(CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "cancel", String.valueOf(cancelRequest)));
        cancelRequest.addResponseMessage(MessageHandler.getMessage(196611));
        return CancelResult.CANNOT_CANCEL;
    }

    @Override
    public CancelRequest getCancelRequest() {
        assert (Debug.debugEnter(CLASS_NAME, "getCancelRequest", new String[0]));
        return null;
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("UnbindOperation(connID=");
        stringBuilder.append(this.clientConnection.getConnectionID());
        stringBuilder.append(", opID=");
        stringBuilder.append(this.operationID);
        stringBuilder.append(")");
    }
}

