/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PostOperationPluginResult;
import org.opends.server.api.plugin.PreOperationPluginResult;
import org.opends.server.api.plugin.PreParsePluginResult;
import org.opends.server.api.plugin.SearchEntryPluginResult;
import org.opends.server.api.plugin.SearchReferencePluginResult;
import org.opends.server.controls.AccountUsableResponseControl;
import org.opends.server.controls.LDAPAssertionRequestControl;
import org.opends.server.controls.MatchedValuesControl;
import org.opends.server.controls.PersistentSearchControl;
import org.opends.server.controls.ProxiedAuthV1Control;
import org.opends.server.controls.ProxiedAuthV2Control;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.CancelRequest;
import org.opends.server.core.CancelResult;
import org.opends.server.core.CancelledOperationException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.Operation;
import org.opends.server.core.OperationType;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.core.PersistentSearch;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.loggers.Access;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.Entry;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchOperation
extends Operation {
    private static final String CLASS_NAME = "org.opends.server.core.SearchOperation";
    private AtomicBoolean responseSent;
    private boolean clientAcceptsReferrals;
    private boolean includeUsableControl;
    private boolean returnLDAPSubentries;
    private boolean typesOnly;
    private ByteString rawBaseDN;
    private CancelRequest cancelRequest;
    private DereferencePolicy derefPolicy;
    private DN baseDN;
    private int entriesSent;
    private int referencesSent;
    private int sizeLimit;
    private int timeLimit;
    private LDAPFilter rawFilter;
    private LinkedHashSet<String> attributes;
    private List<Control> responseControls;
    private long processingStartTime;
    private long processingStopTime;
    private long timeLimitExpiration;
    private MatchedValuesControl matchedValuesControl;
    private PersistentSearch persistentSearch;
    private SearchFilter filter;
    private SearchScope scope;

    public SearchOperation(ClientConnection clientConnection, long l, int n, List<Control> list, ByteString byteString, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n2, int n3, boolean bl, LDAPFilter lDAPFilter, LinkedHashSet<String> linkedHashSet) {
        super(clientConnection, l, n, list);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(l), String.valueOf(n), String.valueOf(list), String.valueOf(byteString), String.valueOf((Object)searchScope), String.valueOf((Object)dereferencePolicy), String.valueOf(n2), String.valueOf(n3), String.valueOf(bl), String.valueOf(lDAPFilter), String.valueOf(linkedHashSet)));
        this.rawBaseDN = byteString;
        this.scope = searchScope;
        this.derefPolicy = dereferencePolicy;
        this.sizeLimit = n2;
        this.timeLimit = n3;
        this.typesOnly = bl;
        this.rawFilter = lDAPFilter;
        this.attributes = linkedHashSet;
        this.sizeLimit = clientConnection.getSizeLimit() <= 0 ? n2 : (n2 <= 0 ? clientConnection.getSizeLimit() : Math.min(n2, clientConnection.getSizeLimit()));
        this.timeLimit = clientConnection.getTimeLimit() <= 0 ? n3 : (n3 <= 0 ? clientConnection.getTimeLimit() : Math.min(n3, clientConnection.getTimeLimit()));
        this.baseDN = null;
        this.filter = null;
        this.entriesSent = 0;
        this.referencesSent = 0;
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
        this.clientAcceptsReferrals = true;
        this.includeUsableControl = false;
        this.responseSent = new AtomicBoolean(false);
        this.persistentSearch = null;
        this.returnLDAPSubentries = false;
        this.matchedValuesControl = null;
    }

    public SearchOperation(ClientConnection clientConnection, long l, int n, List<Control> list, DN dN, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n2, int n3, boolean bl, SearchFilter searchFilter, LinkedHashSet<String> linkedHashSet) {
        super(clientConnection, l, n, list);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(l), String.valueOf(n), String.valueOf(list), String.valueOf(dN), String.valueOf((Object)searchScope), String.valueOf((Object)dereferencePolicy), String.valueOf(n2), String.valueOf(n3), String.valueOf(bl), String.valueOf(searchFilter), String.valueOf(linkedHashSet)));
        this.baseDN = dN;
        this.scope = searchScope;
        this.derefPolicy = dereferencePolicy;
        this.sizeLimit = n2;
        this.timeLimit = n3;
        this.typesOnly = bl;
        this.filter = searchFilter;
        this.attributes = linkedHashSet;
        this.rawBaseDN = new ASN1OctetString(dN.toString());
        this.rawFilter = new LDAPFilter(searchFilter);
        this.sizeLimit = clientConnection.getSizeLimit() <= 0 ? n2 : (n2 <= 0 ? clientConnection.getSizeLimit() : Math.min(n2, clientConnection.getSizeLimit()));
        this.timeLimit = clientConnection.getTimeLimit() <= 0 ? n3 : (n3 <= 0 ? clientConnection.getTimeLimit() : Math.min(n3, clientConnection.getTimeLimit()));
        this.entriesSent = 0;
        this.referencesSent = 0;
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
        this.clientAcceptsReferrals = true;
        this.includeUsableControl = false;
        this.responseSent = new AtomicBoolean(false);
        this.persistentSearch = null;
        this.returnLDAPSubentries = false;
        this.matchedValuesControl = null;
    }

    public ByteString getRawBaseDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getRawBaseDN", new String[0]));
        return this.rawBaseDN;
    }

    public void setRawBaseDN(ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "setRawBaseDN", String.valueOf(byteString)));
        this.rawBaseDN = byteString;
        this.baseDN = null;
    }

    public DN getBaseDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getBaseDN", new String[0]));
        return this.baseDN;
    }

    public void setBaseDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "setBaseDN", String.valueOf(dN)));
        this.baseDN = dN;
    }

    public SearchScope getScope() {
        assert (Debug.debugEnter(CLASS_NAME, "getScope", new String[0]));
        return this.scope;
    }

    public void setScope(SearchScope searchScope) {
        assert (Debug.debugEnter(CLASS_NAME, "setScope", String.valueOf((Object)searchScope)));
        this.scope = searchScope;
    }

    public DereferencePolicy getDerefPolicy() {
        assert (Debug.debugEnter(CLASS_NAME, "getDerefPolicy", new String[0]));
        return this.derefPolicy;
    }

    public void setDerefPolicy(DereferencePolicy dereferencePolicy) {
        assert (Debug.debugEnter(CLASS_NAME, "setDerefPolicy", String.valueOf((Object)dereferencePolicy)));
        this.derefPolicy = dereferencePolicy;
    }

    public int getSizeLimit() {
        assert (Debug.debugEnter(CLASS_NAME, "getSizeLimit", new String[0]));
        return this.sizeLimit;
    }

    public void setSizeLimit(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setSizeLimit", String.valueOf(n)));
        this.sizeLimit = n;
    }

    public int getTimeLimit() {
        assert (Debug.debugEnter(CLASS_NAME, "getTimeLimit", new String[0]));
        return this.timeLimit;
    }

    public void setTimeLimit(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setTimeLimit", String.valueOf(n)));
        this.timeLimit = n;
    }

    public boolean getTypesOnly() {
        assert (Debug.debugEnter(CLASS_NAME, "getTypesOnly", new String[0]));
        return this.typesOnly;
    }

    public void setTypesOnly(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setTypesOnly", String.valueOf(bl)));
        this.typesOnly = bl;
    }

    public LDAPFilter getRawFilter() {
        assert (Debug.debugEnter(CLASS_NAME, "getRawFilter", new String[0]));
        return this.rawFilter;
    }

    public void setRawFilter(LDAPFilter lDAPFilter) {
        assert (Debug.debugEnter(CLASS_NAME, "setRawFilter", String.valueOf(lDAPFilter)));
        this.rawFilter = lDAPFilter;
        this.filter = null;
    }

    public SearchFilter getFilter() {
        assert (Debug.debugEnter(CLASS_NAME, "getFilter", new String[0]));
        return this.filter;
    }

    public void setFilter(SearchFilter searchFilter) {
        assert (Debug.debugEnter(CLASS_NAME, "setFilter", String.valueOf(searchFilter)));
        this.filter = searchFilter;
    }

    public LinkedHashSet<String> getAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributes", new String[0]));
        return this.attributes;
    }

    public int getEntriesSent() {
        assert (Debug.debugEnter(CLASS_NAME, "getEntriesSent", new String[0]));
        return this.entriesSent;
    }

    public int getReferencesSent() {
        assert (Debug.debugEnter(CLASS_NAME, "getReferencesSent", new String[0]));
        return this.referencesSent;
    }

    public long getProcessingStartTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingStartTime", new String[0]));
        return this.processingStartTime;
    }

    public long getProcessingStopTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingStopTime", new String[0]));
        return this.processingStopTime;
    }

    public long getProcessingTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingTime", new String[0]));
        return this.processingStopTime - this.processingStartTime;
    }

    public boolean returnEntry(Entry entry, List<Control> list) {
        Entry entry2;
        int n;
        Object object;
        block52: {
            assert (Debug.debugEnter(CLASS_NAME, "returnEntry", String.valueOf(entry)));
            if (this.cancelRequest != null) {
                this.setResultCode(ResultCode.CANCELED);
                return false;
            }
            if (this.sizeLimit > 0 && this.entriesSent >= this.sizeLimit) {
                this.setResultCode(ResultCode.SIZE_LIMIT_EXCEEDED);
                this.appendErrorMessage(MessageHandler.getMessage(196847, this.sizeLimit));
                return false;
            }
            if (this.timeLimit > 0 && TimeThread.getTime() >= this.timeLimitExpiration) {
                this.setResultCode(ResultCode.TIME_LIMIT_EXCEEDED);
                this.appendErrorMessage(MessageHandler.getMessage(196846, this.timeLimit));
                return false;
            }
            if (this.scope != SearchScope.BASE_OBJECT && !this.returnLDAPSubentries && entry.isLDAPSubentry()) {
                return true;
            }
            if (this.includeUsableControl) {
                try {
                    int n2;
                    object = new PasswordPolicyState(entry, false, false);
                    boolean bl = ((PasswordPolicyState)object).isDisabled() || ((PasswordPolicyState)object).isAccountExpired();
                    boolean bl2 = ((PasswordPolicyState)object).lockedDueToFailures() || ((PasswordPolicyState)object).lockedDueToMaximumResetAge() || ((PasswordPolicyState)object).lockedDueToIdleInterval();
                    boolean bl3 = ((PasswordPolicyState)object).mustChangePassword();
                    boolean bl4 = ((PasswordPolicyState)object).isPasswordExpired();
                    if (bl || bl2 || bl3 || bl4) {
                        n2 = ((PasswordPolicyState)object).getSecondsUntilUnlock();
                        n = ((PasswordPolicyState)object).getGraceLoginsRemaining();
                        if (list == null) {
                            list = new ArrayList<Control>(1);
                        }
                        list.add(new AccountUsableResponseControl(bl, bl3, bl4, n, bl2, n2));
                    } else {
                        if (list == null) {
                            list = new ArrayList<Control>(1);
                        }
                        n2 = ((PasswordPolicyState)object).getSecondsUntilExpiration();
                        list.add(new AccountUsableResponseControl(n2));
                    }
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "returnEntry", exception)) break block52;
                    throw new AssertionError();
                }
            }
        }
        object = new SearchResultEntry(entry, list);
        if (!AccessControlConfigManager.getInstance().getAccessControlHandler().maySend(this, (SearchResultEntry)object)) {
            return true;
        }
        if (this.attributes == null || this.attributes.isEmpty()) {
            entry2 = entry.duplicateWithoutOperationalAttributes(this.typesOnly);
        } else {
            entry2 = entry.duplicateWithoutAttributes();
            block2: for (String string : this.attributes) {
                HashSet<String> hashSet;
                String string2;
                if (string.equals("*")) {
                    if (this.typesOnly) {
                        AttributeType attributeType = DirectoryServer.getObjectClassAttributeType();
                        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
                        arrayList.add(new Attribute(attributeType));
                        entry2.putAttribute(attributeType, arrayList);
                        for (AttributeType n3 : entry.getUserAttributes().keySet()) {
                            ArrayList<Attribute> arrayList2 = new ArrayList<Attribute>(1);
                            arrayList2.add(new Attribute(n3));
                            entry2.putAttribute(n3, arrayList2);
                        }
                        continue;
                    }
                    Attribute attribute = entry.getObjectClassAttribute();
                    ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
                    arrayList.add(attribute);
                    entry2.putAttribute(attribute.getAttributeType(), arrayList);
                    for (AttributeType attributeType : entry.getUserAttributes().keySet()) {
                        entry2.putAttribute(attributeType, entry.duplicateUserAttribute(attributeType));
                    }
                    continue;
                }
                if (string.equals("+")) {
                    for (AttributeType attributeType : entry.getOperationalAttributes().keySet()) {
                        if (this.typesOnly) {
                            ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
                            arrayList.add(new Attribute(attributeType));
                            entry2.putAttribute(attributeType, arrayList);
                            continue;
                        }
                        entry2.putAttribute(attributeType, entry.duplicateOperationalAttribute(attributeType));
                    }
                    continue;
                }
                n = string.indexOf(59);
                if (n > 0) {
                    int n2;
                    string2 = StaticUtils.toLowerCase(string.substring(0, n));
                    int n3 = string.indexOf(59, n + 1);
                    hashSet = new HashSet<String>();
                    while (n2 > 0) {
                        hashSet.add(string.substring(n + 1, n2));
                        n = n2;
                        n2 = string.indexOf(59, n + 1);
                    }
                    hashSet.add(string.substring(n + 1));
                } else {
                    string2 = StaticUtils.toLowerCase(string);
                    hashSet = null;
                }
                AttributeType attributeType = DirectoryServer.getAttributeType(string2);
                if (attributeType == null) {
                    ArrayList<Attribute> arrayList;
                    List<Attribute> list2;
                    boolean bl = false;
                    for (AttributeType attributeType2 : entry.getUserAttributes().keySet()) {
                        if (!attributeType2.hasNameOrOID(string2)) continue;
                        if (hashSet == null || hashSet.isEmpty()) {
                            if (this.typesOnly) {
                                list2 = new ArrayList<Attribute>(1);
                                list2.add(new Attribute(attributeType2));
                                entry2.putAttribute(attributeType2, list2);
                            } else {
                                entry2.putAttribute(attributeType2, entry.duplicateUserAttribute(attributeType2));
                            }
                            bl = true;
                            break;
                        }
                        list2 = entry.duplicateUserAttribute(attributeType2);
                        arrayList = new ArrayList<Attribute>(list2.size());
                        for (Attribute attribute : list2) {
                            if (!attribute.hasOptions(hashSet)) continue;
                            arrayList.add(attribute);
                        }
                        if (arrayList.isEmpty()) continue;
                        if (this.typesOnly) {
                            list2 = new ArrayList<Attribute>(1);
                            list2.add(new Attribute(attributeType2));
                            entry2.putAttribute(attributeType2, list2);
                        } else {
                            entry2.putAttribute(attributeType2, arrayList);
                        }
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    for (AttributeType attributeType2 : entry.getOperationalAttributes().keySet()) {
                        if (!attributeType2.hasNameOrOID(string2)) continue;
                        if (hashSet == null || hashSet.isEmpty()) {
                            if (this.typesOnly) {
                                list2 = new ArrayList<Attribute>(1);
                                list2.add(new Attribute(attributeType2));
                                entry2.putAttribute(attributeType2, list2);
                            } else {
                                entry2.putAttribute(attributeType2, entry.duplicateOperationalAttribute(attributeType2));
                            }
                            bl = true;
                            continue block2;
                        }
                        list2 = entry.duplicateOperationalAttribute(attributeType2);
                        arrayList = new ArrayList(list2.size());
                        for (Attribute attribute : list2) {
                            if (!attribute.hasOptions(hashSet)) continue;
                            arrayList.add(attribute);
                        }
                        if (arrayList.isEmpty()) continue;
                        if (this.typesOnly) {
                            list2 = new ArrayList<Attribute>(1);
                            list2.add(new Attribute(attributeType2));
                            entry2.putAttribute(attributeType2, list2);
                        } else {
                            entry2.putAttribute(attributeType2, arrayList);
                        }
                        bl = true;
                        continue block2;
                    }
                    continue;
                }
                List<Attribute> list3 = entry.getAttribute(attributeType, hashSet);
                if (list3 == null) continue;
                if (this.typesOnly) {
                    list3 = new ArrayList<Attribute>(1);
                    list3.add(new Attribute(attributeType));
                    entry2.putAttribute(attributeType, list3);
                    continue;
                }
                entry2.putAttribute(attributeType, list3);
            }
        }
        if (this.matchedValuesControl != null && !this.typesOnly) {
            Object object2;
            AttributeType attributeType = DirectoryServer.getObjectClassAttributeType();
            Iterator<String> iterator = entry2.getObjectClasses().values().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                AttributeValue attributeValue = new AttributeValue(attributeType, (ByteString)new ASN1OctetString(string));
                if (this.matchedValuesControl.valueMatches(attributeType, attributeValue)) continue;
                iterator.remove();
            }
            for (AttributeType attributeType2 : entry2.getUserAttributes().keySet()) {
                for (Attribute attribute : entry2.getUserAttribute(attributeType2)) {
                    Iterator iterator2 = attribute.getValues().iterator();
                    while (iterator2.hasNext()) {
                        object2 = (AttributeValue)iterator2.next();
                        if (this.matchedValuesControl.valueMatches(attributeType2, (AttributeValue)object2)) continue;
                        iterator2.remove();
                    }
                }
            }
            for (AttributeType attributeType3 : entry2.getOperationalAttributes().keySet()) {
                for (Attribute attribute : entry2.getOperationalAttribute(attributeType3)) {
                    Iterator iterator3 = attribute.getValues().iterator();
                    while (iterator3.hasNext()) {
                        object2 = (AttributeValue)iterator3.next();
                        if (this.matchedValuesControl.valueMatches(attributeType3, (AttributeValue)object2)) continue;
                        iterator3.remove();
                    }
                }
            }
        }
        SearchResultEntry searchResultEntry = new SearchResultEntry(entry2, list);
        searchResultEntry = AccessControlConfigManager.getInstance().getAccessControlHandler().filterEntry(this, searchResultEntry);
        SearchEntryPluginResult searchEntryPluginResult = DirectoryServer.getPluginConfigManager().invokeSearchResultEntryPlugins(this, searchResultEntry);
        if (searchEntryPluginResult.connectionTerminated()) {
            this.setResultCode(ResultCode.CANCELED);
            this.appendErrorMessage(MessageHandler.getMessage(262380, String.valueOf(entry.getDN())));
            return false;
        }
        if (searchEntryPluginResult.sendEntry()) {
            this.clientConnection.sendSearchEntry(this, searchResultEntry);
            Access.logSearchResultEntry(this, searchResultEntry);
            ++this.entriesSent;
        }
        return searchEntryPluginResult.continueSearch();
    }

    public boolean returnReference(SearchResultReference searchResultReference) {
        assert (Debug.debugEnter(CLASS_NAME, "returnReference", String.valueOf(searchResultReference)));
        if (this.cancelRequest != null) {
            this.setResultCode(ResultCode.CANCELED);
            return false;
        }
        if (this.timeLimit > 0 && TimeThread.getTime() >= this.timeLimitExpiration) {
            this.setResultCode(ResultCode.TIME_LIMIT_EXCEEDED);
            this.appendErrorMessage(MessageHandler.getMessage(196846, this.timeLimit));
            return false;
        }
        if (!this.clientAcceptsReferrals) {
            return true;
        }
        if (!AccessControlConfigManager.getInstance().getAccessControlHandler().maySend(this, searchResultReference)) {
            return true;
        }
        SearchReferencePluginResult searchReferencePluginResult = DirectoryServer.getPluginConfigManager().invokeSearchResultReferencePlugins(this, searchResultReference);
        if (searchReferencePluginResult.connectionTerminated()) {
            this.setResultCode(ResultCode.CANCELED);
            this.appendErrorMessage(MessageHandler.getMessage(262381, String.valueOf(searchResultReference.getReferralURLString())));
            return false;
        }
        if (searchReferencePluginResult.sendReference()) {
            if (this.clientConnection.sendSearchReference(this, searchResultReference)) {
                Access.logSearchResultReference(this, searchResultReference);
                ++this.referencesSent;
            } else {
                this.clientAcceptsReferrals = false;
            }
        }
        return searchReferencePluginResult.continueSearch();
    }

    public void sendSearchResultDone() {
        assert (Debug.debugEnter(CLASS_NAME, "sendSearchResultDone", new String[0]));
        if (this.responseSent.compareAndSet(false, true)) {
            this.clientConnection.sendResponse(this);
            Access.logSearchResultDone(this);
            DirectoryServer.getPluginConfigManager().invokePostResponseSearchPlugins(this);
        }
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.SEARCH;
    }

    @Override
    public String[][] getRequestLogElements() {
        String string;
        if (this.attributes == null || this.attributes.isEmpty()) {
            string = null;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.attributes.iterator();
            stringBuilder.append((String)iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(", ");
                stringBuilder.append((String)iterator.next());
            }
            string = stringBuilder.toString();
        }
        return new String[][]{{"baseDN", String.valueOf(this.rawBaseDN)}, {"scope", String.valueOf((Object)this.scope)}, {"sizeLimit", String.valueOf(this.sizeLimit)}, {"timeLimit", String.valueOf(this.timeLimit)}, {"filter", String.valueOf(this.rawFilter)}, {"attributes", string}};
    }

    @Override
    public String[][] getResponseLogElements() {
        CharSequence charSequence;
        String string;
        String string2 = String.valueOf(this.getResultCode().getIntValue());
        StringBuilder stringBuilder = this.getErrorMessage();
        String string3 = stringBuilder == null ? null : stringBuilder.toString();
        DN dN = this.getMatchedDN();
        String string4 = dN == null ? null : dN.toString();
        List<String> list = this.getReferralURLs();
        if (list == null || list.isEmpty()) {
            string = null;
        } else {
            charSequence = new StringBuilder();
            Iterator<String> iterator = list.iterator();
            ((StringBuilder)charSequence).append(iterator.next());
            while (iterator.hasNext()) {
                ((StringBuilder)charSequence).append(", ");
                ((StringBuilder)charSequence).append(iterator.next());
            }
            string = ((StringBuilder)charSequence).toString();
        }
        charSequence = String.valueOf(this.processingStopTime - this.processingStartTime);
        return new String[][]{{"resultCode", string2}, {"errorMessage", string3}, {"matchedDN", string4}, {"referralURLs", string}, {"entriesSent", String.valueOf(this.entriesSent)}, {"referencesSent", String.valueOf(this.referencesSent)}, {"processingTime", charSequence}};
    }

    @Override
    public List<Control> getResponseControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getResponseControls", new String[0]));
        return this.responseControls;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Object object;
        boolean bl;
        PluginConfigManager pluginConfigManager;
        boolean bl2;
        block93: {
            assert (Debug.debugEnter(CLASS_NAME, "run", new String[0]));
            this.setResultCode(ResultCode.UNDEFINED);
            bl2 = true;
            pluginConfigManager = DirectoryServer.getPluginConfigManager();
            bl = false;
            this.processingStartTime = System.currentTimeMillis();
            this.timeLimitExpiration = this.timeLimit <= 0 ? Long.MAX_VALUE : this.processingStartTime + (long)(1000 * this.timeLimit);
            if (this.cancelRequest != null) {
                this.setCancelResult(CancelResult.CANCELED);
                if (this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                    this.setResultCode(ResultCode.CANCELED);
                    String string = this.cancelRequest.getCancelReason();
                    if (string != null) {
                        this.appendErrorMessage(string);
                    }
                    this.clientConnection.sendResponse(this);
                }
                this.processingStopTime = System.currentTimeMillis();
                return;
            }
            object = pluginConfigManager.invokePreParseSearchPlugins(this);
            if (((PreParsePluginResult)object).connectionTerminated()) {
                this.setResultCode(ResultCode.CANCELED);
                int n = 262368;
                this.appendErrorMessage(MessageHandler.getMessage(n));
                this.processingStopTime = System.currentTimeMillis();
                Access.logSearchRequest(this);
                Access.logSearchResultDone(this);
                return;
            }
            if (((PreParsePluginResult)object).sendResponseImmediately()) {
                bl = true;
                Access.logSearchRequest(this);
            } else {
                block92: {
                    Access.logSearchRequest(this);
                    if (this.cancelRequest != null) {
                        this.setCancelResult(CancelResult.CANCELED);
                        if (this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                            this.setResultCode(ResultCode.CANCELED);
                            String string = this.cancelRequest.getCancelReason();
                            if (string != null) {
                                this.appendErrorMessage(string);
                            }
                            this.clientConnection.sendResponse(this);
                        }
                        this.processingStopTime = System.currentTimeMillis();
                        Access.logSearchResultDone(this);
                        return;
                    }
                    try {
                        if (this.baseDN != null) break block92;
                        this.baseDN = DN.decode(this.rawBaseDN);
                    }
                    catch (DirectoryException directoryException) {
                        assert (Debug.debugException(CLASS_NAME, "run", directoryException));
                        this.setResultCode(directoryException.getResultCode());
                        this.appendErrorMessage(directoryException.getErrorMessage());
                        this.setMatchedDN(directoryException.getMatchedDN());
                        this.setReferralURLs(directoryException.getReferralURLs());
                        break block93;
                    }
                }
                if (this.filter == null) {
                    this.filter = this.rawFilter.toSearchFilter();
                }
                if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this)) {
                    this.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                    int n = 262659;
                    this.appendErrorMessage(MessageHandler.getMessage(n, String.valueOf(this.baseDN)));
                    bl = true;
                } else {
                    Object object2;
                    Object object3;
                    Object object4;
                    boolean bl3 = true;
                    List<Control> list = this.getRequestControls();
                    if (list != null && !list.isEmpty()) {
                        for (int i = 0; i < list.size(); ++i) {
                            object4 = list.get(i);
                            String string = ((Control)object4).getOID();
                            if (string.equals("1.3.6.1.1.12")) {
                                if (object4 instanceof LDAPAssertionRequestControl) {
                                    object3 = (LDAPAssertionRequestControl)object4;
                                } else {
                                    try {
                                        object3 = LDAPAssertionRequestControl.decodeControl((Control)object4);
                                        list.set(i, (Control)object3);
                                    }
                                    catch (LDAPException lDAPException) {
                                        assert (Debug.debugException(CLASS_NAME, "run", lDAPException));
                                        this.setResultCode(ResultCode.valueOf(lDAPException.getResultCode()));
                                        this.appendErrorMessage(lDAPException.getMessage());
                                        break block93;
                                    }
                                }
                                object2 = ((LDAPAssertionRequestControl)object3).getSearchFilter();
                                try {
                                    Entry entry;
                                    try {
                                        entry = DirectoryServer.getEntry(this.baseDN);
                                    }
                                    catch (DirectoryException directoryException) {
                                        assert (Debug.debugException(CLASS_NAME, "run", directoryException));
                                        this.setResultCode(directoryException.getResultCode());
                                        int n = 196979;
                                        this.appendErrorMessage(MessageHandler.getMessage(n, directoryException.getErrorMessage()));
                                        break block93;
                                    }
                                    if (entry == null) {
                                        this.setResultCode(ResultCode.NO_SUCH_OBJECT);
                                        int n = 196980;
                                        this.appendErrorMessage(MessageHandler.getMessage(n));
                                        break block93;
                                    }
                                    if (((SearchFilter)object2).matchesEntry(entry)) continue;
                                    this.setResultCode(ResultCode.ASSERTION_FAILED);
                                    this.appendErrorMessage(MessageHandler.getMessage(196981));
                                }
                                catch (DirectoryException directoryException) {
                                    assert (Debug.debugException(CLASS_NAME, "run", directoryException));
                                    this.setResultCode(ResultCode.PROTOCOL_ERROR);
                                    int n = 196982;
                                    this.appendErrorMessage(MessageHandler.getMessage(n, directoryException.getErrorMessage()));
                                }
                                break block93;
                            }
                            if (string.equals("2.16.840.1.113730.3.4.12")) {
                                if (object4 instanceof ProxiedAuthV1Control) {
                                    object3 = (ProxiedAuthV1Control)object4;
                                } else {
                                    try {
                                        object3 = ProxiedAuthV1Control.decodeControl((Control)object4);
                                    }
                                    catch (LDAPException lDAPException) {
                                        assert (Debug.debugException(CLASS_NAME, "run", lDAPException));
                                        this.setResultCode(ResultCode.valueOf(lDAPException.getResultCode()));
                                        this.appendErrorMessage(lDAPException.getMessage());
                                        break block93;
                                    }
                                }
                                try {
                                    object2 = ((ProxiedAuthV1Control)object3).getValidatedAuthorizationDN();
                                }
                                catch (DirectoryException directoryException) {
                                    assert (Debug.debugException(CLASS_NAME, "run", directoryException));
                                    this.setResultCode(directoryException.getResultCode());
                                    this.appendErrorMessage(directoryException.getErrorMessage());
                                    break block93;
                                }
                                this.setAuthorizationDN((DN)object2);
                                continue;
                            }
                            if (string.equals("2.16.840.1.113730.3.4.18")) {
                                if (object4 instanceof ProxiedAuthV2Control) {
                                    object3 = (ProxiedAuthV2Control)object4;
                                } else {
                                    try {
                                        object3 = ProxiedAuthV2Control.decodeControl((Control)object4);
                                    }
                                    catch (LDAPException lDAPException) {
                                        assert (Debug.debugException(CLASS_NAME, "run", lDAPException));
                                        this.setResultCode(ResultCode.valueOf(lDAPException.getResultCode()));
                                        this.appendErrorMessage(lDAPException.getMessage());
                                        break block93;
                                    }
                                }
                                try {
                                    object2 = ((ProxiedAuthV2Control)object3).getValidatedAuthorizationDN();
                                }
                                catch (DirectoryException directoryException) {
                                    assert (Debug.debugException(CLASS_NAME, "run", directoryException));
                                    this.setResultCode(directoryException.getResultCode());
                                    this.appendErrorMessage(directoryException.getErrorMessage());
                                    break block93;
                                }
                                this.setAuthorizationDN((DN)object2);
                                continue;
                            }
                            if (string.equals("2.16.840.1.113730.3.4.3")) {
                                if (object4 instanceof PersistentSearchControl) {
                                    object3 = (PersistentSearchControl)object4;
                                } else {
                                    try {
                                        object3 = PersistentSearchControl.decodeControl((Control)object4);
                                    }
                                    catch (LDAPException lDAPException) {
                                        assert (Debug.debugException(CLASS_NAME, "run", lDAPException));
                                        this.setResultCode(ResultCode.valueOf(lDAPException.getResultCode()));
                                        this.appendErrorMessage(lDAPException.getMessage());
                                        break block93;
                                    }
                                }
                                this.persistentSearch = new PersistentSearch(this, ((PersistentSearchControl)object3).getChangeTypes(), ((PersistentSearchControl)object3).getReturnECs());
                                if (!((PersistentSearchControl)object3).getChangesOnly()) continue;
                                bl3 = false;
                                continue;
                            }
                            if (string.equals("1.3.6.1.4.1.7628.5.101.1")) {
                                this.returnLDAPSubentries = true;
                                continue;
                            }
                            if (string.equals("1.2.826.0.1.3344810.2.3")) {
                                if (object4 instanceof MatchedValuesControl) {
                                    this.matchedValuesControl = (MatchedValuesControl)object4;
                                    continue;
                                }
                                try {
                                    this.matchedValuesControl = MatchedValuesControl.decodeControl((Control)object4);
                                    continue;
                                }
                                catch (LDAPException lDAPException) {
                                    assert (Debug.debugException(CLASS_NAME, "run", lDAPException));
                                    this.setResultCode(ResultCode.valueOf(lDAPException.getResultCode()));
                                    this.appendErrorMessage(lDAPException.getMessage());
                                    break block93;
                                }
                            } else {
                                if (string.equals("1.3.6.1.4.1.42.2.27.9.5.8")) {
                                    this.includeUsableControl = true;
                                    continue;
                                }
                                if (!((Control)object4).isCritical() || (object3 = DirectoryServer.getBackend(this.baseDN)) != null && ((Backend)object3).supportsControl(string)) continue;
                                this.setResultCode(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION);
                                int n = 196983;
                                this.appendErrorMessage(MessageHandler.getMessage(n, string));
                            }
                            break block93;
                        }
                    }
                    if (this.cancelRequest != null) {
                        this.setCancelResult(CancelResult.CANCELED);
                        if (this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                            this.setResultCode(ResultCode.CANCELED);
                            String string = this.cancelRequest.getCancelReason();
                            if (string != null) {
                                this.appendErrorMessage(string);
                            }
                            this.clientConnection.sendResponse(this);
                        }
                        this.processingStopTime = System.currentTimeMillis();
                        Access.logSearchResultDone(this);
                        return;
                    }
                    PreOperationPluginResult preOperationPluginResult = pluginConfigManager.invokePreOperationSearchPlugins(this);
                    if (preOperationPluginResult.connectionTerminated()) {
                        this.setResultCode(ResultCode.CANCELED);
                        int n = 262369;
                        this.appendErrorMessage(MessageHandler.getMessage(n));
                        this.processingStopTime = System.currentTimeMillis();
                        Access.logSearchResultDone(this);
                        return;
                    }
                    if (preOperationPluginResult.sendResponseImmediately()) {
                        bl = true;
                    } else {
                        if (this.cancelRequest != null) {
                            this.setCancelResult(CancelResult.CANCELED);
                            if (this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                                this.setResultCode(ResultCode.CANCELED);
                                object4 = this.cancelRequest.getCancelReason();
                                if (object4 != null) {
                                    this.appendErrorMessage((String)object4);
                                }
                                this.clientConnection.sendResponse(this);
                            }
                            this.processingStopTime = System.currentTimeMillis();
                            Access.logSearchResultDone(this);
                            return;
                        }
                        object4 = DirectoryServer.getBackend(this.baseDN);
                        if (object4 == null) {
                            this.setResultCode(ResultCode.NO_SUCH_OBJECT);
                            this.appendErrorMessage(MessageHandler.getMessage(196848, String.valueOf(this.baseDN)));
                        } else {
                            this.setResultCode(ResultCode.SUCCESS);
                            if (this.persistentSearch != null) {
                                DirectoryServer.registerPersistentSearch(this.persistentSearch);
                                bl2 = false;
                            }
                            try {
                                if (bl3) {
                                    this.searchBackend((Backend)object4);
                                }
                            }
                            catch (DirectoryException directoryException) {
                                assert (Debug.debugException(CLASS_NAME, "run", directoryException));
                                this.setResultCode(directoryException.getResultCode());
                                this.appendErrorMessage(directoryException.getErrorMessage());
                                this.setMatchedDN(directoryException.getMatchedDN());
                                this.setReferralURLs(directoryException.getReferralURLs());
                                if (this.persistentSearch != null) {
                                    DirectoryServer.deregisterPersistentSearch(this.persistentSearch);
                                    bl2 = true;
                                }
                            }
                            catch (CancelledOperationException cancelledOperationException) {
                                assert (Debug.debugException(CLASS_NAME, "run", cancelledOperationException));
                                object3 = cancelledOperationException.getCancelResult();
                                this.setCancelResult((CancelResult)((Object)object3));
                                this.setResultCode(((CancelResult)((Object)object3)).getResultCode());
                                object2 = cancelledOperationException.getMessage();
                                if (object2 != null && ((String)object2).length() > 0) {
                                    this.appendErrorMessage((String)object2);
                                }
                                if (this.persistentSearch != null) {
                                    DirectoryServer.deregisterPersistentSearch(this.persistentSearch);
                                    bl2 = true;
                                }
                                bl = true;
                            }
                            catch (Exception exception) {
                                assert (Debug.debugException(CLASS_NAME, "run", exception));
                                this.setResultCode(DirectoryServer.getServerErrorResultCode());
                                int n = 196878;
                                this.appendErrorMessage(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
                                if (this.persistentSearch != null) {
                                    DirectoryServer.deregisterPersistentSearch(this.persistentSearch);
                                    bl2 = true;
                                }
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
        if (this.cancelRequest != null) {
            this.setCancelResult(CancelResult.CANCELED);
            if (this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                this.setResultCode(ResultCode.CANCELED);
                object = this.cancelRequest.getCancelReason();
                if (object != null) {
                    this.appendErrorMessage((String)object);
                }
                this.clientConnection.sendResponse(this);
            }
            this.processingStopTime = System.currentTimeMillis();
            Access.logSearchResultDone(this);
            return;
        }
        if (!bl && ((PostOperationPluginResult)(object = pluginConfigManager.invokePostOperationSearchPlugins(this))).connectionTerminated()) {
            this.setResultCode(ResultCode.CANCELED);
            int n = 262370;
            this.appendErrorMessage(MessageHandler.getMessage(n));
            this.processingStopTime = System.currentTimeMillis();
            Access.logSearchResultDone(this);
            return;
        }
        this.setCancelResult(CancelResult.TOO_LATE);
        this.processingStopTime = System.currentTimeMillis();
        if (bl2) {
            this.sendSearchResultDone();
        }
    }

    private void searchBackend(Backend backend) throws DirectoryException, CancelledOperationException {
        Backend[] backendArray;
        assert (Debug.debugEnter(CLASS_NAME, "searchBackend", String.valueOf(backend)));
        if (this.cancelRequest != null) {
            this.setCancelResult(CancelResult.CANCELED);
            this.processingStopTime = System.currentTimeMillis();
            return;
        }
        backend.search(this);
        block0: for (Backend backend2 : backendArray = backend.getSubordinateBackends()) {
            DN[] dNArray;
            for (DN dN : dNArray = backend2.getBaseDNs()) {
                if (!dN.isDescendantOf(this.baseDN)) continue;
                this.searchBackend(backend2);
                continue block0;
            }
        }
    }

    @Override
    public CancelResult cancel(CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "cancel", String.valueOf(cancelRequest)));
        this.cancelRequest = cancelRequest;
        if (this.persistentSearch != null) {
            DirectoryServer.deregisterPersistentSearch(this.persistentSearch);
            this.persistentSearch = null;
        }
        CancelResult cancelResult = this.getCancelResult();
        long l = System.currentTimeMillis() + 5000L;
        while (cancelResult == null && System.currentTimeMillis() < l) {
            block6: {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "cancel", exception)) break block6;
                    throw new AssertionError();
                }
            }
            cancelResult = this.getCancelResult();
        }
        if (cancelResult == null) {
            cancelResult = CancelResult.CANNOT_CANCEL;
        }
        return cancelResult;
    }

    @Override
    public CancelRequest getCancelRequest() {
        assert (Debug.debugEnter(CLASS_NAME, "getCancelRequest", new String[0]));
        return this.cancelRequest;
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("SearchOperation(connID=");
        stringBuilder.append(this.clientConnection.getConnectionID());
        stringBuilder.append(", opID=");
        stringBuilder.append(this.operationID);
        stringBuilder.append(", baseDN=");
        stringBuilder.append(this.rawBaseDN);
        stringBuilder.append(", scope=");
        stringBuilder.append(this.scope.toString());
        stringBuilder.append(", filter=");
        stringBuilder.append(this.rawFilter.toString());
        stringBuilder.append(")");
    }
}

