/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.api.ConfigHandler;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class RootDNConfigManager
implements ConfigChangeListener,
ConfigAddListener,
ConfigDeleteListener {
    private static final String CLASS_NAME = "org.opends.server.core.RootDNConfigManager";
    private ConcurrentHashMap<DN, List<DN>> bindMappings;

    public RootDNConfigManager() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.bindMappings = new ConcurrentHashMap();
    }

    public void initializeRootDNs() throws ConfigException, InitializationException {
        ConfigEntry configEntry;
        assert (Debug.debugEnter(CLASS_NAME, "initializeRootDNs", new String[0]));
        ConfigHandler configHandler = DirectoryServer.getConfigHandler();
        try {
            DN dN = DN.decode("cn=Root DNs,cn=config");
            configEntry = configHandler.getConfigEntry(dN);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeRootDNs", exception));
            int n = 3473943;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new ConfigException(n, string, exception);
        }
        if (configEntry == null) {
            int n = 3408408;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        configEntry.registerAddListener(this);
        configEntry.registerDeleteListener(this);
        if (!configEntry.hasChildren()) {
            return;
        }
        for (ConfigEntry configEntry2 : configEntry.getChildren().values()) {
            StringBuilder stringBuilder;
            if (!this.configAddIsAcceptable(configEntry2, stringBuilder = new StringBuilder())) {
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408409, String.valueOf(configEntry2.getDN()), stringBuilder.toString());
                continue;
            }
            try {
                ConfigChangeResult configChangeResult = this.applyConfigurationAdd(configEntry2);
                if (configChangeResult.getResultCode() == ResultCode.SUCCESS) continue;
                StringBuilder stringBuilder2 = new StringBuilder();
                List<String> list = configChangeResult.getMessages();
                if (list == null || list.isEmpty()) {
                    stringBuilder2.append(MessageHandler.getMessage(0x300030));
                } else {
                    Iterator<String> iterator = list.iterator();
                    stringBuilder2.append(iterator.next());
                    while (iterator.hasNext()) {
                        stringBuilder2.append(ServerConstants.EOL);
                        stringBuilder2.append(iterator.next());
                    }
                }
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408410, String.valueOf(configEntry2.getDN()), stringBuilder2.toString());
            }
            catch (Exception exception) {
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408367, configEntry2.getDN().toString(), String.valueOf(exception));
            }
        }
    }

    public boolean configChangeIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configChangeIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        if (!configEntry.hasObjectClass("ds-cfg-root-dn")) {
            int n = 3408411;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
            stringBuilder.append(string);
            return false;
        }
        int n = 3146268;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-alternate-bind-dn", MessageHandler.getMessage(n), false, true, false);
        try {
            DNConfigAttribute dNConfigAttribute2 = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (dNConfigAttribute2 != null) {
                for (DN dN : dNConfigAttribute2.pendingValues()) {
                    DN dN2 = DirectoryServer.getActualRootBindDN(dN);
                    if (dN2 == null || dN2.equals(configEntry.getDN())) continue;
                    n = 3408413;
                    String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(configEntry.getDN()), String.valueOf(dN2));
                    stringBuilder.append(string);
                    return false;
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            n = 3408414;
            String string = MessageHandler.getMessage(n, String.valueOf(configEntry.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
            stringBuilder.append(string);
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationChange(ConfigEntry configEntry) {
        List<DN> list;
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationChange", String.valueOf(configEntry)));
        DN dN = configEntry.getDN();
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        List<DN> list2 = null;
        int n = 3146268;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-alternate-bind-dn", MessageHandler.getMessage(n), false, true, false);
        try {
            list = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (list != null) {
                list2 = ((DNConfigAttribute)((Object)list)).activeValues();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
            n = 3408414;
            arrayList.add(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
        }
        if (resultCode == ResultCode.SUCCESS) {
            list = this.bindMappings.get(dN);
            if (list != null) {
                for (DN dN2 : list) {
                    if (list2 != null && list2.contains(dN2)) continue;
                    DirectoryServer.deregisterAlternateRootBindDN(dN2);
                }
            }
            if (list2 == null) {
                list2 = new ArrayList<DN>(0);
            } else {
                for (DN dN2 : list2) {
                    try {
                        DirectoryServer.registerAlternateRootDN(dN, dN2);
                    }
                    catch (DirectoryException directoryException) {
                        assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", directoryException));
                        n = 3408415;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN2), String.valueOf(dN), directoryException.getErrorMessage()));
                        if (resultCode != ResultCode.SUCCESS) continue;
                        resultCode = ResultCode.CONSTRAINT_VIOLATION;
                    }
                }
            }
            this.bindMappings.put(dN, list2);
        }
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }

    public boolean configAddIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configAddIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        DN dN = configEntry.getDN();
        if (this.bindMappings.containsKey(dN) || DirectoryServer.getActualRootBindDN(dN) != null) {
            int n = 3408416;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            stringBuilder.append(string);
            return false;
        }
        if (!configEntry.hasObjectClass("ds-cfg-root-dn")) {
            int n = 3408411;
            String string = MessageHandler.getMessage(n, dN.toString());
            stringBuilder.append(string);
            return false;
        }
        int n = 3146268;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-alternate-bind-dn", MessageHandler.getMessage(n), false, true, false);
        try {
            DNConfigAttribute dNConfigAttribute2 = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (dNConfigAttribute2 != null) {
                for (DN dN2 : dNConfigAttribute2.pendingValues()) {
                    DN dN3 = DirectoryServer.getActualRootBindDN(dN2);
                    if (dN3 == null || dN3.equals(dN)) continue;
                    n = 3408413;
                    String string = MessageHandler.getMessage(n, String.valueOf(dN2), String.valueOf(dN), String.valueOf(dN3));
                    stringBuilder.append(string);
                    return false;
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            n = 3408414;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            stringBuilder.append(string);
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationAdd(ConfigEntry configEntry) {
        List<DN> list;
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationAdd", String.valueOf(configEntry)));
        DN dN = configEntry.getDN();
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        List<DN> list2 = null;
        int n = 3146268;
        DNConfigAttribute dNConfigAttribute = new DNConfigAttribute("ds-cfg-alternate-bind-dn", MessageHandler.getMessage(n), false, true, false);
        try {
            list = (DNConfigAttribute)configEntry.getConfigAttribute(dNConfigAttribute);
            if (list != null) {
                list2 = ((DNConfigAttribute)((Object)list)).activeValues();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            n = 3408414;
            arrayList.add(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
        }
        if (resultCode == ResultCode.SUCCESS) {
            list = this.bindMappings.get(dN);
            if (list != null) {
                for (DN dN2 : list) {
                    if (list2 != null && list2.contains(dN2)) continue;
                    DirectoryServer.deregisterAlternateRootBindDN(dN2);
                }
            }
            if (list2 == null) {
                list2 = new ArrayList<DN>(0);
            } else {
                for (DN dN2 : list2) {
                    try {
                        DirectoryServer.registerAlternateRootDN(dN, dN2);
                    }
                    catch (DirectoryException directoryException) {
                        assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", directoryException));
                        n = 3408415;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN2), String.valueOf(dN)));
                        if (resultCode != ResultCode.SUCCESS) continue;
                        resultCode = ResultCode.CONSTRAINT_VIOLATION;
                    }
                }
            }
            this.bindMappings.put(dN, list2);
            DirectoryServer.registerRootDN(dN);
            configEntry.registerChangeListener(this);
        }
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }

    public boolean configDeleteIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configDeleteIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        return true;
    }

    public ConfigChangeResult applyConfigurationDelete(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationDelete", String.valueOf(configEntry)));
        DN dN = configEntry.getDN();
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        List<DN> list = this.bindMappings.remove(dN);
        if (list != null) {
            for (DN dN2 : list) {
                DirectoryServer.deregisterAlternateRootBindDN(dN2);
            }
        }
        return new ConfigChangeResult(resultCode, bl);
    }
}

