/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Set;
import org.opends.server.controls.EntryChangeNotificationControl;
import org.opends.server.controls.PersistentSearchChangeType;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentSearch {
    private static final String CLASS_NAME = "org.opends.server.core.PersistentSearch";
    private boolean returnECs;
    private DN baseDN;
    private Set<PersistentSearchChangeType> changeTypes;
    private SearchScope scope;
    private SearchFilter filter;
    private SearchOperation searchOperation;

    public PersistentSearch(SearchOperation searchOperation, Set<PersistentSearchChangeType> set, boolean bl) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(searchOperation), String.valueOf(set), String.valueOf(bl)));
        this.searchOperation = searchOperation;
        this.changeTypes = set;
        this.returnECs = bl;
        this.baseDN = searchOperation.getBaseDN();
        this.scope = searchOperation.getScope();
        this.filter = searchOperation.getFilter();
    }

    public SearchOperation getSearchOperation() {
        assert (Debug.debugEnter(CLASS_NAME, "getSearchOperation", new String[0]));
        return this.searchOperation;
    }

    public Set<PersistentSearchChangeType> getChangeTypes() {
        assert (Debug.debugEnter(CLASS_NAME, "getChangeTypes", new String[0]));
        return this.changeTypes;
    }

    public boolean getReturnECs() {
        assert (Debug.debugEnter(CLASS_NAME, "getReturnECs", new String[0]));
        return this.returnECs;
    }

    public DN getBaseDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getBaseDN", new String[0]));
        return this.baseDN;
    }

    public SearchScope getScope() {
        assert (Debug.debugEnter(CLASS_NAME, "getScope", new String[0]));
        return this.scope;
    }

    public SearchFilter getFilter() {
        assert (Debug.debugEnter(CLASS_NAME, "getFilter", new String[0]));
        return this.filter;
    }

    public void processAdd(AddOperation addOperation, Entry entry) {
        block19: {
            assert (Debug.debugEnter(CLASS_NAME, "processAdd", String.valueOf(addOperation), String.valueOf(entry)));
            if (!this.changeTypes.contains((Object)PersistentSearchChangeType.ADD)) {
                return;
            }
            switch (this.scope) {
                case BASE_OBJECT: {
                    if (this.baseDN.equals(entry.getDN())) break;
                    return;
                }
                case SINGLE_LEVEL: {
                    if (this.baseDN.equals(entry.getDN().getParent())) break;
                    return;
                }
                case WHOLE_SUBTREE: {
                    if (this.baseDN.isAncestorOf(entry.getDN())) break;
                    return;
                }
                case SUBORDINATE_SUBTREE: {
                    if (!this.baseDN.equals(entry.getDN()) && this.baseDN.isAncestorOf(entry.getDN())) break;
                    return;
                }
                default: {
                    return;
                }
            }
            try {
                if (!this.filter.matchesEntry(entry)) {
                    return;
                }
            }
            catch (DirectoryException directoryException) {
                assert (Debug.debugException(CLASS_NAME, "processAdd", directoryException));
                return;
            }
            ArrayList<Control> arrayList = new ArrayList<Control>(1);
            if (this.returnECs) {
                arrayList.add(new EntryChangeNotificationControl(PersistentSearchChangeType.ADD, addOperation.getChangeNumber()));
            }
            try {
                if (!this.searchOperation.returnEntry(entry, arrayList)) {
                    DirectoryServer.deregisterPersistentSearch(this);
                    this.searchOperation.sendSearchResultDone();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "processAdd", exception));
                DirectoryServer.deregisterPersistentSearch(this);
                try {
                    this.searchOperation.sendSearchResultDone();
                }
                catch (Exception exception2) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "processAdd", exception2)) break block19;
                    throw new AssertionError();
                }
            }
        }
    }

    public void processDelete(DeleteOperation deleteOperation, Entry entry) {
        block19: {
            assert (Debug.debugEnter(CLASS_NAME, "processDelete", String.valueOf(deleteOperation), String.valueOf(entry)));
            if (!this.changeTypes.contains((Object)PersistentSearchChangeType.DELETE)) {
                return;
            }
            switch (this.scope) {
                case BASE_OBJECT: {
                    if (this.baseDN.equals(entry.getDN())) break;
                    return;
                }
                case SINGLE_LEVEL: {
                    if (this.baseDN.equals(entry.getDN().getParent())) break;
                    return;
                }
                case WHOLE_SUBTREE: {
                    if (this.baseDN.isAncestorOf(entry.getDN())) break;
                    return;
                }
                case SUBORDINATE_SUBTREE: {
                    if (!this.baseDN.equals(entry.getDN()) && this.baseDN.isAncestorOf(entry.getDN())) break;
                    return;
                }
                default: {
                    return;
                }
            }
            try {
                if (!this.filter.matchesEntry(entry)) {
                    return;
                }
            }
            catch (DirectoryException directoryException) {
                assert (Debug.debugException(CLASS_NAME, "processDelete", directoryException));
                return;
            }
            ArrayList<Control> arrayList = new ArrayList<Control>(1);
            if (this.returnECs) {
                arrayList.add(new EntryChangeNotificationControl(PersistentSearchChangeType.DELETE, deleteOperation.getChangeNumber()));
            }
            try {
                if (!this.searchOperation.returnEntry(entry, arrayList)) {
                    DirectoryServer.deregisterPersistentSearch(this);
                    this.searchOperation.sendSearchResultDone();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "processDelete", exception));
                DirectoryServer.deregisterPersistentSearch(this);
                try {
                    this.searchOperation.sendSearchResultDone();
                }
                catch (Exception exception2) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "processDelete", exception2)) break block19;
                    throw new AssertionError();
                }
            }
        }
    }

    public void processModify(ModifyOperation modifyOperation, Entry entry, Entry entry2) {
        block19: {
            assert (Debug.debugEnter(CLASS_NAME, "processModify", String.valueOf(modifyOperation), String.valueOf(entry), String.valueOf(entry2)));
            if (!this.changeTypes.contains((Object)PersistentSearchChangeType.MODIFY)) {
                return;
            }
            switch (this.scope) {
                case BASE_OBJECT: {
                    if (this.baseDN.equals(entry.getDN())) break;
                    return;
                }
                case SINGLE_LEVEL: {
                    if (this.baseDN.equals(entry.getDN().getParent())) break;
                    return;
                }
                case WHOLE_SUBTREE: {
                    if (this.baseDN.isAncestorOf(entry.getDN())) break;
                    return;
                }
                case SUBORDINATE_SUBTREE: {
                    if (!this.baseDN.equals(entry.getDN()) && this.baseDN.isAncestorOf(entry.getDN())) break;
                    return;
                }
                default: {
                    return;
                }
            }
            try {
                if (!this.filter.matchesEntry(entry) && !this.filter.matchesEntry(entry2)) {
                    return;
                }
            }
            catch (DirectoryException directoryException) {
                assert (Debug.debugException(CLASS_NAME, "processModify", directoryException));
                return;
            }
            ArrayList<Control> arrayList = new ArrayList<Control>(1);
            if (this.returnECs) {
                arrayList.add(new EntryChangeNotificationControl(PersistentSearchChangeType.MODIFY, modifyOperation.getChangeNumber()));
            }
            try {
                if (!this.searchOperation.returnEntry(entry2, arrayList)) {
                    DirectoryServer.deregisterPersistentSearch(this);
                    this.searchOperation.sendSearchResultDone();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "processModify", exception));
                DirectoryServer.deregisterPersistentSearch(this);
                try {
                    this.searchOperation.sendSearchResultDone();
                }
                catch (Exception exception2) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "processModify", exception2)) break block19;
                    throw new AssertionError();
                }
            }
        }
    }

    public void processModifyDN(ModifyDNOperation modifyDNOperation, Entry entry, Entry entry2) {
        block19: {
            assert (Debug.debugEnter(CLASS_NAME, "processModifyDN", String.valueOf(modifyDNOperation), String.valueOf(entry), String.valueOf(entry2)));
            if (!this.changeTypes.contains((Object)PersistentSearchChangeType.MODIFY_DN)) {
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            switch (this.scope) {
                case BASE_OBJECT: {
                    bl = this.baseDN.equals(entry.getDN());
                    bl2 = this.baseDN.equals(entry2.getDN());
                    if (bl || bl2) break;
                    return;
                }
                case SINGLE_LEVEL: {
                    bl = this.baseDN.equals(entry.getDN().getParent());
                    bl2 = this.baseDN.equals(entry2.getDN().getParent());
                    if (bl || bl2) break;
                    return;
                }
                case WHOLE_SUBTREE: {
                    bl = this.baseDN.isAncestorOf(entry.getDN());
                    bl2 = this.baseDN.isAncestorOf(entry2.getDN());
                    if (bl || bl2) break;
                    return;
                }
                case SUBORDINATE_SUBTREE: {
                    bl = !this.baseDN.equals(entry.getDN()) && this.baseDN.isAncestorOf(entry.getDN());
                    boolean bl3 = bl2 = !this.baseDN.equals(entry2.getDN()) && this.baseDN.isAncestorOf(entry2.getDN());
                    if (bl || bl2) break;
                    return;
                }
                default: {
                    return;
                }
            }
            try {
                if (!(bl && this.filter.matchesEntry(entry) || bl2 || this.filter.matchesEntry(entry2))) {
                    return;
                }
            }
            catch (DirectoryException directoryException) {
                assert (Debug.debugException(CLASS_NAME, "processModifyDN", directoryException));
                return;
            }
            ArrayList<Control> arrayList = new ArrayList<Control>(1);
            if (this.returnECs) {
                arrayList.add(new EntryChangeNotificationControl(PersistentSearchChangeType.MODIFY_DN, entry.getDN(), modifyDNOperation.getChangeNumber()));
            }
            try {
                if (!this.searchOperation.returnEntry(entry2, arrayList)) {
                    DirectoryServer.deregisterPersistentSearch(this);
                    this.searchOperation.sendSearchResultDone();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "processModifyDN", exception));
                DirectoryServer.deregisterPersistentSearch(this);
                try {
                    this.searchOperation.sendSearchResultDone();
                }
                catch (Exception exception2) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "processModifyDN", exception2)) break block19;
                    throw new AssertionError();
                }
            }
        }
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("PersistentSearch(connID=");
        stringBuilder.append(this.searchOperation.getConnectionID());
        stringBuilder.append(",opID=");
        stringBuilder.append(this.searchOperation.getOperationID());
        stringBuilder.append(",baseDN=\"");
        this.searchOperation.getBaseDN().toString(stringBuilder);
        stringBuilder.append("\",scope=");
        stringBuilder.append(this.scope.toString());
        stringBuilder.append(",filter=\"");
        this.filter.toString(stringBuilder);
        stringBuilder.append("\")");
    }
}

