/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.server.api.AccountStatusNotificationHandler;
import org.opends.server.api.PasswordGenerator;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.api.PasswordValidator;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.Operation;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.AccountStatusNotification;
import org.opends.server.types.AccountStatusNotificationType;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordPolicyState {
    private static final String CLASS_NAME = "org.opends.server.core.PasswordPolicyState";
    private boolean debug;
    private boolean updateEntry;
    private boolean sendExpirationWarning;
    private boolean useGraceLogin;
    private ConditionResult isAccountExpired;
    private ConditionResult isDisabled;
    private ConditionResult isPasswordExpired;
    private ConditionResult isFirstWarning;
    private ConditionResult isIdleLocked;
    private ConditionResult isResetLocked;
    private ConditionResult mayUseGraceLogin;
    private ConditionResult mustChangePassword;
    private ConditionResult shouldWarn;
    private Entry userEntry;
    private int secondsUntilUnlock;
    private int secondsUntilExpiration;
    private LinkedList<Modification> modifications;
    private List<Long> authFailureTimes;
    private List<Long> graceLoginTimes;
    private long createTime;
    private long currentTime;
    private long expirationTime;
    private long failureLockedTime;
    private long idleLockedTime;
    private long lastLoginTime;
    private long passwordChangedTime;
    private long requiredChangeTime;
    private long warnedTime;
    private PasswordPolicy passwordPolicy;
    private String currentGeneralizedTime;
    private String userDNString;

    public PasswordPolicyState(Entry entry, boolean bl, boolean bl2) throws DirectoryException {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(entry), String.valueOf(this.passwordPolicy)));
        this.userEntry = entry;
        this.updateEntry = bl;
        this.debug = bl2;
        this.userDNString = entry.getDN().toString();
        this.passwordPolicy = this.getPasswordPolicyInternal();
        this.currentGeneralizedTime = TimeThread.getGeneralizedTime();
        this.currentTime = TimeThread.getTime();
        this.modifications = new LinkedList();
        this.isDisabled = ConditionResult.UNDEFINED;
        this.isAccountExpired = ConditionResult.UNDEFINED;
        this.isPasswordExpired = ConditionResult.UNDEFINED;
        this.isFirstWarning = ConditionResult.UNDEFINED;
        this.isIdleLocked = ConditionResult.UNDEFINED;
        this.isResetLocked = ConditionResult.UNDEFINED;
        this.mayUseGraceLogin = ConditionResult.UNDEFINED;
        this.mustChangePassword = ConditionResult.UNDEFINED;
        this.shouldWarn = ConditionResult.UNDEFINED;
        this.expirationTime = Long.MIN_VALUE;
        this.failureLockedTime = Long.MIN_VALUE;
        this.idleLockedTime = Long.MIN_VALUE;
        this.lastLoginTime = Long.MIN_VALUE;
        this.requiredChangeTime = Long.MIN_VALUE;
        this.warnedTime = Long.MIN_VALUE;
        this.authFailureTimes = null;
        this.sendExpirationWarning = false;
        this.useGraceLogin = false;
        this.secondsUntilExpiration = Integer.MIN_VALUE;
        this.secondsUntilUnlock = Integer.MIN_VALUE;
        AttributeType attributeType = DirectoryServer.getAttributeType("createtimestamp");
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType("createTimestamp");
        }
        this.createTime = this.getGeneralizedTime(attributeType);
        attributeType = DirectoryServer.getAttributeType("pwdchangedtime");
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType("pwdChangedTime");
        }
        this.passwordChangedTime = this.getGeneralizedTime(attributeType);
        if (this.passwordChangedTime <= 0L) {
            this.passwordChangedTime = this.createTime;
            if (this.passwordChangedTime <= 0L) {
                this.passwordChangedTime = 0L;
                if (bl2) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "<init>", "Could not determine password changed time for user " + this.userDNString);
                }
            }
        }
    }

    private PasswordPolicy getPasswordPolicyInternal() throws DirectoryException {
        List<Attribute> list;
        assert (Debug.debugEnter(CLASS_NAME, "getPasswordPolicy", new String[0]));
        AttributeType attributeType = DirectoryServer.getAttributeType("pwdpolicysubentry");
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType("pwdPolicySubentry");
        }
        if ((list = this.userEntry.getAttribute(attributeType)) == null || list.isEmpty()) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getPasswordPolicy", "Using the default password policy for user " + this.userDNString);
            }
            return DirectoryServer.getDefaultPasswordPolicy();
        }
        for (Attribute attribute : list) {
            DN dN;
            Iterator iterator = attribute.getValues().iterator();
            if (!iterator.hasNext()) continue;
            AttributeValue attributeValue = (AttributeValue)iterator.next();
            try {
                dN = DN.decode(attributeValue.getValue());
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "getPasswordPolicy", exception));
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.ERROR, CLASS_NAME, "getPasswordPolicy", "Could not parse password policy subentry DN \"" + attributeValue.getStringValue() + "\" for user \"" + this.userDNString + "\":  " + StaticUtils.stackTraceToSingleLineString(exception));
                }
                int n = 197112;
                String string = MessageHandler.getMessage(n, attributeValue.getStringValue(), this.userDNString, exception.getMessage());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, string, n, exception);
            }
            PasswordPolicy passwordPolicy = DirectoryServer.getPasswordPolicy(dN);
            if (passwordPolicy == null) {
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.ERROR, CLASS_NAME, "getPasswordPolicy", "Password policy subentry \"" + String.valueOf(dN) + "\" for user \"" + this.userDNString + "\" is not defined in the Directory " + "Server.");
                }
                int n = 197113;
                String string = MessageHandler.getMessage(n, this.userDNString, String.valueOf(dN));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n);
            }
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getPasswordPolicy", "Using password policy subentry \"" + String.valueOf(dN) + "\" for user \"" + this.userDNString + "\".");
            }
            return passwordPolicy;
        }
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getPasswordPolicy", "Falling back to the default password policy for user " + this.userDNString);
        }
        return DirectoryServer.getDefaultPasswordPolicy();
    }

    private String getValue(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "getValue", String.valueOf(attributeType)));
        List<Attribute> list = this.userEntry.getAttribute(attributeType);
        if (list == null || list.isEmpty()) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getValue", "Returning null because attribute " + attributeType.getNameOrOID() + " does not exist in user " + "entry " + this.userDNString);
            }
            return null;
        }
        for (Attribute attribute : list) {
            Iterator iterator = attribute.getValues().iterator();
            if (!iterator.hasNext()) continue;
            AttributeValue attributeValue = (AttributeValue)iterator.next();
            String string = attributeValue.getStringValue();
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getValue", "Returning value \"" + string + "\" for user " + this.userDNString);
            }
            return string;
        }
        return null;
    }

    private long getGeneralizedTime(AttributeType attributeType) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getGeneralizedTime", String.valueOf(attributeType)));
        List<Attribute> list = this.userEntry.getAttribute(attributeType);
        if (list == null || list.isEmpty()) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getGeneralizedTime", "Returning -1 because attribute " + attributeType.getNameOrOID() + " does not exist in user " + "entry " + this.userDNString);
            }
            return -1L;
        }
        for (Attribute attribute : list) {
            Iterator iterator = attribute.getValues().iterator();
            if (!iterator.hasNext()) continue;
            AttributeValue attributeValue = (AttributeValue)iterator.next();
            try {
                return GeneralizedTimeSyntax.decodeGeneralizedTimeValue(attributeValue.getNormalizedValue());
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "getGeneralizedTime", exception));
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "getGeneralizedTime", "Unable to decode value " + attributeValue.getStringValue() + " for attribute " + attributeType.getNameOrOID() + " in user entry " + this.userDNString + ":  " + exception);
                }
                int n = 197114;
                String string = MessageHandler.getMessage(n, attributeValue.getStringValue(), attributeType.getNameOrOID(), this.userDNString, String.valueOf(exception));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string, n, exception);
            }
        }
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getGeneralizedTime", "Returning -1 for attribute " + attributeType.getNameOrOID() + " in user entry " + this.userDNString + " because all options have been exhausted.");
        }
        return -1L;
    }

    private List<Long> getGeneralizedTimes(AttributeType attributeType) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getGeneralizedTimes", String.valueOf(attributeType)));
        ArrayList<Long> arrayList = new ArrayList<Long>();
        List<Attribute> list = this.userEntry.getAttribute(attributeType);
        if (list == null || list.isEmpty()) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getGeneralizedTimes", "Returning an empty list because attribute " + attributeType.getNameOrOID() + " does not exist in user " + "entry " + this.userDNString);
            }
            return arrayList;
        }
        for (Attribute attribute : list) {
            for (AttributeValue attributeValue : attribute.getValues()) {
                try {
                    arrayList.add(GeneralizedTimeSyntax.decodeGeneralizedTimeValue(attributeValue.getNormalizedValue()));
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "getGeneralizedTimes", exception));
                    if (this.debug) {
                        Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "getGeneralizedTimes", "Unable to decode value " + attributeValue.getStringValue() + " for attribute " + attributeType.getNameOrOID() + " in user entry " + this.userDNString + ":  " + exception);
                    }
                    int n = 197114;
                    String string = MessageHandler.getMessage(n, attributeValue.getStringValue(), attributeType.getNameOrOID(), this.userDNString, String.valueOf(exception));
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string, n, exception);
                }
            }
        }
        return arrayList;
    }

    private boolean getBoolean(AttributeType attributeType, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getBoolean", String.valueOf(attributeType), String.valueOf(bl)));
        List<Attribute> list = this.userEntry.getAttribute(attributeType);
        if (list == null || list.isEmpty()) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getBoolean", "Returning default of " + bl + " because attribute " + attributeType.getNameOrOID() + " does not exist in user entry " + this.userDNString);
            }
            return bl;
        }
        for (Attribute attribute : list) {
            Iterator iterator = attribute.getValues().iterator();
            if (!iterator.hasNext()) continue;
            AttributeValue attributeValue = (AttributeValue)iterator.next();
            String string = StaticUtils.toLowerCase(attributeValue.getStringValue());
            if (string.equals("true") || string.equals("yes") || string.equals("on") || string.equals("1")) {
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getBoolean", "Attribute " + attributeType.getNameOrOID() + " resolves to true for user entry " + this.userDNString);
                }
                return true;
            }
            if (string.equals("false") || string.equals("no") || string.equals("off") || string.equals("0")) {
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getBoolean", "Attribute " + attributeType.getNameOrOID() + " resolves to false for user entry " + this.userDNString);
                }
                return false;
            }
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.ERROR, CLASS_NAME, "getBoolean", "Unable to resolve value \"" + string + "\" for attribute " + attributeType.getNameOrOID() + " in user entry " + this.userDNString + " as a Boolean.");
            }
            int n = 197115;
            String string2 = MessageHandler.getMessage(n, attributeValue.getStringValue(), attributeType.getNameOrOID(), this.userDNString);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n);
        }
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getBoolean", "Returning default of " + bl + " for attribute " + attributeType.getNameOrOID() + " in user entry " + this.userDNString + " because all options have been exhausted.");
        }
        return bl;
    }

    public PasswordPolicy getPasswordPolicy() {
        assert (Debug.debugEnter(CLASS_NAME, "getPasswordPolicy", new String[0]));
        return this.passwordPolicy;
    }

    public Entry getUserEntry() {
        assert (Debug.debugEnter(CLASS_NAME, "getUserEntry", new String[0]));
        return this.userEntry;
    }

    public LinkedList<Modification> getModifications() {
        assert (Debug.debugEnter(CLASS_NAME, "getModifications", new String[0]));
        return this.modifications;
    }

    public AttributeType getPasswordAttribute() {
        assert (Debug.debugEnter(CLASS_NAME, "getPasswordAttribute", new String[0]));
        return this.passwordPolicy.getPasswordAttribute();
    }

    public LinkedHashSet<AttributeValue> getPasswordValues() {
        assert (Debug.debugEnter(CLASS_NAME, "getPasswordValues", new String[0]));
        List<Attribute> list = this.userEntry.getAttribute(this.passwordPolicy.getPasswordAttribute());
        Iterator<Attribute> iterator = list.iterator();
        if (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            return attribute.getValues();
        }
        return new LinkedHashSet<AttributeValue>(0);
    }

    public boolean requireSecureAuthentication() {
        assert (Debug.debugEnter(CLASS_NAME, "requireSecureAuthentication", new String[0]));
        return this.passwordPolicy.requireSecureAuthentication();
    }

    public boolean requireSecurePasswordChanges() {
        assert (Debug.debugEnter(CLASS_NAME, "requireSecurePasswordChanges", new String[0]));
        return this.passwordPolicy.requireSecurePasswordChanges();
    }

    public boolean allowMultiplePasswordValues() {
        assert (Debug.debugEnter(CLASS_NAME, "allowMultiplePasswordValues", new String[0]));
        return this.passwordPolicy.allowMultiplePasswordValues();
    }

    public boolean allowPreEncodedPasswords() {
        assert (Debug.debugEnter(CLASS_NAME, "allowPreEncodedPasswords", new String[0]));
        return this.passwordPolicy.allowPreEncodedPasswords();
    }

    public boolean allowUserPasswordChanges() {
        assert (Debug.debugEnter(CLASS_NAME, "allowUserPasswordChanges", new String[0]));
        return this.passwordPolicy.allowUserPasswordChanges();
    }

    public boolean requireCurrentPassword() {
        assert (Debug.debugEnter(CLASS_NAME, "requireCurrentPassword", new String[0]));
        return this.passwordPolicy.requireCurrentPassword();
    }

    public boolean skipValidationForAdministrators() {
        assert (Debug.debugEnter(CLASS_NAME, "skipValidationForAdministrators", new String[0]));
        return this.passwordPolicy.skipValidationForAdministrators();
    }

    public boolean forceChangeOnAdd() {
        assert (Debug.debugEnter(CLASS_NAME, "forceChangeOnAdd", new String[0]));
        return this.passwordPolicy.forceChangeOnAdd();
    }

    public boolean forceChangeOnReset() {
        assert (Debug.debugEnter(CLASS_NAME, "forceChangeOnReset", new String[0]));
        return this.passwordPolicy.forceChangeOnReset();
    }

    public boolean expirePasswordsWithoutWarning() {
        assert (Debug.debugEnter(CLASS_NAME, "expirePasswordsWithoutWarning", new String[0]));
        return this.passwordPolicy.expirePasswordsWithoutWarning();
    }

    public long getPasswordChangedTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getPasswordChangedTime", new String[0]));
        return this.passwordChangedTime;
    }

    public long getCurrentTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getCurrentTime", new String[0]));
        return this.currentTime;
    }

    public String getCurrentGeneralizedTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getCurrentGeneralizedTime", new String[0]));
        return this.currentGeneralizedTime;
    }

    public void setPasswordChangedTime() {
        assert (Debug.debugEnter(CLASS_NAME, "setPasswordChangedTime", new String[0]));
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "setPasswordChangedTime", "Setting password changed time for user " + this.userDNString + " to current time of " + this.currentTime);
        }
        if (this.passwordChangedTime != this.currentTime) {
            this.passwordChangedTime = this.currentTime;
            AttributeType attributeType = DirectoryServer.getAttributeType("pwdchangedtime");
            if (attributeType == null) {
                attributeType = DirectoryServer.getDefaultAttributeType("pwdChangedTime");
            }
            LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
            String string = GeneralizedTimeSyntax.format(this.passwordChangedTime);
            linkedHashSet.add(new AttributeValue(attributeType, string));
            Attribute attribute = new Attribute(attributeType, "pwdChangedTime", linkedHashSet);
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
            arrayList.add(attribute);
            if (this.updateEntry) {
                this.userEntry.putAttribute(attributeType, arrayList);
            } else {
                this.modifications.add(new Modification(ModificationType.REPLACE, attribute, true));
            }
        }
    }

    public boolean isDisabled() {
        assert (Debug.debugEnter(CLASS_NAME, "isDisabled", new String[0]));
        if (this.isDisabled == null || this.isDisabled == ConditionResult.UNDEFINED) {
            AttributeType attributeType = DirectoryServer.getAttributeType("ds-pwp-account-disabled", true);
            try {
                if (this.getBoolean(attributeType, false)) {
                    if (this.debug) {
                        Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "isDisabled", "User " + this.userDNString + " is administratively disabled.");
                    }
                    this.isDisabled = ConditionResult.TRUE;
                    return true;
                }
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "isDisabled", "User " + this.userDNString + " is not administratively disabled.");
                }
                this.isDisabled = ConditionResult.FALSE;
                return false;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "isDisabled", exception));
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "isDisabled", "User " + this.userDNString + " is considered " + "administratively disabled because an error occurred " + "while attempting to make the determination:  " + StaticUtils.stackTraceToSingleLineString(exception) + ".");
                }
                this.isDisabled = ConditionResult.TRUE;
                return true;
            }
        }
        if (this.isDisabled == ConditionResult.FALSE) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "isDisabled", "Returning stored result of false for user " + this.userDNString);
            }
            return false;
        }
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "isDisabled", "Returning stored result of true for user " + this.userDNString);
        }
        return true;
    }

    public void setDisabled(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setDisabled", String.valueOf(bl)));
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "setDisabled", "Updating user " + this.userDNString + " to set the disabled flag to " + bl);
        }
        AttributeType attributeType = DirectoryServer.getAttributeType("ds-pwp-account-disabled", true);
        if (bl) {
            if (this.isDisabled == ConditionResult.TRUE) {
                return;
            }
            this.isDisabled = ConditionResult.TRUE;
            LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
            linkedHashSet.add(new AttributeValue(attributeType, String.valueOf(bl)));
            Attribute attribute = new Attribute(attributeType, "ds-pwp-account-disabled", linkedHashSet);
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
            arrayList.add(attribute);
            if (this.updateEntry) {
                this.userEntry.putAttribute(attributeType, arrayList);
            } else {
                this.modifications.add(new Modification(ModificationType.REPLACE, attribute, true));
            }
        } else {
            if (this.isDisabled == ConditionResult.FALSE) {
                return;
            }
            this.isDisabled = ConditionResult.FALSE;
            LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
            linkedHashSet.add(new AttributeValue(attributeType, String.valueOf(bl)));
            if (this.updateEntry) {
                this.userEntry.removeAttribute(attributeType);
            } else {
                this.modifications.add(new Modification(ModificationType.REPLACE, new Attribute(attributeType), true));
            }
        }
    }

    public boolean isAccountExpired() {
        assert (Debug.debugEnter(CLASS_NAME, "isAccountExpired", new String[0]));
        if (this.isAccountExpired == null || this.isAccountExpired == ConditionResult.UNDEFINED) {
            AttributeType attributeType = DirectoryServer.getAttributeType("ds-pwp-account-expiration-time", true);
            try {
                long l = this.getGeneralizedTime(attributeType);
                if (l < 0L) {
                    if (this.debug) {
                        Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "isAccountExpired", "The account for user " + this.userDNString + " is not expired because there is no expiration " + "time in the user's entry.");
                    }
                    this.isAccountExpired = ConditionResult.FALSE;
                    return false;
                }
                if (l > this.currentTime) {
                    if (this.debug) {
                        Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "isAccountExpired", "The account for user " + this.userDNString + " is not expired because the expiration time has " + "not yet arrived.");
                    }
                    this.isAccountExpired = ConditionResult.FALSE;
                    return false;
                }
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "isAccountExpired", "The account for user " + this.userDNString + " is expired because the expiration time in that " + "account has passed.");
                }
                this.isAccountExpired = ConditionResult.TRUE;
                return true;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "isAccountExpired", exception));
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "isAccountExpired", "User " + this.userDNString + " is considered to have an " + "expired account because an error occurred " + "while attempting to make the determination:  " + StaticUtils.stackTraceToSingleLineString(exception) + ".");
                }
                this.isAccountExpired = ConditionResult.TRUE;
                return true;
            }
        }
        if (this.isAccountExpired == ConditionResult.FALSE) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "isAccountExpired", "Returning stored result of false for user " + this.userDNString);
            }
            return false;
        }
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "isAccountExpired", "Returning stored result of true for user " + this.userDNString);
        }
        return true;
    }

    public List<Long> getAuthFailureTimes() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthFailureTimes", new String[0]));
        if (this.authFailureTimes == null) {
            AttributeType attributeType = DirectoryServer.getAttributeType("pwdfailuretime");
            if (attributeType == null) {
                attributeType = DirectoryServer.getDefaultAttributeType("pwdFailureTime");
            }
            try {
                this.authFailureTimes = this.getGeneralizedTimes(attributeType);
                if (this.passwordPolicy.getLockoutFailureExpirationInterval() > 0) {
                    LinkedHashSet<AttributeValue> linkedHashSet = null;
                    long l = this.currentTime - (long)(this.passwordPolicy.getLockoutFailureExpirationInterval() * 1000);
                    Iterator<Long> iterator = this.authFailureTimes.iterator();
                    while (iterator.hasNext()) {
                        long l2 = iterator.next();
                        if (l2 >= l) continue;
                        if (this.debug) {
                            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getAuthFailureTimes", "Removing expired auth failure time " + l2 + " for user " + this.userDNString);
                        }
                        iterator.remove();
                        if (linkedHashSet == null) {
                            linkedHashSet = new LinkedHashSet<AttributeValue>();
                        }
                        linkedHashSet.add(new AttributeValue(attributeType, GeneralizedTimeSyntax.format(l2)));
                    }
                    if (linkedHashSet != null) {
                        Attribute attribute = new Attribute(attributeType, "pwdFailureTime", linkedHashSet);
                        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
                        arrayList.add(attribute);
                        if (this.authFailureTimes.isEmpty()) {
                            if (this.updateEntry) {
                                this.userEntry.removeAttribute(attributeType);
                            }
                        } else {
                            LinkedHashSet<AttributeValue> linkedHashSet2 = new LinkedHashSet<AttributeValue>(this.authFailureTimes.size());
                            for (Long l3 : this.authFailureTimes) {
                                linkedHashSet2.add(new AttributeValue(attributeType, GeneralizedTimeSyntax.format(l3)));
                            }
                            ArrayList arrayList2 = new ArrayList(1);
                            arrayList2.add(new Attribute(attributeType, "pwdFailureTime", linkedHashSet2));
                            if (this.updateEntry) {
                                this.userEntry.putAttribute(attributeType, arrayList2);
                            }
                        }
                        if (!this.updateEntry) {
                            this.modifications.add(new Modification(ModificationType.DELETE, attribute, true));
                        }
                    }
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "getAuthFailureTimes", exception));
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "getAuthFailureTimes", "Error while processing auth failure times for user " + this.userDNString + ":  " + StaticUtils.stackTraceToSingleLineString(exception));
                }
                this.authFailureTimes = new ArrayList<Long>();
                if (this.updateEntry) {
                    this.userEntry.removeAttribute(attributeType);
                }
                this.modifications.add(new Modification(ModificationType.REPLACE, new Attribute(attributeType), true));
            }
        }
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getAuthFailureTimes", "Returning auth failure time list of " + this.authFailureTimes.size() + " elements for user " + this.userDNString);
        }
        return this.authFailureTimes;
    }

    public void updateAuthFailureTimes() {
        assert (Debug.debugEnter(CLASS_NAME, "updateAuthFailureTimes", new String[0]));
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "updateAuthFailureTimes", "Updating authentication failure times for user " + this.userDNString);
        }
        List<Long> list = this.getAuthFailureTimes();
        long l = -1L;
        for (Long serializable22 : list) {
            l = Math.max(serializable22, l);
        }
        l = l >= this.currentTime ? ++l : this.currentTime;
        list.add(l);
        Object object = DirectoryServer.getAttributeType("pwdfailuretime");
        if (object == null) {
            object = DirectoryServer.getDefaultAttributeType("pwdFailureTime");
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(list.size());
        for (Long l2 : list) {
            linkedHashSet.add(new AttributeValue((AttributeType)object, GeneralizedTimeSyntax.format(l2)));
        }
        Attribute attribute = new Attribute((AttributeType)object, "pwdFailureTime", linkedHashSet);
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
        arrayList.add(attribute);
        LinkedHashSet<AttributeValue> linkedHashSet2 = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet2.add(new AttributeValue((AttributeType)object, GeneralizedTimeSyntax.format(l)));
        Attribute attribute2 = new Attribute((AttributeType)object, "pwdFailureTime", linkedHashSet2);
        if (this.updateEntry) {
            this.userEntry.putAttribute((AttributeType)object, arrayList);
        } else {
            this.modifications.add(new Modification(ModificationType.ADD, attribute2, true));
        }
    }

    public void clearAuthFailureTimes() {
        List<Long> list;
        assert (Debug.debugEnter(CLASS_NAME, "clearAuthFailureTimes", new String[0]));
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "clearAuthFailureTimes", "Clearing authentication failure times for user " + this.userDNString);
        }
        if ((list = this.getAuthFailureTimes()).isEmpty()) {
            return;
        }
        list.clear();
        AttributeType attributeType = DirectoryServer.getAttributeType("pwdfailuretime");
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType("pwdFailureTime");
        }
        if (this.updateEntry) {
            this.userEntry.removeAttribute(attributeType);
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, new Attribute(attributeType), true));
        }
    }

    public int getMaxAllowedFailures() {
        assert (Debug.debugEnter(CLASS_NAME, "getMaxAllowedFailures", new String[0]));
        return this.passwordPolicy.getLockoutFailureCount();
    }

    public boolean lockedDueToFailures() {
        assert (Debug.debugEnter(CLASS_NAME, "lockedDueToFailures", new String[0]));
        int n = this.passwordPolicy.getLockoutFailureCount();
        if (n <= 0) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "lockedDueToFailures", "Returning false for user " + this.userDNString + " because lockout due to failures is not enabled.");
            }
            return false;
        }
        AttributeType attributeType = DirectoryServer.getAttributeType("pwdaccountlockedtime");
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType("pwdAccountLockedTime");
        }
        if (this.failureLockedTime == Long.MIN_VALUE) {
            try {
                this.failureLockedTime = this.getGeneralizedTime(attributeType);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "lockedDueToFailures", exception));
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "lockedDueToFailures", "Returning true for user " + this.userDNString + " because an error occurred:  " + StaticUtils.stackTraceToSingleLineString(exception));
                }
                return true;
            }
        }
        if (this.failureLockedTime <= 0L) {
            List<Long> list = this.getAuthFailureTimes();
            if (list != null && list.size() >= n) {
                this.lockDueToFailures();
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "lockedDueToFailures", "Setting the lock for user " + this.userDNString + " because there were enough preexisting failures even " + "though there was no account locked time.");
                }
                return true;
            }
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "lockedDueToFailures", "Returning false for user " + this.userDNString + " because there is no locked time.");
            }
            return false;
        }
        if (this.passwordPolicy.getLockoutDuration() > 0) {
            long l = this.failureLockedTime + (long)(1000 * this.passwordPolicy.getLockoutDuration());
            if (l > this.currentTime) {
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "lockedDueToFailures", "Returning true for user " + this.userDNString + " because there is a locked time and the lockout " + "duration has not been reached.");
                    this.secondsUntilUnlock = (int)(l - this.currentTime);
                }
                return true;
            }
            if (this.updateEntry) {
                this.userEntry.removeAttribute(attributeType);
            } else {
                this.modifications.add(new Modification(ModificationType.REPLACE, new Attribute(attributeType), true));
            }
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "lockedDueToFailures", "Returning false for user " + this.userDNString + " because the existing lockout has expired.");
            }
            return false;
        }
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "lockedDueToFailures", "Returning true for user " + this.userDNString + " because there is a locked time and no lockout " + "duration.");
        }
        return true;
    }

    public int getLockoutDuration() {
        assert (Debug.debugEnter(CLASS_NAME, "getLockoutDuration", new String[0]));
        return this.passwordPolicy.getLockoutDuration();
    }

    public int getSecondsUntilUnlock() {
        assert (Debug.debugEnter(CLASS_NAME, "getSecondsBeforeUnlock", new String[0]));
        if (this.secondsUntilUnlock < 0) {
            return -1;
        }
        return this.secondsUntilUnlock;
    }

    public void lockDueToFailures() {
        assert (Debug.debugEnter(CLASS_NAME, "lockDueToFailures", new String[0]));
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "lockDueToFailures", "Locking user account " + this.userDNString + " due to too many failures.");
        }
        this.failureLockedTime = this.currentTime;
        AttributeType attributeType = DirectoryServer.getAttributeType("pwdaccountlockedtime");
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType("pwdAccountLockedTime");
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet.add(new AttributeValue(attributeType, GeneralizedTimeSyntax.format(this.failureLockedTime)));
        Attribute attribute = new Attribute(attributeType, "pwdAccountLockedTime", linkedHashSet);
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
        arrayList.add(attribute);
        if (this.updateEntry) {
            this.userEntry.putAttribute(attributeType, arrayList);
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, attribute, true));
        }
    }

    public void clearFailureLockout() {
        assert (Debug.debugEnter(CLASS_NAME, "clearFailureLock", new String[0]));
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "clearFailureLockout", "Clearing lockout failures for user " + this.userDNString);
        }
        if (!this.lockedDueToFailures()) {
            return;
        }
        AttributeType attributeType = DirectoryServer.getAttributeType("pwdaccountlockedtime");
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType("pwdAccountLockedTime");
        }
        if (this.updateEntry) {
            this.userEntry.removeAttribute(attributeType);
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, new Attribute(attributeType), true));
        }
    }

    public long getLastLoginTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getLastLoginTime", new String[0]));
        if (this.lastLoginTime == Long.MIN_VALUE) {
            AttributeType attributeType = this.passwordPolicy.getLastLoginTimeAttribute();
            String string = this.passwordPolicy.getLastLoginTimeFormat();
            if (attributeType == null || string == null) {
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getLastLoginTime", "Returning creation time of " + this.createTime + " for user " + this.userDNString + " because no last login " + "time will be maintained.");
                }
                this.lastLoginTime = this.createTime;
                return this.lastLoginTime;
            }
            List<Attribute> list = this.userEntry.getAttribute(attributeType);
            if (list == null || list.isEmpty()) {
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getLastLoginTime", "Returning creation time of " + this.createTime + " for user " + this.userDNString + " because no last login " + "time value exists.");
                }
                this.lastLoginTime = this.createTime;
                return this.lastLoginTime;
            }
            for (Attribute attribute : list) {
                Iterator iterator = attribute.getValues().iterator();
                if (!iterator.hasNext()) continue;
                AttributeValue attributeValue = (AttributeValue)iterator.next();
                String string2 = attributeValue.getStringValue();
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
                    this.lastLoginTime = simpleDateFormat.parse(string2).getTime();
                    if (this.debug) {
                        Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getLastLoginTime", "Returning last login time of " + this.lastLoginTime + " for user " + this.userDNString + " decoded using " + "current last login time format.");
                    }
                    return this.lastLoginTime;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "getLastLoginTime", exception));
                    for (String string3 : this.passwordPolicy.getPreviousLastLoginTimeFormats()) {
                        try {
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
                            this.lastLoginTime = simpleDateFormat.parse(string2).getTime();
                            if (this.debug) {
                                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getLastLoginTime", "Returning last login time of " + this.lastLoginTime + " for user " + this.userDNString + " decoded using " + "previous last login time format of " + string3);
                            }
                            return this.lastLoginTime;
                        }
                        catch (Exception exception2) {
                            assert (Debug.debugException(CLASS_NAME, "getLastLoginTime", exception2));
                        }
                    }
                    if (this.debug) {
                        Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "getLastLoginTime", "Returning creation time of " + this.createTime + " for user " + this.userDNString + " because the last " + "login time value " + string2 + "could not be parsed using any known format.");
                    }
                    this.lastLoginTime = this.createTime;
                    return this.lastLoginTime;
                }
            }
        }
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getLastLoginTime", "Returning previously calculated last login time of " + this.lastLoginTime + " for user " + this.userDNString);
        }
        return this.lastLoginTime;
    }

    public void setLastLoginTime() {
        String string;
        Object object;
        assert (Debug.debugEnter(CLASS_NAME, "setLastLoginTime", new String[0]));
        AttributeType attributeType = this.passwordPolicy.getLastLoginTimeAttribute();
        String string2 = this.passwordPolicy.getLastLoginTimeFormat();
        if (attributeType == null || string2 == null) {
            return;
        }
        try {
            object = new SimpleDateFormat(string2);
            string = ((DateFormat)object).format(TimeThread.getDate());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "setLastLoginTime", exception));
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "setLastLoginTime", "Unable to set last login time for user " + this.userDNString + " because an error occurred:  " + StaticUtils.stackTraceToSingleLineString(exception));
            }
            return;
        }
        object = this.getValue(attributeType);
        if (object != null && string.equals(object)) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "setLastLoginTime", "Not updating last login time for user " + this.userDNString + " because the new value matches the existing value.");
            }
            return;
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet.add(new AttributeValue(attributeType, string));
        Attribute attribute = new Attribute(attributeType, attributeType.getNameOrOID(), linkedHashSet);
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
        arrayList.add(attribute);
        if (this.updateEntry) {
            this.userEntry.putAttribute(attributeType, arrayList);
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, attribute, true));
        }
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "setLastLoginTime", "Updated the last login time for user " + this.userDNString + " to " + string);
        }
    }

    public boolean lockedDueToIdleInterval() {
        assert (Debug.debugEnter(CLASS_NAME, "lockedDueToIdleInterval", new String[0]));
        if (this.isIdleLocked == null || this.isIdleLocked == ConditionResult.UNDEFINED) {
            if (this.passwordPolicy.getIdleLockoutInterval() <= 0) {
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "lockedDueToIdleInterval", "Returning false for user " + this.userDNString + " because no idle lockout interval is defined.");
                }
                this.isIdleLocked = ConditionResult.FALSE;
                return false;
            }
            long l = this.currentTime - (long)(this.passwordPolicy.getIdleLockoutInterval() * 1000);
            long l2 = this.getLastLoginTime();
            if (l2 > 0L) {
                if (l2 > l) {
                    if (this.debug) {
                        Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "lockedDueToIdleInterval", "Returning false for user " + this.userDNString + " because the last login time is in an acceptable " + "window.");
                    }
                    this.isIdleLocked = ConditionResult.FALSE;
                    return false;
                }
                if (this.passwordChangedTime > l) {
                    if (this.debug) {
                        Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "lockedDueToIdleInterval", "Returning false for user " + this.userDNString + " because the password changed time is in an " + "acceptable window.");
                    }
                    this.isIdleLocked = ConditionResult.FALSE;
                    return false;
                }
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "lockedDueToIdleInterval", "Returning true for user " + this.userDNString + " because neither last login time nor password " + "changed time are in an acceptable window.");
                }
                this.isIdleLocked = ConditionResult.TRUE;
                return true;
            }
            if (this.passwordChangedTime < l) {
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "lockedDueToIdleInterval", "Returning true for user " + this.userDNString + " because there is no last login time and the " + "password changed time is not in an acceptable " + "window.");
                }
                this.isIdleLocked = ConditionResult.TRUE;
                return true;
            }
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "lockedDueToIdleInterval", "Returning false for user " + this.userDNString + " because there is no last login time but the " + "password changed time is in an acceptable window.");
            }
            this.isIdleLocked = ConditionResult.FALSE;
            return false;
        }
        if (this.isIdleLocked == ConditionResult.TRUE) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "lockedDueToIdleInterval", "Returning stored result of true for user " + this.userDNString);
            }
            return true;
        }
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "lockedDueToIdleInterval", "Returning stored result of false for user " + this.userDNString);
        }
        return false;
    }

    public boolean mustChangePassword() {
        assert (Debug.debugEnter(CLASS_NAME, "mustChangePassword", new String[0]));
        if (!this.passwordPolicy.allowUserPasswordChanges()) {
            return false;
        }
        if (!this.passwordPolicy.forceChangeOnAdd() && !this.passwordPolicy.forceChangeOnReset()) {
            return false;
        }
        if (this.mustChangePassword == null || this.mustChangePassword == ConditionResult.UNDEFINED) {
            AttributeType attributeType = DirectoryServer.getAttributeType("pwdreset");
            if (attributeType == null) {
                attributeType = DirectoryServer.getDefaultAttributeType("pwdReset");
            }
            try {
                boolean bl = this.getBoolean(attributeType, false);
                if (bl) {
                    if (this.debug) {
                        Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "mustChangePassword", "Returning true for user " + this.userDNString);
                    }
                    this.mustChangePassword = ConditionResult.TRUE;
                    return true;
                }
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "mustChangePassword", "Returning false for user " + this.userDNString);
                }
                this.mustChangePassword = ConditionResult.FALSE;
                return false;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "mustChangePassword", exception));
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "mustChangePassword", "Returning true for user " + this.userDNString + " because an unexpected error occurred:  " + StaticUtils.stackTraceToSingleLineString(exception));
                }
                this.mustChangePassword = ConditionResult.TRUE;
                return true;
            }
        }
        if (this.mustChangePassword == ConditionResult.TRUE) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "mustChangePassword", "Returning stored result of true for user " + this.userDNString);
            }
            return true;
        }
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "mustChangePassword", "Returning stored result of false for user " + this.userDNString);
        }
        return false;
    }

    public void setMustChangePassword(boolean bl) {
        AttributeType attributeType;
        assert (Debug.debugEnter(CLASS_NAME, "setMustChangePassword", String.valueOf(bl)));
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "setMustChangePassword", "Updating user " + this.userDNString + " to set the reset flag to " + bl);
        }
        if ((attributeType = DirectoryServer.getAttributeType("pwdreset")) == null) {
            attributeType = DirectoryServer.getDefaultAttributeType("pwdReset");
        }
        if (bl) {
            if (this.mustChangePassword == ConditionResult.TRUE) {
                return;
            }
            this.mustChangePassword = ConditionResult.TRUE;
            LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
            linkedHashSet.add(new AttributeValue(attributeType, String.valueOf(bl)));
            Attribute attribute = new Attribute(attributeType, "pwdReset", linkedHashSet);
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
            arrayList.add(attribute);
            if (this.updateEntry) {
                this.userEntry.putAttribute(attributeType, arrayList);
            } else {
                this.modifications.add(new Modification(ModificationType.REPLACE, attribute, true));
            }
        } else {
            if (this.mustChangePassword == ConditionResult.FALSE) {
                return;
            }
            this.mustChangePassword = ConditionResult.FALSE;
            if (this.updateEntry) {
                this.userEntry.removeAttribute(attributeType);
            } else {
                this.modifications.add(new Modification(ModificationType.REPLACE, new Attribute(attributeType), true));
            }
        }
    }

    public boolean lockedDueToMaximumResetAge() {
        boolean bl;
        assert (Debug.debugEnter(CLASS_NAME, "lockedDueToMaximumResetAge", new String[0]));
        if (this.passwordPolicy.getMaximumPasswordResetAge() <= 0) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "lockedDueToMaximumResetAge", "Returning false for user " + this.userDNString + " because there is no maximum reset age .");
            }
            return false;
        }
        if (!this.mustChangePassword()) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "lockedDueToMaximumResetAge", "Returning false for user " + this.userDNString + " because the user's password has not been reset.");
            }
            return false;
        }
        long l = this.passwordChangedTime + (long)(1000 * this.passwordPolicy.getMaximumPasswordResetAge());
        boolean bl2 = bl = l < this.currentTime;
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "lockedDueToMaximumResetAge", "Returning " + bl + " for user " + this.userDNString + " after comparing the current and max reset times.");
        }
        return bl;
    }

    public long getPasswordExpirationTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getPasswordExpirationTime", new String[0]));
        if (this.expirationTime == Long.MIN_VALUE) {
            long l;
            long l2;
            long l3;
            this.expirationTime = Long.MAX_VALUE;
            boolean bl = false;
            int n = this.passwordPolicy.getMaximumPasswordAge();
            if (n > 0 && (l3 = this.passwordChangedTime + (long)(1000 * n)) < this.expirationTime) {
                this.expirationTime = l3;
                bl = true;
            }
            int n2 = this.passwordPolicy.getMaximumPasswordResetAge();
            if (this.mustChangePassword() && n2 > 0 && (l2 = this.passwordChangedTime + (long)(1000 * n2)) < this.expirationTime) {
                this.expirationTime = l2;
                bl = false;
            }
            if ((l2 = this.passwordPolicy.getRequireChangeByTime()) > 0L && (l = this.getRequiredChangeTime()) != l2 && l2 < this.expirationTime) {
                this.expirationTime = l2;
                bl = true;
            }
            if (this.expirationTime == Long.MAX_VALUE) {
                this.expirationTime = -1L;
                this.shouldWarn = ConditionResult.FALSE;
                this.isFirstWarning = ConditionResult.FALSE;
                this.isPasswordExpired = ConditionResult.FALSE;
                this.mayUseGraceLogin = ConditionResult.TRUE;
            } else if (bl) {
                this.mayUseGraceLogin = ConditionResult.TRUE;
                int n3 = this.passwordPolicy.getWarningInterval();
                if (n3 > 0) {
                    long l4 = this.expirationTime - (long)(n3 * 1000);
                    if (l4 > this.currentTime) {
                        this.shouldWarn = ConditionResult.FALSE;
                        this.isFirstWarning = ConditionResult.FALSE;
                        this.isPasswordExpired = ConditionResult.FALSE;
                    } else {
                        long l5 = this.getWarnedTime();
                        if (this.expirationTime > this.currentTime) {
                            this.shouldWarn = ConditionResult.TRUE;
                            this.isPasswordExpired = ConditionResult.FALSE;
                            if (l5 < 0L) {
                                this.isFirstWarning = ConditionResult.TRUE;
                                this.setWarnedTime();
                                if (!this.passwordPolicy.expirePasswordsWithoutWarning()) {
                                    this.expirationTime = this.currentTime + (long)(n3 * 1000);
                                }
                            } else {
                                this.isFirstWarning = ConditionResult.FALSE;
                                if (!this.passwordPolicy.expirePasswordsWithoutWarning()) {
                                    this.expirationTime = l5 + (long)(n3 * 1000);
                                }
                            }
                        } else if (this.passwordPolicy.expirePasswordsWithoutWarning()) {
                            this.shouldWarn = ConditionResult.FALSE;
                            this.isFirstWarning = ConditionResult.FALSE;
                            this.isPasswordExpired = ConditionResult.TRUE;
                        } else if (l5 > 0L) {
                            this.expirationTime = l5 + (long)(n3 * 1000);
                            if (this.expirationTime > this.currentTime) {
                                this.shouldWarn = ConditionResult.TRUE;
                                this.isFirstWarning = ConditionResult.FALSE;
                                this.isPasswordExpired = ConditionResult.FALSE;
                            } else {
                                this.shouldWarn = ConditionResult.FALSE;
                                this.isFirstWarning = ConditionResult.FALSE;
                                this.isPasswordExpired = ConditionResult.TRUE;
                            }
                        } else {
                            this.shouldWarn = ConditionResult.TRUE;
                            this.isFirstWarning = ConditionResult.TRUE;
                            this.isPasswordExpired = ConditionResult.FALSE;
                            this.expirationTime = this.currentTime + (long)(n3 * 1000);
                        }
                    }
                } else {
                    this.shouldWarn = ConditionResult.FALSE;
                    this.isFirstWarning = ConditionResult.FALSE;
                    this.isPasswordExpired = this.currentTime > this.expirationTime ? ConditionResult.TRUE : ConditionResult.FALSE;
                }
            } else {
                this.mayUseGraceLogin = ConditionResult.FALSE;
                this.shouldWarn = ConditionResult.FALSE;
                this.isFirstWarning = ConditionResult.FALSE;
                this.isPasswordExpired = this.expirationTime < this.currentTime ? ConditionResult.TRUE : ConditionResult.FALSE;
            }
        }
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getPasswordExpirationTime", "Returning password expiration time of " + this.expirationTime + " for user " + this.userDNString);
        }
        this.secondsUntilExpiration = (int)(this.expirationTime - this.currentTime);
        return this.expirationTime;
    }

    public boolean isPasswordExpired() {
        assert (Debug.debugEnter(CLASS_NAME, "isPasswordExpired", new String[0]));
        if (this.isPasswordExpired == null || this.isPasswordExpired == ConditionResult.UNDEFINED) {
            this.getPasswordExpirationTime();
        }
        return this.isPasswordExpired == ConditionResult.TRUE;
    }

    public boolean allowExpiredPasswordChanges() {
        assert (Debug.debugEnter(CLASS_NAME, "allowExpiredPasswordChanges", new String[0]));
        return this.passwordPolicy.allowExpiredPasswordChanges();
    }

    public boolean isWithinMinimumAge() {
        assert (Debug.debugEnter(CLASS_NAME, "isWithinMinimumAge", new String[0]));
        int n = this.passwordPolicy.getMinimumPasswordAge();
        if (n <= 0) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "isWithinMinimumAge", "Returning false because there is no minimum age.");
            }
            return false;
        }
        if (this.passwordChangedTime + (long)(n * 1000) < this.currentTime) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "isWithinMinimumAge", "Returning false because the minimum age has expired.");
            }
            return false;
        }
        if (this.mustChangePassword()) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "isWithinMinimumAge", "Returning false because the account is in a must-change state.");
            }
            return false;
        }
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "isWithinMinimumAge", "Returning true.");
        }
        return true;
    }

    public boolean mayUseGraceLogin() {
        assert (Debug.debugEnter(CLASS_NAME, "mayUseGraceLogin", new String[0]));
        if (this.mayUseGraceLogin == null || this.mayUseGraceLogin == ConditionResult.UNDEFINED) {
            this.getPasswordExpirationTime();
        }
        return this.mayUseGraceLogin == ConditionResult.TRUE;
    }

    public boolean shouldWarn() {
        assert (Debug.debugEnter(CLASS_NAME, "shouldWarn", new String[0]));
        if (this.shouldWarn == null || this.shouldWarn == ConditionResult.UNDEFINED) {
            this.getPasswordExpirationTime();
        }
        return this.shouldWarn == ConditionResult.TRUE;
    }

    public boolean isFirstWarning() {
        assert (Debug.debugEnter(CLASS_NAME, "isFirstWarning", new String[0]));
        if (this.isFirstWarning == null || this.isFirstWarning == ConditionResult.UNDEFINED) {
            this.getPasswordExpirationTime();
        }
        return this.isFirstWarning == ConditionResult.TRUE;
    }

    public int getSecondsUntilExpiration() {
        assert (Debug.debugEnter(CLASS_NAME, "getSecondsUntilExpiration", new String[0]));
        long l = this.getPasswordExpirationTime();
        if (l < 0L) {
            return -1;
        }
        if (l < this.currentTime) {
            return 0;
        }
        return (int)((l - this.currentTime) / 1000L);
    }

    public long getRequiredChangeTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getRequiredChangeTime", new String[0]));
        if (this.requiredChangeTime == Long.MIN_VALUE) {
            AttributeType attributeType = DirectoryServer.getAttributeType("ds-pwp-password-changed-by-required-time", true);
            try {
                this.requiredChangeTime = this.getGeneralizedTime(attributeType);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "getRequiredChangeTime", exception));
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "getRequiredChangeTime", "An error occurred while attempting to determine the required change time for user " + this.userDNString + ":  " + StaticUtils.stackTraceToSingleLineString(exception));
                }
                this.requiredChangeTime = -1L;
            }
        }
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getRequiredChangeTime", "Returning required change time of " + this.requiredChangeTime + " for user " + this.userDNString);
        }
        return this.requiredChangeTime;
    }

    public void setRequiredChangeTime() {
        long l;
        assert (Debug.debugEnter(CLASS_NAME, "setRequiredChangeTime", new String[0]));
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "setRequiredChangeTime", "Updating required change time for user " + this.userDNString);
        }
        if ((l = this.getRequiredChangeTime()) != this.passwordPolicy.getRequireChangeByTime()) {
            this.requiredChangeTime = l = this.passwordPolicy.getRequireChangeByTime();
            AttributeType attributeType = DirectoryServer.getAttributeType("ds-pwp-password-changed-by-required-time", true);
            LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
            String string = GeneralizedTimeSyntax.format(this.passwordChangedTime);
            linkedHashSet.add(new AttributeValue(attributeType, string));
            Attribute attribute = new Attribute(attributeType, "ds-pwp-password-changed-by-required-time", linkedHashSet);
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
            arrayList.add(attribute);
            if (this.updateEntry) {
                this.userEntry.putAttribute(attributeType, arrayList);
            } else {
                this.modifications.add(new Modification(ModificationType.REPLACE, attribute, true));
            }
        }
    }

    public long getWarnedTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getWarnedTime", new String[0]));
        if (this.warnedTime == Long.MIN_VALUE) {
            AttributeType attributeType = DirectoryServer.getAttributeType("ds-pwp-warned-time", true);
            try {
                this.warnedTime = this.getGeneralizedTime(attributeType);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "getWarnedTime", exception));
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "getWarnedTime", "Unable to decode the warned time for user " + this.userDNString + ":  " + StaticUtils.stackTraceToSingleLineString(exception));
                }
                this.warnedTime = -1L;
            }
        }
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getWarnedTime", "Returning a warned time of " + this.warnedTime + " for user " + this.userDNString);
        }
        return this.warnedTime;
    }

    public void setWarnedTime() {
        assert (Debug.debugEnter(CLASS_NAME, "setWarnedTime", new String[0]));
        long l = this.getWarnedTime();
        if (l == this.currentTime) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "setWarnedTime", "Not updating warned time for user " + this.userDNString + " because the warned time is the same as the current " + "time.");
            }
            return;
        }
        this.warnedTime = this.currentTime;
        AttributeType attributeType = DirectoryServer.getAttributeType("ds-pwp-warned-time", true);
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet.add(GeneralizedTimeSyntax.createGeneralizedTimeValue(this.currentTime));
        Attribute attribute = new Attribute(attributeType, "ds-pwp-warned-time", linkedHashSet);
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
        arrayList.add(attribute);
        if (this.updateEntry) {
            this.userEntry.putAttribute(attributeType, arrayList);
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, attribute, true));
        }
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "setWarnedTime", "Updated the warned time for user " + this.userDNString);
        }
    }

    public void clearWarnedTime() {
        assert (Debug.debugEnter(CLASS_NAME, "clearWarnedTime", new String[0]));
        AttributeType attributeType = DirectoryServer.getAttributeType("ds-pwp-warned-time", true);
        if (this.updateEntry) {
            this.userEntry.removeAttribute(attributeType);
        } else {
            Attribute attribute = new Attribute(attributeType);
            this.modifications.add(new Modification(ModificationType.REPLACE, attribute, true));
        }
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "clearWarnedTime", "Cleared the warned time for user " + this.userDNString);
        }
    }

    public int getMaxAllowedGraceLogins() {
        assert (Debug.debugEnter(CLASS_NAME, "getMaxAllowedGraceLogins", new String[0]));
        return this.passwordPolicy.getGraceLoginCount();
    }

    public List<Long> getGraceLoginTimes() {
        assert (Debug.debugEnter(CLASS_NAME, "getGraceLoginTimes", new String[0]));
        if (this.graceLoginTimes == null) {
            AttributeType attributeType = DirectoryServer.getAttributeType("pwdgraceusetime");
            if (attributeType == null) {
                attributeType = DirectoryServer.getDefaultAttributeType("pwdGraceUseTime");
            }
            try {
                this.graceLoginTimes = this.getGeneralizedTimes(attributeType);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "getGraceLoginTimes", exception));
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "getGraceLoginTimes", "Error while processing grace login times for user " + this.userDNString + ":  " + StaticUtils.stackTraceToSingleLineString(exception));
                }
                this.graceLoginTimes = new ArrayList<Long>();
                if (this.updateEntry) {
                    this.userEntry.removeAttribute(attributeType);
                }
                this.modifications.add(new Modification(ModificationType.REPLACE, new Attribute(attributeType), true));
            }
        }
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "getGraceLoginTimes", "Returning grace login times for user " + this.userDNString);
        }
        return this.graceLoginTimes;
    }

    public int getGraceLoginsRemaining() {
        assert (Debug.debugEnter(CLASS_NAME, "getGraceLoginsRemaining", new String[0]));
        int n = this.passwordPolicy.getGraceLoginCount();
        if (n <= 0) {
            return -1;
        }
        List<Long> list = this.getGraceLoginTimes();
        return n - list.size();
    }

    public void updateGraceLoginTimes() {
        assert (Debug.debugEnter(CLASS_NAME, "updateGraceLoginTimes", new String[0]));
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "updateGraceLoginTimes", "Updating grace login times for user " + this.userDNString);
        }
        List<Long> list = this.getGraceLoginTimes();
        long l = -1L;
        for (Long serializable22 : list) {
            l = Math.max(serializable22, l);
        }
        l = l >= this.currentTime ? ++l : this.currentTime;
        list.add(l);
        Object object = DirectoryServer.getAttributeType("pwdgraceusetime");
        if (object == null) {
            object = DirectoryServer.getDefaultAttributeType("pwdGraceUseTime");
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(list.size());
        for (Long l2 : list) {
            linkedHashSet.add(new AttributeValue((AttributeType)object, GeneralizedTimeSyntax.format(l2)));
        }
        Attribute attribute = new Attribute((AttributeType)object, "pwdGraceUseTime", linkedHashSet);
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
        arrayList.add(attribute);
        LinkedHashSet<AttributeValue> linkedHashSet2 = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet2.add(new AttributeValue((AttributeType)object, GeneralizedTimeSyntax.format(l)));
        Attribute attribute2 = new Attribute((AttributeType)object, "pwdGraceUseTime", linkedHashSet2);
        if (this.updateEntry) {
            this.userEntry.putAttribute((AttributeType)object, arrayList);
        } else {
            this.modifications.add(new Modification(ModificationType.ADD, attribute2, true));
        }
    }

    public void clearGraceLoginTimes() {
        List<Long> list;
        assert (Debug.debugEnter(CLASS_NAME, "clearGraceLoginTimes", new String[0]));
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "clearGraceLoginTimes", "Clearing grace login times for user " + this.userDNString);
        }
        if ((list = this.getGraceLoginTimes()).isEmpty()) {
            return;
        }
        list.clear();
        AttributeType attributeType = DirectoryServer.getAttributeType("pwdgraceusetime");
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType("pwdGraceUseTime");
        }
        if (this.updateEntry) {
            this.userEntry.removeAttribute(attributeType);
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, new Attribute(attributeType), true));
        }
    }

    public List<ByteString> getClearPasswords() {
        LinkedList<ByteString> linkedList;
        block14: {
            linkedList = new LinkedList<ByteString>();
            List<Attribute> list = this.userEntry.getAttribute(this.passwordPolicy.getPasswordAttribute());
            if (list == null) break block14;
            if (this.passwordPolicy.usesAuthPasswordSyntax()) {
                for (Attribute attribute : list) {
                    for (AttributeValue attributeValue : attribute.getValues()) {
                        try {
                            StringBuilder[] stringBuilderArray = AuthPasswordSyntax.decodeAuthPassword(attributeValue.getStringValue());
                            PasswordStorageScheme passwordStorageScheme = DirectoryServer.getAuthPasswordStorageScheme(stringBuilderArray[0].toString());
                            if (passwordStorageScheme == null) {
                                if (!this.debug) continue;
                                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "getClearPasswords", "User entry " + this.userDNString + " contains an " + "authPassword with scheme " + stringBuilderArray[0] + " that is not defined in the server.");
                                continue;
                            }
                            if (!passwordStorageScheme.isReversible()) continue;
                            ByteString byteString = passwordStorageScheme.getAuthPasswordPlaintextValue(stringBuilderArray[1].toString(), stringBuilderArray[2].toString());
                            linkedList.add(byteString);
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "getClearPasswords", exception));
                            if (!this.debug) continue;
                            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "getClearPasswords", "Cannot get clear authPassword value for user " + this.userDNString + ":  " + exception);
                        }
                    }
                }
            } else {
                for (Attribute attribute : list) {
                    for (AttributeValue attributeValue : attribute.getValues()) {
                        try {
                            String[] stringArray = UserPasswordSyntax.decodeUserPassword(attributeValue.getStringValue());
                            PasswordStorageScheme passwordStorageScheme = DirectoryServer.getPasswordStorageScheme(stringArray[0]);
                            if (passwordStorageScheme == null) {
                                if (!this.debug) continue;
                                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "getClearPasswords", "User entry " + this.userDNString + " contains a " + "password with scheme " + stringArray[0] + " that is not defined in the server.");
                                continue;
                            }
                            if (!passwordStorageScheme.isReversible()) continue;
                            ByteString byteString = passwordStorageScheme.getPlaintextValue(new ASN1OctetString(stringArray[1]));
                            linkedList.add(byteString);
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "getClearPasswords", exception));
                            if (!this.debug) continue;
                            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "getClearPasswords", "Cannot get clear password value for user " + this.userDNString + ":  " + exception);
                        }
                    }
                }
            }
        }
        return linkedList;
    }

    public boolean passwordMatches(ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "passwordMatches", "ByteString"));
        List<Attribute> list = this.userEntry.getAttribute(this.passwordPolicy.getPasswordAttribute());
        if (list == null || list.isEmpty()) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "passwordMatches", "Returning false because user " + this.userDNString + " does not have any values for password attribute " + this.passwordPolicy.getPasswordAttribute().getNameOrOID());
            }
            return false;
        }
        if (this.passwordPolicy.usesAuthPasswordSyntax()) {
            for (Attribute attribute : list) {
                for (AttributeValue attributeValue : attribute.getValues()) {
                    try {
                        StringBuilder[] stringBuilderArray = AuthPasswordSyntax.decodeAuthPassword(attributeValue.getStringValue());
                        PasswordStorageScheme passwordStorageScheme = DirectoryServer.getAuthPasswordStorageScheme(stringBuilderArray[0].toString());
                        if (passwordStorageScheme == null) {
                            if (!this.debug) continue;
                            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "passwordMatches", "User entry " + this.userDNString + " contains a " + "password with scheme " + stringBuilderArray[0] + " that is not defined in the server.");
                            continue;
                        }
                        if (!passwordStorageScheme.authPasswordMatches(byteString, stringBuilderArray[1].toString(), stringBuilderArray[2].toString())) continue;
                        if (this.debug) {
                            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "passwordMatches", "Returning true for user " + this.userDNString + " because the provided password matches a " + "value encoded with scheme " + stringBuilderArray[0]);
                        }
                        return true;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "passwordMatches", exception));
                        if (!this.debug) continue;
                        Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.ERROR, CLASS_NAME, "passwordMatches", "An error occurred while attempting to process a password value for user " + this.userDNString + ":  " + StaticUtils.stackTraceToSingleLineString(exception));
                    }
                }
            }
        } else {
            for (Attribute attribute : list) {
                for (AttributeValue attributeValue : attribute.getValues()) {
                    try {
                        String[] stringArray = UserPasswordSyntax.decodeUserPassword(attributeValue.getStringValue());
                        PasswordStorageScheme passwordStorageScheme = DirectoryServer.getPasswordStorageScheme(stringArray[0]);
                        if (passwordStorageScheme == null) {
                            if (!this.debug) continue;
                            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "passwordMatches", "User entry " + this.userDNString + " contains a " + "password with scheme " + stringArray[0] + " that is not defined in the server.");
                            continue;
                        }
                        if (!passwordStorageScheme.passwordMatches(byteString, new ASN1OctetString(stringArray[1]))) continue;
                        if (this.debug) {
                            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "passwordMatches", "Returning true for user " + this.userDNString + " because the provided password matches a " + "value encoded with scheme " + stringArray[0]);
                        }
                        return true;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "passwordMatches", exception));
                        if (!this.debug) continue;
                        Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.ERROR, CLASS_NAME, "passwordMatches", "An error occurred while attempting to process a password value for user " + this.userDNString + ":  " + StaticUtils.stackTraceToSingleLineString(exception));
                    }
                }
            }
        }
        if (this.debug) {
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "passwordMatches", "Returning false because the provided password does not match any of the stored password values for user " + this.userDNString);
        }
        return false;
    }

    public boolean usesAuthPasswordSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "usesAuthPasswordSyntax", new String[0]));
        return this.passwordPolicy.usesAuthPasswordSyntax();
    }

    public boolean passwordIsPreEncoded(ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "isPreEncoded", "ByteString"));
        if (this.passwordPolicy.usesAuthPasswordSyntax()) {
            return AuthPasswordSyntax.isEncoded(byteString);
        }
        return UserPasswordSyntax.isEncoded(byteString);
    }

    public List<ByteString> encodePassword(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "encodePassword", "ByteString"));
        CopyOnWriteArrayList<PasswordStorageScheme> copyOnWriteArrayList = this.passwordPolicy.getDefaultStorageSchemes();
        ArrayList<ByteString> arrayList = new ArrayList<ByteString>(copyOnWriteArrayList.size());
        if (this.passwordPolicy.usesAuthPasswordSyntax()) {
            for (PasswordStorageScheme passwordStorageScheme : copyOnWriteArrayList) {
                arrayList.add(passwordStorageScheme.encodeAuthPassword(byteString));
            }
        } else {
            for (PasswordStorageScheme passwordStorageScheme : copyOnWriteArrayList) {
                arrayList.add(passwordStorageScheme.encodePasswordWithScheme(byteString));
            }
        }
        return arrayList;
    }

    public boolean passwordIsAcceptable(Operation operation, Entry entry, ByteString byteString, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "passwordIsAcceptable", String.valueOf(operation), String.valueOf(entry), "ByteString", "StringBuilder"));
        for (DN dN : this.passwordPolicy.getPasswordValidators().keySet()) {
            PasswordValidator passwordValidator = this.passwordPolicy.getPasswordValidators().get(dN);
            if (!passwordValidator.passwordIsValid(byteString, operation, entry, stringBuilder)) {
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "passwordIsAcceptable", "The password provided for user " + this.userDNString + " failed the " + dN.toString() + " password validator.");
                }
                return false;
            }
            if (!this.debug) continue;
            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "passwordIsAcceptable", "The password provided for user " + this.userDNString + " passed the " + dN.toString() + " password validator.");
        }
        return true;
    }

    public void handleDeprecatedStorageSchemes(ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "handleDeprecatedStorageSchemes", "ByteString"));
        if (this.passwordPolicy.getDefaultStorageSchemes().isEmpty()) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "handleDeprecatedStorageSchemes", "Doing nothing for user " + this.userDNString + " because no deprecated storage schemes have been " + "defined.");
            }
            return;
        }
        AttributeType attributeType = this.passwordPolicy.getPasswordAttribute();
        List<Attribute> list = this.userEntry.getAttribute(attributeType);
        if (list == null || list.isEmpty()) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "handleDeprecatedStorageSchemes", "Doing nothing for entry " + this.userDNString + " because no password values were found.");
            }
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>();
        LinkedHashSet<AttributeValue> linkedHashSet2 = new LinkedHashSet<AttributeValue>();
        if (this.passwordPolicy.usesAuthPasswordSyntax()) {
            Object object;
            Object object2;
            for (Attribute object4 : list) {
                Iterator iterator = object4.getValues().iterator();
                while (iterator.hasNext()) {
                    object2 = (AttributeValue)iterator.next();
                    try {
                        object = AuthPasswordSyntax.decodeAuthPassword(((AttributeValue)object2).getStringValue());
                        String string = object[0].toString();
                        PasswordStorageScheme passwordStorageScheme = DirectoryServer.getAuthPasswordStorageScheme(string);
                        if (passwordStorageScheme == null) {
                            if (!this.debug) continue;
                            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "handleDeprecatedStorageSchemes", "Skipping password value for user " + this.userDNString + " because the associated storage " + "scheme \"" + string + "\" is not configured for use.");
                            continue;
                        }
                        if (!passwordStorageScheme.authPasswordMatches(byteString, object[1].toString(), object[2].toString())) continue;
                        if (this.passwordPolicy.isDefaultStorageScheme(string)) {
                            hashSet.add(string);
                            linkedHashSet2.add((AttributeValue)object2);
                            continue;
                        }
                        if (this.passwordPolicy.isDeprecatedStorageScheme(string)) {
                            if (this.debug) {
                                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "handleDeprecatedStorageSchemes", "Marking password with scheme " + object[0] + " for removal from user " + "entry " + this.userDNString);
                            }
                            iterator.remove();
                            linkedHashSet.add((AttributeValue)object2);
                            continue;
                        }
                        linkedHashSet2.add((AttributeValue)object2);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "handleDeprecatedStorageSchemes", exception));
                        if (!this.debug) continue;
                        Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "handleDeprecatedStorageSchemes", "Skipping password value for user " + this.userDNString + " because an error occurred while attempting " + "to decode it based on the user password syntax:  " + StaticUtils.stackTraceToSingleLineString(exception));
                    }
                }
            }
            if (linkedHashSet.isEmpty()) {
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "handleDeprecatedStorageSchemes", "User entry " + this.userDNString + " does not have any " + "password values encoded using deprecated schemes.");
                }
            } else {
                LinkedHashSet linkedHashSet3 = new LinkedHashSet();
                for (PasswordStorageScheme passwordStorageScheme : this.passwordPolicy.getDefaultStorageSchemes()) {
                    if (hashSet.contains(StaticUtils.toLowerCase(passwordStorageScheme.getStorageSchemeName()))) continue;
                    try {
                        object2 = passwordStorageScheme.encodeAuthPassword(byteString);
                        object = new AttributeValue(attributeType, (ByteString)object2);
                        linkedHashSet3.add(object);
                        linkedHashSet2.add((AttributeValue)object);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "handleDeprecatedStorageSchemes", exception));
                        if (!this.debug) continue;
                        Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "handleDeprecatedStorageSchemes", "Unable to encode password for user " + this.userDNString + " using default scheme " + passwordStorageScheme.getStorageSchemeName() + ":  " + StaticUtils.stackTraceToSingleLineString(exception));
                    }
                }
                if (linkedHashSet2.isEmpty()) {
                    if (this.debug) {
                        Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "handleDeprecatedStorageSchemes", "Not updating user entry " + this.userDNString + " because removing deprecated schemes would leave " + "the user without a password.");
                    }
                    return;
                }
                Attribute attribute = new Attribute(attributeType, attributeType.getNameOrOID(), linkedHashSet);
                if (!this.updateEntry) {
                    this.modifications.add(new Modification(ModificationType.DELETE, attribute, true));
                }
                if (!linkedHashSet3.isEmpty()) {
                    Attribute attribute2 = new Attribute(attributeType, attributeType.getNameOrOID(), linkedHashSet3);
                    if (!this.updateEntry) {
                        this.modifications.add(new Modification(ModificationType.ADD, attribute2, true));
                    }
                }
                ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
                arrayList.add(new Attribute(attributeType, attributeType.getNameOrOID(), linkedHashSet2));
                if (this.updateEntry) {
                    this.userEntry.putAttribute(attributeType, arrayList);
                }
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "handleDeprecatedStorageSchemes", "Updating user entry " + this.userDNString + "to replace password values encoded with deprecated " + "schemes with values encoded with the default " + "schemes.");
                }
            }
        } else {
            Object object;
            Object object3;
            for (Attribute attribute : list) {
                Iterator iterator = attribute.getValues().iterator();
                while (iterator.hasNext()) {
                    object3 = (AttributeValue)iterator.next();
                    try {
                        object = UserPasswordSyntax.decodeUserPassword(((AttributeValue)object3).getStringValue());
                        PasswordStorageScheme passwordStorageScheme = DirectoryServer.getPasswordStorageScheme(object[0]);
                        if (passwordStorageScheme == null) {
                            if (!this.debug) continue;
                            Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "handleDeprecatedStorageSchemes", "Skipping password value for user " + this.userDNString + " because the associated storage " + "scheme \"" + object[0] + "\" is not configured for use.");
                            continue;
                        }
                        if (!passwordStorageScheme.passwordMatches(byteString, new ASN1OctetString(object[1]))) continue;
                        if (this.passwordPolicy.isDefaultStorageScheme(object[0])) {
                            hashSet.add(object[0]);
                            linkedHashSet2.add((AttributeValue)object3);
                            continue;
                        }
                        if (this.passwordPolicy.isDeprecatedStorageScheme(object[0])) {
                            if (this.debug) {
                                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "handleDeprecatedStorageSchemes", "Marking password with scheme " + object[0] + " for removal from user " + "entry " + this.userDNString);
                            }
                            iterator.remove();
                            linkedHashSet.add((AttributeValue)object3);
                            continue;
                        }
                        linkedHashSet2.add((AttributeValue)object3);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "handleDeprecatedStorageSchemes", exception));
                        if (!this.debug) continue;
                        Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "handleDeprecatedStorageSchemes", "Skipping password value for user " + this.userDNString + " because an error occurred while attempting " + "to decode it based on the user password syntax:  " + StaticUtils.stackTraceToSingleLineString(exception));
                    }
                }
            }
            if (linkedHashSet.isEmpty()) {
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "handleDeprecatedStorageSchemes", "User entry " + this.userDNString + " does not have any " + "password values encoded using deprecated schemes.");
                }
            } else {
                LinkedHashSet linkedHashSet4 = new LinkedHashSet();
                for (PasswordStorageScheme passwordStorageScheme : this.passwordPolicy.getDefaultStorageSchemes()) {
                    if (hashSet.contains(StaticUtils.toLowerCase(passwordStorageScheme.getStorageSchemeName()))) continue;
                    try {
                        object3 = passwordStorageScheme.encodePasswordWithScheme(byteString);
                        object = new AttributeValue(attributeType, (ByteString)object3);
                        linkedHashSet4.add(object);
                        linkedHashSet2.add((AttributeValue)object);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "handleDeprecatedStorageSchemes", exception));
                        if (!this.debug) continue;
                        Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "handleDeprecatedStorageSchemes", "Unable to encode password for user " + this.userDNString + " using default scheme " + passwordStorageScheme.getStorageSchemeName() + ":  " + StaticUtils.stackTraceToSingleLineString(exception));
                    }
                }
                if (linkedHashSet2.isEmpty()) {
                    if (this.debug) {
                        Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "handleDeprecatedStorageSchemes", "Not updating user entry " + this.userDNString + " because removing deprecated schemes would leave " + "the user without a password.");
                    }
                    return;
                }
                Attribute attribute = new Attribute(attributeType, attributeType.getNameOrOID(), linkedHashSet);
                if (!this.updateEntry) {
                    this.modifications.add(new Modification(ModificationType.DELETE, attribute, true));
                }
                if (!linkedHashSet4.isEmpty()) {
                    Attribute attribute3 = new Attribute(attributeType, attributeType.getNameOrOID(), linkedHashSet4);
                    if (!this.updateEntry) {
                        this.modifications.add(new Modification(ModificationType.ADD, attribute3, true));
                    }
                }
                ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
                arrayList.add(new Attribute(attributeType, attributeType.getNameOrOID(), linkedHashSet2));
                if (this.updateEntry) {
                    this.userEntry.putAttribute(attributeType, arrayList);
                }
                if (this.debug) {
                    Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.INFO, CLASS_NAME, "handleDeprecatedStorageSchemes", "Updating user entry " + this.userDNString + "to replace password values encoded with deprecated " + "schemes with values encoded with the default " + "schemes.");
                }
            }
        }
    }

    public ByteString generatePassword() throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "generatePassword", new String[0]));
        PasswordGenerator passwordGenerator = this.passwordPolicy.getPasswordGenerator();
        if (passwordGenerator == null) {
            if (this.debug) {
                Debug.debugMessage(DebugLogCategory.PASSWORD_POLICY, DebugLogSeverity.WARNING, CLASS_NAME, "generatePassword", "Unable to generate a new password for user " + this.userDNString + " because no password generator has been " + "defined in the associated password policy.");
            }
            return null;
        }
        return passwordGenerator.generatePassword(this.userEntry);
    }

    public void generateAccountStatusNotification(AccountStatusNotificationType accountStatusNotificationType, DN dN, int n, String string) {
        assert (Debug.debugEnter(CLASS_NAME, "generateAccountStatusNotification", String.valueOf((Object)accountStatusNotificationType), String.valueOf(dN), String.valueOf(n), String.valueOf(string)));
        Collection<AccountStatusNotificationHandler> collection = this.passwordPolicy.getAccountStatusNotificationHandlers().values();
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (AccountStatusNotificationHandler accountStatusNotificationHandler : collection) {
            accountStatusNotificationHandler.handleStatusNotification(accountStatusNotificationType, dN, n, string);
        }
    }

    public void generateAccountStatusNotification(AccountStatusNotification accountStatusNotification) {
        assert (Debug.debugEnter(CLASS_NAME, "generateAccountStatusNotification", String.valueOf(accountStatusNotification)));
        Collection<AccountStatusNotificationHandler> collection = this.passwordPolicy.getAccountStatusNotificationHandlers().values();
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (AccountStatusNotificationHandler accountStatusNotificationHandler : collection) {
            accountStatusNotificationHandler.handleStatusNotification(accountStatusNotification);
        }
    }

    public void updateUserEntry() throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "updateUserEntry", new String[0]));
        if (this.modifications.isEmpty()) {
            return;
        }
        ArrayList<LDAPModification> arrayList = new ArrayList<LDAPModification>();
        for (Modification object2 : this.modifications) {
            arrayList.add(new LDAPModification(object2.getModificationType(), new LDAPAttribute(object2.getAttribute())));
        }
        InternalClientConnection internalClientConnection = InternalClientConnection.getRootConnection();
        ModifyOperation modifyOperation = internalClientConnection.processModify(new ASN1OctetString(this.userDNString), arrayList);
        ResultCode resultCode = modifyOperation.getResultCode();
        if (resultCode != ResultCode.SUCCESS) {
            int n = 197130;
            String string = MessageHandler.getMessage(n, this.userDNString, String.valueOf(modifyOperation.getErrorMessage()));
            throw new DirectoryException(resultCode, string, n);
        }
    }
}

