/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opends.server.api.AccountStatusNotificationHandler;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.PasswordGenerator;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.api.PasswordValidator;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.config.IntegerConfigAttribute;
import org.opends.server.config.IntegerWithUnitConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ResultCode;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordPolicy
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.core.PasswordPolicy";
    private AttributeType lastLoginTimeAttribute;
    private AttributeType passwordAttribute;
    private boolean allowExpiredPasswordChanges;
    private boolean allowMultiplePasswordValues;
    private boolean allowPreEncodedPasswords;
    private boolean allowUserPasswordChanges;
    private boolean authPasswordSyntax;
    private boolean expirePasswordsWithoutWarning;
    private boolean forceChangeOnAdd;
    private boolean forceChangeOnReset;
    private boolean requireCurrentPassword;
    private boolean requireSecureAuthentication;
    private boolean requireSecurePasswordChanges;
    private boolean skipValidationForAdministrators;
    private ConcurrentHashMap<DN, AccountStatusNotificationHandler> notificationHandlers;
    private ConcurrentHashMap<DN, PasswordValidator> passwordValidators;
    private CopyOnWriteArrayList<PasswordStorageScheme> defaultStorageSchemes;
    private CopyOnWriteArrayList<String> previousLastLoginTimeFormats;
    private CopyOnWriteArraySet<String> deprecatedStorageSchemes;
    private DN configEntryDN;
    private DN passwordGeneratorDN;
    private int graceLoginCount;
    private int idleLockoutInterval;
    private int lockoutDuration;
    private int lockoutFailureCount;
    private int lockoutFailureExpirationInterval;
    private int maximumPasswordAge;
    private int maximumPasswordResetAge;
    private int minimumPasswordAge;
    private int warningInterval;
    private long requireChangeByTime;
    private PasswordGenerator passwordGenerator;
    private String lastLoginTimeFormat;

    private PasswordPolicy() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.configEntryDN = null;
        this.passwordAttribute = null;
        this.authPasswordSyntax = false;
        this.lastLoginTimeAttribute = null;
        this.allowExpiredPasswordChanges = false;
        this.allowMultiplePasswordValues = false;
        this.allowPreEncodedPasswords = false;
        this.allowUserPasswordChanges = true;
        this.expirePasswordsWithoutWarning = false;
        this.forceChangeOnAdd = false;
        this.forceChangeOnReset = false;
        this.requireCurrentPassword = false;
        this.requireSecureAuthentication = false;
        this.requireSecurePasswordChanges = false;
        this.skipValidationForAdministrators = false;
        this.graceLoginCount = 0;
        this.idleLockoutInterval = 0;
        this.lockoutDuration = 0;
        this.lockoutFailureCount = 0;
        this.lockoutFailureExpirationInterval = 0;
        this.minimumPasswordAge = 0;
        this.maximumPasswordAge = 0;
        this.maximumPasswordResetAge = 0;
        this.warningInterval = 604800;
        this.requireChangeByTime = -1L;
        this.lastLoginTimeFormat = null;
        this.passwordGenerator = null;
        this.passwordGeneratorDN = null;
        this.notificationHandlers = new ConcurrentHashMap();
        this.defaultStorageSchemes = new CopyOnWriteArrayList();
        PasswordStorageScheme passwordStorageScheme = DirectoryServer.getPasswordStorageScheme("SSHA");
        if (passwordStorageScheme != null) {
            this.defaultStorageSchemes.add(passwordStorageScheme);
        }
        this.deprecatedStorageSchemes = new CopyOnWriteArraySet();
        this.passwordValidators = new ConcurrentHashMap();
        this.previousLastLoginTimeFormats = new CopyOnWriteArrayList();
    }

    public PasswordPolicy(ConfigEntry configEntry) throws ConfigException, InitializationException {
        this();
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(configEntry)));
        this.configEntryDN = configEntry.getDN();
        PasswordPolicy.initializePasswordPolicyConfig(configEntry, this);
        if (this.passwordAttribute == null) {
            int n = 262566;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
            throw new ConfigException(n, string);
        }
        if (this.defaultStorageSchemes.isEmpty()) {
            int n = 262567;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
            throw new ConfigException(n, string);
        }
        DirectoryServer.registerConfigurableComponent(this);
    }

    private static void initializePasswordPolicyConfig(ConfigEntry configEntry, PasswordPolicy passwordPolicy) throws ConfigException, InitializationException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        LinkedHashMap<String, Double> linkedHashMap;
        DN dN;
        block151: {
            Object object5;
            StringConfigAttribute stringConfigAttribute;
            ConfigAttribute configAttribute;
            IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute;
            ConfigAttribute configAttribute2;
            IntegerConfigAttribute integerConfigAttribute;
            ConfigAttribute configAttribute3;
            Object object6;
            ConfigAttribute configAttribute4;
            IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute2;
            IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute3;
            IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute4;
            ConfigAttribute configAttribute5;
            BooleanConfigAttribute booleanConfigAttribute;
            BooleanConfigAttribute booleanConfigAttribute2;
            Object object7;
            ConfigAttribute configAttribute6;
            ConfigAttribute configAttribute7;
            Object object8;
            Object object9;
            Object object13;
            Object object14;
            Object object15;
            StringConfigAttribute stringConfigAttribute2;
            block150: {
                assert (Debug.debugEnter(CLASS_NAME, "initializePasswordPolicyConfig", String.valueOf(configEntry)));
                dN = configEntry.getDN();
                linkedHashMap = new LinkedHashMap<String, Double>();
                linkedHashMap.put("s", 1.0);
                linkedHashMap.put("seconds", 1.0);
                linkedHashMap.put("m", 60.0);
                linkedHashMap.put("minutes", 60.0);
                linkedHashMap.put("h", 3600.0);
                linkedHashMap.put("hours", 3600.0);
                linkedHashMap.put("d", 86400.0);
                linkedHashMap.put("days", 86400.0);
                linkedHashMap.put("w", 604800.0);
                linkedHashMap.put("weeks", 604800.0);
                n = 424;
                StringConfigAttribute stringConfigAttribute3 = new StringConfigAttribute("ds-cfg-password-attribute", MessageHandler.getMessage(n), false, false, false);
                try {
                    stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute3);
                    if (stringConfigAttribute2 == null) {
                        n = 262566;
                        String string = MessageHandler.getMessage(n, String.valueOf(dN));
                        throw new ConfigException(n, string);
                    }
                    object15 = StaticUtils.toLowerCase(stringConfigAttribute2.pendingValue());
                    object14 = DirectoryServer.getAttributeType((String)object15);
                    if (object14 == null) {
                        n = 262569;
                        String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(stringConfigAttribute2.pendingValue()));
                        throw new ConfigException(n, string);
                    }
                    object13 = ((AttributeType)object14).getSyntaxOID();
                    if (((String)object13).equals("1.3.6.1.4.1.4203.1.1.2")) {
                        passwordPolicy.passwordAttribute = object14;
                        passwordPolicy.authPasswordSyntax = true;
                        break block150;
                    }
                    if (((String)object13).equals("1.3.6.1.4.1.26027.1.3.1")) {
                        passwordPolicy.passwordAttribute = object14;
                        passwordPolicy.authPasswordSyntax = false;
                        break block150;
                    }
                    String string = ((AttributeType)object14).getSyntax().getSyntaxName();
                    if (string == null || string.length() == 0) {
                        String object122 = object13;
                    }
                    n = 262570;
                    String string2 = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(stringConfigAttribute2.pendingValue()), String.valueOf(object13));
                    throw new ConfigException(n, string2);
                }
                catch (ConfigException configException) {
                    throw configException;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                    n = 262571;
                    String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                    throw new InitializationException(n, string, exception);
                }
            }
            n = 428;
            stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-default-password-storage-scheme", MessageHandler.getMessage(n), false, true, false);
            try {
                object15 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute2);
                if (object15 == null) {
                    n = 262567;
                    object14 = MessageHandler.getMessage(n, String.valueOf(dN));
                    throw new ConfigException(n, (String)object14);
                }
                object14 = new LinkedList();
                for (String configException : ((StringConfigAttribute)object15).pendingValues()) {
                    object9 = passwordPolicy.authPasswordSyntax ? DirectoryServer.getAuthPasswordStorageScheme(configException) : DirectoryServer.getPasswordStorageScheme(StaticUtils.toLowerCase(configException));
                    if (object9 == null) {
                        n = 262573;
                        String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(configException));
                        throw new ConfigException(n, string);
                    }
                    ((LinkedList)object14).add(object9);
                }
                passwordPolicy.defaultStorageSchemes = new CopyOnWriteArrayList(object14);
            }
            catch (ConfigException configException) {
                throw configException;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262574;
                object14 = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, (String)object14, exception);
            }
            n = 431;
            object15 = new StringConfigAttribute("ds-cfg-deprecated-password-storage-scheme", MessageHandler.getMessage(n), false, true, false);
            try {
                object14 = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object15);
                if (object14 != null) {
                    passwordPolicy.deprecatedStorageSchemes = new CopyOnWriteArraySet<String>(((StringConfigAttribute)object14).pendingValues());
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262576;
                object13 = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, (String)object13, exception);
            }
            n = 433;
            object14 = new DNConfigAttribute("ds-cfg-password-validator-dn", MessageHandler.getMessage(n), false, true, false);
            try {
                object13 = (DNConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object14);
                if (object13 != null) {
                    ConcurrentHashMap<DN, PasswordValidator> exception = new ConcurrentHashMap<DN, PasswordValidator>();
                    for (DN dN2 : ((DNConfigAttribute)object13).pendingValues()) {
                        PasswordValidator passwordValidator = DirectoryServer.getPasswordValidator(dN2);
                        if (passwordValidator == null) {
                            n = 262578;
                            String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(dN2));
                            throw new ConfigException(n, string);
                        }
                        exception.put(dN2, passwordValidator);
                    }
                    passwordPolicy.passwordValidators = exception;
                }
            }
            catch (ConfigException configException) {
                throw configException;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262579;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            n = 436;
            object13 = new DNConfigAttribute("ds-cfg-account-status-notification-handler-dn", MessageHandler.getMessage(n), false, true, false);
            try {
                DNConfigAttribute dNConfigAttribute = (DNConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object13);
                if (dNConfigAttribute != null) {
                    object9 = new ConcurrentHashMap();
                    for (DN dN3 : dNConfigAttribute.pendingValues()) {
                        object8 = DirectoryServer.getAccountStatusNotificationHandler(dN3);
                        if (object8 == null) {
                            n = 262581;
                            String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(dN3));
                            throw new ConfigException(n, string);
                        }
                        ((ConcurrentHashMap)object9).put(dN3, object8);
                    }
                    passwordPolicy.notificationHandlers = object9;
                }
            }
            catch (ConfigException configException) {
                throw configException;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262582;
                object9 = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, (String)object9, exception);
            }
            n = 439;
            BooleanConfigAttribute booleanConfigAttribute3 = new BooleanConfigAttribute("ds-cfg-allow-user-password-changes", MessageHandler.getMessage(n), false);
            try {
                object9 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute3);
                if (object9 != null) {
                    passwordPolicy.allowUserPasswordChanges = ((BooleanConfigAttribute)object9).pendingValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262584;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            n = 441;
            object9 = new BooleanConfigAttribute("ds-cfg-password-change-requires-current-password", MessageHandler.getMessage(n), false);
            try {
                BooleanConfigAttribute booleanConfigAttribute4 = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object9);
                if (booleanConfigAttribute4 != null) {
                    passwordPolicy.requireCurrentPassword = booleanConfigAttribute4.pendingValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262586;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            n = 492;
            BooleanConfigAttribute booleanConfigAttribute5 = new BooleanConfigAttribute("ds-cfg-force-change-on-add", MessageHandler.getMessage(n), false);
            try {
                BooleanConfigAttribute booleanConfigAttribute6 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute5);
                if (booleanConfigAttribute6 != null) {
                    passwordPolicy.forceChangeOnAdd = booleanConfigAttribute6.pendingValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262637;
                object8 = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, (String)object8, exception);
            }
            n = 443;
            BooleanConfigAttribute booleanConfigAttribute7 = new BooleanConfigAttribute("ds-cfg-force-change-on-reset", MessageHandler.getMessage(n), false);
            try {
                object8 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute7);
                if (object8 != null) {
                    passwordPolicy.forceChangeOnReset = ((BooleanConfigAttribute)object8).pendingValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262588;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            n = 445;
            object8 = new BooleanConfigAttribute("ds-cfg-skip-validation-for-administrators", MessageHandler.getMessage(n), false);
            try {
                configAttribute7 = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object8);
                if (configAttribute7 != null) {
                    passwordPolicy.skipValidationForAdministrators = configAttribute7.pendingValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262590;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            n = 447;
            configAttribute7 = new DNConfigAttribute("ds-cfg-password-generator-dn", MessageHandler.getMessage(n), false, false, false);
            try {
                configAttribute6 = (DNConfigAttribute)configEntry.getConfigAttribute(configAttribute7);
                if (configAttribute6 != null) {
                    object7 = DirectoryServer.getPasswordGenerator(((DNConfigAttribute)configAttribute6).pendingValue());
                    if (object7 == null) {
                        n = 262592;
                        String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(((DNConfigAttribute)configAttribute6).pendingValue()));
                        throw new ConfigException(n, string);
                    }
                    passwordPolicy.passwordGeneratorDN = ((DNConfigAttribute)configAttribute6).pendingValue();
                    passwordPolicy.passwordGenerator = object7;
                }
            }
            catch (ConfigException configException) {
                throw configException;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262593;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            n = 450;
            configAttribute6 = new BooleanConfigAttribute("ds-cfg-require-secure-authentication", MessageHandler.getMessage(n), false);
            try {
                object7 = (BooleanConfigAttribute)configEntry.getConfigAttribute(configAttribute6);
                if (object7 != null) {
                    passwordPolicy.requireSecureAuthentication = ((BooleanConfigAttribute)object7).pendingValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262595;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            n = 452;
            object7 = new BooleanConfigAttribute("ds-cfg-require-secure-password-changes", MessageHandler.getMessage(n), false);
            try {
                booleanConfigAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object7);
                if (booleanConfigAttribute2 != null) {
                    passwordPolicy.requireSecurePasswordChanges = booleanConfigAttribute2.pendingValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262597;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            n = 494;
            booleanConfigAttribute2 = new BooleanConfigAttribute("ds-cfg-allow-multiple-password-values", MessageHandler.getMessage(n), false);
            try {
                booleanConfigAttribute = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute2);
                if (booleanConfigAttribute != null) {
                    passwordPolicy.allowMultiplePasswordValues = booleanConfigAttribute.pendingValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262639;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            n = 454;
            booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-allow-pre-encoded-passwords", MessageHandler.getMessage(n), false);
            try {
                configAttribute5 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
                if (configAttribute5 != null) {
                    passwordPolicy.allowPreEncodedPasswords = configAttribute5.pendingValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262599;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            n = 456;
            configAttribute5 = new IntegerWithUnitConfigAttribute("ds-cfg-minimum-password-age", MessageHandler.getMessage(n), false, linkedHashMap, true, 0L, true, Integer.MAX_VALUE);
            try {
                integerWithUnitConfigAttribute4 = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(configAttribute5);
                if (integerWithUnitConfigAttribute4 != null) {
                    passwordPolicy.minimumPasswordAge = (int)integerWithUnitConfigAttribute4.pendingCalculatedValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262601;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            n = 458;
            integerWithUnitConfigAttribute4 = new IntegerWithUnitConfigAttribute("ds-cfg-maximum-password-age", MessageHandler.getMessage(n), false, linkedHashMap, true, 0L, true, Integer.MAX_VALUE);
            try {
                integerWithUnitConfigAttribute3 = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(integerWithUnitConfigAttribute4);
                if (integerWithUnitConfigAttribute3 != null) {
                    passwordPolicy.maximumPasswordAge = (int)integerWithUnitConfigAttribute3.pendingCalculatedValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262603;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            n = 460;
            integerWithUnitConfigAttribute3 = new IntegerWithUnitConfigAttribute("ds-cfg-maximum-password-reset-age", MessageHandler.getMessage(n), false, linkedHashMap, true, 0L, true, Integer.MAX_VALUE);
            try {
                integerWithUnitConfigAttribute2 = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(integerWithUnitConfigAttribute3);
                if (integerWithUnitConfigAttribute2 != null) {
                    passwordPolicy.maximumPasswordResetAge = (int)integerWithUnitConfigAttribute2.pendingCalculatedValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262605;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            n = 462;
            integerWithUnitConfigAttribute2 = new IntegerWithUnitConfigAttribute("ds-cfg-password-expiration-warning-interval", MessageHandler.getMessage(n), false, linkedHashMap, true, 0L, true, Integer.MAX_VALUE);
            try {
                configAttribute4 = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(integerWithUnitConfigAttribute2);
                if (configAttribute4 != null) {
                    passwordPolicy.warningInterval = (int)configAttribute4.pendingCalculatedValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262607;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            n = 464;
            configAttribute4 = new BooleanConfigAttribute("ds-cfg-expire-passwords-without-warning", MessageHandler.getMessage(n), false);
            try {
                object6 = (BooleanConfigAttribute)configEntry.getConfigAttribute(configAttribute4);
                if (object6 != null) {
                    passwordPolicy.expirePasswordsWithoutWarning = ((BooleanConfigAttribute)object6).pendingValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262609;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            if (!passwordPolicy.expirePasswordsWithoutWarning() && passwordPolicy.getWarningInterval() <= 0) {
                n = 262644;
                object6 = MessageHandler.getMessage(n, String.valueOf(dN));
                throw new ConfigException(n, (String)object6);
            }
            n = 466;
            object6 = new BooleanConfigAttribute("ds-cfg-allow-expired-password-changes", MessageHandler.getMessage(n), false);
            try {
                configAttribute3 = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object6);
                if (configAttribute3 != null) {
                    passwordPolicy.allowExpiredPasswordChanges = configAttribute3.pendingValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262611;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            n = 468;
            configAttribute3 = new IntegerConfigAttribute("ds-cfg-grace-login-count", MessageHandler.getMessage(n), false, false, false, true, 0L, true, Integer.MAX_VALUE);
            try {
                integerConfigAttribute = (IntegerConfigAttribute)configEntry.getConfigAttribute(configAttribute3);
                if (integerConfigAttribute != null) {
                    passwordPolicy.graceLoginCount = integerConfigAttribute.pendingIntValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262613;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            n = 470;
            integerConfigAttribute = new IntegerConfigAttribute("ds-cfg-lockout-failure-count", MessageHandler.getMessage(n), false, false, false, true, 0L, true, Integer.MAX_VALUE);
            try {
                configAttribute2 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute);
                if (configAttribute2 != null) {
                    passwordPolicy.lockoutFailureCount = configAttribute2.pendingIntValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262615;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            n = 472;
            configAttribute2 = new IntegerWithUnitConfigAttribute("ds-cfg-lockout-duration", MessageHandler.getMessage(n), false, linkedHashMap, true, 0L, true, Integer.MAX_VALUE);
            try {
                integerWithUnitConfigAttribute = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(configAttribute2);
                if (integerWithUnitConfigAttribute != null) {
                    passwordPolicy.lockoutDuration = (int)integerWithUnitConfigAttribute.pendingCalculatedValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262617;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            n = 474;
            integerWithUnitConfigAttribute = new IntegerWithUnitConfigAttribute("ds-cfg-lockout-failure-expiration-interval", MessageHandler.getMessage(n), false, linkedHashMap, true, 0L, true, Integer.MAX_VALUE);
            try {
                configAttribute = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(integerWithUnitConfigAttribute);
                if (configAttribute != null) {
                    passwordPolicy.lockoutFailureExpirationInterval = (int)configAttribute.pendingCalculatedValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262619;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            n = 476;
            configAttribute = new StringConfigAttribute("ds-cfg-require-change-by-time", MessageHandler.getMessage(n), false, false, false);
            try {
                stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(configAttribute);
                if (stringConfigAttribute != null) {
                    object5 = new ASN1OctetString(stringConfigAttribute.pendingValue());
                    object4 = (GeneralizedTimeSyntax)DirectoryServer.getAttributeSyntax("1.3.6.1.4.1.1466.115.121.1.24", false);
                    if (object4 == null) {
                        passwordPolicy.requireChangeByTime = GeneralizedTimeSyntax.decodeGeneralizedTimeValue((ByteString)object5);
                    } else {
                        object5 = ((GeneralizedTimeSyntax)object4).getEqualityMatchingRule().normalizeValue((ByteString)object5);
                        passwordPolicy.requireChangeByTime = GeneralizedTimeSyntax.decodeGeneralizedTimeValue((ByteString)object5);
                    }
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262621;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
            n = 478;
            stringConfigAttribute = new StringConfigAttribute("ds-cfg-last-login-time-attribute", MessageHandler.getMessage(n), false, false, false);
            try {
                object5 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                if (object5 != null) {
                    object4 = StaticUtils.toLowerCase(((StringConfigAttribute)object5).pendingValue());
                    object3 = DirectoryServer.getAttributeType((String)object4);
                    if (object3 == null) {
                        n = 262623;
                        String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(((StringConfigAttribute)object5).pendingValue()));
                        throw new ConfigException(n, string);
                    }
                    passwordPolicy.lastLoginTimeAttribute = object3;
                }
            }
            catch (ConfigException configException) {
                throw configException;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262624;
                object4 = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, (String)object4, exception);
            }
            n = 481;
            object5 = new StringConfigAttribute("ds-cfg-last-login-time-format", MessageHandler.getMessage(n), false, false, false);
            try {
                object4 = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object5);
                if (object4 == null) break block151;
                object3 = ((StringConfigAttribute)object4).pendingValue();
                try {
                    object2 = new SimpleDateFormat((String)object3);
                    passwordPolicy.lastLoginTimeFormat = object3;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                    n = 262626;
                    String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(object3));
                    throw new ConfigException(n, string);
                }
            }
            catch (ConfigException configException) {
                throw configException;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                n = 262627;
                object3 = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, (String)object3, exception);
            }
        }
        n = 484;
        object4 = new StringConfigAttribute("ds-cfg-previous-last-login-time-format", MessageHandler.getMessage(n), false, true, false);
        try {
            object3 = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object4);
            if (object3 != null) {
                object2 = ((StringConfigAttribute)object3).pendingValues();
                object = object2.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
                        n = 262629;
                        String string3 = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(string));
                        throw new ConfigException(n, string3);
                    }
                }
                passwordPolicy.previousLastLoginTimeFormats = new CopyOnWriteArrayList(object2);
            }
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
            n = 262630;
            object2 = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, (String)object2, exception);
        }
        n = 487;
        object3 = new IntegerWithUnitConfigAttribute("ds-cfg-idle-lockout-interval", MessageHandler.getMessage(n), false, linkedHashMap, true, 0L, true, Integer.MAX_VALUE);
        try {
            object2 = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object3);
            if (object2 != null) {
                passwordPolicy.idleLockoutInterval = (int)((IntegerWithUnitConfigAttribute)object2).pendingCalculatedValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializePasswordPolicyConfig", exception));
            n = 262632;
            object = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, (String)object, exception);
        }
    }

    public AttributeType getPasswordAttribute() {
        assert (Debug.debugEnter(CLASS_NAME, "getPasswordAttribute", new String[0]));
        return this.passwordAttribute;
    }

    public boolean usesAuthPasswordSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "usesAuthPasswordSyntax", new String[0]));
        return this.authPasswordSyntax;
    }

    public CopyOnWriteArrayList<PasswordStorageScheme> getDefaultStorageSchemes() {
        assert (Debug.debugEnter(CLASS_NAME, "getDefaultStorageSchemes", new String[0]));
        return this.defaultStorageSchemes;
    }

    public boolean isDefaultStorageScheme(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "isDefaultStorageScheme", String.valueOf(string)));
        CopyOnWriteArrayList<PasswordStorageScheme> copyOnWriteArrayList = this.getDefaultStorageSchemes();
        if (copyOnWriteArrayList == null) {
            return false;
        }
        for (PasswordStorageScheme passwordStorageScheme : copyOnWriteArrayList) {
            if (!(this.authPasswordSyntax ? passwordStorageScheme.getAuthPasswordSchemeName().equalsIgnoreCase(string) : passwordStorageScheme.getStorageSchemeName().equalsIgnoreCase(string))) continue;
            return true;
        }
        return false;
    }

    public CopyOnWriteArraySet<String> getDeprecatedStorageSchemes() {
        assert (Debug.debugEnter(CLASS_NAME, "getDeprecatedStorageSchemes", new String[0]));
        return this.deprecatedStorageSchemes;
    }

    public boolean isDeprecatedStorageScheme(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "isDeprecatedStorageScheme", String.valueOf(string)));
        CopyOnWriteArraySet<String> copyOnWriteArraySet = this.getDeprecatedStorageSchemes();
        if (copyOnWriteArraySet == null) {
            return false;
        }
        for (String string2 : copyOnWriteArraySet) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public ConcurrentHashMap<DN, PasswordValidator> getPasswordValidators() {
        assert (Debug.debugEnter(CLASS_NAME, "getPasswordValidators", new String[0]));
        return this.passwordValidators;
    }

    public ConcurrentHashMap<DN, AccountStatusNotificationHandler> getAccountStatusNotificationHandlers() {
        assert (Debug.debugEnter(CLASS_NAME, "getAccountStatusNotificationHandlers", new String[0]));
        return this.notificationHandlers;
    }

    public boolean allowUserPasswordChanges() {
        assert (Debug.debugEnter(CLASS_NAME, "allowUserPasswordChanges", new String[0]));
        return this.allowUserPasswordChanges;
    }

    public boolean requireCurrentPassword() {
        assert (Debug.debugEnter(CLASS_NAME, "requireCurrentPassword", new String[0]));
        return this.requireCurrentPassword;
    }

    public boolean forceChangeOnAdd() {
        assert (Debug.debugEnter(CLASS_NAME, "forceChangeOnAdd", new String[0]));
        return this.forceChangeOnAdd;
    }

    public boolean forceChangeOnReset() {
        assert (Debug.debugEnter(CLASS_NAME, "forceChangeOnReset", new String[0]));
        return this.forceChangeOnReset;
    }

    public boolean skipValidationForAdministrators() {
        assert (Debug.debugEnter(CLASS_NAME, "skipValidationForAdministrators", new String[0]));
        return this.skipValidationForAdministrators;
    }

    public DN getPasswordGeneratorDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getPasswordGeneratorDN", new String[0]));
        return this.passwordGeneratorDN;
    }

    public PasswordGenerator getPasswordGenerator() {
        assert (Debug.debugEnter(CLASS_NAME, "getPasswordGenerator", new String[0]));
        return this.passwordGenerator;
    }

    public boolean requireSecureAuthentication() {
        assert (Debug.debugEnter(CLASS_NAME, "requireSecureAuthentication", new String[0]));
        return this.requireSecureAuthentication;
    }

    public boolean requireSecurePasswordChanges() {
        assert (Debug.debugEnter(CLASS_NAME, "requireSecurePasswordChanges", new String[0]));
        return this.requireSecurePasswordChanges;
    }

    public boolean allowMultiplePasswordValues() {
        assert (Debug.debugEnter(CLASS_NAME, "allowMultiplePasswordValues", new String[0]));
        return this.allowMultiplePasswordValues;
    }

    public boolean allowPreEncodedPasswords() {
        assert (Debug.debugEnter(CLASS_NAME, "allowPreEncodedPasswords", new String[0]));
        return this.allowPreEncodedPasswords;
    }

    public int getMinimumPasswordAge() {
        assert (Debug.debugEnter(CLASS_NAME, "getMinimumPasswordAge", new String[0]));
        if (this.minimumPasswordAge <= 0) {
            return 0;
        }
        return this.minimumPasswordAge;
    }

    public int getMaximumPasswordAge() {
        assert (Debug.debugEnter(CLASS_NAME, "getMaximumPasswordAge", new String[0]));
        if (this.maximumPasswordAge < 0) {
            return 0;
        }
        return this.maximumPasswordAge;
    }

    public int getMaximumPasswordResetAge() {
        assert (Debug.debugEnter(CLASS_NAME, "getMaximumPasswordResetAge", new String[0]));
        if (this.maximumPasswordResetAge < 0) {
            return 0;
        }
        return this.maximumPasswordResetAge;
    }

    public int getWarningInterval() {
        assert (Debug.debugEnter(CLASS_NAME, "getWarningInterval", new String[0]));
        if (this.warningInterval < 0) {
            return 0;
        }
        return this.warningInterval;
    }

    public boolean expirePasswordsWithoutWarning() {
        assert (Debug.debugEnter(CLASS_NAME, "expirePasswordsWithoutWarning", new String[0]));
        return this.expirePasswordsWithoutWarning;
    }

    public boolean allowExpiredPasswordChanges() {
        assert (Debug.debugEnter(CLASS_NAME, "allowExpiredPasswordChanges", new String[0]));
        return this.allowExpiredPasswordChanges;
    }

    public int getGraceLoginCount() {
        assert (Debug.debugEnter(CLASS_NAME, "getGraceLoginCount", new String[0]));
        if (this.graceLoginCount < 0) {
            return 0;
        }
        return this.graceLoginCount;
    }

    public int getLockoutFailureCount() {
        assert (Debug.debugEnter(CLASS_NAME, "getLockoutFailureCount", new String[0]));
        if (this.lockoutFailureCount < 0) {
            return 0;
        }
        return this.lockoutFailureCount;
    }

    public int getLockoutDuration() {
        assert (Debug.debugEnter(CLASS_NAME, "getLockoutDuration", new String[0]));
        if (this.lockoutDuration < 0) {
            return 0;
        }
        return this.lockoutDuration;
    }

    public int getLockoutFailureExpirationInterval() {
        assert (Debug.debugEnter(CLASS_NAME, "getLockoutFailureExpirationInterval", new String[0]));
        if (this.lockoutFailureExpirationInterval < 0) {
            return 0;
        }
        return this.lockoutFailureExpirationInterval;
    }

    public long getRequireChangeByTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getRequireChangeTime", new String[0]));
        if (this.requireChangeByTime < 0L) {
            return 0L;
        }
        return this.requireChangeByTime;
    }

    public AttributeType getLastLoginTimeAttribute() {
        assert (Debug.debugEnter(CLASS_NAME, "getLastLoginTimeAttribute", new String[0]));
        return this.lastLoginTimeAttribute;
    }

    public String getLastLoginTimeFormat() {
        assert (Debug.debugEnter(CLASS_NAME, "getLastLoginTimeFormat", new String[0]));
        return this.lastLoginTimeFormat;
    }

    public CopyOnWriteArrayList<String> getPreviousLastLoginTimeFormats() {
        assert (Debug.debugEnter(CLASS_NAME, "getPreviousLastLoginTimeFormats", new String[0]));
        return this.previousLastLoginTimeFormats;
    }

    public int getIdleLockoutInterval() {
        assert (Debug.debugEnter(CLASS_NAME, "getIdleLockoutInterval", new String[0]));
        if (this.idleLockoutInterval < 0) {
            return 0;
        }
        return this.idleLockoutInterval;
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedHashMap<String, Double> linkedHashMap = new LinkedHashMap<String, Double>();
        linkedHashMap.put("s", 1.0);
        linkedHashMap.put("seconds", 1.0);
        linkedHashMap.put("m", 60.0);
        linkedHashMap.put("minutes", 60.0);
        linkedHashMap.put("h", 3600.0);
        linkedHashMap.put("hours", 3600.0);
        linkedHashMap.put("d", 86400.0);
        linkedHashMap.put("days", 86400.0);
        linkedHashMap.put("w", 604800.0);
        linkedHashMap.put("weeks", 604800.0);
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        int n = 424;
        String string = this.passwordAttribute == null ? null : this.passwordAttribute.getNameOrOID();
        linkedList.add(new StringConfigAttribute("ds-cfg-password-attribute", MessageHandler.getMessage(n), false, false, false, string));
        n = 428;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.defaultStorageSchemes != null) {
            for (PasswordStorageScheme object2 : this.defaultStorageSchemes) {
                arrayList.add(object2.getStorageSchemeName());
            }
        }
        linkedList.add(new StringConfigAttribute("ds-cfg-default-password-storage-scheme", MessageHandler.getMessage(n), false, true, false, arrayList));
        n = 431;
        arrayList = new ArrayList();
        if (this.deprecatedStorageSchemes != null) {
            arrayList.addAll(this.deprecatedStorageSchemes);
        }
        linkedList.add(new StringConfigAttribute("ds-cfg-deprecated-password-storage-scheme", MessageHandler.getMessage(n), false, true, false, arrayList));
        n = 433;
        ArrayList arrayList2 = new ArrayList();
        if (this.passwordValidators != null) {
            arrayList2.addAll(this.passwordValidators.keySet());
        }
        linkedList.add(new DNConfigAttribute("ds-cfg-password-validator-dn", MessageHandler.getMessage(n), false, true, false, arrayList2));
        n = 436;
        ArrayList<DN> arrayList3 = new ArrayList<DN>();
        if (this.notificationHandlers != null) {
            arrayList3.addAll(this.notificationHandlers.keySet());
        }
        linkedList.add(new DNConfigAttribute("ds-cfg-account-status-notification-handler-dn", MessageHandler.getMessage(n), false, true, false, arrayList3));
        n = 439;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-allow-user-password-changes", MessageHandler.getMessage(n), false, this.allowUserPasswordChanges));
        n = 441;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-password-change-requires-current-password", MessageHandler.getMessage(n), false, this.requireCurrentPassword));
        n = 492;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-force-change-on-add", MessageHandler.getMessage(n), false, this.forceChangeOnAdd));
        n = 443;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-force-change-on-reset", MessageHandler.getMessage(n), false, this.forceChangeOnReset));
        n = 445;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-skip-validation-for-administrators", MessageHandler.getMessage(n), false, this.skipValidationForAdministrators));
        n = 447;
        linkedList.add(new DNConfigAttribute("ds-cfg-password-generator-dn", MessageHandler.getMessage(n), false, false, false, this.passwordGeneratorDN));
        n = 450;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-require-secure-authentication", MessageHandler.getMessage(n), false, this.requireSecureAuthentication));
        n = 452;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-require-secure-password-changes", MessageHandler.getMessage(n), false, this.requireSecurePasswordChanges));
        n = 494;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-allow-multiple-password-values", MessageHandler.getMessage(n), false, this.allowMultiplePasswordValues));
        n = 454;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-allow-pre-encoded-passwords", MessageHandler.getMessage(n), false, this.allowPreEncodedPasswords));
        n = 456;
        linkedList.add(new IntegerWithUnitConfigAttribute("ds-cfg-minimum-password-age", MessageHandler.getMessage(n), false, linkedHashMap, true, 0L, true, Integer.MAX_VALUE, this.minimumPasswordAge, "seconds"));
        n = 458;
        linkedList.add(new IntegerWithUnitConfigAttribute("ds-cfg-maximum-password-age", MessageHandler.getMessage(n), false, linkedHashMap, true, 0L, true, Integer.MAX_VALUE, this.maximumPasswordAge, "seconds"));
        n = 460;
        linkedList.add(new IntegerWithUnitConfigAttribute("ds-cfg-maximum-password-reset-age", MessageHandler.getMessage(n), false, linkedHashMap, true, 0L, true, Integer.MAX_VALUE, this.maximumPasswordResetAge, "seconds"));
        n = 462;
        linkedList.add(new IntegerWithUnitConfigAttribute("ds-cfg-password-expiration-warning-interval", MessageHandler.getMessage(n), false, linkedHashMap, true, 0L, true, Integer.MAX_VALUE, this.warningInterval, "seconds"));
        n = 464;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-expire-passwords-without-warning", MessageHandler.getMessage(n), false, this.expirePasswordsWithoutWarning));
        n = 466;
        linkedList.add(new BooleanConfigAttribute("ds-cfg-allow-expired-password-changes", MessageHandler.getMessage(n), false, this.allowExpiredPasswordChanges));
        n = 468;
        linkedList.add(new IntegerConfigAttribute("ds-cfg-grace-login-count", MessageHandler.getMessage(n), false, false, false, true, 0L, true, Integer.MAX_VALUE, this.graceLoginCount));
        n = 470;
        linkedList.add(new IntegerConfigAttribute("ds-cfg-lockout-failure-count", MessageHandler.getMessage(n), false, false, false, true, 0L, true, Integer.MAX_VALUE, this.lockoutFailureCount));
        n = 472;
        linkedList.add(new IntegerWithUnitConfigAttribute("ds-cfg-lockout-duration", MessageHandler.getMessage(n), false, linkedHashMap, true, 0L, true, Integer.MAX_VALUE, this.lockoutDuration, "seconds"));
        n = 474;
        linkedList.add(new IntegerWithUnitConfigAttribute("ds-cfg-lockout-failure-expiration-interval", MessageHandler.getMessage(n), false, linkedHashMap, true, 0L, true, Integer.MAX_VALUE, this.lockoutFailureExpirationInterval, "seconds"));
        n = 476;
        String string2 = null;
        if (this.requireChangeByTime > 0L) {
            string2 = GeneralizedTimeSyntax.createGeneralizedTimeValue(this.requireChangeByTime).getStringValue();
        }
        linkedList.add(new StringConfigAttribute("ds-cfg-require-change-by-time", MessageHandler.getMessage(n), false, false, false, string2));
        n = 478;
        String string3 = this.lastLoginTimeAttribute == null ? null : this.lastLoginTimeAttribute.getNameOrOID();
        linkedList.add(new StringConfigAttribute("ds-cfg-last-login-time-attribute", MessageHandler.getMessage(n), false, false, false, string3));
        n = 481;
        linkedList.add(new StringConfigAttribute("ds-cfg-last-login-time-format", MessageHandler.getMessage(n), false, false, false, this.lastLoginTimeFormat));
        n = 484;
        ArrayList<String> arrayList4 = new ArrayList<String>();
        if (this.previousLastLoginTimeFormats != null) {
            arrayList4.addAll(this.previousLastLoginTimeFormats);
        }
        linkedList.add(new StringConfigAttribute("ds-cfg-previous-last-login-time-format", MessageHandler.getMessage(n), false, false, false, arrayList4));
        n = 487;
        linkedList.add(new IntegerWithUnitConfigAttribute("ds-cfg-idle-lockout-interval", MessageHandler.getMessage(n), false, linkedHashMap, true, 0L, true, Integer.MAX_VALUE, this.idleLockoutInterval, "seconds"));
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
        PasswordPolicy passwordPolicy = new PasswordPolicy();
        try {
            PasswordPolicy.initializePasswordPolicyConfig(configEntry, passwordPolicy);
        }
        catch (ConfigException configException) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", configException));
            list.add(configException.getMessage());
            return false;
        }
        catch (InitializationException initializationException) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", initializationException));
            list.add(initializationException.getMessage());
            return false;
        }
        if (passwordPolicy.passwordAttribute == null) {
            int n = 262566;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
            list.add(string);
            return false;
        }
        if (passwordPolicy.defaultStorageSchemes == null || passwordPolicy.defaultStorageSchemes.isEmpty()) {
            int n = 262567;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
            list.add(string);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        PasswordPolicy passwordPolicy = new PasswordPolicy();
        try {
            PasswordPolicy.initializePasswordPolicyConfig(configEntry, passwordPolicy);
        }
        catch (ConfigException configException) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", configException));
            resultCode = DirectoryServer.getServerErrorResultCode();
            arrayList.add(configException.getMessage());
            return new ConfigChangeResult(resultCode, bl2, arrayList);
        }
        catch (InitializationException initializationException) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", initializationException));
            resultCode = DirectoryServer.getServerErrorResultCode();
            arrayList.add(initializationException.getMessage());
            return new ConfigChangeResult(resultCode, bl2, arrayList);
        }
        if (passwordPolicy.passwordAttribute == null) {
            resultCode = DirectoryServer.getServerErrorResultCode();
            int n = 262566;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
            return new ConfigChangeResult(resultCode, bl2, arrayList);
        }
        if (passwordPolicy.defaultStorageSchemes == null || passwordPolicy.defaultStorageSchemes.isEmpty()) {
            resultCode = DirectoryServer.getServerErrorResultCode();
            int n = 262567;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
            return new ConfigChangeResult(resultCode, bl2, arrayList);
        }
        this.passwordAttribute = passwordPolicy.passwordAttribute;
        this.lastLoginTimeAttribute = passwordPolicy.lastLoginTimeAttribute;
        this.allowMultiplePasswordValues = passwordPolicy.allowMultiplePasswordValues;
        this.allowPreEncodedPasswords = passwordPolicy.allowPreEncodedPasswords;
        this.allowUserPasswordChanges = passwordPolicy.allowUserPasswordChanges;
        this.expirePasswordsWithoutWarning = passwordPolicy.expirePasswordsWithoutWarning;
        this.allowExpiredPasswordChanges = passwordPolicy.allowExpiredPasswordChanges;
        this.forceChangeOnAdd = passwordPolicy.forceChangeOnAdd;
        this.forceChangeOnReset = passwordPolicy.forceChangeOnReset;
        this.requireCurrentPassword = passwordPolicy.requireCurrentPassword;
        this.requireSecureAuthentication = passwordPolicy.requireSecureAuthentication;
        this.requireSecurePasswordChanges = passwordPolicy.requireSecurePasswordChanges;
        this.skipValidationForAdministrators = passwordPolicy.skipValidationForAdministrators;
        this.graceLoginCount = passwordPolicy.graceLoginCount;
        this.idleLockoutInterval = passwordPolicy.idleLockoutInterval;
        this.lockoutDuration = passwordPolicy.lockoutDuration;
        this.lockoutFailureCount = passwordPolicy.lockoutFailureCount;
        this.lockoutFailureExpirationInterval = passwordPolicy.lockoutFailureExpirationInterval;
        this.minimumPasswordAge = passwordPolicy.minimumPasswordAge;
        this.maximumPasswordAge = passwordPolicy.maximumPasswordAge;
        this.maximumPasswordResetAge = passwordPolicy.maximumPasswordResetAge;
        this.warningInterval = passwordPolicy.warningInterval;
        this.requireChangeByTime = passwordPolicy.requireChangeByTime;
        this.lastLoginTimeFormat = passwordPolicy.lastLoginTimeFormat;
        this.previousLastLoginTimeFormats = passwordPolicy.previousLastLoginTimeFormats;
        this.passwordGenerator = passwordPolicy.passwordGenerator;
        this.passwordGeneratorDN = passwordPolicy.passwordGeneratorDN;
        this.notificationHandlers = passwordPolicy.notificationHandlers;
        this.defaultStorageSchemes = passwordPolicy.defaultStorageSchemes;
        this.deprecatedStorageSchemes = passwordPolicy.deprecatedStorageSchemes;
        this.passwordValidators = passwordPolicy.passwordValidators;
        if (bl) {
            int n = 489;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        Iterator<String> iterator;
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("Password Attribute:                    ");
        stringBuilder.append(this.passwordAttribute.getNameOrOID());
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Default Password Storage Schemes:      ");
        if (this.defaultStorageSchemes == null || this.defaultStorageSchemes.isEmpty()) {
            stringBuilder.append("{none specified}");
            stringBuilder.append(ServerConstants.EOL);
        } else {
            iterator = this.defaultStorageSchemes.iterator();
            stringBuilder.append(iterator.next().getStorageSchemeName());
            stringBuilder.append(ServerConstants.EOL);
            while (iterator.hasNext()) {
                stringBuilder.append("                                       ");
                stringBuilder.append(((PasswordStorageScheme)iterator.next()).getStorageSchemeName());
                stringBuilder.append(ServerConstants.EOL);
            }
        }
        stringBuilder.append("Deprecated Password Storage Schemes:   ");
        if (this.deprecatedStorageSchemes == null || this.deprecatedStorageSchemes.isEmpty()) {
            stringBuilder.append("{none specified}");
            stringBuilder.append(ServerConstants.EOL);
        } else {
            iterator = this.deprecatedStorageSchemes.iterator();
            stringBuilder.append((String)iterator.next());
            stringBuilder.append(ServerConstants.EOL);
            while (iterator.hasNext()) {
                stringBuilder.append("                                       ");
                stringBuilder.append((String)iterator.next());
                stringBuilder.append(ServerConstants.EOL);
            }
        }
        stringBuilder.append("Allow Multiple Password Values:        ");
        stringBuilder.append(this.allowMultiplePasswordValues);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Allow Pre-Encoded Passwords:           ");
        stringBuilder.append(this.allowPreEncodedPasswords);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Allow User Password Changes:           ");
        stringBuilder.append(this.allowUserPasswordChanges);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Force Password Change on Add:          ");
        stringBuilder.append(this.forceChangeOnAdd);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Force Password Change on Admin Reset:  ");
        stringBuilder.append(this.forceChangeOnReset);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Require Current Password:              ");
        stringBuilder.append(this.requireCurrentPassword);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Require Secure Authentication:         ");
        stringBuilder.append(this.requireSecureAuthentication);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Require Secure Password Changes:       ");
        stringBuilder.append(this.requireSecurePasswordChanges);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Lockout Failure Expiration Interval:   ");
        stringBuilder.append(this.lockoutFailureExpirationInterval);
        stringBuilder.append(" seconds");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Password Validators:                   ");
        if (this.passwordValidators == null || this.passwordValidators.isEmpty()) {
            stringBuilder.append("{none specified}");
            stringBuilder.append(ServerConstants.EOL);
        } else {
            iterator = this.passwordValidators.keySet().iterator();
            ((DN)iterator.next()).toString(stringBuilder);
            stringBuilder.append(ServerConstants.EOL);
            while (iterator.hasNext()) {
                stringBuilder.append("                                       ");
                ((DN)iterator.next()).toString(stringBuilder);
                stringBuilder.append(ServerConstants.EOL);
            }
        }
        stringBuilder.append("Skip Validation for Administrators:    ");
        stringBuilder.append(this.skipValidationForAdministrators);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Password Generator:                    ");
        if (this.passwordGenerator == null) {
            stringBuilder.append("{none specified}");
        } else {
            this.passwordGeneratorDN.toString(stringBuilder);
        }
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Account Status Notification Handlers:  ");
        if (this.notificationHandlers == null || this.notificationHandlers.isEmpty()) {
            stringBuilder.append("{none specified}");
            stringBuilder.append(ServerConstants.EOL);
        } else {
            iterator = this.notificationHandlers.keySet().iterator();
            ((DN)iterator.next()).toString(stringBuilder);
            stringBuilder.append(ServerConstants.EOL);
            while (iterator.hasNext()) {
                stringBuilder.append("                                       ");
                ((DN)iterator.next()).toString(stringBuilder);
                stringBuilder.append(ServerConstants.EOL);
            }
        }
        stringBuilder.append("Minimum Password Age:                  ");
        stringBuilder.append(this.minimumPasswordAge);
        stringBuilder.append(" seconds");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Maximum Password Age:                  ");
        stringBuilder.append(this.maximumPasswordAge);
        stringBuilder.append(" seconds");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Maximum Password Reset Age:            ");
        stringBuilder.append(this.maximumPasswordResetAge);
        stringBuilder.append(" seconds");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Expiration Warning Interval:           ");
        stringBuilder.append(this.warningInterval);
        stringBuilder.append(" seconds");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Expire Passwords Without Warning:      ");
        stringBuilder.append(this.expirePasswordsWithoutWarning);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Allow Expired Password Changes:        ");
        stringBuilder.append(this.allowExpiredPasswordChanges);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Grace Login Count:                     ");
        stringBuilder.append(this.graceLoginCount);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Lockout Failure Count:                 ");
        stringBuilder.append(this.lockoutFailureCount);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Lockout Duration:                      ");
        stringBuilder.append(this.lockoutDuration);
        stringBuilder.append(" seconds");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Lockout Count Expiration Interval:     ");
        stringBuilder.append(this.lockoutFailureExpirationInterval);
        stringBuilder.append(" seconds");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Required Password Change By Time:      ");
        if (this.requireChangeByTime <= 0L) {
            stringBuilder.append("{none specified}");
        } else {
            iterator = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
            ((DateFormat)((Object)iterator)).setTimeZone(TimeZone.getTimeZone("UTC"));
            stringBuilder.append(((DateFormat)((Object)iterator)).format(new Date(this.requireChangeByTime)));
        }
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Last Login Time Attribute:             ");
        if (this.lastLoginTimeAttribute == null) {
            stringBuilder.append("{none specified}");
        } else {
            stringBuilder.append(this.lastLoginTimeAttribute.getNameOrOID());
        }
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Last Login Time Format:                ");
        if (this.lastLoginTimeFormat == null) {
            stringBuilder.append("{none specified}");
        } else {
            stringBuilder.append(this.lastLoginTimeFormat);
        }
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Previous Last Login Time Formats:      ");
        if (this.previousLastLoginTimeFormats == null || this.previousLastLoginTimeFormats.isEmpty()) {
            stringBuilder.append("{none specified}");
            stringBuilder.append(ServerConstants.EOL);
        } else {
            iterator = this.previousLastLoginTimeFormats.iterator();
            stringBuilder.append(iterator.next());
            stringBuilder.append(ServerConstants.EOL);
            while (iterator.hasNext()) {
                stringBuilder.append("                                       ");
                stringBuilder.append(iterator.next());
                stringBuilder.append(ServerConstants.EOL);
            }
        }
        stringBuilder.append("Idle Lockout Interval:                 ");
        stringBuilder.append(this.idleLockoutInterval);
        stringBuilder.append(" seconds");
        stringBuilder.append(ServerConstants.EOL);
    }
}

