/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.api.plugin.PostOperationPluginResult;
import org.opends.server.api.plugin.PreOperationPluginResult;
import org.opends.server.api.plugin.PreParsePluginResult;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.CancelRequest;
import org.opends.server.core.CancelResult;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.Operation;
import org.opends.server.core.OperationType;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.loggers.Access;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedOperation
extends Operation {
    private static final String CLASS_NAME = "org.opends.server.core.ExtendedOperation";
    private ASN1OctetString requestValue;
    private ASN1OctetString responseValue;
    private boolean responseSent;
    private CancelRequest cancelRequest;
    private List<Control> responseControls;
    private long processingStartTime;
    private long processingStopTime;
    private String requestOID;
    private String responseOID;

    public ExtendedOperation(ClientConnection clientConnection, long l, int n, List<Control> list, String string, ASN1OctetString aSN1OctetString) {
        super(clientConnection, l, n, list);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(l), String.valueOf(n), String.valueOf(list), String.valueOf(string), String.valueOf(aSN1OctetString)));
        this.requestOID = string;
        this.requestValue = aSN1OctetString;
        this.responseOID = null;
        this.responseValue = null;
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
        this.responseSent = false;
    }

    public String getRequestOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getRequestOID", new String[0]));
        return this.requestOID;
    }

    public void setRequestOID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setRequestOID", String.valueOf(string)));
        this.requestOID = string;
    }

    public ASN1OctetString getRequestValue() {
        assert (Debug.debugEnter(CLASS_NAME, "getRequestValue", new String[0]));
        return this.requestValue;
    }

    public void setRequestValue(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setRequestValue", String.valueOf(aSN1OctetString)));
        this.requestValue = aSN1OctetString;
    }

    public String getResponseOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getResponseOID", new String[0]));
        return this.responseOID;
    }

    public void setResponseOID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setResponseOID", String.valueOf(string)));
        this.responseOID = string;
    }

    public ASN1OctetString getResponseValue() {
        assert (Debug.debugEnter(CLASS_NAME, "getResponseValue", new String[0]));
        return this.responseValue;
    }

    public void setResponseValue(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setResponseValue", String.valueOf(aSN1OctetString)));
        this.responseValue = aSN1OctetString;
    }

    public long getProcessingStartTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingStartTime", new String[0]));
        return this.processingStartTime;
    }

    public long getProcessingStopTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingStopTime", new String[0]));
        return this.processingStopTime;
    }

    public long getProcessingTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingTime", new String[0]));
        return this.processingStopTime - this.processingStartTime;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.EXTENDED;
    }

    @Override
    public String[][] getRequestLogElements() {
        return new String[][]{{"requestOID", this.requestOID}};
    }

    @Override
    public String[][] getResponseLogElements() {
        CharSequence charSequence;
        String string;
        String string2 = String.valueOf(this.getResultCode().getIntValue());
        StringBuilder stringBuilder = this.getErrorMessage();
        String string3 = stringBuilder == null ? null : stringBuilder.toString();
        DN dN = this.getMatchedDN();
        String string4 = dN == null ? null : dN.toString();
        List<String> list = this.getReferralURLs();
        if (list == null || list.isEmpty()) {
            string = null;
        } else {
            charSequence = new StringBuilder();
            Iterator<String> iterator = list.iterator();
            ((StringBuilder)charSequence).append(iterator.next());
            while (iterator.hasNext()) {
                ((StringBuilder)charSequence).append(", ");
                ((StringBuilder)charSequence).append(iterator.next());
            }
            string = ((StringBuilder)charSequence).toString();
        }
        charSequence = String.valueOf(this.processingStopTime - this.processingStartTime);
        return new String[][]{{"resultCode", string2}, {"errorMessage", string3}, {"matchedDN", string4}, {"referralURLs", string}, {"responseOID", this.responseOID}, {"processingTime", charSequence}};
    }

    @Override
    public List<Control> getResponseControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getResponseControls", new String[0]));
        return this.responseControls;
    }

    @Override
    public void run() {
        assert (Debug.debugEnter(CLASS_NAME, "run", new String[0]));
        this.setResultCode(ResultCode.UNDEFINED);
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        boolean bl = false;
        this.processingStartTime = System.currentTimeMillis();
        if (this.cancelRequest != null) {
            this.setCancelResult(CancelResult.CANCELED);
            if (this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                this.setResultCode(ResultCode.CANCELED);
                String string = this.cancelRequest.getCancelReason();
                if (string != null) {
                    this.appendErrorMessage(string);
                }
                this.clientConnection.sendResponse(this);
            }
            this.processingStopTime = System.currentTimeMillis();
            return;
        }
        Object object = pluginConfigManager.invokePreParseExtendedPlugins(this);
        if (((PreParsePluginResult)object).connectionTerminated()) {
            this.setResultCode(ResultCode.CANCELED);
            int n = 262368;
            this.appendErrorMessage(MessageHandler.getMessage(n));
            this.processingStopTime = System.currentTimeMillis();
            Access.logExtendedRequest(this);
            Access.logExtendedResponse(this);
            return;
        }
        if (((PreParsePluginResult)object).sendResponseImmediately()) {
            bl = true;
            Access.logExtendedRequest(this);
        } else {
            Access.logExtendedRequest(this);
            if (this.cancelRequest != null) {
                this.setCancelResult(CancelResult.CANCELED);
                if (this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                    this.setResultCode(ResultCode.CANCELED);
                    String string = this.cancelRequest.getCancelReason();
                    if (string != null) {
                        this.appendErrorMessage(string);
                    }
                    this.clientConnection.sendResponse(this);
                }
                this.processingStopTime = System.currentTimeMillis();
                Access.logExtendedResponse(this);
                return;
            }
            ExtendedOperationHandler extendedOperationHandler = DirectoryServer.getExtendedOperationHandler(this.requestOID);
            if (extendedOperationHandler == null) {
                this.setResultCode(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION);
                this.appendErrorMessage(MessageHandler.getMessage(196876, String.valueOf(this.requestOID)));
            } else if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this)) {
                this.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                int n = 262656;
                this.appendErrorMessage(MessageHandler.getMessage(n, String.valueOf(this.requestOID)));
                bl = true;
            } else {
                PreOperationPluginResult preOperationPluginResult = pluginConfigManager.invokePreOperationExtendedPlugins(this);
                if (preOperationPluginResult.connectionTerminated()) {
                    this.setResultCode(ResultCode.CANCELED);
                    int n = 262369;
                    this.appendErrorMessage(MessageHandler.getMessage(n));
                    this.processingStopTime = System.currentTimeMillis();
                    Access.logExtendedResponse(this);
                    return;
                }
                if (preOperationPluginResult.sendResponseImmediately()) {
                    bl = true;
                } else {
                    if (this.cancelRequest != null) {
                        this.setCancelResult(CancelResult.CANCELED);
                        if (this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                            this.setResultCode(ResultCode.CANCELED);
                            String string = this.cancelRequest.getCancelReason();
                            if (string != null) {
                                this.appendErrorMessage(string);
                            }
                            this.clientConnection.sendResponse(this);
                        }
                        this.processingStopTime = System.currentTimeMillis();
                        Access.logExtendedResponse(this);
                        return;
                    }
                    extendedOperationHandler.processExtendedOperation(this);
                }
            }
        }
        this.setCancelResult(CancelResult.TOO_LATE);
        if (!bl && ((PostOperationPluginResult)(object = pluginConfigManager.invokePostOperationExtendedPlugins(this))).connectionTerminated()) {
            this.setResultCode(ResultCode.CANCELED);
            int n = 262369;
            this.appendErrorMessage(MessageHandler.getMessage(n));
            this.processingStopTime = System.currentTimeMillis();
            Access.logExtendedResponse(this);
            return;
        }
        this.processingStopTime = System.currentTimeMillis();
        if (!this.responseSent) {
            this.responseSent = true;
            this.clientConnection.sendResponse(this);
        }
        Access.logExtendedResponse(this);
        pluginConfigManager.invokePostResponseExtendedPlugins(this);
    }

    public void sendExtendedResponse() {
        assert (Debug.debugEnter(CLASS_NAME, "sendExtendedResponse", new String[0]));
        if (!this.responseSent) {
            this.responseSent = true;
            this.clientConnection.sendResponse(this);
        }
    }

    public void setResponseSent() {
        assert (Debug.debugEnter(CLASS_NAME, "setResponseSent", String.valueOf(this.responseSent)));
        this.responseSent = true;
    }

    @Override
    public CancelResult cancel(CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "cancel", String.valueOf(cancelRequest)));
        this.cancelRequest = cancelRequest;
        CancelResult cancelResult = this.getCancelResult();
        long l = System.currentTimeMillis() + 5000L;
        while (cancelResult == null && System.currentTimeMillis() < l) {
            block5: {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "cancel", exception)) break block5;
                    throw new AssertionError();
                }
            }
            cancelResult = this.getCancelResult();
        }
        if (cancelResult == null) {
            cancelResult = CancelResult.CANNOT_CANCEL;
        }
        return cancelResult;
    }

    @Override
    public CancelRequest getCancelRequest() {
        assert (Debug.debugEnter(CLASS_NAME, "getCancelRequest", new String[0]));
        return this.cancelRequest;
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("ExtendedOperation(connID=");
        stringBuilder.append(this.clientConnection.getConnectionID());
        stringBuilder.append(", opID=");
        stringBuilder.append(this.operationID);
        stringBuilder.append(", oid=");
        stringBuilder.append(this.requestOID);
        stringBuilder.append(")");
    }
}

