/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import org.opends.server.api.AccountStatusNotificationHandler;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.AlertHandler;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.Backend;
import org.opends.server.api.CertificateMapper;
import org.opends.server.api.ChangeNotificationListener;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConfigHandler;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.DirectoryServerMBean;
import org.opends.server.api.EntryCache;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.api.IdentityMapper;
import org.opends.server.api.InvokableComponent;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.MonitorProvider;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.PasswordGenerator;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.api.PasswordValidator;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.api.SynchronizationProvider;
import org.opends.server.api.TrustManagerProvider;
import org.opends.server.api.VirtualAttribute;
import org.opends.server.api.WorkQueue;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.api.plugin.StartupPluginResult;
import org.opends.server.backends.RootDSEBackend;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.ConfigFileHandler;
import org.opends.server.config.JMXMBean;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.AccountStatusNotificationHandlerConfigManager;
import org.opends.server.core.BackendConfigManager;
import org.opends.server.core.CertificateMapperConfigManager;
import org.opends.server.core.ConnectionHandlerConfigManager;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.CryptoManager;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServerShutdownHook;
import org.opends.server.core.EntryCacheConfigManager;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ExtendedOperationConfigManager;
import org.opends.server.core.IdentityMapperConfigManager;
import org.opends.server.core.InitializationException;
import org.opends.server.core.KeyManagerProviderConfigManager;
import org.opends.server.core.LockFileManager;
import org.opends.server.core.LoggerConfigManager;
import org.opends.server.core.MonitorConfigManager;
import org.opends.server.core.Operation;
import org.opends.server.core.OperationType;
import org.opends.server.core.PasswordGeneratorConfigManager;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.core.PasswordPolicyConfigManager;
import org.opends.server.core.PasswordStorageSchemeConfigManager;
import org.opends.server.core.PasswordValidatorConfigManager;
import org.opends.server.core.PersistentSearch;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.RootDNConfigManager;
import org.opends.server.core.SASLConfigManager;
import org.opends.server.core.Schema;
import org.opends.server.core.SchemaConfigManager;
import org.opends.server.core.ServerShutdownMonitor;
import org.opends.server.core.SynchronizationProviderConfigManager;
import org.opends.server.core.TrustManagerProviderConfigManager;
import org.opends.server.extensions.JMXAlertHandler;
import org.opends.server.loggers.Access;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.loggers.StartupDebugLogger;
import org.opends.server.loggers.StartupErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.schema.AttributeTypeSyntax;
import org.opends.server.schema.BinarySyntax;
import org.opends.server.schema.BooleanEqualityMatchingRule;
import org.opends.server.schema.BooleanSyntax;
import org.opends.server.schema.CaseExactEqualityMatchingRule;
import org.opends.server.schema.CaseExactIA5EqualityMatchingRule;
import org.opends.server.schema.CaseExactIA5SubstringMatchingRule;
import org.opends.server.schema.CaseExactOrderingMatchingRule;
import org.opends.server.schema.CaseExactSubstringMatchingRule;
import org.opends.server.schema.CaseIgnoreEqualityMatchingRule;
import org.opends.server.schema.CaseIgnoreIA5EqualityMatchingRule;
import org.opends.server.schema.CaseIgnoreIA5SubstringMatchingRule;
import org.opends.server.schema.CaseIgnoreOrderingMatchingRule;
import org.opends.server.schema.CaseIgnoreSubstringMatchingRule;
import org.opends.server.schema.DirectoryStringSyntax;
import org.opends.server.schema.DistinguishedNameEqualityMatchingRule;
import org.opends.server.schema.DistinguishedNameSyntax;
import org.opends.server.schema.DoubleMetaphoneApproximateMatchingRule;
import org.opends.server.schema.GeneralizedTimeEqualityMatchingRule;
import org.opends.server.schema.GeneralizedTimeOrderingMatchingRule;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.schema.IA5StringSyntax;
import org.opends.server.schema.IntegerEqualityMatchingRule;
import org.opends.server.schema.IntegerOrderingMatchingRule;
import org.opends.server.schema.IntegerSyntax;
import org.opends.server.schema.OIDSyntax;
import org.opends.server.schema.ObjectClassSyntax;
import org.opends.server.schema.ObjectIdentifierEqualityMatchingRule;
import org.opends.server.schema.OctetStringEqualityMatchingRule;
import org.opends.server.schema.OctetStringOrderingMatchingRule;
import org.opends.server.schema.OctetStringSubstringMatchingRule;
import org.opends.server.schema.TelephoneNumberEqualityMatchingRule;
import org.opends.server.schema.TelephoneNumberSubstringMatchingRule;
import org.opends.server.schema.TelephoneNumberSyntax;
import org.opends.server.types.AcceptRejectWarn;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeUsage;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DITContentRule;
import org.opends.server.types.DITStructureRule;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.MatchingRuleUse;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ObjectClassType;
import org.opends.server.types.OperatingSystem;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.WritabilityMode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryServer
implements Thread.UncaughtExceptionHandler,
AlertGenerator {
    private static final String CLASS_NAME = "org.opends.server.core.DirectoryServer";
    private static DirectoryServer directoryServer = new DirectoryServer();
    private AcceptRejectWarn singleStructuralClassPolicy;
    private AcceptRejectWarn syntaxEnforcementPolicy;
    private AccountStatusNotificationHandlerConfigManager accountStatusNotificationHandlerConfigManager;
    private AttributeSyntax defaultBinarySyntax;
    private AttributeSyntax defaultBooleanSyntax;
    private AttributeSyntax defaultDNSyntax;
    private AttributeSyntax defaultIntegerSyntax;
    private AttributeSyntax defaultStringSyntax;
    private AttributeSyntax defaultSyntax;
    private AttributeType objectClassAttributeType;
    private BackendConfigManager backendConfigManager;
    private boolean addMissingRDNAttributes;
    private boolean allowAttributeNameExceptions;
    private boolean bindWithDNRequiresPassword;
    private boolean checkSchema;
    private boolean isBootstrapped = false;
    private boolean isRunning = false;
    private boolean notifyAbandonedOperations;
    private boolean shuttingDown = false;
    private CertificateMapper certificateMapper;
    private CertificateMapperConfigManager certificateMapperConfigManager;
    private ConfigHandler configHandler;
    private ConcurrentHashMap<DN, AccountStatusNotificationHandler> accountStatusNotificationHandlers;
    private ConcurrentHashMap<DN, DN> alternateRootBindDNs;
    private ConcurrentHashMap<DN, IdentityMapper> identityMappers;
    private ConcurrentHashMap<DN, JMXMBean> mBeans;
    private ConcurrentHashMap<DN, PasswordGenerator> passwordGenerators;
    private ConcurrentHashMap<DN, PasswordPolicy> passwordPolicies;
    private ConcurrentHashMap<DN, PasswordValidator> passwordValidators;
    private ConcurrentHashMap<String, ExtendedOperationHandler> extendedOperationHandlers;
    private ConcurrentHashMap<String, MonitorProvider> monitorProviders;
    private ConcurrentHashMap<String, PasswordStorageScheme> authPasswordStorageSchemes;
    private ConcurrentHashMap<String, PasswordStorageScheme> passwordStorageSchemes;
    private ConcurrentHashMap<String, SASLMechanismHandler> saslMechanismHandlers;
    private ConcurrentHashMap<String, VirtualAttribute> virtualAttributes;
    private ConnectionHandlerConfigManager connectionHandlerConfigManager;
    private CopyOnWriteArrayList<AlertHandler> alertHandlers;
    private CopyOnWriteArrayList<ChangeNotificationListener> changeNotificationListeners;
    private CopyOnWriteArrayList<ConnectionHandler> connectionHandlers;
    private CopyOnWriteArrayList<Properties> mailServerPropertySets;
    private CopyOnWriteArrayList<PersistentSearch> persistentSearches;
    private CopyOnWriteArrayList<ServerShutdownListener> shutdownListeners;
    private CopyOnWriteArrayList<SynchronizationProvider> synchronizationProviders;
    private CopyOnWriteArraySet<DN> rootDNs;
    private CoreConfigManager coreConfigManager;
    private CryptoManager cryptoManager;
    private DirectoryServerShutdownHook shutdownHook;
    private DN defaultPasswordPolicyDN;
    private DN proxiedAuthorizationIdentityMapperDN;
    private DN schemaDN;
    private EntryCache entryCache;
    private EntryCacheConfigManager entryCacheConfigManager;
    private ExtendedOperationConfigManager extendedOperationConfigManager;
    private IdentityMapperConfigManager identityMapperConfigManager;
    private int sizeLimit;
    private int timeLimit;
    private int lookthroughLimit;
    private KeyManagerProvider keyManagerProvider;
    private KeyManagerProviderConfigManager keyManagerProviderConfigManager;
    private LinkedHashMap<DN, Backend> privateSuffixes;
    private LinkedHashMap<DN, Backend> suffixes;
    private LinkedHashMap<String, Backend> backends;
    private LinkedHashSet<ClientConnection> establishedConnections;
    private LoggerConfigManager loggerConfigManager;
    private long currentConnections;
    private long maxAllowedConnections;
    private long maxConnections;
    private long startUpTime;
    private long totalConnections;
    private MBeanServer mBeanServer;
    private MonitorConfigManager monitorConfigManager;
    private OperatingSystem operatingSystem;
    private PasswordGeneratorConfigManager passwordGeneratorConfigManager;
    private PasswordPolicy defaultPasswordPolicy;
    private PasswordPolicyConfigManager passwordPolicyConfigManager;
    private PasswordStorageSchemeConfigManager storageSchemeConfigManager;
    private PasswordValidatorConfigManager passwordValidatorConfigManager;
    private PluginConfigManager pluginConfigManager;
    private ResultCode serverErrorResultCode = ResultCode.OTHER;
    private RootDSEBackend rootDSEBackend;
    SASLConfigManager saslConfigManager;
    private Schema schema;
    private SchemaConfigManager schemaConfigManager;
    private StartupDebugLogger startupDebugLogger;
    private StartupErrorLogger startupErrorLogger;
    private String configClass;
    private String configFile;
    private String startTimeUTC;
    private SynchronizationProviderConfigManager synchronizationProviderConfigManager;
    private ThreadGroup directoryThreadGroup;
    private TreeSet<String> supportedControls;
    private TreeSet<String> supportedFeatures;
    private TrustManagerProvider trustManagerProvider;
    private TrustManagerProviderConfigManager trustManagerProviderConfigManager;
    private WorkQueue workQueue;
    private WritabilityMode writabilityMode;

    private DirectoryServer() {
        this.operatingSystem = OperatingSystem.forName(System.getProperty("os.name"));
    }

    public static DirectoryServer getInstance() {
        return directoryServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DirectoryServer getNewInstance() {
        DirectoryServer directoryServer = DirectoryServer.directoryServer;
        synchronized (directoryServer) {
            DirectoryServer.directoryServer = new DirectoryServer();
            return DirectoryServer.directoryServer;
        }
    }

    public static void bootstrapClient() {
        DirectoryServer.directoryServer.syntaxEnforcementPolicy = AcceptRejectWarn.REJECT;
        DirectoryServer.directoryServer.schema = new Schema();
        directoryServer.bootstrapMatchingRules();
        directoryServer.bootstrapAttributeSyntaxes();
        DirectoryServer.directoryServer.alertHandlers = new CopyOnWriteArrayList();
        DirectoryServer.directoryServer.passwordStorageSchemes = new ConcurrentHashMap();
        DirectoryServer.directoryServer.passwordGenerators = new ConcurrentHashMap();
        DirectoryServer.directoryServer.authPasswordStorageSchemes = new ConcurrentHashMap();
        DirectoryServer.directoryServer.passwordValidators = new ConcurrentHashMap();
        DirectoryServer.directoryServer.accountStatusNotificationHandlers = new ConcurrentHashMap();
        DirectoryServer.directoryServer.rootDNs = new CopyOnWriteArraySet();
        DirectoryServer.directoryServer.alternateRootBindDNs = new ConcurrentHashMap();
        DirectoryServer.directoryServer.passwordPolicies = new ConcurrentHashMap();
        DirectoryServer.directoryServer.defaultPasswordPolicyDN = null;
        DirectoryServer.directoryServer.defaultPasswordPolicy = null;
        DirectoryServer.directoryServer.monitorProviders = new ConcurrentHashMap();
        DirectoryServer.directoryServer.privateSuffixes = new LinkedHashMap();
        DirectoryServer.directoryServer.suffixes = new LinkedHashMap();
        DirectoryServer.directoryServer.backends = new LinkedHashMap();
        DirectoryServer.directoryServer.changeNotificationListeners = new CopyOnWriteArrayList();
        DirectoryServer.directoryServer.persistentSearches = new CopyOnWriteArrayList();
        DirectoryServer.directoryServer.shutdownListeners = new CopyOnWriteArrayList();
        DirectoryServer.directoryServer.synchronizationProviders = new CopyOnWriteArrayList();
        DirectoryServer.directoryServer.supportedControls = new TreeSet();
        DirectoryServer.directoryServer.supportedFeatures = new TreeSet();
        DirectoryServer.directoryServer.virtualAttributes = new ConcurrentHashMap();
        DirectoryServer.directoryServer.connectionHandlers = new CopyOnWriteArrayList();
        DirectoryServer.directoryServer.identityMappers = new ConcurrentHashMap();
        DirectoryServer.directoryServer.extendedOperationHandlers = new ConcurrentHashMap();
        DirectoryServer.directoryServer.saslMechanismHandlers = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrapServer() throws InitializationException {
        DirectoryServer directoryServer = DirectoryServer.directoryServer;
        synchronized (directoryServer) {
            if (this.isRunning) {
                int n = 327798;
                String string = MessageHandler.getMessage(n);
                throw new InitializationException(n, string);
            }
            this.isBootstrapped = false;
            this.shuttingDown = false;
        }
        this.directoryThreadGroup = new ThreadGroup("Directory Server Thread Group");
        this.shutdownHook = new DirectoryServerShutdownHook();
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        Thread.setDefaultUncaughtExceptionHandler(this);
        Debug.removeAllDebugLoggers(true);
        this.startupDebugLogger = new StartupDebugLogger();
        this.startupDebugLogger.initializeDebugLogger(null);
        Debug.addDebugLogger(this.startupDebugLogger);
        Error.removeAllErrorLoggers(true);
        this.startupErrorLogger = new StartupErrorLogger();
        this.startupErrorLogger.initializeErrorLogger(null);
        Error.addErrorLogger(this.startupErrorLogger);
        DirectoryServer.initializeJMX();
        Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.STARTUP_DEBUG, 132, DirectoryServer.getVersionString());
        Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.INFORMATIONAL, 132, DirectoryServer.getVersionString());
        DirectoryServer.bootstrapClient();
        this.establishedConnections = new LinkedHashSet(1000);
        this.currentConnections = 0L;
        this.maxConnections = 0L;
        this.totalConnections = 0L;
        directoryServer = DirectoryServer.directoryServer;
        synchronized (directoryServer) {
            this.isBootstrapped = true;
        }
    }

    public static void initializeJMX() throws InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeJMX", new String[0]));
        try {
            DirectoryServer.directoryServer.mBeanServer = MBeanServerFactory.newMBeanServer();
            DirectoryServer.directoryServer.mBeans = new ConcurrentHashMap();
            DirectoryServer.registerAlertGenerator(directoryServer);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapServer", exception));
            int n = 327818;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new InitializationException(n, string, exception);
        }
    }

    public void initializeConfiguration(String string, String string2) throws InitializationException {
        Class<?> clazz;
        this.configClass = string;
        this.configFile = string2;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapServer", exception));
            int n = 327799;
            String string3 = MessageHandler.getMessage(n, string, exception);
            throw new InitializationException(n, string3, exception);
        }
        try {
            this.configHandler = (ConfigHandler)clazz.newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapServer", exception));
            int n = 327800;
            String string4 = MessageHandler.getMessage(n, string, exception);
            throw new InitializationException(n, string4, exception);
        }
        try {
            this.configHandler.initializeConfigHandler(string2, false);
        }
        catch (InitializationException initializationException) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapServer", initializationException));
            throw initializationException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapServer", exception));
            int n = 327801;
            String string5 = MessageHandler.getMessage(n, string, string2, exception);
            throw new InitializationException(n, string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer() throws ConfigException, InitializationException {
        DirectoryServer directoryServer = DirectoryServer.directoryServer;
        synchronized (directoryServer) {
            Object object2;
            if (!this.isBootstrapped) {
                int n = 327802;
                String string = MessageHandler.getMessage(n);
                throw new InitializationException(n, string);
            }
            if (this.isRunning) {
                int n = 327803;
                String string = MessageHandler.getMessage(n);
                throw new InitializationException(n, string);
            }
            Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.NOTICE, 458886, DirectoryServer.getVersionString());
            String string = LockFileManager.getServerLockFileName();
            try {
                object2 = new StringBuilder();
                if (!LockFileManager.acquireExclusiveLock(string, (StringBuilder)object2)) {
                    int n = 328023;
                    String string2 = MessageHandler.getMessage(n, string, String.valueOf(object2));
                    throw new InitializationException(n, string2);
                }
            }
            catch (InitializationException initializationException) {
                throw initializationException;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "startServer", exception));
                int n = 328023;
                String string3 = MessageHandler.getMessage(n, string, StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string3, exception);
            }
            this.initializeSchema();
            this.coreConfigManager = new CoreConfigManager();
            this.coreConfigManager.initializeCoreConfig();
            this.initializeCryptoManager();
            this.loggerConfigManager = new LoggerConfigManager();
            this.loggerConfigManager.initializeLoggers();
            this.initializeMailServerPropertySets();
            this.initializeAlertHandlers();
            this.entryCacheConfigManager = new EntryCacheConfigManager();
            this.entryCacheConfigManager.initializeEntryCache();
            this.keyManagerProviderConfigManager = new KeyManagerProviderConfigManager();
            this.keyManagerProviderConfigManager.initializeKeyManagerProvider();
            this.trustManagerProviderConfigManager = new TrustManagerProviderConfigManager();
            this.trustManagerProviderConfigManager.initializeTrustManagerProvider();
            this.certificateMapperConfigManager = new CertificateMapperConfigManager();
            this.certificateMapperConfigManager.initializeCertificateMapper();
            this.initializeIdentityMappers();
            new RootDNConfigManager().initializeRootDNs();
            this.initializeBackends();
            AccessControlConfigManager.getInstance().initializeAccessControl();
            this.initializeSupportedControls();
            this.initializeSupportedFeatures();
            this.initializeExtendedOperations();
            this.initializeSASLMechanisms();
            this.initializeVirtualAttributes();
            this.initializeConnectionHandlers();
            this.monitorConfigManager = new MonitorConfigManager();
            this.monitorConfigManager.initializeMonitorProviders();
            this.initializePasswordPolicyComponents();
            this.initializePlugins();
            this.synchronizationProviderConfigManager = new SynchronizationProviderConfigManager();
            this.synchronizationProviderConfigManager.initializeSynchronizationProviders();
            object2 = this.pluginConfigManager.invokeStartupPlugins();
            if (!((StartupPluginResult)object2).continueStartup()) {
                int n = 327900;
                String string4 = MessageHandler.getMessage(n, ((StartupPluginResult)object2).getErrorMessage(), ((StartupPluginResult)object2).getErrorID());
                throw new InitializationException(n, string4);
            }
            this.initializeWorkQueue();
            for (ConnectionHandler object3 : this.connectionHandlers) {
                object3.start();
            }
            this.startUpTime = System.currentTimeMillis();
            this.startTimeUTC = TimeThread.getUTCTime();
            this.isRunning = true;
            int n = 458887;
            String string2 = MessageHandler.getMessage(n);
            Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.NOTICE, string2, n);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.DirectoryServerStarted", n, string2);
            Debug.removeDebugLogger(this.startupDebugLogger);
            Error.removeErrorLogger(this.startupErrorLogger);
        }
    }

    private void bootstrapMatchingRules() {
        String string;
        int n;
        MatchingRule matchingRule;
        try {
            matchingRule = new DoubleMetaphoneApproximateMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerApproximateMatchingRule((ApproximateMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, DoubleMetaphoneApproximateMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new BooleanEqualityMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerEqualityMatchingRule((EqualityMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, BooleanEqualityMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new CaseExactEqualityMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerEqualityMatchingRule((EqualityMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, CaseExactEqualityMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new CaseExactIA5EqualityMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerEqualityMatchingRule((EqualityMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, CaseExactIA5EqualityMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new CaseIgnoreEqualityMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerEqualityMatchingRule((EqualityMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, CaseIgnoreEqualityMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new CaseIgnoreIA5EqualityMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerEqualityMatchingRule((EqualityMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, CaseIgnoreIA5EqualityMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new DistinguishedNameEqualityMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerEqualityMatchingRule((EqualityMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, DistinguishedNameEqualityMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new GeneralizedTimeEqualityMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerEqualityMatchingRule((EqualityMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, GeneralizedTimeEqualityMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new IntegerEqualityMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerEqualityMatchingRule((EqualityMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, IntegerEqualityMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new OctetStringEqualityMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerEqualityMatchingRule((EqualityMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, OctetStringEqualityMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new ObjectIdentifierEqualityMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerEqualityMatchingRule((EqualityMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, ObjectIdentifierEqualityMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new TelephoneNumberEqualityMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerEqualityMatchingRule((EqualityMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, TelephoneNumberEqualityMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new CaseExactOrderingMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerOrderingMatchingRule((OrderingMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, CaseExactOrderingMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new CaseIgnoreOrderingMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerOrderingMatchingRule((OrderingMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, CaseIgnoreOrderingMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new GeneralizedTimeOrderingMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerOrderingMatchingRule((OrderingMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, GeneralizedTimeOrderingMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new IntegerOrderingMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerOrderingMatchingRule((OrderingMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, IntegerOrderingMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new OctetStringOrderingMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerOrderingMatchingRule((OrderingMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, OctetStringOrderingMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new CaseExactSubstringMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerSubstringMatchingRule((SubstringMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, CaseExactSubstringMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new CaseExactIA5SubstringMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerSubstringMatchingRule((SubstringMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, CaseExactIA5SubstringMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new CaseIgnoreSubstringMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerSubstringMatchingRule((SubstringMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, CaseIgnoreSubstringMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new CaseIgnoreIA5SubstringMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerSubstringMatchingRule((SubstringMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, CaseIgnoreIA5SubstringMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new OctetStringSubstringMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerSubstringMatchingRule((SubstringMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, OctetStringSubstringMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            matchingRule = new TelephoneNumberSubstringMatchingRule();
            matchingRule.initializeMatchingRule(null);
            DirectoryServer.registerSubstringMatchingRule((SubstringMatchingRule)matchingRule, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapMatchingRules", exception));
            n = 262273;
            string = MessageHandler.getMessage(n, TelephoneNumberSubstringMatchingRule.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
    }

    private void bootstrapAttributeSyntaxes() {
        String string;
        int n;
        AttributeSyntax attributeSyntax;
        try {
            attributeSyntax = new AttributeTypeSyntax();
            ((AttributeTypeSyntax)attributeSyntax).initializeSyntax(null);
            DirectoryServer.registerAttributeSyntax(attributeSyntax, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapAttributeSyntaxes", exception));
            n = 262274;
            string = MessageHandler.getMessage(n, AttributeTypeSyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            this.defaultBinarySyntax = new BinarySyntax();
            this.defaultBinarySyntax.initializeSyntax(null);
            DirectoryServer.registerAttributeSyntax(this.defaultBinarySyntax, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapAttributeSyntaxes", exception));
            n = 262274;
            string = MessageHandler.getMessage(n, BinarySyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            this.defaultBooleanSyntax = new BooleanSyntax();
            this.defaultBooleanSyntax.initializeSyntax(null);
            DirectoryServer.registerAttributeSyntax(this.defaultBooleanSyntax, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapAttributeSyntaxes", exception));
            n = 262274;
            string = MessageHandler.getMessage(n, BooleanSyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            this.defaultStringSyntax = new DirectoryStringSyntax();
            this.defaultStringSyntax.initializeSyntax(null);
            DirectoryServer.registerAttributeSyntax(this.defaultStringSyntax, true);
            this.defaultSyntax = this.defaultStringSyntax;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapAttributeSyntaxes", exception));
            n = 262274;
            string = MessageHandler.getMessage(n, DirectoryStringSyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            this.defaultDNSyntax = new DistinguishedNameSyntax();
            this.defaultDNSyntax.initializeSyntax(null);
            DirectoryServer.registerAttributeSyntax(this.defaultDNSyntax, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapAttributeSyntaxes", exception));
            n = 262274;
            string = MessageHandler.getMessage(n, DistinguishedNameSyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            attributeSyntax = new IA5StringSyntax();
            attributeSyntax.initializeSyntax(null);
            DirectoryServer.registerAttributeSyntax(attributeSyntax, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapAttributeSyntaxes", exception));
            n = 262274;
            string = MessageHandler.getMessage(n, IA5StringSyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            this.defaultIntegerSyntax = new IntegerSyntax();
            this.defaultIntegerSyntax.initializeSyntax(null);
            DirectoryServer.registerAttributeSyntax(this.defaultIntegerSyntax, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapAttributeSyntaxes", exception));
            n = 262274;
            string = MessageHandler.getMessage(n, IntegerSyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            attributeSyntax = new GeneralizedTimeSyntax();
            attributeSyntax.initializeSyntax(null);
            DirectoryServer.registerAttributeSyntax(attributeSyntax, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapAttributeSyntaxes", exception));
            n = 262274;
            string = MessageHandler.getMessage(n, GeneralizedTimeSyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            attributeSyntax = new ObjectClassSyntax();
            attributeSyntax.initializeSyntax(null);
            DirectoryServer.registerAttributeSyntax(attributeSyntax, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapAttributeSyntaxes", exception));
            n = 262274;
            string = MessageHandler.getMessage(n, ObjectClassSyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            attributeSyntax = new OIDSyntax();
            attributeSyntax.initializeSyntax(null);
            DirectoryServer.registerAttributeSyntax(attributeSyntax, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapAttributeSyntaxes", exception));
            n = 262274;
            string = MessageHandler.getMessage(n, OIDSyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
        try {
            attributeSyntax = new TelephoneNumberSyntax();
            attributeSyntax.initializeSyntax(null);
            DirectoryServer.registerAttributeSyntax(attributeSyntax, true);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "bootstrapAttributeSyntaxes", exception));
            n = 262274;
            string = MessageHandler.getMessage(n, TelephoneNumberSyntax.class.getName(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
    }

    public void initializeCryptoManager() throws ConfigException, InitializationException {
        this.cryptoManager = new CryptoManager();
    }

    public static CryptoManager getCryptoManager() {
        assert (Debug.debugEnter(CLASS_NAME, "getCryptoManager", new String[0]));
        return DirectoryServer.directoryServer.cryptoManager;
    }

    public void initializeMailServerPropertySets() throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMailServerPropertySets", new String[0]));
        this.mailServerPropertySets = new CopyOnWriteArrayList();
        Properties properties = new Properties();
        properties.setProperty("mail.smtp.host", "127.0.0.1");
        this.mailServerPropertySets.add(properties);
    }

    public static CopyOnWriteArrayList<Properties> getMailServerPropertySets() {
        assert (Debug.debugEnter(CLASS_NAME, "getMailServerPropertySets", new String[0]));
        return DirectoryServer.directoryServer.mailServerPropertySets;
    }

    private void initializeAlertHandlers() throws ConfigException, InitializationException {
        JMXAlertHandler jMXAlertHandler = new JMXAlertHandler();
        jMXAlertHandler.initializeAlertHandler(null);
        this.alertHandlers.add(jMXAlertHandler);
    }

    public void initializeSchema() throws ConfigException, InitializationException {
        block8: {
            assert (Debug.debugEnter(CLASS_NAME, "initializeSchema", new String[0]));
            this.schemaConfigManager = new SchemaConfigManager();
            this.schema = this.schemaConfigManager.getSchema();
            this.schemaConfigManager.initializeMatchingRules();
            this.schemaConfigManager.initializeAttributeSyntaxes();
            this.schemaConfigManager.initializeSchemaFromFiles();
            try {
                this.configHandler.finalizeConfigHandler();
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "initializeSchema", exception)) break block8;
                throw new AssertionError();
            }
        }
        try {
            this.configHandler.initializeConfigHandler(this.configFile, true);
        }
        catch (InitializationException initializationException) {
            assert (Debug.debugException(CLASS_NAME, "initializeSchema", initializationException));
            throw initializationException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeSchema", exception));
            int n = 327801;
            String string = MessageHandler.getMessage(n, this.configClass, this.configFile, exception);
            throw new InitializationException(n, string);
        }
    }

    private void initializeBackends() throws ConfigException, InitializationException {
        ConfigEntry configEntry;
        DN[] dNArray;
        assert (Debug.debugEnter(CLASS_NAME, "initializeBackends", new String[0]));
        this.backendConfigManager = new BackendConfigManager();
        this.backendConfigManager.initializeBackendConfig();
        try {
            dNArray = DN.decode("cn=Root DSE,cn=config");
            configEntry = this.configHandler.getConfigEntry((DN)dNArray);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeBackends", exception));
            int n = 262327;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        dNArray = new DN[]{new DN(new RDN[0])};
        this.rootDSEBackend = new RootDSEBackend();
        this.rootDSEBackend.initializeBackend(configEntry, dNArray);
    }

    private void initializeSupportedControls() throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSupportedControls", new String[0]));
        this.supportedControls.add("1.3.6.1.1.12");
        this.supportedControls.add("1.3.6.1.1.13.1");
        this.supportedControls.add("1.3.6.1.1.13.2");
        this.supportedControls.add("1.3.6.1.4.1.4203.1.10.2");
        this.supportedControls.add("2.16.840.1.113730.3.4.3");
        this.supportedControls.add("2.16.840.1.113730.3.4.12");
        this.supportedControls.add("2.16.840.1.113730.3.4.18");
        this.supportedControls.add("2.16.840.1.113730.3.4.16");
        this.supportedControls.add("1.2.826.0.1.3344810.2.3");
        this.supportedControls.add("1.3.6.1.4.1.7628.5.101.1");
        this.supportedControls.add("1.3.6.1.4.1.42.2.27.8.5.1");
    }

    private void initializeSupportedFeatures() throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSupportedFeatures", new String[0]));
        this.supportedFeatures.add("1.3.6.1.4.1.4203.1.5.1");
        this.supportedFeatures.add("1.3.6.1.1.14");
        this.supportedFeatures.add("1.3.6.1.4.1.4203.1.5.3");
    }

    private void initializeIdentityMappers() throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeIdentityMappers", new String[0]));
        this.identityMapperConfigManager = new IdentityMapperConfigManager();
        this.identityMapperConfigManager.initializeIdentityMappers();
    }

    private void initializeExtendedOperations() throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeExtendedOperations", new String[0]));
        this.extendedOperationConfigManager = new ExtendedOperationConfigManager();
        this.extendedOperationConfigManager.initializeExtendedOperationHandlers();
    }

    private void initializeSASLMechanisms() throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSASLMechanisms", new String[0]));
        this.saslConfigManager = new SASLConfigManager();
        this.saslConfigManager.initializeSASLMechanismHandlers();
    }

    private void initializeVirtualAttributes() throws ConfigException, InitializationException {
    }

    private void initializeConnectionHandlers() throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeConnectionHandlers", new String[0]));
        this.connectionHandlerConfigManager = new ConnectionHandlerConfigManager();
        this.connectionHandlerConfigManager.initializeConnectionHandlerConfig();
    }

    public void initializePasswordPolicyComponents() throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializePasswordPolicyComponents", new String[0]));
        this.storageSchemeConfigManager = new PasswordStorageSchemeConfigManager();
        this.storageSchemeConfigManager.initializePasswordStorageSchemes();
        this.passwordValidatorConfigManager = new PasswordValidatorConfigManager();
        this.passwordValidatorConfigManager.initializePasswordValidators();
        this.passwordGeneratorConfigManager = new PasswordGeneratorConfigManager();
        this.passwordGeneratorConfigManager.initializePasswordGenerators();
        this.accountStatusNotificationHandlerConfigManager = new AccountStatusNotificationHandlerConfigManager();
        this.accountStatusNotificationHandlerConfigManager.initializeNotificationHandlers();
        this.passwordPolicyConfigManager = new PasswordPolicyConfigManager();
        this.passwordPolicyConfigManager.initializePasswordPolicies();
    }

    public static OperatingSystem getOperatingSystem() {
        assert (Debug.debugEnter(CLASS_NAME, "getOperatingSystem", new String[0]));
        return DirectoryServer.directoryServer.operatingSystem;
    }

    public static ThreadGroup getDirectoryThreadGroup() {
        assert (Debug.debugEnter(CLASS_NAME, "getDirectoryThreadGroup", new String[0]));
        return DirectoryServer.directoryServer.directoryThreadGroup;
    }

    public static ConfigHandler getConfigHandler() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigHandler", new String[0]));
        return DirectoryServer.directoryServer.configHandler;
    }

    public void initializePlugins() throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializePlugins", new String[0]));
        this.pluginConfigManager = new PluginConfigManager();
        this.pluginConfigManager.initializePluginConfig(null);
    }

    public void initializePlugins(Set<PluginType> set) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializePlugins", new String[0]));
        this.pluginConfigManager = new PluginConfigManager();
        this.pluginConfigManager.initializePluginConfig(set);
    }

    public static PluginConfigManager getPluginConfigManager() {
        assert (Debug.debugEnter(CLASS_NAME, "getPluginConfigManager", new String[0]));
        return DirectoryServer.directoryServer.pluginConfigManager;
    }

    public static ConfigEntry getConfigEntry(DN dN) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigEntry", String.valueOf(dN)));
        return DirectoryServer.directoryServer.configHandler.getConfigEntry(dN);
    }

    public static String getServerRoot() {
        assert (Debug.debugEnter(CLASS_NAME, "getServerRoot", new String[0]));
        return DirectoryServer.directoryServer.configHandler.getServerRoot();
    }

    public static long getStartTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getStartTime", new String[0]));
        return DirectoryServer.directoryServer.startUpTime;
    }

    public static String getStartTimeUTC() {
        assert (Debug.debugEnter(CLASS_NAME, "getStartTimeUTC", new String[0]));
        return DirectoryServer.directoryServer.startTimeUTC;
    }

    public static Schema getSchema() {
        assert (Debug.debugEnter(CLASS_NAME, "getSchema", new String[0]));
        return DirectoryServer.directoryServer.schema;
    }

    public static ConcurrentHashMap<String, MatchingRule> getMatchingRules() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRules", new String[0]));
        return DirectoryServer.directoryServer.schema.getMatchingRules();
    }

    public static LinkedHashSet<AttributeValue> getMatchingRuleSet() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRuleSet", new String[0]));
        return DirectoryServer.directoryServer.schema.getMatchingRuleSet();
    }

    public static MatchingRule getMatchingRule(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRule", String.valueOf(string)));
        return DirectoryServer.directoryServer.schema.getMatchingRule(string);
    }

    public static void registerMatchingRule(MatchingRule matchingRule, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerMatchingRule", String.valueOf(matchingRule), String.valueOf(bl)));
        DirectoryServer.directoryServer.schema.registerMatchingRule(matchingRule, bl);
    }

    public static void deregisterMatchingRule(MatchingRule matchingRule) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterMatchingRule", String.valueOf(matchingRule)));
        DirectoryServer.directoryServer.schema.deregisterMatchingRule(matchingRule);
    }

    public static ConcurrentHashMap<String, ApproximateMatchingRule> getApproximateMatchingRules() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRules", new String[0]));
        return DirectoryServer.directoryServer.schema.getApproximateMatchingRules();
    }

    public static ApproximateMatchingRule getApproximateMatchingRule(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", String.valueOf(string)));
        return DirectoryServer.directoryServer.schema.getApproximateMatchingRule(string);
    }

    public static void registerApproximateMatchingRule(ApproximateMatchingRule approximateMatchingRule, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerApproximateMatchingRule", String.valueOf(approximateMatchingRule), String.valueOf(bl)));
        DirectoryServer.directoryServer.schema.registerApproximateMatchingRule(approximateMatchingRule, bl);
    }

    public static void deregisterApproximateMatchingRule(ApproximateMatchingRule approximateMatchingRule) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterApproximateMatchingRule", String.valueOf(approximateMatchingRule)));
        DirectoryServer.directoryServer.schema.deregisterApproximateMatchingRule(approximateMatchingRule);
    }

    public static ConcurrentHashMap<String, EqualityMatchingRule> getEqualityMatchingRules() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRules", new String[0]));
        return DirectoryServer.directoryServer.schema.getEqualityMatchingRules();
    }

    public static EqualityMatchingRule getEqualityMatchingRule(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", String.valueOf(string)));
        return DirectoryServer.directoryServer.schema.getEqualityMatchingRule(string);
    }

    public static void registerEqualityMatchingRule(EqualityMatchingRule equalityMatchingRule, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerEqualityMatchingRule", String.valueOf(equalityMatchingRule), String.valueOf(bl)));
        DirectoryServer.directoryServer.schema.registerEqualityMatchingRule(equalityMatchingRule, bl);
    }

    public static void deregisterEqualityMatchingRule(EqualityMatchingRule equalityMatchingRule) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterEqualityMatchingRule", String.valueOf(equalityMatchingRule)));
        DirectoryServer.directoryServer.schema.deregisterEqualityMatchingRule(equalityMatchingRule);
    }

    public static ConcurrentHashMap<String, OrderingMatchingRule> getOrderingMatchingRules() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRules", new String[0]));
        return DirectoryServer.directoryServer.schema.getOrderingMatchingRules();
    }

    public static OrderingMatchingRule getOrderingMatchingRule(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", String.valueOf(string)));
        return DirectoryServer.directoryServer.schema.getOrderingMatchingRule(string);
    }

    public static void registerOrderingMatchingRule(OrderingMatchingRule orderingMatchingRule, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerOrderingMatchingRule", String.valueOf(orderingMatchingRule), String.valueOf(bl)));
        DirectoryServer.directoryServer.schema.registerOrderingMatchingRule(orderingMatchingRule, bl);
    }

    public static void deregisterOrderingMatchingRule(OrderingMatchingRule orderingMatchingRule) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterOrderingMatchingRule", String.valueOf(orderingMatchingRule)));
        DirectoryServer.directoryServer.schema.deregisterOrderingMatchingRule(orderingMatchingRule);
    }

    public static ConcurrentHashMap<String, SubstringMatchingRule> getSubstringMatchingRules() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRules", new String[0]));
        return DirectoryServer.directoryServer.schema.getSubstringMatchingRules();
    }

    public static SubstringMatchingRule getSubstringMatchingRule(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", String.valueOf(string)));
        return DirectoryServer.directoryServer.schema.getSubstringMatchingRule(string);
    }

    public static void registerSubstringMatchingRule(SubstringMatchingRule substringMatchingRule, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerSubstringMatchingRule", String.valueOf(substringMatchingRule), String.valueOf(bl)));
        DirectoryServer.directoryServer.schema.registerSubstringMatchingRule(substringMatchingRule, bl);
    }

    public static void deregisterSubstringMatchingRule(SubstringMatchingRule substringMatchingRule) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterSubstringMatchingRule", String.valueOf(substringMatchingRule)));
        DirectoryServer.directoryServer.schema.deregisterSubstringMatchingRule(substringMatchingRule);
    }

    public static ConcurrentHashMap<String, ObjectClass> getObjectClasses() {
        assert (Debug.debugEnter(CLASS_NAME, "getObjectClasses", new String[0]));
        return DirectoryServer.directoryServer.schema.getObjectClasses();
    }

    public static LinkedHashSet<AttributeValue> getObjectClassSet() {
        assert (Debug.debugEnter(CLASS_NAME, "getObjectClassSet", new String[0]));
        return DirectoryServer.directoryServer.schema.getObjectClassSet();
    }

    public static ObjectClass getObjectClass(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getObjectClass", String.valueOf(string)));
        return DirectoryServer.directoryServer.schema.getObjectClass(string);
    }

    public static ObjectClass getObjectClass(String string, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "getObjectClass", String.valueOf(string), String.valueOf(bl)));
        ObjectClass objectClass = DirectoryServer.directoryServer.schema.getObjectClass(string);
        if (bl && objectClass == null) {
            objectClass = DirectoryServer.getDefaultObjectClass(string);
        }
        return objectClass;
    }

    public static void registerObjectClass(ObjectClass objectClass, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerObjectClass", String.valueOf(objectClass), String.valueOf(bl)));
        DirectoryServer.directoryServer.schema.registerObjectClass(objectClass, bl);
    }

    public static void deregisterObjectClass(ObjectClass objectClass) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterObjectClass", String.valueOf(objectClass)));
        DirectoryServer.directoryServer.schema.deregisterObjectClass(objectClass);
    }

    public static ObjectClass getTopObjectClass() {
        assert (Debug.debugEnter(CLASS_NAME, "getTopObjectClass", new String[0]));
        ObjectClass objectClass = DirectoryServer.directoryServer.schema.getObjectClass("top");
        if (objectClass == null) {
            ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>(1);
            concurrentHashMap.put("top", "top");
            CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet = new CopyOnWriteArraySet<AttributeType>();
            CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet2 = new CopyOnWriteArraySet<AttributeType>();
            ConcurrentHashMap<String, CopyOnWriteArrayList<String>> concurrentHashMap2 = new ConcurrentHashMap<String, CopyOnWriteArrayList<String>>(0);
            objectClass = new ObjectClass("top", concurrentHashMap, "2.5.6.0", "Topmost ObjectClass", null, copyOnWriteArraySet, copyOnWriteArraySet2, ObjectClassType.ABSTRACT, false, concurrentHashMap2);
        }
        return objectClass;
    }

    public static ObjectClass getDefaultObjectClass(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getDefaultObjectClass", String.valueOf(string)));
        String string2 = StaticUtils.toLowerCase(string);
        ObjectClass objectClass = DirectoryServer.directoryServer.schema.getObjectClass(string2);
        if (objectClass == null) {
            ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>(1);
            concurrentHashMap.put(string2, string);
            CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet = new CopyOnWriteArraySet<AttributeType>();
            CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet2 = new CopyOnWriteArraySet<AttributeType>();
            ConcurrentHashMap<String, CopyOnWriteArrayList<String>> concurrentHashMap2 = new ConcurrentHashMap<String, CopyOnWriteArrayList<String>>(0);
            objectClass = new ObjectClass(string, concurrentHashMap, string2, null, DirectoryServer.getTopObjectClass(), copyOnWriteArraySet, copyOnWriteArraySet2, ObjectClassType.ABSTRACT, false, concurrentHashMap2);
        }
        return objectClass;
    }

    public static ConcurrentHashMap<String, AttributeType> getAttributeTypes() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeTypes", new String[0]));
        return DirectoryServer.directoryServer.schema.getAttributeTypes();
    }

    public static LinkedHashSet<AttributeValue> getAttributeTypeSet() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeTypeSet", new String[0]));
        return DirectoryServer.directoryServer.schema.getAttributeTypeSet();
    }

    public static AttributeType getAttributeType(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeType", String.valueOf(string)));
        return DirectoryServer.directoryServer.schema.getAttributeType(string);
    }

    public static AttributeType getAttributeType(String string, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeType", String.valueOf(string), String.valueOf(bl)));
        AttributeType attributeType = DirectoryServer.directoryServer.schema.getAttributeType(string);
        if (bl && attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType(string);
        }
        return attributeType;
    }

    public static void registerAttributeType(AttributeType attributeType, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerAttributeType", String.valueOf(attributeType), String.valueOf(bl)));
        DirectoryServer.directoryServer.schema.registerAttributeType(attributeType, bl);
    }

    public static void deregisterAttributeType(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterAttributeType", String.valueOf(attributeType)));
        DirectoryServer.directoryServer.schema.deregisterAttributeType(attributeType);
    }

    public static AttributeType getObjectClassAttributeType() {
        block9: {
            assert (Debug.debugEnter(CLASS_NAME, "getObjectClassAttributeType", new String[0]));
            if (DirectoryServer.directoryServer.objectClassAttributeType == null) {
                DirectoryServer.directoryServer.objectClassAttributeType = DirectoryServer.directoryServer.schema.getAttributeType("objectclass");
                if (DirectoryServer.directoryServer.objectClassAttributeType == null) {
                    AttributeSyntax attributeSyntax;
                    block8: {
                        attributeSyntax = DirectoryServer.directoryServer.schema.getSyntax("OID");
                        if (attributeSyntax == null) {
                            try {
                                attributeSyntax = new OIDSyntax();
                                attributeSyntax.initializeSyntax(null);
                                DirectoryServer.directoryServer.schema.registerSyntax(attributeSyntax, true);
                            }
                            catch (Exception exception) {
                                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "getObjectClassAttributeType", exception)) break block8;
                                throw new AssertionError();
                            }
                        }
                    }
                    DirectoryServer.directoryServer.objectClassAttributeType = new AttributeType("objectClass", Collections.singleton("objectClass"), "2.5.4.0", null, null, attributeSyntax, AttributeUsage.USER_APPLICATIONS, false, false, false, false);
                    try {
                        DirectoryServer.directoryServer.schema.registerAttributeType(DirectoryServer.directoryServer.objectClassAttributeType, true);
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "getObjectClassAttributeType", exception)) break block9;
                        throw new AssertionError();
                    }
                }
            }
        }
        return DirectoryServer.directoryServer.objectClassAttributeType;
    }

    public static AttributeType getDefaultAttributeType(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getDefaultAttributeType", String.valueOf(string)));
        return DirectoryServer.getDefaultAttributeType(string, DirectoryServer.getDefaultAttributeSyntax());
    }

    public static AttributeType getDefaultAttributeType(String string, AttributeSyntax attributeSyntax) {
        assert (Debug.debugEnter(CLASS_NAME, "getDefaultAttributeType", String.valueOf(string)));
        String string2 = StaticUtils.toLowerCase(string);
        return new AttributeType(string, Collections.singleton(string), string2, null, null, attributeSyntax, AttributeUsage.USER_APPLICATIONS, false, false, false, false);
    }

    public static ConcurrentHashMap<String, AttributeSyntax> getAttributeSyntaxes() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeSyntaxes", new String[0]));
        return DirectoryServer.directoryServer.schema.getSyntaxes();
    }

    public static LinkedHashSet<AttributeValue> getAttributeSyntaxSet() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeSyntaxSet", new String[0]));
        return DirectoryServer.directoryServer.schema.getSyntaxSet();
    }

    public static AttributeSyntax getAttributeSyntax(String string, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeSyntax", String.valueOf(string), String.valueOf(bl)));
        AttributeSyntax attributeSyntax = DirectoryServer.directoryServer.schema.getSyntax(string);
        if (attributeSyntax == null && bl) {
            return DirectoryServer.getDefaultAttributeSyntax();
        }
        return attributeSyntax;
    }

    public static void registerAttributeSyntax(AttributeSyntax attributeSyntax, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerAttributeSyntax", String.valueOf(attributeSyntax), String.valueOf(bl)));
        DirectoryServer.directoryServer.schema.registerSyntax(attributeSyntax, bl);
    }

    public static void deregisterAttributeSyntax(AttributeSyntax attributeSyntax) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterAttributeSyntax", String.valueOf(attributeSyntax)));
        DirectoryServer.directoryServer.schema.deregisterSyntax(attributeSyntax);
    }

    public static AttributeSyntax getDefaultAttributeSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "getDefaultAttributeSyntax", new String[0]));
        return DirectoryServer.directoryServer.defaultSyntax;
    }

    public static AttributeSyntax getDefaultBinarySyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "getDefaultBinarySyntax", new String[0]));
        return DirectoryServer.directoryServer.defaultBinarySyntax;
    }

    public static AttributeSyntax getDefaultBooleanSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "getDefaultBooleanSyntax", new String[0]));
        return DirectoryServer.directoryServer.defaultBooleanSyntax;
    }

    public static AttributeSyntax getDefaultDNSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "getDefaultDNSyntax", new String[0]));
        return DirectoryServer.directoryServer.defaultDNSyntax;
    }

    public static AttributeSyntax getDefaultIntegerSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "getDefaultIntegerSyntax", new String[0]));
        return DirectoryServer.directoryServer.defaultIntegerSyntax;
    }

    public static AttributeSyntax getDefaultStringSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "getDefaultStringSyntax", new String[0]));
        return DirectoryServer.directoryServer.defaultStringSyntax;
    }

    public static ConcurrentHashMap<MatchingRule, MatchingRuleUse> getMatchingRuleUses() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRuleUses", new String[0]));
        return DirectoryServer.directoryServer.schema.getMatchingRuleUses();
    }

    public static LinkedHashSet<AttributeValue> getMatchingRuleUseSet() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRuleUseSet", new String[0]));
        return DirectoryServer.directoryServer.schema.getMatchingRuleUseSet();
    }

    public static MatchingRuleUse getMatchingRuleUse(MatchingRule matchingRule) {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRuleUse", String.valueOf(matchingRule)));
        return DirectoryServer.directoryServer.schema.getMatchingRuleUse(matchingRule);
    }

    public static void registerMatchingRuleUse(MatchingRuleUse matchingRuleUse, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerMatchingRuleUse", String.valueOf(matchingRuleUse), String.valueOf(bl)));
        DirectoryServer.directoryServer.schema.registerMatchingRuleUse(matchingRuleUse, bl);
    }

    public static void deregisterMatchingRuleUse(MatchingRuleUse matchingRuleUse) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterMatchingRuleUse", String.valueOf(matchingRuleUse)));
        DirectoryServer.directoryServer.schema.deregisterMatchingRuleUse(matchingRuleUse);
    }

    public static ConcurrentHashMap<ObjectClass, DITContentRule> getDITContentRules() {
        assert (Debug.debugEnter(CLASS_NAME, "getDITContentRules", new String[0]));
        return DirectoryServer.directoryServer.schema.getDITContentRules();
    }

    public static LinkedHashSet<AttributeValue> getDITContentRuleSet() {
        assert (Debug.debugEnter(CLASS_NAME, "getDITContentRuleSet", new String[0]));
        return DirectoryServer.directoryServer.schema.getDITContentRuleSet();
    }

    public static DITContentRule getDITContentRule(ObjectClass objectClass) {
        assert (Debug.debugEnter(CLASS_NAME, "getDITContentRule", String.valueOf(objectClass)));
        return DirectoryServer.directoryServer.schema.getDITContentRule(objectClass);
    }

    public static void registerDITContentRule(DITContentRule dITContentRule, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerDITContentRule", String.valueOf(dITContentRule), String.valueOf(bl)));
        DirectoryServer.directoryServer.schema.registerDITContentRule(dITContentRule, bl);
    }

    public static void deregisterDITContentRule(DITContentRule dITContentRule) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterDITContentRule", String.valueOf(dITContentRule)));
        DirectoryServer.directoryServer.schema.deregisterDITContentRule(dITContentRule);
    }

    public static ConcurrentHashMap<NameForm, DITStructureRule> getDITStructureRules() {
        assert (Debug.debugEnter(CLASS_NAME, "getDITStructureRules", new String[0]));
        return DirectoryServer.directoryServer.schema.getDITStructureRulesByNameForm();
    }

    public static LinkedHashSet<AttributeValue> getDITStructureRuleSet() {
        assert (Debug.debugEnter(CLASS_NAME, "getDITStructureRuleSet", new String[0]));
        return DirectoryServer.directoryServer.schema.getDITStructureRuleSet();
    }

    public static DITStructureRule getDITStructureRule(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "getDITStructureRule", String.valueOf(n)));
        return DirectoryServer.directoryServer.schema.getDITStructureRule(n);
    }

    public static DITStructureRule getDITStructureRule(NameForm nameForm) {
        assert (Debug.debugEnter(CLASS_NAME, "getDITStructureRule", String.valueOf(nameForm)));
        return DirectoryServer.directoryServer.schema.getDITStructureRule(nameForm);
    }

    public static void registerDITStructureRule(DITStructureRule dITStructureRule, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerDITStructureRule", String.valueOf(dITStructureRule), String.valueOf(bl)));
        DirectoryServer.directoryServer.schema.registerDITStructureRule(dITStructureRule, bl);
    }

    public static void deregisterDITStructureRule(DITStructureRule dITStructureRule) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterDITStructureRule", String.valueOf(dITStructureRule)));
        DirectoryServer.directoryServer.schema.deregisterDITStructureRule(dITStructureRule);
    }

    public static ConcurrentHashMap<ObjectClass, NameForm> getNameForms() {
        assert (Debug.debugEnter(CLASS_NAME, "getNameForms", new String[0]));
        return DirectoryServer.directoryServer.schema.getNameFormsByObjectClass();
    }

    public static LinkedHashSet<AttributeValue> getNameFormSet() {
        assert (Debug.debugEnter(CLASS_NAME, "getNameFormSet", new String[0]));
        return DirectoryServer.directoryServer.schema.getNameFormSet();
    }

    public static NameForm getNameForm(ObjectClass objectClass) {
        assert (Debug.debugEnter(CLASS_NAME, "getNameForm", String.valueOf(objectClass)));
        return DirectoryServer.directoryServer.schema.getNameForm(objectClass);
    }

    public static NameForm getNameForm(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getNameForm", String.valueOf(string)));
        return DirectoryServer.directoryServer.schema.getNameForm(string);
    }

    public static void registerNameForm(NameForm nameForm, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerNameForm", String.valueOf(nameForm), String.valueOf(bl)));
        DirectoryServer.directoryServer.schema.registerNameForm(nameForm, bl);
    }

    public static void deregisterNameForm(NameForm nameForm) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterNameForm", String.valueOf(nameForm)));
        DirectoryServer.directoryServer.schema.deregisterNameForm(nameForm);
    }

    public static MBeanServer getJMXMBeanServer() {
        assert (Debug.debugEnter(CLASS_NAME, "getJMXMBeanServer", new String[0]));
        return DirectoryServer.directoryServer.mBeanServer;
    }

    public static ConcurrentHashMap<DN, JMXMBean> getJMXMBeans() {
        assert (Debug.debugEnter(CLASS_NAME, "getJMXMBeans", new String[0]));
        return DirectoryServer.directoryServer.mBeans;
    }

    public static JMXMBean getJMXMBean(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getJMXMBean", String.valueOf(dN)));
        return DirectoryServer.directoryServer.mBeans.get(dN);
    }

    public static void registerConfigurableComponent(ConfigurableComponent configurableComponent) {
        assert (Debug.debugEnter(CLASS_NAME, "registerConfigurableComponent", String.valueOf(configurableComponent)));
        DN dN = configurableComponent.getConfigurableComponentEntryDN();
        JMXMBean jMXMBean = DirectoryServer.directoryServer.mBeans.get(dN);
        if (jMXMBean == null) {
            jMXMBean = new JMXMBean(dN);
            jMXMBean.addConfigurableComponent(configurableComponent);
            DirectoryServer.directoryServer.mBeans.put(dN, jMXMBean);
        } else {
            jMXMBean.addConfigurableComponent(configurableComponent);
        }
    }

    public static void deregisterConfigurableComponent(ConfigurableComponent configurableComponent) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterConfigurableComponent", String.valueOf(configurableComponent)));
        DN dN = configurableComponent.getConfigurableComponentEntryDN();
        JMXMBean jMXMBean = DirectoryServer.directoryServer.mBeans.get(dN);
        if (jMXMBean != null) {
            jMXMBean.removeConfigurableComponent(configurableComponent);
        }
    }

    public static void registerInvokableComponent(InvokableComponent invokableComponent) {
        assert (Debug.debugEnter(CLASS_NAME, "registerInvokableComponent", String.valueOf(invokableComponent)));
        DN dN = invokableComponent.getInvokableComponentEntryDN();
        JMXMBean jMXMBean = DirectoryServer.directoryServer.mBeans.get(dN);
        if (jMXMBean == null) {
            jMXMBean = new JMXMBean(dN);
            jMXMBean.addInvokableComponent(invokableComponent);
            DirectoryServer.directoryServer.mBeans.put(dN, jMXMBean);
        } else {
            jMXMBean.addInvokableComponent(invokableComponent);
        }
    }

    public static void deregisterInvokableComponent(InvokableComponent invokableComponent) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterInvokableComponent", String.valueOf(invokableComponent)));
        DN dN = invokableComponent.getInvokableComponentEntryDN();
        JMXMBean jMXMBean = DirectoryServer.directoryServer.mBeans.get(dN);
        if (jMXMBean != null) {
            jMXMBean.removeInvokableComponent(invokableComponent);
        }
    }

    public static void registerAlertGenerator(AlertGenerator alertGenerator) {
        assert (Debug.debugEnter(CLASS_NAME, "registerAlertGenerator", new String[0]));
        DN dN = alertGenerator.getComponentEntryDN();
        JMXMBean jMXMBean = DirectoryServer.directoryServer.mBeans.get(dN);
        if (jMXMBean == null) {
            jMXMBean = new JMXMBean(dN);
            jMXMBean.addAlertGenerator(alertGenerator);
            DirectoryServer.directoryServer.mBeans.put(dN, jMXMBean);
        } else {
            jMXMBean.addAlertGenerator(alertGenerator);
        }
    }

    public static void deregisterAlertGenerator(AlertGenerator alertGenerator) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterAlertGenerator", new String[0]));
        DN dN = alertGenerator.getComponentEntryDN();
        JMXMBean jMXMBean = DirectoryServer.directoryServer.mBeans.get(dN);
        if (jMXMBean != null) {
            jMXMBean.removeAlertGenerator(alertGenerator);
        }
    }

    public static CopyOnWriteArrayList<AlertHandler> getAlertHandlers() {
        assert (Debug.debugEnter(CLASS_NAME, "getAlertHandlers", new String[0]));
        return DirectoryServer.directoryServer.alertHandlers;
    }

    public static void registerAlertHandler(AlertHandler alertHandler) {
        assert (Debug.debugEnter(CLASS_NAME, "registerAlertHandler", String.valueOf(alertHandler)));
        DirectoryServer.directoryServer.alertHandlers.add(alertHandler);
    }

    public static void deregisterAlertHandler(AlertHandler alertHandler) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterAlertHandler", String.valueOf(alertHandler)));
        DirectoryServer.directoryServer.alertHandlers.remove(alertHandler);
    }

    public static void sendAlertNotification(AlertGenerator alertGenerator, String string, int n, String string2) {
        assert (Debug.debugEnter(CLASS_NAME, "sendAlertNotification", String.valueOf(alertGenerator), String.valueOf(string), String.valueOf(n), String.valueOf(string2)));
        if (DirectoryServer.directoryServer.alertHandlers == null || DirectoryServer.directoryServer.alertHandlers.isEmpty()) {
            if (!DirectoryServer.directoryServer.isRunning) {
                try {
                    JMXAlertHandler jMXAlertHandler = new JMXAlertHandler();
                    jMXAlertHandler.initializeAlertHandler(null);
                    jMXAlertHandler.sendAlertNotification(alertGenerator, string, n, string2);
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "sendAlertNotification", exception));
                }
            }
        } else {
            for (AlertHandler object2 : DirectoryServer.directoryServer.alertHandlers) {
                object2.sendAlertNotification(alertGenerator, string, n, string2);
            }
        }
        int n2 = 458891;
        String string3 = MessageHandler.getMessage(n2, alertGenerator.getClassName(), string, n, string2);
        Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.NOTICE, string3, n2);
    }

    public static ConcurrentHashMap<String, PasswordStorageScheme> getPasswordStorageSchemes() {
        assert (Debug.debugEnter(CLASS_NAME, "getPasswordStorageSchemes", new String[0]));
        return DirectoryServer.directoryServer.passwordStorageSchemes;
    }

    public static PasswordStorageScheme getPasswordStorageScheme(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getPasswordStorageScheme", String.valueOf(string)));
        return DirectoryServer.directoryServer.passwordStorageSchemes.get(string);
    }

    public static ConcurrentHashMap<String, PasswordStorageScheme> getAuthPasswordStorageSchemes() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthPasswordStorageSchemes", new String[0]));
        return DirectoryServer.directoryServer.authPasswordStorageSchemes;
    }

    public static PasswordStorageScheme getAuthPasswordStorageScheme(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthPasswordStorageScheme", String.valueOf(string)));
        return DirectoryServer.directoryServer.authPasswordStorageSchemes.get(string);
    }

    public static void registerPasswordStorageScheme(PasswordStorageScheme passwordStorageScheme) {
        assert (Debug.debugEnter(CLASS_NAME, "registerPasswordStorageScheme", String.valueOf(passwordStorageScheme)));
        String string = StaticUtils.toLowerCase(passwordStorageScheme.getStorageSchemeName());
        DirectoryServer.directoryServer.passwordStorageSchemes.put(string, passwordStorageScheme);
        if (passwordStorageScheme.supportsAuthPasswordSyntax()) {
            DirectoryServer.directoryServer.authPasswordStorageSchemes.put(passwordStorageScheme.getAuthPasswordSchemeName(), passwordStorageScheme);
        }
    }

    public static void deregisterPasswordStorageScheme(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterPasswordStorageScheme", String.valueOf(string)));
        PasswordStorageScheme passwordStorageScheme = DirectoryServer.directoryServer.passwordStorageSchemes.remove(string);
        if (passwordStorageScheme != null && passwordStorageScheme.supportsAuthPasswordSyntax()) {
            DirectoryServer.directoryServer.authPasswordStorageSchemes.remove(passwordStorageScheme.getAuthPasswordSchemeName());
        }
    }

    public static ConcurrentHashMap<DN, PasswordValidator> getPasswordValidators() {
        assert (Debug.debugEnter(CLASS_NAME, "getPasswordValidators", new String[0]));
        return DirectoryServer.directoryServer.passwordValidators;
    }

    public static PasswordValidator getPasswordValidator(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getPasswordValidator", String.valueOf(dN)));
        return DirectoryServer.directoryServer.passwordValidators.get(dN);
    }

    public static void registerPasswordValidator(DN dN, PasswordValidator passwordValidator) {
        assert (Debug.debugEnter(CLASS_NAME, "registerPasswordValidator", String.valueOf(dN), String.valueOf(passwordValidator)));
        DirectoryServer.directoryServer.passwordValidators.put(dN, passwordValidator);
    }

    public static void deregisterPasswordValidator(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterPasswordValidator", String.valueOf(dN)));
        DirectoryServer.directoryServer.passwordValidators.remove(dN);
    }

    public static ConcurrentHashMap<DN, AccountStatusNotificationHandler> getAccountStatusNotificationHandlers() {
        assert (Debug.debugEnter(CLASS_NAME, "getAccountStatusNotificationHandlers", new String[0]));
        return DirectoryServer.directoryServer.accountStatusNotificationHandlers;
    }

    public static AccountStatusNotificationHandler getAccountStatusNotificationHandler(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getAccountStatusNotificationHandler", String.valueOf(dN)));
        return DirectoryServer.directoryServer.accountStatusNotificationHandlers.get(dN);
    }

    public static void registerAccountStatusNotificationHandler(DN dN, AccountStatusNotificationHandler accountStatusNotificationHandler) {
        assert (Debug.debugEnter(CLASS_NAME, "registerAccountStatusNotificationHandler", String.valueOf(dN), String.valueOf(accountStatusNotificationHandler)));
        DirectoryServer.directoryServer.accountStatusNotificationHandlers.put(dN, accountStatusNotificationHandler);
    }

    public static void deregisterAccountStatusNotificationHandler(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterAccountStatusNotificationHandler", String.valueOf(dN)));
        DirectoryServer.directoryServer.accountStatusNotificationHandlers.remove(dN);
    }

    public static ConcurrentHashMap<DN, PasswordGenerator> getPasswordGenerators() {
        assert (Debug.debugEnter(CLASS_NAME, "getPasswordGenerators", new String[0]));
        return DirectoryServer.directoryServer.passwordGenerators;
    }

    public static PasswordGenerator getPasswordGenerator(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getPasswordGenerator", String.valueOf(dN)));
        return DirectoryServer.directoryServer.passwordGenerators.get(dN);
    }

    public static void registerPasswordGenerator(DN dN, PasswordGenerator passwordGenerator) {
        assert (Debug.debugEnter(CLASS_NAME, "registerPasswordGenerator", String.valueOf(dN), String.valueOf(passwordGenerator)));
        DirectoryServer.directoryServer.passwordGenerators.put(dN, passwordGenerator);
    }

    public static void deregisterPasswordGenerator(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterPasswordGenerator", String.valueOf(dN)));
        DirectoryServer.directoryServer.passwordGenerators.remove(dN);
    }

    public static ConcurrentHashMap<DN, PasswordPolicy> getPasswordPolicies() {
        assert (Debug.debugEnter(CLASS_NAME, "getPasswordPolicies", new String[0]));
        return DirectoryServer.directoryServer.passwordPolicies;
    }

    public static PasswordPolicy getPasswordPolicy(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getPasswordPolicy", String.valueOf(dN)));
        return DirectoryServer.directoryServer.passwordPolicies.get(dN);
    }

    public static void registerPasswordPolicy(DN dN, PasswordPolicy passwordPolicy) {
        assert (Debug.debugEnter(CLASS_NAME, "registerPasswordPolicy", String.valueOf(dN), String.valueOf(passwordPolicy)));
        DirectoryServer.directoryServer.passwordPolicies.put(dN, passwordPolicy);
    }

    public static void deregisterPasswordPolicy(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterPasswordPolicy", String.valueOf(dN)));
        DirectoryServer.directoryServer.passwordPolicies.remove(dN);
    }

    public static DN getDefaultPasswordPolicyDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getDefaultPasswordPolicyDN", new String[0]));
        return DirectoryServer.directoryServer.defaultPasswordPolicyDN;
    }

    public static void setDefaultPasswordPolicyDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "setDefaultPasswordPolicyDN", String.valueOf(dN)));
        DirectoryServer.directoryServer.defaultPasswordPolicyDN = dN;
        DirectoryServer.directoryServer.defaultPasswordPolicy = null;
    }

    public static PasswordPolicy getDefaultPasswordPolicy() {
        assert (Debug.debugEnter(CLASS_NAME, "getDefaultPasswordPolicy", new String[0]));
        if (DirectoryServer.directoryServer.defaultPasswordPolicy == null && DirectoryServer.directoryServer.defaultPasswordPolicyDN != null) {
            DirectoryServer.directoryServer.defaultPasswordPolicy = DirectoryServer.directoryServer.passwordPolicies.get(DirectoryServer.directoryServer.defaultPasswordPolicyDN);
        }
        return DirectoryServer.directoryServer.defaultPasswordPolicy;
    }

    public static void setDefaultPasswordPolicy(PasswordPolicy passwordPolicy) {
        assert (Debug.debugEnter(CLASS_NAME, "setDefaultPasswordPolicy", String.valueOf(passwordPolicy)));
        DirectoryServer.directoryServer.defaultPasswordPolicy = passwordPolicy;
        DirectoryServer.directoryServer.defaultPasswordPolicyDN = passwordPolicy.getConfigurableComponentEntryDN();
    }

    public static ConcurrentHashMap<String, MonitorProvider> getMonitorProviders() {
        assert (Debug.debugEnter(CLASS_NAME, "getMonitorProviders", new String[0]));
        return DirectoryServer.directoryServer.monitorProviders;
    }

    public static MonitorProvider getMonitorProvider(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getMonitorProvider", String.valueOf(string)));
        return DirectoryServer.directoryServer.monitorProviders.get(string);
    }

    public static void registerMonitorProvider(MonitorProvider monitorProvider) {
        block5: {
            assert (Debug.debugEnter(CLASS_NAME, "registerMonitorProvider", String.valueOf(monitorProvider)));
            String string = StaticUtils.toLowerCase(monitorProvider.getMonitorInstanceName());
            DirectoryServer.directoryServer.monitorProviders.put(string, monitorProvider);
            try {
                DN dN = DN.decode("cn=" + monitorProvider.getMonitorInstanceName() + ",cn=monitor");
                JMXMBean jMXMBean = DirectoryServer.directoryServer.mBeans.get(dN);
                if (jMXMBean == null) {
                    jMXMBean = new JMXMBean(dN);
                    jMXMBean.addMonitorProvider(monitorProvider);
                    DirectoryServer.directoryServer.mBeans.put(dN, jMXMBean);
                } else {
                    jMXMBean.addMonitorProvider(monitorProvider);
                }
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "registerMonitorProvider", exception)) break block5;
                throw new AssertionError();
            }
        }
    }

    public static void deregisterMonitorProvider(String string) {
        block5: {
            assert (Debug.debugEnter(CLASS_NAME, "deregisterMonitorProvider", String.valueOf(string)));
            MonitorProvider monitorProvider = DirectoryServer.directoryServer.monitorProviders.remove(StaticUtils.toLowerCase(string));
            if (monitorProvider != null) {
                try {
                    DN dN = DN.decode("cn=" + monitorProvider.getMonitorInstanceName() + ",cn=monitor");
                    JMXMBean jMXMBean = DirectoryServer.directoryServer.mBeans.get(dN);
                    if (jMXMBean != null) {
                        jMXMBean.removeMonitorProvider(monitorProvider);
                    }
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "deregisterMonitorProvider", exception)) break block5;
                    throw new AssertionError();
                }
            }
        }
    }

    public static EntryCache getEntryCache() {
        assert (Debug.debugEnter(CLASS_NAME, "getEntryCache", new String[0]));
        return DirectoryServer.directoryServer.entryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEntryCache(EntryCache entryCache) {
        assert (Debug.debugEnter(CLASS_NAME, "setEntryCache", new String[0]));
        DirectoryServer directoryServer = DirectoryServer.directoryServer;
        synchronized (directoryServer) {
            DirectoryServer.directoryServer.entryCache = entryCache;
        }
    }

    public static KeyManagerProvider getKeyManagerProvider() {
        assert (Debug.debugEnter(CLASS_NAME, "getKeyManagerProvider", new String[0]));
        return DirectoryServer.directoryServer.keyManagerProvider;
    }

    public static void setKeyManagerProvider(KeyManagerProvider keyManagerProvider) {
        assert (Debug.debugEnter(CLASS_NAME, "setKeyManagerProvider", String.valueOf(keyManagerProvider)));
        DirectoryServer.directoryServer.keyManagerProvider = keyManagerProvider;
    }

    public static TrustManagerProvider getTrustManagerProvider() {
        assert (Debug.debugEnter(CLASS_NAME, "getTrustManagerProvider", new String[0]));
        return DirectoryServer.directoryServer.trustManagerProvider;
    }

    public static void setTrustManagerProvider(TrustManagerProvider trustManagerProvider) {
        assert (Debug.debugEnter(CLASS_NAME, "setTrustManagerProvider", String.valueOf(trustManagerProvider)));
        DirectoryServer.directoryServer.trustManagerProvider = trustManagerProvider;
    }

    public static CertificateMapper getCertificateMapper() {
        assert (Debug.debugEnter(CLASS_NAME, "getCertificateMapper", new String[0]));
        return DirectoryServer.directoryServer.certificateMapper;
    }

    public static void setCertificateMapper(CertificateMapper certificateMapper) {
        assert (Debug.debugEnter(CLASS_NAME, "setCertificateMapper", String.valueOf(certificateMapper)));
        DirectoryServer.directoryServer.certificateMapper = certificateMapper;
    }

    public static CopyOnWriteArraySet<DN> getRootDNs() {
        assert (Debug.debugEnter(CLASS_NAME, "getRootDNs", new String[0]));
        return DirectoryServer.directoryServer.rootDNs;
    }

    public static boolean isRootDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "isRootDN", String.valueOf(dN)));
        return DirectoryServer.directoryServer.rootDNs.contains(dN);
    }

    public static void registerRootDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "registerRootDN", String.valueOf(dN)));
        DirectoryServer.directoryServer.rootDNs.add(dN);
    }

    public static void deregisterRootDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterRootDN", String.valueOf(dN)));
        DirectoryServer.directoryServer.rootDNs.remove(dN);
    }

    public static ConcurrentHashMap<DN, DN> getAlternateRootBindDNs() {
        assert (Debug.debugEnter(CLASS_NAME, "getAlternateRootBindDNs", new String[0]));
        return DirectoryServer.directoryServer.alternateRootBindDNs;
    }

    public static DN getActualRootBindDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getActualRootBindDN", String.valueOf(dN)));
        return DirectoryServer.directoryServer.alternateRootBindDNs.get(dN);
    }

    public static void registerAlternateRootDN(DN dN, DN dN2) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "registerAlternateRootDN", String.valueOf(dN), String.valueOf(dN2)));
        DN dN3 = DirectoryServer.directoryServer.alternateRootBindDNs.putIfAbsent(dN2, dN);
        if (dN3 != null && !dN3.equals(dN)) {
            int n = 262674;
            String string = MessageHandler.getMessage(n, String.valueOf(dN2), String.valueOf(dN3));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
        }
    }

    public static DN deregisterAlternateRootBindDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterAlternateRootBindDN", String.valueOf(dN)));
        return DirectoryServer.directoryServer.alternateRootBindDNs.remove(dN);
    }

    public static ResultCode getServerErrorResultCode() {
        assert (Debug.debugEnter(CLASS_NAME, "getServerErrorResultCode", new String[0]));
        return DirectoryServer.directoryServer.serverErrorResultCode;
    }

    public static void setServerErrorResultCode(ResultCode resultCode) {
        assert (Debug.debugEnter(CLASS_NAME, "setServerErrorResultCode", String.valueOf((Object)resultCode)));
        DirectoryServer.directoryServer.serverErrorResultCode = resultCode;
    }

    public static boolean addMissingRDNAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "addMissingRDNAttributes", new String[0]));
        return DirectoryServer.directoryServer.addMissingRDNAttributes;
    }

    public static void setAddMissingRDNAttributes(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setAddMissingRDNAttributes", String.valueOf(bl)));
        DirectoryServer.directoryServer.addMissingRDNAttributes = bl;
    }

    public static boolean allowAttributeNameExceptions() {
        assert (Debug.debugEnter(CLASS_NAME, "allowAttributeNameExceptions", new String[0]));
        return DirectoryServer.directoryServer.allowAttributeNameExceptions;
    }

    public static void setAllowAttributeNameExceptions(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setAllowAttributeNameExceptions", String.valueOf(bl)));
        DirectoryServer.directoryServer.allowAttributeNameExceptions = bl;
    }

    public static boolean checkSchema() {
        assert (Debug.debugEnter(CLASS_NAME, "checkSchema", new String[0]));
        return DirectoryServer.directoryServer.checkSchema;
    }

    public static void setCheckSchema(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setCheckSchema", String.valueOf(bl)));
        DirectoryServer.directoryServer.checkSchema = bl;
    }

    public static AcceptRejectWarn getSingleStructuralObjectClassPolicy() {
        assert (Debug.debugEnter(CLASS_NAME, "getSingleStructuralObjectClassPolicy", new String[0]));
        return DirectoryServer.directoryServer.singleStructuralClassPolicy;
    }

    public static void setSingleStructuralObjectClassPolicy(AcceptRejectWarn acceptRejectWarn) {
        assert (Debug.debugEnter(CLASS_NAME, "getSingleStructuralObjectClassPolicy", new String[0]));
        DirectoryServer.directoryServer.singleStructuralClassPolicy = acceptRejectWarn;
    }

    public static AcceptRejectWarn getSyntaxEnforcementPolicy() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxEnforcementPolicy", new String[0]));
        return DirectoryServer.directoryServer.syntaxEnforcementPolicy;
    }

    public static void setSyntaxEnforcementPolicy(AcceptRejectWarn acceptRejectWarn) {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxEnforcementPolicy", new String[0]));
        DirectoryServer.directoryServer.syntaxEnforcementPolicy = acceptRejectWarn;
    }

    public static boolean notifyAbandonedOperations() {
        assert (Debug.debugEnter(CLASS_NAME, "notifyAbandonedOperations", new String[0]));
        return DirectoryServer.directoryServer.notifyAbandonedOperations;
    }

    public static void setNotifyAbandonedOperations(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setNotifyAbandonedOperations", String.valueOf(bl)));
        DirectoryServer.directoryServer.notifyAbandonedOperations = bl;
    }

    public static LinkedHashMap<String, Backend> getBackends() {
        assert (Debug.debugEnter(CLASS_NAME, "getBackends", new String[0]));
        return DirectoryServer.directoryServer.backends;
    }

    public static Backend getBackend(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getBackend", String.valueOf(string)));
        return DirectoryServer.directoryServer.backends.get(string);
    }

    public static boolean hasBackend(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "hasBackend", String.valueOf(string)));
        return DirectoryServer.directoryServer.backends.containsKey(string);
    }

    public static void registerBackend(Backend backend) {
        assert (Debug.debugEnter(CLASS_NAME, "registerBackend", String.valueOf(backend)));
        DirectoryServer.directoryServer.backends.put(backend.getBackendID(), backend);
    }

    public static void deregisterBackend(Backend backend) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterBackend", String.valueOf(backend)));
        DirectoryServer.directoryServer.backends.remove(backend.getBackendID());
    }

    public static LinkedHashMap<DN, Backend> getSuffixes() {
        assert (Debug.debugEnter(CLASS_NAME, "getSuffixes", new String[0]));
        return DirectoryServer.directoryServer.suffixes;
    }

    public static LinkedHashMap<DN, Backend> getPrivateSuffixes() {
        assert (Debug.debugEnter(CLASS_NAME, "getPrivateSuffixes", new String[0]));
        return DirectoryServer.directoryServer.privateSuffixes;
    }

    public static boolean isSuffix(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "isSuffix", String.valueOf(dN)));
        return DirectoryServer.directoryServer.suffixes.containsKey(dN) || DirectoryServer.directoryServer.privateSuffixes.containsKey(dN);
    }

    public static Backend getBackend(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getBackend", String.valueOf(dN)));
        if (dN.isNullDN()) {
            return DirectoryServer.directoryServer.rootDSEBackend;
        }
        Backend backend = DirectoryServer.directoryServer.suffixes.get(dN);
        if (backend == null) {
            backend = DirectoryServer.directoryServer.privateSuffixes.get(dN);
        }
        while (backend == null && (dN = dN.getParent()) != null) {
            backend = DirectoryServer.directoryServer.suffixes.get(dN);
            if (backend != null) continue;
            backend = DirectoryServer.directoryServer.privateSuffixes.get(dN);
        }
        return backend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSuffix(DN dN, Backend backend) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "registerSuffix", String.valueOf(dN), String.valueOf(backend)));
        backend.setPrivateBackend(false);
        LinkedHashMap<DN, Backend> linkedHashMap = DirectoryServer.directoryServer.suffixes;
        synchronized (linkedHashMap) {
            Object object;
            Object object2;
            Set<String> set;
            Backend backend2 = DirectoryServer.directoryServer.suffixes.get(dN);
            if (backend2 != null) {
                int n = 262324;
                String string = MessageHandler.getMessage(n, String.valueOf(dN), backend2.getClass().getName());
                throw new ConfigException(n, string);
            }
            boolean bl = false;
            for (DN dN2 = dN.getParent(); dN2 != null; dN2 = dN2.getParent()) {
                backend2 = DirectoryServer.directoryServer.suffixes.get(dN);
                if (backend2 == null) continue;
                if (backend2.hasSubSuffix(dN)) {
                    int n = 262325;
                    String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(dN2));
                    throw new ConfigException(n, string);
                }
                backend2.addSubordinateBackend(backend);
                bl = true;
                break;
            }
            if (!bl) {
                DirectoryServer.directoryServer.suffixes.put(dN, backend);
            }
            if ((set = backend.getSupportedControls()) != null) {
                object2 = set.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    DirectoryServer.registerSupportedControl((String)object);
                }
            }
            if ((object2 = backend.getSupportedFeatures()) != null) {
                object = object2.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    DirectoryServer.registerSupportedFeature(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPrivateSuffix(DN dN, Backend backend) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "registerPrivateSuffix", String.valueOf(dN), String.valueOf(backend)));
        backend.setPrivateBackend(true);
        LinkedHashMap<DN, Backend> linkedHashMap = DirectoryServer.directoryServer.privateSuffixes;
        synchronized (linkedHashMap) {
            Object object;
            Object object2;
            Object object3 = DirectoryServer.directoryServer.suffixes;
            synchronized (object3) {
                object2 = DirectoryServer.directoryServer.suffixes.get(dN);
                if (object2 != null) {
                    int n = 262324;
                    String string = MessageHandler.getMessage(n, String.valueOf(dN), object2.getClass().getName());
                    throw new ConfigException(n, string);
                }
                object = dN.getParent();
                while (object != null) {
                    object2 = DirectoryServer.directoryServer.suffixes.get(dN);
                    if (object2 != null) {
                        int n = 262326;
                        String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(object));
                        throw new ConfigException(n, string);
                    }
                    object = dN.getParent();
                }
            }
            object3 = DirectoryServer.directoryServer.privateSuffixes.get(dN);
            if (object3 != null) {
                int n = 262324;
                object = MessageHandler.getMessage(n, String.valueOf(dN), object3.getClass().getName());
                throw new ConfigException(n, (String)object);
            }
            object2 = dN.getParent();
            while (object2 != null) {
                object3 = DirectoryServer.directoryServer.privateSuffixes.get(dN);
                if (object3 != null) {
                    if (((Backend)object3).hasSubSuffix(dN)) {
                        int n = 262325;
                        String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(object2));
                        throw new ConfigException(n, string);
                    }
                    ((Backend)object3).addSubordinateBackend(backend);
                    return;
                }
                object2 = dN.getParent();
            }
            DirectoryServer.directoryServer.privateSuffixes.put(dN, backend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterSuffix(DN dN) throws ConfigException {
        DN dN2;
        Backend backend;
        assert (Debug.debugEnter(CLASS_NAME, "deregisterSuffix", String.valueOf(dN)));
        LinkedHashMap<DN, Backend> linkedHashMap = DirectoryServer.directoryServer.suffixes;
        synchronized (linkedHashMap) {
            backend = (Backend)DirectoryServer.directoryServer.suffixes.remove(dN);
            if (backend != null) {
                return;
            }
            dN2 = dN.getParent();
            while (dN2 != null) {
                backend = DirectoryServer.directoryServer.suffixes.get(dN2);
                if (backend == null) continue;
                if (backend.hasSubSuffix(dN)) {
                    backend.removeSubSuffix(dN, dN2);
                }
                return;
            }
        }
        linkedHashMap = DirectoryServer.directoryServer.privateSuffixes;
        synchronized (linkedHashMap) {
            backend = (Backend)DirectoryServer.directoryServer.privateSuffixes.remove(dN);
            if (backend != null) {
                return;
            }
            dN2 = dN.getParent();
            while (dN2 != null) {
                backend = DirectoryServer.directoryServer.privateSuffixes.get(dN2);
                if (backend == null) continue;
                if (backend.hasSubSuffix(dN)) {
                    backend.removeSubSuffix(dN, dN2);
                }
                return;
            }
        }
    }

    public static Entry getRootDSE() {
        assert (Debug.debugEnter(CLASS_NAME, "getRootDSE", new String[0]));
        return DirectoryServer.directoryServer.rootDSEBackend.getRootDSE();
    }

    public static RootDSEBackend getRootDSEBackend() {
        assert (Debug.debugEnter(CLASS_NAME, "getRootDSEBackend", new String[0]));
        return DirectoryServer.directoryServer.rootDSEBackend;
    }

    public static DN getSchemaDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getSchemaDN", new String[0]));
        return DirectoryServer.directoryServer.schemaDN;
    }

    public static void setSchemaDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "setSchemaDN", String.valueOf(dN)));
        DirectoryServer.directoryServer.schemaDN = dN;
    }

    public static Entry getEntry(DN dN) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getEntry", String.valueOf(dN)));
        if (dN.isNullDN()) {
            return DirectoryServer.directoryServer.rootDSEBackend.getRootDSE();
        }
        Backend backend = DirectoryServer.getBackend(dN);
        if (backend == null) {
            return null;
        }
        return backend.getEntry(dN);
    }

    public static boolean entryExists(DN dN) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getEntry", String.valueOf(dN)));
        if (dN.isNullDN()) {
            return true;
        }
        Backend backend = DirectoryServer.getBackend(dN);
        if (backend == null) {
            return false;
        }
        return backend.entryExists(dN);
    }

    public static TreeSet<String> getSupportedControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedControls", new String[0]));
        return DirectoryServer.directoryServer.supportedControls;
    }

    public static boolean isSupportedControl(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "isSupportedControl", String.valueOf(string)));
        return DirectoryServer.directoryServer.supportedControls.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSupportedControl(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "registerSupportedControl", String.valueOf(string)));
        TreeSet<String> treeSet = DirectoryServer.directoryServer.supportedControls;
        synchronized (treeSet) {
            DirectoryServer.directoryServer.supportedControls.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterSupportedControl(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterSupportedControl", String.valueOf(string)));
        TreeSet<String> treeSet = DirectoryServer.directoryServer.supportedControls;
        synchronized (treeSet) {
            DirectoryServer.directoryServer.supportedControls.remove(string);
        }
    }

    public static TreeSet<String> getSupportedFeatures() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedFeatures", new String[0]));
        return DirectoryServer.directoryServer.supportedFeatures;
    }

    public static boolean isSupportedFeature(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "isSupportedFeature", String.valueOf(string)));
        return DirectoryServer.directoryServer.supportedFeatures.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSupportedFeature(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "registerSupportedFeature", String.valueOf(string)));
        TreeSet<String> treeSet = DirectoryServer.directoryServer.supportedFeatures;
        synchronized (treeSet) {
            DirectoryServer.directoryServer.supportedFeatures.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterSupportedFeature(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterSupportedFeature", String.valueOf(string)));
        TreeSet<String> treeSet = DirectoryServer.directoryServer.supportedFeatures;
        synchronized (treeSet) {
            DirectoryServer.directoryServer.supportedFeatures.remove(string);
        }
    }

    public static ConcurrentHashMap<String, ExtendedOperationHandler> getSupportedExtensions() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedExtensions", new String[0]));
        return DirectoryServer.directoryServer.extendedOperationHandlers;
    }

    public static ExtendedOperationHandler getExtendedOperationHandler(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getExtendedOperationHandler", String.valueOf(string)));
        return DirectoryServer.directoryServer.extendedOperationHandlers.get(string);
    }

    public static void registerSupportedExtension(String string, ExtendedOperationHandler extendedOperationHandler) {
        assert (Debug.debugEnter(CLASS_NAME, "registerSupportedExtension", String.valueOf(string), String.valueOf(extendedOperationHandler)));
        DirectoryServer.directoryServer.extendedOperationHandlers.put(StaticUtils.toLowerCase(string), extendedOperationHandler);
    }

    public static void deregisterSupportedExtension(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterSupportedExtension", String.valueOf(string)));
        DirectoryServer.directoryServer.extendedOperationHandlers.remove(StaticUtils.toLowerCase(string));
    }

    public static ConcurrentHashMap<String, SASLMechanismHandler> getSupportedSASLMechanisms() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedSASLMechanisms", new String[0]));
        return DirectoryServer.directoryServer.saslMechanismHandlers;
    }

    public static SASLMechanismHandler getSASLMechanismHandler(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getSASLMechanismHandler", String.valueOf(string)));
        return DirectoryServer.directoryServer.saslMechanismHandlers.get(string);
    }

    public static void registerSASLMechanismHandler(String string, SASLMechanismHandler sASLMechanismHandler) {
        assert (Debug.debugEnter(CLASS_NAME, "registerSASLMechanismHandler", String.valueOf(string), String.valueOf(sASLMechanismHandler)));
        DirectoryServer.directoryServer.saslMechanismHandlers.put(string, sASLMechanismHandler);
    }

    public static void deregisterSASLMechanismHandler(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterSASLMechanismHandler", String.valueOf(string)));
        DirectoryServer.directoryServer.saslMechanismHandlers.remove(string);
    }

    public static ConcurrentHashMap<DN, IdentityMapper> getIdentityMappers() {
        assert (Debug.debugEnter(CLASS_NAME, "getIdentityMappers", new String[0]));
        return DirectoryServer.directoryServer.identityMappers;
    }

    public static IdentityMapper getIdentityMapper(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getIdentityMapper", String.valueOf(dN)));
        return DirectoryServer.directoryServer.identityMappers.get(dN);
    }

    public static void registerIdentityMapper(DN dN, IdentityMapper identityMapper) {
        assert (Debug.debugEnter(CLASS_NAME, "registerIdentityMapper", String.valueOf(dN), String.valueOf(identityMapper)));
        DirectoryServer.directoryServer.identityMappers.put(dN, identityMapper);
    }

    public static void deregisterIdentityMapper(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterIdentityMapper", String.valueOf(dN)));
        DirectoryServer.directoryServer.identityMappers.remove(dN);
    }

    public static DN getProxiedAuthorizationIdentityMapperDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getProxiedAuthorizationIdentityMapperDN", new String[0]));
        return DirectoryServer.directoryServer.proxiedAuthorizationIdentityMapperDN;
    }

    public static void setProxiedAuthorizationIdentityMapperDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "setProxiedAuthorizationIdentityMapperDN", String.valueOf(dN)));
        DirectoryServer.directoryServer.proxiedAuthorizationIdentityMapperDN = dN;
    }

    public static IdentityMapper getProxiedAuthorizationIdentityMapper() {
        assert (Debug.debugEnter(CLASS_NAME, "getProxiedAuthorizationIdentityMapper", new String[0]));
        if (DirectoryServer.directoryServer.proxiedAuthorizationIdentityMapperDN == null) {
            return null;
        }
        return DirectoryServer.directoryServer.identityMappers.get(DirectoryServer.directoryServer.proxiedAuthorizationIdentityMapperDN);
    }

    public static CopyOnWriteArrayList<ConnectionHandler> getConnectionHandlers() {
        assert (Debug.debugEnter(CLASS_NAME, "getConnectionHandlers", new String[0]));
        return DirectoryServer.directoryServer.connectionHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerConnectionHandler(ConnectionHandler connectionHandler) {
        assert (Debug.debugEnter(CLASS_NAME, "registerConnectionHandler", String.valueOf(connectionHandler)));
        CopyOnWriteArrayList<ConnectionHandler> copyOnWriteArrayList = DirectoryServer.directoryServer.connectionHandlers;
        synchronized (copyOnWriteArrayList) {
            DirectoryServer.directoryServer.connectionHandlers.add(connectionHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterConnectionHandler(ConnectionHandler connectionHandler) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterConnectionHandler", String.valueOf(connectionHandler)));
        CopyOnWriteArrayList<ConnectionHandler> copyOnWriteArrayList = DirectoryServer.directoryServer.connectionHandlers;
        synchronized (copyOnWriteArrayList) {
            DirectoryServer.directoryServer.connectionHandlers.remove(connectionHandler);
        }
    }

    private void initializeWorkQueue() throws ConfigException, InitializationException {
        Class<?> clazz;
        DN dN;
        assert (Debug.debugEnter(CLASS_NAME, "initializeWorkQueue", new String[0]));
        try {
            dN = DN.decode("cn=Work Queue,cn=config");
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeWorkQueue", exception));
            int n = 262668;
            String string = MessageHandler.getMessage(n, "cn=Work Queue,cn=config", StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        ConfigEntry configEntry = this.configHandler.getConfigEntry(dN);
        if (configEntry == null) {
            int n = 262669;
            String string = MessageHandler.getMessage(n, "cn=Work Queue,cn=config");
            throw new ConfigException(n, string);
        }
        int n = 526;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-work-queue-class", MessageHandler.getMessage(n), true, false, true);
        StringConfigAttribute stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
        if (stringConfigAttribute2 == null) {
            n = 262671;
            String string = MessageHandler.getMessage(n, "cn=Work Queue,cn=config", "ds-cfg-work-queue-class");
            throw new ConfigException(n, string);
        }
        try {
            clazz = Class.forName(stringConfigAttribute2.activeValue());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeWorkQueue", exception));
            n = 262672;
            String string = MessageHandler.getMessage(n, stringConfigAttribute2.activeValue(), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        try {
            this.workQueue = (WorkQueue)clazz.newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeWorkQueue", exception));
            n = 262673;
            String string = MessageHandler.getMessage(n, stringConfigAttribute2.activeValue(), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        this.workQueue.initializeWorkQueue(configEntry);
    }

    public static WorkQueue getWorkQueue() {
        assert (Debug.debugEnter(CLASS_NAME, "getWorkQueue", new String[0]));
        return DirectoryServer.directoryServer.workQueue;
    }

    public static void enqueueRequest(Operation operation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "enqueueRequest", String.valueOf(operation)));
        ClientConnection clientConnection = operation.getClientConnection();
        if (clientConnection.bindInProgress() && operation.getOperationType() != OperationType.BIND) {
            int n = 197109;
            String string = MessageHandler.getMessage(n);
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
        }
        if (clientConnection.mustChangePassword()) {
            switch (operation.getOperationType()) {
                case ADD: 
                case COMPARE: 
                case DELETE: 
                case MODIFY_DN: 
                case SEARCH: {
                    int n = 197110;
                    String string = MessageHandler.getMessage(n);
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
                }
                case EXTENDED: {
                    ExtendedOperation extendedOperation = (ExtendedOperation)operation;
                    String string = extendedOperation.getRequestOID();
                    if (string != null && string.equals("1.3.6.1.4.1.4203.1.11.1")) break;
                    int n = 197110;
                    String string2 = MessageHandler.getMessage(n);
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string2, n);
                }
            }
        }
        DirectoryServer.directoryServer.workQueue.submitOperation(operation);
    }

    public static CopyOnWriteArrayList<ChangeNotificationListener> getChangeNotificationListeners() {
        assert (Debug.debugEnter(CLASS_NAME, "getChangeNotificationListeners", new String[0]));
        return DirectoryServer.directoryServer.changeNotificationListeners;
    }

    public static void registerChangeNotificationListener(ChangeNotificationListener changeNotificationListener) {
        assert (Debug.debugEnter(CLASS_NAME, "registerChangeNotificationListener", String.valueOf(changeNotificationListener)));
        DirectoryServer.directoryServer.changeNotificationListeners.add(changeNotificationListener);
    }

    public static void deregisterChangeNotificationListener(ChangeNotificationListener changeNotificationListener) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterChangeNotificationListener", String.valueOf(changeNotificationListener)));
        DirectoryServer.directoryServer.changeNotificationListeners.remove(changeNotificationListener);
    }

    public static CopyOnWriteArrayList<PersistentSearch> getPersistentSearches() {
        assert (Debug.debugEnter(CLASS_NAME, "getPersistentSearches", new String[0]));
        return DirectoryServer.directoryServer.persistentSearches;
    }

    public static void registerPersistentSearch(PersistentSearch persistentSearch) {
        assert (Debug.debugEnter(CLASS_NAME, "registerPersistentSearch", String.valueOf(persistentSearch)));
        DirectoryServer.directoryServer.persistentSearches.add(persistentSearch);
        persistentSearch.getSearchOperation().getClientConnection().registerPersistentSearch(persistentSearch);
    }

    public static void deregisterPersistentSearch(PersistentSearch persistentSearch) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterPersistentSearch", String.valueOf(persistentSearch)));
        DirectoryServer.directoryServer.persistentSearches.remove(persistentSearch);
        persistentSearch.getSearchOperation().getClientConnection().deregisterPersistentSearch(persistentSearch);
    }

    public static CopyOnWriteArrayList<SynchronizationProvider> getSynchronizationProviders() {
        assert (Debug.debugEnter(CLASS_NAME, "getSynchronizationProviders", new String[0]));
        return DirectoryServer.directoryServer.synchronizationProviders;
    }

    public static void registerSynchronizationProvider(SynchronizationProvider synchronizationProvider) {
        assert (Debug.debugEnter(CLASS_NAME, "registerSynchronizationProvider", String.valueOf(synchronizationProvider)));
        DirectoryServer.directoryServer.synchronizationProviders.add(synchronizationProvider);
    }

    public static void deregisterSynchronizationProvider(SynchronizationProvider synchronizationProvider) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterSynchronizationProvider", String.valueOf(synchronizationProvider)));
        DirectoryServer.directoryServer.synchronizationProviders.remove(synchronizationProvider);
    }

    public static void registerShutdownListener(ServerShutdownListener serverShutdownListener) {
        assert (Debug.debugEnter(CLASS_NAME, "registerShutdownListener", String.valueOf(serverShutdownListener)));
        DirectoryServer.directoryServer.shutdownListeners.add(serverShutdownListener);
    }

    public static void deregisterShutdownListener(ServerShutdownListener serverShutdownListener) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterShutdownListener", String.valueOf(serverShutdownListener)));
        DirectoryServer.directoryServer.shutdownListeners.remove(serverShutdownListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutDown(String string, String string2) {
        ServerShutdownMonitor serverShutdownMonitor;
        block53: {
            String string3;
            int n;
            block52: {
                Object object;
                assert (Debug.debugEnter(CLASS_NAME, "shutDown", String.valueOf(string), String.valueOf(string2)));
                DirectoryServer directoryServer = DirectoryServer.directoryServer;
                synchronized (directoryServer) {
                    if (DirectoryServer.directoryServer.shuttingDown) {
                        return;
                    }
                    DirectoryServer.directoryServer.shuttingDown = true;
                }
                n = 458893;
                string3 = MessageHandler.getMessage(n, string, string2);
                DirectoryServer.sendAlertNotification(DirectoryServer.directoryServer, "org.opends.server.DirectoryServerShutdown", n, string3);
                serverShutdownMonitor = new ServerShutdownMonitor();
                serverShutdownMonitor.start();
                for (ConnectionHandler object3 : DirectoryServer.directoryServer.connectionHandlers) {
                    try {
                        int n2 = 272;
                        object3.finalizeConnectionHandler(MessageHandler.getMessage(n2), true);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "shutDown", exception));
                    }
                }
                DirectoryServer.directoryServer.connectionHandlers.clear();
                for (SynchronizationProvider synchronizationProvider : DirectoryServer.directoryServer.synchronizationProviders) {
                    synchronizationProvider.finalizeSynchronizationProvider();
                }
                if (DirectoryServer.directoryServer.shutdownHook != null) {
                    try {
                        Runtime.getRuntime().removeShutdownHook(DirectoryServer.directoryServer.shutdownHook);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                DirectoryServer.directoryServer.workQueue.finalizeWorkQueue(string2);
                for (ServerShutdownListener serverShutdownListener : DirectoryServer.directoryServer.shutdownListeners) {
                    try {
                        serverShutdownListener.processServerShutdown(string2);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "shutDown", exception));
                    }
                }
                if (DirectoryServer.directoryServer.pluginConfigManager != null) {
                    DirectoryServer.directoryServer.pluginConfigManager.invokeShutdownPlugins();
                    DirectoryServer.directoryServer.pluginConfigManager.finalizePlugins();
                }
                for (AlertHandler alertHandler : DirectoryServer.directoryServer.alertHandlers) {
                    alertHandler.finalizeAlertHandler();
                }
                Set<ObjectInstance> set = DirectoryServer.directoryServer.mBeanServer.queryMBeans(null, null);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof DirectoryServerMBean)) continue;
                    try {
                        object = (DirectoryServerMBean)e;
                        DirectoryServer.directoryServer.mBeanServer.unregisterMBean(object.getObjectName());
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "shutDown", exception));
                    }
                }
                for (SASLMechanismHandler sASLMechanismHandler : DirectoryServer.directoryServer.saslMechanismHandlers.values()) {
                    try {
                        sASLMechanismHandler.finalizeSASLMechanismHandler();
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "shutDown", exception));
                    }
                }
                for (ExtendedOperationHandler extendedOperationHandler : DirectoryServer.directoryServer.extendedOperationHandlers.values()) {
                    try {
                        extendedOperationHandler.finalizeExtendedOperationHandler();
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "shutDown", exception));
                    }
                }
                for (MonitorProvider monitorProvider : DirectoryServer.directoryServer.monitorProviders.values()) {
                    try {
                        monitorProvider.processServerShutdown(string2);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "shutDown", exception));
                    }
                }
                for (Backend backend : DirectoryServer.directoryServer.backends.values()) {
                    try {
                        backend.finalizeBackend();
                        try {
                            StringBuilder stringBuilder;
                            object = LockFileManager.getBackendLockFileName(backend);
                            if (LockFileManager.releaseLock((String)object, stringBuilder = new StringBuilder())) continue;
                            n = 3277142;
                            string3 = MessageHandler.getMessage(n, backend.getBackendID(), String.valueOf(stringBuilder));
                            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string3, n);
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                            n = 3277142;
                            string3 = MessageHandler.getMessage(n, backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(exception));
                            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, string3, n);
                        }
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "shutDown", exception));
                    }
                }
                try {
                    Access.removeAllAccessLoggers(true);
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "shutDown", exception)) break block52;
                    throw new AssertionError();
                }
            }
            String string4 = LockFileManager.getServerLockFileName();
            try {
                StringBuilder stringBuilder = new StringBuilder();
                if (!LockFileManager.releaseLock(string4, stringBuilder)) {
                    n = 3277144;
                    string3 = MessageHandler.getMessage(n, string4, String.valueOf(stringBuilder));
                    Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, string3, n);
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "startServer", exception));
                n = 3277144;
                string3 = MessageHandler.getMessage(n, string4, StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, string3, n);
            }
            Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.NOTICE, 458955);
            try {
                Error.removeAllErrorLoggers(true);
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "shutDown", exception)) break block53;
                throw new AssertionError();
            }
        }
        try {
            Debug.removeAllDebugLoggers(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        serverShutdownMonitor.waitForMonitor();
        DirectoryServer.directoryServer.isRunning = false;
    }

    public static void restart(String string, String string2) {
        assert (Debug.debugEnter(CLASS_NAME, "restart", String.valueOf(string), String.valueOf(string2)));
        try {
            String string3 = DirectoryServer.directoryServer.configClass;
            String string4 = DirectoryServer.directoryServer.configFile;
            DirectoryServer.shutDown(string, string2);
            DirectoryServer.getNewInstance();
            directoryServer.bootstrapServer();
            directoryServer.initializeConfiguration(string3, string4);
            directoryServer.startServer();
        }
        catch (Exception exception) {
            System.err.println("ERROR:  Unable to perform an in-core restart:");
            exception.printStackTrace();
            System.err.println("Halting the JVM so that it must be manually restarted.");
            Runtime.getRuntime().halt(1);
        }
    }

    public static long getMaxAllowedConnections() {
        assert (Debug.debugEnter(CLASS_NAME, "getMaxAllowedConnections", new String[0]));
        return DirectoryServer.directoryServer.maxAllowedConnections;
    }

    public static void setMaxAllowedConnections(long l) {
        assert (Debug.debugEnter(CLASS_NAME, "setMaxAllowedConnections", String.valueOf(l)));
        DirectoryServer.directoryServer.maxAllowedConnections = l > 0L ? l : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long newConnectionAccepted(ClientConnection clientConnection) {
        assert (Debug.debugEnter(CLASS_NAME, "newConnectionAccepted", String.valueOf(clientConnection)));
        LinkedHashSet<ClientConnection> linkedHashSet = DirectoryServer.directoryServer.establishedConnections;
        synchronized (linkedHashSet) {
            if (DirectoryServer.directoryServer.maxAllowedConnections > 0L && DirectoryServer.directoryServer.currentConnections >= DirectoryServer.directoryServer.maxAllowedConnections) {
                return -1L;
            }
            DirectoryServer.directoryServer.establishedConnections.add(clientConnection);
            ++DirectoryServer.directoryServer.currentConnections;
            if (DirectoryServer.directoryServer.currentConnections > DirectoryServer.directoryServer.maxConnections) {
                DirectoryServer.directoryServer.maxConnections = DirectoryServer.directoryServer.currentConnections;
            }
            return DirectoryServer.directoryServer.totalConnections++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void connectionClosed(ClientConnection clientConnection) {
        assert (Debug.debugEnter(CLASS_NAME, "connectionClosed", String.valueOf(clientConnection)));
        LinkedHashSet<ClientConnection> linkedHashSet = DirectoryServer.directoryServer.establishedConnections;
        synchronized (linkedHashSet) {
            DirectoryServer.directoryServer.establishedConnections.remove(clientConnection);
            --DirectoryServer.directoryServer.currentConnections;
        }
    }

    public static long getCurrentConnections() {
        assert (Debug.debugEnter(CLASS_NAME, "getCurrentConnections", new String[0]));
        return DirectoryServer.directoryServer.currentConnections;
    }

    public static long getMaxConnections() {
        assert (Debug.debugEnter(CLASS_NAME, "getMaxConnections", new String[0]));
        return DirectoryServer.directoryServer.maxConnections;
    }

    public static long getTotalConnections() {
        assert (Debug.debugEnter(CLASS_NAME, "getTotalConnections", new String[0]));
        return DirectoryServer.directoryServer.totalConnections;
    }

    public static String getVersionString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OpenDS Directory Server");
        stringBuilder.append(" ");
        stringBuilder.append(0);
        stringBuilder.append(".");
        stringBuilder.append(1);
        stringBuilder.append("");
        return stringBuilder.toString();
    }

    public static int getSizeLimit() {
        assert (Debug.debugEnter(CLASS_NAME, "getSizeLimit", new String[0]));
        return DirectoryServer.directoryServer.sizeLimit;
    }

    public static void setSizeLimit(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setSizeLimit", String.valueOf(n)));
        DirectoryServer.directoryServer.sizeLimit = n;
    }

    public static int getLookthroughLimit() {
        assert (Debug.debugEnter(CLASS_NAME, "getLookthroughLimit", new String[0]));
        return DirectoryServer.directoryServer.lookthroughLimit;
    }

    public static void setLookthroughLimit(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setLookthroughLimit", String.valueOf(n)));
        DirectoryServer.directoryServer.lookthroughLimit = n;
    }

    public static int getTimeLimit() {
        assert (Debug.debugEnter(CLASS_NAME, "getTimeLimit", new String[0]));
        return DirectoryServer.directoryServer.timeLimit;
    }

    public static void setTimeLimit(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setTimeLimit", String.valueOf(n)));
        DirectoryServer.directoryServer.timeLimit = n;
    }

    public static WritabilityMode getWritabilityMode() {
        assert (Debug.debugEnter(CLASS_NAME, "getWritabilityMode", new String[0]));
        return DirectoryServer.directoryServer.writabilityMode;
    }

    public static void setWritabilityMode(WritabilityMode writabilityMode) {
        assert (Debug.debugEnter(CLASS_NAME, "setWritabilityMode", String.valueOf((Object)writabilityMode)));
        DirectoryServer.directoryServer.writabilityMode = writabilityMode;
    }

    public static boolean bindWithDNRequiresPassword() {
        assert (Debug.debugEnter(CLASS_NAME, "bindWithDNRequiresPassword", new String[0]));
        return DirectoryServer.directoryServer.bindWithDNRequiresPassword;
    }

    public static void setBindWithDNRequiresPassword(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setBindWithDNRequiresPassword", String.valueOf(bl)));
        DirectoryServer.directoryServer.bindWithDNRequiresPassword = bl;
    }

    @Override
    public DN getComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getComponentEntryDN", new String[0]));
        try {
            if (this.configHandler == null) {
                return new DN(new ArrayList<RDN>(0));
            }
            return this.configHandler.getConfigRootEntry().getDN();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getComponentEntryDN", exception));
            return new DN(new ArrayList<RDN>(0));
        }
    }

    @Override
    public String getClassName() {
        assert (Debug.debugEnter(CLASS_NAME, "getClassName", new String[0]));
        return CLASS_NAME;
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("org.opends.server.DirectoryServerStarted", "This alert type will be used to provide notification that the Directory Server has completed its startup process.");
        linkedHashMap.put("org.opends.server.DirectoryServerShutdown", "This alert type will be used to provide notification that the Directory Server has begun the process of shutting down.");
        linkedHashMap.put("org.opends.server.UncaughtException", "This alert type will be used if a Directory Server thread has encountered an uncaught exception that caused that thread to terminate abnormally.  The impact that this problem has on the server depends on which thread was impacted and the nature of the exception.");
        return linkedHashMap;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        assert (Debug.debugEnter(CLASS_NAME, "uncaughtException", String.valueOf(thread), String.valueOf(throwable)));
        assert (Debug.debugException(CLASS_NAME, "uncaughtException", throwable));
        int n = 327820;
        String string = MessageHandler.getMessage(n, thread.getName(), StaticUtils.stackTraceToString(throwable));
        Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_ERROR, string, n);
        DirectoryServer.sendAlertNotification(this, "org.opends.server.UncaughtException", n, string);
    }

    public static void main(String[] stringArray) {
        String string;
        Object object;
        String string2;
        int n;
        Argument argument = null;
        Argument argument2 = null;
        Argument argument3 = null;
        Argument argument4 = null;
        Argument argument5 = null;
        StringArgument stringArgument = null;
        StringArgument stringArgument2 = null;
        ArgumentParser argumentParser = new ArgumentParser(CLASS_NAME, false);
        try {
            stringArgument = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, 281, new Object[0]);
            argumentParser.addArgument(stringArgument);
            stringArgument2 = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, "{configFile}", null, null, 282, new Object[0]);
            argumentParser.addArgument(stringArgument2);
            argument5 = new BooleanArgument("version", Character.valueOf('v'), "version", 283, new Object[0]);
            argumentParser.addArgument(argument5);
            argument3 = new BooleanArgument("fullversion", Character.valueOf('V'), "fullVersion", 284, new Object[0]);
            argument3.setHidden(true);
            argumentParser.addArgument(argument3);
            argument4 = new BooleanArgument("systeminfo", Character.valueOf('s'), "systemInfo", 285, new Object[0]);
            argument4.setHidden(true);
            argumentParser.addArgument(argument4);
            argument2 = new BooleanArgument("dumpmessages", Character.valueOf('m'), "dumpMessages", 286, new Object[0]);
            argument2.setHidden(true);
            argumentParser.addArgument(argument2);
            argument = new BooleanArgument("help", Character.valueOf('H'), "help", 287, new Object[0]);
            argumentParser.addArgument(argument);
            argumentParser.setUsageArgument(argument);
        }
        catch (ArgumentException argumentException) {
            n = 327968;
            string2 = MessageHandler.getMessage(n, argumentException.getMessage());
            System.err.println(string2);
            System.exit(1);
        }
        try {
            argumentParser.parseArguments(stringArray);
        }
        catch (ArgumentException argumentException) {
            n = 327969;
            string2 = MessageHandler.getMessage(n, argumentException.getMessage());
            System.err.println(string2);
            System.err.println(argumentParser.getUsage());
            System.exit(1);
        }
        if (argument.isPresent()) {
            System.exit(0);
        } else {
            if (argument3.isPresent()) {
                System.out.println(DirectoryServer.getVersionString());
                System.out.println("Build ID:            20060927001324");
                System.out.println("Major Version:       0");
                System.out.println("Minor Version:       1");
                System.out.println("Point Version:       0");
                System.out.println("Version Qualifier:   ");
                System.out.println("Fix IDs:             ");
                System.out.println("Debug Build:         false");
                System.out.println("Build OS:            Linux 2.6.15-27-386 i386");
                System.out.println("Build User:          bdaw");
                System.out.println("Build Java Version:  1.5.0_08");
                System.out.println("Build Java Vendor:   Sun Microsystems Inc.");
                System.out.println("Build JVM Version:   1.5.0_08-b03");
                System.out.println("Build JVM Vendor:    Sun Microsystems Inc.");
                return;
            }
            if (argument5.isPresent()) {
                System.out.println(DirectoryServer.getVersionString());
                System.out.println("Build 20060927001324");
                if ("" != null && "".length() > 0) {
                    System.out.println("Fix IDs:  ");
                }
                return;
            }
            if (argument4.isPresent()) {
                System.out.println(DirectoryServer.getVersionString());
                System.out.println("Build ID:               20060927001324");
                System.out.println("Java Version:           " + System.getProperty("java.version"));
                System.out.println("Java Vendor:            " + System.getProperty("java.vendor"));
                System.out.println("JVM Version:            " + System.getProperty("java.vm.version"));
                System.out.println("JVM Vendor:             " + System.getProperty("java.vm.vendor"));
                System.out.println("Class Path:             " + System.getProperty("java.class.path"));
                System.out.println("Current Directory:      " + System.getProperty("user.dir"));
                System.out.println("Operating System:       " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
                try {
                    System.out.println("System Name:            " + InetAddress.getLocalHost().getCanonicalHostName());
                }
                catch (Exception exception) {
                    System.out.println("System Name:             Unknown (" + exception + ")");
                }
                object = Runtime.getRuntime();
                System.out.println("Available Processors:   " + ((Runtime)object).availableProcessors());
                System.out.println("Max Available Memory:   " + ((Runtime)object).maxMemory());
                System.out.println("Currently Used Memory:  " + ((Runtime)object).totalMemory());
                System.out.println("Currently Free Memory:  " + ((Runtime)object).freeMemory());
                return;
            }
            if (argument2.isPresent()) {
                DirectoryServer.bootstrapClient();
                object = MessageHandler.getMessages();
                Iterator iterator = ((ConcurrentHashMap)object).keySet().iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)iterator.next();
                    System.out.println(n2 + "\t" + (String)((ConcurrentHashMap)object).get(n2));
                }
                return;
            }
        }
        object = DirectoryServer.getInstance();
        try {
            ((DirectoryServer)object).bootstrapServer();
            ((DirectoryServer)object).initializeConfiguration(stringArgument.getValue(), stringArgument2.getValue());
        }
        catch (InitializationException initializationException) {
            assert (Debug.debugException(CLASS_NAME, "main", initializationException));
            int n3 = 327970;
            string = MessageHandler.getMessage(n3, initializationException.getMessage());
            System.err.println(string);
            System.exit(1);
        }
        catch (Exception exception) {
            int n4 = 327970;
            string = MessageHandler.getMessage(n4, StaticUtils.stackTraceToSingleLineString(exception));
            System.err.println(string);
            System.exit(1);
        }
        try {
            ((DirectoryServer)object).startServer();
        }
        catch (InitializationException initializationException) {
            assert (Debug.debugException(CLASS_NAME, "main", initializationException));
            int n5 = 327971;
            string = MessageHandler.getMessage(n5, initializationException.getMessage());
            System.err.println(string);
            System.exit(1);
        }
        catch (Exception exception) {
            int n6 = 327971;
            string = MessageHandler.getMessage(n6, StaticUtils.stackTraceToSingleLineString(exception));
            System.err.println(string);
            System.exit(1);
        }
    }
}

