/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import org.opends.server.api.CertificateMapper;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.extensions.SubjectEqualsDNCertificateMapper;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class CertificateMapperConfigManager
implements ConfigChangeListener,
ConfigAddListener,
ConfigDeleteListener {
    private static final String CLASS_NAME = "org.opends.server.core.CertificateMapperConfigManager";

    public CertificateMapperConfigManager() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeCertificateMapper() throws InitializationException {
        CertificateMapper certificateMapper;
        Object object;
        Object object2;
        Object object3;
        ConfigEntry configEntry;
        Object object4;
        assert (Debug.debugEnter(CLASS_NAME, "initializeCertificateMapper", new String[0]));
        try {
            object4 = new SubjectEqualsDNCertificateMapper();
            ((SubjectEqualsDNCertificateMapper)object4).initializeCertificateMapper(null);
            DirectoryServer.setCertificateMapper((CertificateMapper)object4);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCertificateMapper", exception));
            int n = 3408214;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        try {
            object4 = DN.decode("cn=Certificate Mapper,cn=SSL,cn=config");
            configEntry = DirectoryServer.getConfigEntry((DN)object4);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCertificateMapper", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408215, StaticUtils.stackTraceToSingleLineString(exception));
            return;
        }
        if (configEntry == null) {
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 3408216);
            try {
                ConfigEntry configEntry2 = DirectoryServer.getConfigEntry(((DN)object4).getParent());
                if (configEntry2 != null) {
                    configEntry2.registerAddListener(this);
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeCertificateMapper", exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408217, StaticUtils.stackTraceToSingleLineString(exception));
            }
            return;
        }
        configEntry.registerChangeListener(this);
        try {
            DN dN = ((DN)object4).getParent();
            object3 = DirectoryServer.getConfigEntry(dN);
            if (object3 != null) {
                ((ConfigEntry)object3).registerDeleteListener(this);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCertificateMapper", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 3408218, StaticUtils.stackTraceToSingleLineString(exception));
        }
        int n = 3408219;
        object3 = new BooleanConfigAttribute("ds-cfg-certificate-mapper-enabled", MessageHandler.getMessage(n), false);
        try {
            object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object3);
            if (object2 == null) {
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 3408220);
                return;
            }
            if (!((BooleanConfigAttribute)object2).activeValue()) {
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_WARNING, 3408221);
                return;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCertificateMapper", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408222, StaticUtils.stackTraceToSingleLineString(exception));
            return;
        }
        n = 3408223;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-certificate-mapper-class", MessageHandler.getMessage(n), true, false, false);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object == null) {
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408224);
                return;
            }
            object2 = ((StringConfigAttribute)object).activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCertificateMapper", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408225, StaticUtils.stackTraceToSingleLineString(exception));
            return;
        }
        try {
            object = Class.forName((String)object2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCertificateMapper", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408226, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception));
            return;
        }
        try {
            certificateMapper = (CertificateMapper)((Class)object).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCertificateMapper", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408227, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception));
            return;
        }
        try {
            certificateMapper.initializeCertificateMapper(configEntry);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeCertificateMapper", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408228, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception));
            return;
        }
        DirectoryServer.setCertificateMapper(certificateMapper);
    }

    public boolean configChangeIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        Object object;
        Object object2;
        assert (Debug.debugEnter(CLASS_NAME, "configChangeIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        int n = 3408219;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-certificate-mapper-enabled", MessageHandler.getMessage(n), false);
        try {
            object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (object2 == null) {
                n = 3408220;
                stringBuilder.append(MessageHandler.getMessage(n));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            n = 3408222;
            stringBuilder.append(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        n = 3408223;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-certificate-mapper-class", MessageHandler.getMessage(n), true, false, false);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object == null) {
                n = 3408224;
                stringBuilder.append(MessageHandler.getMessage(n));
                return false;
            }
            object2 = ((StringConfigAttribute)object).activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            n = 3408225;
            stringBuilder.append(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        try {
            object = Class.forName((String)object2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            n = 3408226;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        try {
            CertificateMapper certificateMapper = (CertificateMapper)((Class)object).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            n = 3408227;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationChange(ConfigEntry configEntry) {
        CertificateMapper certificateMapper;
        Object object;
        Object object2;
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationChange", String.valueOf(configEntry)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = false;
        String string = null;
        int n = 3408219;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-certificate-mapper-enabled", MessageHandler.getMessage(n), false);
        try {
            object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (object2 == null) {
                n = 3408220;
                arrayList.add(MessageHandler.getMessage(n));
                resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            if (!((BooleanConfigAttribute)object2).pendingValue()) {
                DirectoryServer.getCertificateMapper().finalizeCertificateMapper();
                try {
                    SubjectEqualsDNCertificateMapper subjectEqualsDNCertificateMapper = new SubjectEqualsDNCertificateMapper();
                    subjectEqualsDNCertificateMapper.initializeCertificateMapper(null);
                    DirectoryServer.setCertificateMapper(subjectEqualsDNCertificateMapper);
                    return new ConfigChangeResult(resultCode, bl, arrayList);
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                    n = 3408214;
                    arrayList.add(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    return new ConfigChangeResult(resultCode, bl, arrayList);
                }
            }
            if (DirectoryServer.getCertificateMapper() instanceof SubjectEqualsDNCertificateMapper) {
                bl2 = true;
            } else {
                string = DirectoryServer.getCertificateMapper().getClass().getName();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
            n = 3408222;
            arrayList.add(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        n = 3408223;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-certificate-mapper-class", MessageHandler.getMessage(n), true, false, false);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object == null) {
                n = 3408224;
                arrayList.add(MessageHandler.getMessage(n));
                resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            object2 = ((StringConfigAttribute)object).activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
            n = 3408225;
            arrayList.add(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        if (!bl2) {
            if (!((String)object2).equals(string)) {
                n = 3342697;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(object2)));
                resultCode = ResultCode.UNWILLING_TO_PERFORM;
                bl = true;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            object = Class.forName((String)object2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
            n = 3408226;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            certificateMapper = (CertificateMapper)((Class)object).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
            n = 3408227;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            certificateMapper.initializeCertificateMapper(configEntry);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
            n = 3408228;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        DirectoryServer.setCertificateMapper(certificateMapper);
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }

    public boolean configAddIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        Object object;
        Object object2;
        DN dN;
        assert (Debug.debugEnter(CLASS_NAME, "configAddIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        DN dN2 = configEntry.getDN();
        try {
            dN = DN.decode("cn=Certificate Mapper,cn=SSL,cn=config");
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", directoryException));
            stringBuilder.append(directoryException.getErrorMessage());
            return false;
        }
        if (!dN2.equals(dN)) {
            return true;
        }
        int n = 3408219;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-certificate-mapper-enabled", MessageHandler.getMessage(n), false);
        try {
            object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (object2 == null) {
                n = 3408220;
                stringBuilder.append(MessageHandler.getMessage(n));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            n = 3408222;
            stringBuilder.append(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        n = 3408223;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-certificate-mapper-class", MessageHandler.getMessage(n), true, false, false);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object == null) {
                n = 3408224;
                stringBuilder.append(MessageHandler.getMessage(n));
                return false;
            }
            object2 = ((StringConfigAttribute)object).activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            n = 3408225;
            stringBuilder.append(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        try {
            object = Class.forName((String)object2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            n = 3408226;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        try {
            CertificateMapper certificateMapper = (CertificateMapper)((Class)object).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            n = 3408227;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationAdd(ConfigEntry configEntry) {
        CertificateMapper certificateMapper;
        Object object;
        Object object2;
        Object object3;
        DN dN;
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationAdd", String.valueOf(configEntry)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        DN dN2 = configEntry.getDN();
        try {
            dN = DN.decode("cn=Certificate Mapper,cn=SSL,cn=config");
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", directoryException));
            arrayList.add(directoryException.getErrorMessage());
            resultCode = directoryException.getResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        if (!dN2.equals(dN)) {
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        configEntry.registerChangeListener(this);
        try {
            DN dN3 = configEntry.getDN().getParent();
            object3 = DirectoryServer.getConfigEntry(dN3);
            if (object3 != null) {
                ((ConfigEntry)object3).registerDeleteListener(this);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 3408218, StaticUtils.stackTraceToSingleLineString(exception));
        }
        int n = 3408219;
        object3 = new BooleanConfigAttribute("ds-cfg-certificate-mapper-enabled", MessageHandler.getMessage(n), false);
        try {
            object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object3);
            if (object2 == null) {
                arrayList.add(MessageHandler.getMessage(3408220));
                resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            if (!((BooleanConfigAttribute)object2).activeValue()) {
                arrayList.add(MessageHandler.getMessage(3408221));
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            n = 3408222;
            arrayList.add(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        n = 3408223;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-certificate-mapper-class", MessageHandler.getMessage(n), true, false, false);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object == null) {
                arrayList.add(MessageHandler.getMessage(3408224));
                resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            object2 = ((StringConfigAttribute)object).activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            n = 3408225;
            arrayList.add(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            object = Class.forName((String)object2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            n = 3408226;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            certificateMapper = (CertificateMapper)((Class)object).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            n = 3408227;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            certificateMapper.initializeCertificateMapper(configEntry);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            n = 3408228;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        DirectoryServer.setCertificateMapper(certificateMapper);
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }

    public boolean configDeleteIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        DN dN;
        assert (Debug.debugEnter(CLASS_NAME, "configDeleteIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        DN dN2 = configEntry.getDN();
        try {
            dN = DN.decode("cn=Certificate Mapper,cn=SSL,cn=config");
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", directoryException));
            stringBuilder.append(directoryException.getErrorMessage());
            return false;
        }
        if (!dN2.equals(dN)) {
            return true;
        }
        CertificateMapper certificateMapper = DirectoryServer.getCertificateMapper();
        if (!(certificateMapper instanceof SubjectEqualsDNCertificateMapper)) {
            int n = 3342698;
            stringBuilder.append(MessageHandler.getMessage(n, certificateMapper.getClass().getName()));
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationDelete(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationDelete", String.valueOf(configEntry)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }
}

