/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.HashSet;
import java.util.InputMismatchException;
import java.util.NoSuchElementException;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.SimpleSubtreeSpecification;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AbsoluteSubtreeSpecification
extends SimpleSubtreeSpecification {
    private static final String CLASS_NAME = AbsoluteSubtreeSpecification.class.getName();
    private SearchFilter filter;

    public static AbsoluteSubtreeSpecification valueOf(String string) throws DirectoryException {
        String string2;
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "valueOf", new String[0]));
        DN dN = null;
        int n2 = -1;
        int n3 = -1;
        HashSet<DN> hashSet = new HashSet<DN>();
        HashSet<DN> hashSet2 = new HashSet<DN>();
        SearchFilter searchFilter = null;
        SimpleSubtreeSpecification.Parser parser = new SimpleSubtreeSpecification.Parser(string);
        boolean bl = true;
        try {
            block22: {
                parser.skipLeftBrace();
                n = 1;
                while (true) {
                    if (parser.hasNextRightBrace()) {
                        parser.skipRightBrace();
                        if (parser.hasNext()) {
                            throw new InputMismatchException();
                        }
                        break block22;
                    }
                    if (n == 0) {
                        parser.skipSeparator();
                    } else {
                        n = 0;
                    }
                    string2 = parser.nextKey();
                    if (string2.equals("absolutebase")) {
                        if (dN != null) {
                            throw new InputMismatchException();
                        }
                        dN = DN.decode(parser.nextStringValue());
                        continue;
                    }
                    if (string2.equals("minimum")) {
                        if (n2 != -1) {
                            throw new InputMismatchException();
                        }
                        n2 = parser.nextInt();
                        continue;
                    }
                    if (string2.equals("maximum")) {
                        if (n3 != -1) {
                            throw new InputMismatchException();
                        }
                        n3 = parser.nextInt();
                        continue;
                    }
                    if (string2.equals("specificationfilter")) {
                        if (searchFilter != null) {
                            throw new InputMismatchException();
                        }
                        searchFilter = SearchFilter.createFilterFromString(parser.nextStringValue());
                        continue;
                    }
                    if (!string2.equals("specificexclusions")) break;
                    if (!hashSet.isEmpty() || !hashSet2.isEmpty()) {
                        throw new InputMismatchException();
                    }
                    parser.nextSpecificExclusions(hashSet, hashSet2);
                }
                throw new InputMismatchException();
            }
            if (dN == null) {
                bl = false;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n3 >= 0 && n3 < n2) {
                bl = false;
            }
        }
        catch (InputMismatchException inputMismatchException) {
            bl = false;
        }
        catch (NoSuchElementException noSuchElementException) {
            bl = false;
        }
        if (bl) {
            return new AbsoluteSubtreeSpecification(dN, n2, n3, hashSet, hashSet2, searchFilter);
        }
        n = 6488322;
        string2 = MessageHandler.getMessage(n, string);
        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n);
    }

    public AbsoluteSubtreeSpecification(DN dN, int n, int n2, Iterable<DN> iterable, Iterable<DN> iterable2, SearchFilter searchFilter) {
        super(dN, n, n2, iterable, iterable2);
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.filter = searchFilter;
    }

    public DN getAbsoluteBaseDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getAbsoluteBaseDN", new String[0]));
        return this.getBaseDN();
    }

    public SearchFilter getFilter() {
        assert (Debug.debugEnter(CLASS_NAME, "getFilter", new String[0]));
        return this.filter;
    }

    @Override
    public boolean isWithinScope(Entry entry) {
        assert (Debug.debugEnter(CLASS_NAME, "isWithinScope", new String[0]));
        if (this.isDNWithinScope(entry.getDN())) {
            try {
                return this.filter.matchesEntry(entry);
            }
            catch (DirectoryException directoryException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public StringBuilder toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        stringBuilder.append("{ absoluteBase ");
        StaticUtils.toRFC3641StringValue(stringBuilder, this.getBaseDN().toString());
        Iterable<DN> iterable = this.getChopBefore();
        Iterable<DN> iterable2 = this.getChopAfter();
        if (iterable != null && iterable.iterator().hasNext() || iterable2 != null && iterable2.iterator().hasNext()) {
            stringBuilder.append(", specificExclusions { ");
            boolean bl = true;
            if (iterable != null) {
                for (DN dN : iterable) {
                    if (!bl) {
                        stringBuilder.append(", chopBefore:");
                    } else {
                        stringBuilder.append("chopBefore:");
                        bl = false;
                    }
                    StaticUtils.toRFC3641StringValue(stringBuilder, dN.toString());
                }
            }
            if (iterable2 != null) {
                for (DN dN : iterable2) {
                    if (!bl) {
                        stringBuilder.append(", chopAfter:");
                    } else {
                        stringBuilder.append("chopAfter:");
                        bl = false;
                    }
                    StaticUtils.toRFC3641StringValue(stringBuilder, dN.toString());
                }
            }
            stringBuilder.append(" }");
        }
        if (this.getMinimumDepth() > 0) {
            stringBuilder.append(", minimum ");
            stringBuilder.append(this.getMinimumDepth());
        }
        if (this.getMaximumDepth() >= 0) {
            stringBuilder.append(", maximum ");
            stringBuilder.append(this.getMaximumDepth());
        }
        if (this.filter != null) {
            stringBuilder.append(", specificationFilter ");
            StaticUtils.toRFC3641StringValue(stringBuilder, this.filter.toString());
        }
        stringBuilder.append(" }");
        return stringBuilder;
    }

    @Override
    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", new String[0]));
        if (this == object) {
            return true;
        }
        if (object instanceof AbsoluteSubtreeSpecification) {
            AbsoluteSubtreeSpecification absoluteSubtreeSpecification = (AbsoluteSubtreeSpecification)object;
            if (!this.commonComponentsEquals(absoluteSubtreeSpecification)) {
                return false;
            }
            if (!this.getBaseDN().equals(absoluteSubtreeSpecification.getBaseDN())) {
                return false;
            }
            if (this.filter != null) {
                return this.filter.equals(absoluteSubtreeSpecification.filter);
            }
            return this.filter == absoluteSubtreeSpecification.filter;
        }
        return false;
    }

    @Override
    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        int n = this.commonComponentsHashCode();
        n = n * 31 + this.getBaseDN().hashCode();
        if (this.filter != null) {
            n = n * 31 + this.filter.hashCode();
        }
        return n;
    }
}

