/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.concurrent.locks.Lock;
import org.opends.server.api.IdentityMapper;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockManager;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class ProxiedAuthV2Control
extends Control {
    private static final String CLASS_NAME = "org.opends.server.controls.ProxiedAuthV2Control";
    private ASN1OctetString authorizationID;

    public ProxiedAuthV2Control(ASN1OctetString aSN1OctetString) {
        super("2.16.840.1.113730.3.4.18", true, ProxiedAuthV2Control.encodeValue(aSN1OctetString));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(aSN1OctetString)));
        this.authorizationID = aSN1OctetString;
    }

    private ProxiedAuthV2Control(String string, boolean bl, ASN1OctetString aSN1OctetString) {
        super(string, bl, aSN1OctetString);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(aSN1OctetString)));
        this.authorizationID = aSN1OctetString;
    }

    private static ASN1OctetString encodeValue(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "encodeValue", String.valueOf(aSN1OctetString)));
        if (aSN1OctetString == null) {
            return new ASN1OctetString(new ASN1OctetString().encode());
        }
        return new ASN1OctetString(aSN1OctetString.encode());
    }

    public static ProxiedAuthV2Control decodeControl(Control control) throws LDAPException {
        ASN1OctetString aSN1OctetString;
        assert (Debug.debugEnter(CLASS_NAME, "decodeControl", String.valueOf(control)));
        if (!control.hasValue()) {
            int n = 2294057;
            String string = MessageHandler.getMessage(n);
            throw new LDAPException(2, n, string);
        }
        try {
            aSN1OctetString = ASN1OctetString.decodeAsOctetString(control.getValue().value());
        }
        catch (ASN1Exception aSN1Exception) {
            String string = StaticUtils.toLowerCase(control.getValue().stringValue());
            if (string.startsWith("dn:") || string.startsWith("u:")) {
                aSN1OctetString = control.getValue();
            }
            assert (Debug.debugException(CLASS_NAME, "decodeControl", aSN1Exception));
            int n = 2294058;
            String string2 = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(aSN1Exception));
            throw new LDAPException(2, n, string2, aSN1Exception);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeControl", exception));
            int n = 2294058;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new LDAPException(2, n, string, exception);
        }
        return new ProxiedAuthV2Control(control.getOID(), control.isCritical(), aSN1OctetString);
    }

    public ASN1OctetString getAuthorizationID() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthorizationID", new String[0]));
        return this.authorizationID;
    }

    public void setAuthorizationID(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setAuthorizationID", String.valueOf(aSN1OctetString)));
        if (aSN1OctetString == null) {
            this.authorizationID = new ASN1OctetString();
            this.setValue(this.authorizationID);
        } else {
            this.authorizationID = aSN1OctetString;
            this.setValue(aSN1OctetString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DN getValidatedAuthorizationDN() throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getValidatedAuthorizationDN", new String[0]));
        if (this.authorizationID.value().length == 0) {
            return new DN();
        }
        String string = this.authorizationID.stringValue();
        String string2 = StaticUtils.toLowerCase(string);
        if (string2.startsWith("dn:")) {
            int n;
            DN dN = DN.decode(string.substring(3));
            if (dN.isNullDN()) {
                return dN;
            }
            Lock lock = null;
            for (n = 0; n < 3 && (lock = LockManager.lockRead(dN)) == null; ++n) {
            }
            if (lock == null) {
                n = 2294133;
                String string3 = MessageHandler.getMessage(n, String.valueOf(dN));
                throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, string3, n);
            }
            try {
                Entry entry = DirectoryServer.getEntry(dN);
                if (entry == null) {
                    int n2 = 2294061;
                    String string4 = MessageHandler.getMessage(n2, string);
                    throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, string4, n2);
                }
                PasswordPolicyState passwordPolicyState = new PasswordPolicyState(entry, false, false);
                if (passwordPolicyState.isDisabled() || passwordPolicyState.isAccountExpired() || passwordPolicyState.lockedDueToFailures() || passwordPolicyState.lockedDueToIdleInterval() || passwordPolicyState.lockedDueToMaximumResetAge() || passwordPolicyState.isPasswordExpired()) {
                    int n3 = 2294134;
                    String string5 = MessageHandler.getMessage(n3, String.valueOf(dN));
                    throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, string5, n3);
                }
                DN dN2 = dN;
                return dN2;
            }
            finally {
                LockManager.unlock(dN, lock);
            }
        }
        if (string2.startsWith("u:")) {
            if (string2.length() == 2) {
                return new DN();
            }
            IdentityMapper identityMapper = DirectoryServer.getProxiedAuthorizationIdentityMapper();
            if (identityMapper == null) {
                int n = 2294059;
                String string6 = MessageHandler.getMessage(n);
                throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, string6, n);
            }
            Entry entry = identityMapper.getEntryForID(string.substring(2));
            if (entry == null) {
                int n = 2294061;
                String string7 = MessageHandler.getMessage(n, string);
                throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, string7, n);
            }
            DN dN = entry.getDN();
            PasswordPolicyState passwordPolicyState = new PasswordPolicyState(entry, false, false);
            if (passwordPolicyState.isDisabled() || passwordPolicyState.isAccountExpired() || passwordPolicyState.lockedDueToFailures() || passwordPolicyState.lockedDueToIdleInterval() || passwordPolicyState.lockedDueToMaximumResetAge() || passwordPolicyState.isPasswordExpired()) {
                int n = 2294134;
                String string8 = MessageHandler.getMessage(n, String.valueOf(dN));
                throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, string8, n);
            }
            return dN;
        }
        int n = 2294060;
        String string9 = MessageHandler.getMessage(n, string);
        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string9, n);
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("ProxiedAuthorizationV2Control(authzID=\"");
        this.authorizationID.toString(stringBuilder);
        stringBuilder.append("\")");
    }
}

