/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import java.util.Set;
import org.opends.server.controls.PersistentSearchChangeType;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Boolean;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.types.Control;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentSearchControl
extends Control {
    private static final String CLASS_NAME = "org.opends.server.controls.PersistentSearchControl";
    private boolean changesOnly;
    private boolean returnECs;
    private Set<PersistentSearchChangeType> changeTypes;

    public PersistentSearchControl(Set<PersistentSearchChangeType> set, boolean bl, boolean bl2) {
        super("2.16.840.1.113730.3.4.3", true, PersistentSearchControl.encodeValue(set, bl, bl2));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(set), String.valueOf(bl), String.valueOf(bl2)));
        this.changeTypes = set;
        this.changesOnly = bl;
        this.returnECs = bl2;
    }

    public PersistentSearchControl(String string, boolean bl, Set<PersistentSearchChangeType> set, boolean bl2, boolean bl3) {
        super(string, bl, PersistentSearchControl.encodeValue(set, bl2, bl3));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(set), String.valueOf(bl2), String.valueOf(bl3)));
        this.changeTypes = set;
        this.changesOnly = bl2;
        this.returnECs = bl3;
    }

    private PersistentSearchControl(String string, boolean bl, Set<PersistentSearchChangeType> set, boolean bl2, boolean bl3, ASN1OctetString aSN1OctetString) {
        super(string, bl, aSN1OctetString);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(set), String.valueOf(bl2), String.valueOf(bl3), String.valueOf(aSN1OctetString)));
        this.changeTypes = set;
        this.changesOnly = bl2;
        this.returnECs = bl3;
    }

    private static ASN1OctetString encodeValue(Set<PersistentSearchChangeType> set, boolean bl, boolean bl2) {
        assert (Debug.debugEnter(CLASS_NAME, "encodeValue", String.valueOf(set), String.valueOf(bl), String.valueOf(bl2)));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(3);
        arrayList.add(new ASN1Integer(PersistentSearchChangeType.changeTypesToInt(set)));
        arrayList.add(new ASN1Boolean(bl));
        arrayList.add(new ASN1Boolean(bl2));
        return new ASN1OctetString(new ASN1Sequence(arrayList).encode());
    }

    public static PersistentSearchControl decodeControl(Control control) throws LDAPException {
        boolean bl;
        boolean bl2;
        Set<PersistentSearchChangeType> set;
        assert (Debug.debugEnter(CLASS_NAME, "decodeControl", String.valueOf(control)));
        if (!control.hasValue()) {
            int n = 2294065;
            String string = MessageHandler.getMessage(n);
            throw new LDAPException(2, n, string);
        }
        try {
            ArrayList<ASN1Element> arrayList = ASN1Sequence.decodeAsSequence(control.getValue().value()).elements();
            if (arrayList.size() != 3) {
                int n = 2294066;
                String string = MessageHandler.getMessage(n, arrayList.size());
                throw new LDAPException(2, n, string);
            }
            int n = arrayList.get(0).decodeAsInteger().intValue();
            set = PersistentSearchChangeType.intToTypes(n);
            bl2 = arrayList.get(1).decodeAsBoolean().booleanValue();
            bl = arrayList.get(2).decodeAsBoolean().booleanValue();
        }
        catch (LDAPException lDAPException) {
            throw lDAPException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeControl", exception));
            int n = 2294067;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new LDAPException(2, n, string, exception);
        }
        return new PersistentSearchControl(control.getOID(), control.isCritical(), set, bl2, bl, control.getValue());
    }

    public Set<PersistentSearchChangeType> getChangeTypes() {
        assert (Debug.debugEnter(CLASS_NAME, "getChangeTypes", new String[0]));
        return this.changeTypes;
    }

    public void setChangeTypes(Set<PersistentSearchChangeType> set) {
        assert (Debug.debugEnter(CLASS_NAME, "setChangeTypes", String.valueOf(set)));
        this.changeTypes = set;
        this.setValue(PersistentSearchControl.encodeValue(set, this.changesOnly, this.returnECs));
    }

    public boolean getChangesOnly() {
        assert (Debug.debugEnter(CLASS_NAME, "getChangesOnly", new String[0]));
        return this.changesOnly;
    }

    public void setChangesOnly(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setChangesOnly", String.valueOf(bl)));
        this.changesOnly = bl;
        this.setValue(PersistentSearchControl.encodeValue(this.changeTypes, bl, this.returnECs));
    }

    public boolean getReturnECs() {
        assert (Debug.debugEnter(CLASS_NAME, "getReturnECs", new String[0]));
        return this.returnECs;
    }

    public void setReturnECs(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setReturnECs", String.valueOf(bl)));
        this.returnECs = bl;
        this.setValue(PersistentSearchControl.encodeValue(this.changeTypes, this.changesOnly, bl));
    }

    @Override
    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("PersistentSearchControl(changeTypes=\"");
        PersistentSearchChangeType.changeTypesToString(this.changeTypes, stringBuilder);
        stringBuilder.append("\",changesOnly=");
        stringBuilder.append(this.changesOnly);
        stringBuilder.append(",returnECs=");
        stringBuilder.append(this.returnECs);
        stringBuilder.append(")");
    }
}

