/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.ldap.LDAPException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PersistentSearchChangeType {
    ADD(1),
    DELETE(2),
    MODIFY(4),
    MODIFY_DN(8);

    private int intValue;

    private PersistentSearchChangeType(int n2) {
        this.intValue = n2;
    }

    public int intValue() {
        return this.intValue;
    }

    public String toString() {
        switch (this.intValue) {
            case 1: {
                return "add";
            }
            case 2: {
                return "delete";
            }
            case 4: {
                return "modify";
            }
            case 8: {
                return "modDN";
            }
        }
        return "unknown";
    }

    public static PersistentSearchChangeType valueOf(int n) throws LDAPException {
        switch (n) {
            case 1: {
                return ADD;
            }
            case 2: {
                return DELETE;
            }
            case 4: {
                return MODIFY;
            }
            case 8: {
                return MODIFY_DN;
            }
        }
        int n2 = 2294062;
        String string = MessageHandler.getMessage(n2, n);
        throw new LDAPException(19, n2, string);
    }

    public static Set<PersistentSearchChangeType> intToTypes(int n) throws LDAPException {
        HashSet<PersistentSearchChangeType> hashSet = new HashSet<PersistentSearchChangeType>(4);
        switch (n) {
            case 0: {
                int n2 = 2294063;
                String string = MessageHandler.getMessage(n2);
                throw new LDAPException(19, n2, string);
            }
            case 1: {
                hashSet.add(ADD);
                break;
            }
            case 2: {
                hashSet.add(DELETE);
                break;
            }
            case 3: {
                hashSet.add(ADD);
                hashSet.add(DELETE);
                break;
            }
            case 4: {
                hashSet.add(MODIFY);
                break;
            }
            case 5: {
                hashSet.add(ADD);
                hashSet.add(MODIFY);
                break;
            }
            case 6: {
                hashSet.add(DELETE);
                hashSet.add(MODIFY);
                break;
            }
            case 7: {
                hashSet.add(ADD);
                hashSet.add(DELETE);
                hashSet.add(MODIFY);
                break;
            }
            case 8: {
                hashSet.add(MODIFY_DN);
                break;
            }
            case 9: {
                hashSet.add(ADD);
                hashSet.add(MODIFY_DN);
                break;
            }
            case 10: {
                hashSet.add(DELETE);
                hashSet.add(MODIFY_DN);
                break;
            }
            case 11: {
                hashSet.add(ADD);
                hashSet.add(DELETE);
                hashSet.add(MODIFY_DN);
                break;
            }
            case 12: {
                hashSet.add(MODIFY);
                hashSet.add(MODIFY_DN);
                break;
            }
            case 13: {
                hashSet.add(ADD);
                hashSet.add(MODIFY);
                hashSet.add(MODIFY_DN);
                break;
            }
            case 14: {
                hashSet.add(DELETE);
                hashSet.add(MODIFY);
                hashSet.add(MODIFY_DN);
                break;
            }
            case 15: {
                hashSet.add(ADD);
                hashSet.add(DELETE);
                hashSet.add(MODIFY);
                hashSet.add(MODIFY_DN);
                break;
            }
            default: {
                int n3 = 2294064;
                String string = MessageHandler.getMessage(n3, n);
                throw new LDAPException(19, n3, string);
            }
        }
        return hashSet;
    }

    public static int changeTypesToInt(Set<PersistentSearchChangeType> set) {
        int n = 0;
        if (set.contains((Object)ADD)) {
            n |= 1;
        }
        if (set.contains((Object)DELETE)) {
            n |= 2;
        }
        if (set.contains((Object)MODIFY)) {
            n |= 4;
        }
        if (set.contains((Object)MODIFY_DN)) {
            n |= 8;
        }
        return n;
    }

    public static String changeTypesToString(Set<PersistentSearchChangeType> set) {
        StringBuilder stringBuilder = new StringBuilder();
        PersistentSearchChangeType.changeTypesToString(set, stringBuilder);
        return stringBuilder.toString();
    }

    public static void changeTypesToString(Set<PersistentSearchChangeType> set, StringBuilder stringBuilder) {
        Iterator<PersistentSearchChangeType> iterator = set.iterator();
        if (iterator.hasNext()) {
            stringBuilder.append(iterator.next().toString());
            while (iterator.hasNext()) {
                stringBuilder.append("|");
                stringBuilder.append(iterator.next().toString());
            }
        }
    }
}

