/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.DirectoryServerMBean;
import org.opends.server.api.InvokableComponent;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.jmx.Credential;
import org.opends.server.protocols.jmx.JmxClientConnection;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InvokableMethod;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXMBean
implements DynamicMBean,
DirectoryServerMBean {
    private static final String CLASS_NAME = "org.opends.server.config.JMXMBean";
    private CopyOnWriteArrayList<AlertGenerator> alertGenerators;
    private CopyOnWriteArrayList<ConfigurableComponent> configurableComponents;
    private CopyOnWriteArrayList<InvokableComponent> invokableComponents;
    private CopyOnWriteArrayList<MonitorProvider> monitorProviders;
    private DN configEntryDN;
    private ObjectName objectName;

    public static String getJmxName(DN dN) {
        String string = null;
        String string2 = null;
        try {
            String string3 = dN.toString();
            if (string3 != null && string3.length() != 0) {
                StringBuilder stringBuilder = new StringBuilder(string3.length());
                String[] stringArray = string3.replace(',', ';').split(";");
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    int n = stringArray.length - i;
                    stringBuilder.append(",Rdn" + n + "=");
                    block7: for (int j = 0; j < stringArray[i].length(); ++j) {
                        char c = stringArray[i].charAt(j);
                        if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c)) {
                            stringBuilder.append(c);
                            continue;
                        }
                        switch (c) {
                            case ' ': {
                                stringBuilder.append("_");
                                continue block7;
                            }
                            case '=': {
                                stringBuilder.append("-");
                            }
                        }
                    }
                }
                string = stringBuilder.toString();
            }
            string2 = "org.opends.server:Name=rootDSE" + string;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "<init>", exception));
            int n = 3407955;
            String string4 = MessageHandler.getMessage(n, dN.toString(), String.valueOf(exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, string4, n);
        }
        return string2;
    }

    public JMXMBean(DN dN) {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.configEntryDN = dN;
        this.alertGenerators = new CopyOnWriteArrayList();
        this.configurableComponents = new CopyOnWriteArrayList();
        this.invokableComponents = new CopyOnWriteArrayList();
        this.monitorProviders = new CopyOnWriteArrayList();
        MBeanServer mBeanServer = DirectoryServer.getJMXMBeanServer();
        if (mBeanServer != null) {
            try {
                block8: {
                    this.objectName = new ObjectName(JMXMBean.getJmxName(dN));
                    try {
                        if (mBeanServer.isRegistered(this.objectName)) {
                            mBeanServer.unregisterMBean(this.objectName);
                        }
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "<init>", exception)) break block8;
                        throw new AssertionError();
                    }
                }
                mBeanServer.registerMBean(this, this.objectName);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "<init>", exception));
                exception.printStackTrace();
                int n = 3407955;
                String string = MessageHandler.getMessage(n, dN.toString(), String.valueOf(exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
            }
        }
    }

    @Override
    public ObjectName getObjectName() {
        assert (Debug.debugEnter(CLASS_NAME, "getObjectName", new String[0]));
        return this.objectName;
    }

    public CopyOnWriteArrayList<AlertGenerator> getAlertGenerators() {
        assert (Debug.debugEnter(CLASS_NAME, "getAlertGenerators", new String[0]));
        return this.alertGenerators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlertGenerator(AlertGenerator alertGenerator) {
        assert (Debug.debugEnter(CLASS_NAME, "addAlertGenerator", String.valueOf(alertGenerator)));
        CopyOnWriteArrayList<AlertGenerator> copyOnWriteArrayList = this.alertGenerators;
        synchronized (copyOnWriteArrayList) {
            if (!this.alertGenerators.contains(alertGenerator)) {
                this.alertGenerators.add(alertGenerator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAlertGenerator(AlertGenerator alertGenerator) {
        assert (Debug.debugEnter(CLASS_NAME, "removeAlertGenerator", String.valueOf(alertGenerator)));
        CopyOnWriteArrayList<AlertGenerator> copyOnWriteArrayList = this.alertGenerators;
        synchronized (copyOnWriteArrayList) {
            return this.alertGenerators.remove(alertGenerator);
        }
    }

    public CopyOnWriteArrayList<ConfigurableComponent> getConfigurableComponents() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponents", new String[0]));
        return this.configurableComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurableComponent(ConfigurableComponent configurableComponent) {
        assert (Debug.debugEnter(CLASS_NAME, "addConfigurableComponent", String.valueOf(configurableComponent)));
        CopyOnWriteArrayList<ConfigurableComponent> copyOnWriteArrayList = this.configurableComponents;
        synchronized (copyOnWriteArrayList) {
            if (!this.configurableComponents.contains(configurableComponent)) {
                this.configurableComponents.add(configurableComponent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConfigurableComponent(ConfigurableComponent configurableComponent) {
        assert (Debug.debugEnter(CLASS_NAME, "removeConfigurableComponent", String.valueOf(configurableComponent)));
        CopyOnWriteArrayList<ConfigurableComponent> copyOnWriteArrayList = this.configurableComponents;
        synchronized (copyOnWriteArrayList) {
            return this.configurableComponents.remove(configurableComponent);
        }
    }

    public CopyOnWriteArrayList<InvokableComponent> getInvokableComponents() {
        assert (Debug.debugEnter(CLASS_NAME, "getInvokableComponents", new String[0]));
        return this.invokableComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvokableComponent(InvokableComponent invokableComponent) {
        assert (Debug.debugEnter(CLASS_NAME, "addInvokableComponent", String.valueOf(invokableComponent)));
        CopyOnWriteArrayList<InvokableComponent> copyOnWriteArrayList = this.invokableComponents;
        synchronized (copyOnWriteArrayList) {
            if (!this.invokableComponents.contains(invokableComponent)) {
                this.invokableComponents.add(invokableComponent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeInvokableComponent(InvokableComponent invokableComponent) {
        assert (Debug.debugEnter(CLASS_NAME, "removeInvokableComponent", String.valueOf(invokableComponent)));
        CopyOnWriteArrayList<InvokableComponent> copyOnWriteArrayList = this.invokableComponents;
        synchronized (copyOnWriteArrayList) {
            return this.invokableComponents.remove(invokableComponent);
        }
    }

    public CopyOnWriteArrayList<MonitorProvider> getMonitorProviders() {
        assert (Debug.debugEnter(CLASS_NAME, "getMonitorProviders", new String[0]));
        return this.monitorProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitorProvider(MonitorProvider monitorProvider) {
        assert (Debug.debugEnter(CLASS_NAME, "addMonitorProvider", String.valueOf(monitorProvider)));
        CopyOnWriteArrayList<MonitorProvider> copyOnWriteArrayList = this.monitorProviders;
        synchronized (copyOnWriteArrayList) {
            if (!this.monitorProviders.contains(monitorProvider)) {
                this.monitorProviders.add(monitorProvider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMonitorProvider(MonitorProvider monitorProvider) {
        assert (Debug.debugEnter(CLASS_NAME, "removeMonitorProvider", String.valueOf(monitorProvider)));
        CopyOnWriteArrayList<MonitorProvider> copyOnWriteArrayList = this.monitorProviders;
        synchronized (copyOnWriteArrayList) {
            return this.monitorProviders.remove(monitorProvider);
        }
    }

    private ConfigAttribute getConfigAttribute(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigAttribute", String.valueOf(string)));
        for (ConfigurableComponent configurableComponent : this.configurableComponents) {
            for (ConfigAttribute configAttribute : configurableComponent.getConfigurationAttributes()) {
                if (!configAttribute.getName().equalsIgnoreCase(string)) continue;
                return configAttribute;
            }
        }
        return null;
    }

    private javax.management.Attribute getJmxAttribute(String string) {
        String string2;
        assert (Debug.debugEnter(CLASS_NAME, "getJmxAttribute", String.valueOf(string)));
        String string3 = ";pending";
        boolean bl = false;
        if (string.endsWith(string3)) {
            int n = string.indexOf(string3);
            string2 = string.substring(0, n);
            bl = true;
        } else {
            string2 = string;
        }
        for (ConfigurableComponent object : this.configurableComponents) {
            for (ConfigAttribute configAttribute : object.getConfigurationAttributes()) {
                if (!configAttribute.getName().equalsIgnoreCase(string2)) continue;
                if (bl) {
                    return configAttribute.toJMXAttributePending();
                }
                return configAttribute.toJMXAttribute();
            }
        }
        Object object = DirectoryServer.getAttributeType(string.toLowerCase());
        if (object == null) {
            object = DirectoryServer.getDefaultAttributeType(string);
        }
        for (MonitorProvider monitorProvider : this.monitorProviders) {
            for (Attribute attribute : monitorProvider.getMonitorData()) {
                LinkedHashSet<AttributeValue> linkedHashSet;
                if (!((AttributeType)object).equals(attribute.getAttributeType()) || (linkedHashSet = attribute.getValues()).isEmpty()) continue;
                Iterator iterator = linkedHashSet.iterator();
                AttributeValue attributeValue = (AttributeValue)iterator.next();
                if (iterator.hasNext()) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(attributeValue.getStringValue());
                    while (iterator.hasNext()) {
                        attributeValue = (AttributeValue)iterator.next();
                        arrayList.add(attributeValue.getStringValue());
                    }
                    String[] stringArray = new String[arrayList.size()];
                    arrayList.toArray(stringArray);
                    return new javax.management.Attribute(string, stringArray);
                }
                return new javax.management.Attribute(string, attributeValue.getStringValue());
            }
        }
        return null;
    }

    @Override
    public javax.management.Attribute getAttribute(String string) throws AttributeNotFoundException {
        LDAPFilter lDAPFilter;
        assert (Debug.debugEnter(CLASS_NAME, "getAttribute", new String[0]));
        JmxClientConnection jmxClientConnection = this.getClientConnection();
        if (jmxClientConnection == null) {
            return null;
        }
        try {
            lDAPFilter = LDAPFilter.decode("objectclass=*");
        }
        catch (LDAPException lDAPException) {
            throw new AttributeNotFoundException();
        }
        InternalSearchOperation internalSearchOperation = jmxClientConnection.processSearch(new ASN1OctetString(this.configEntryDN.toString()), SearchScope.BASE_OBJECT, lDAPFilter);
        ResultCode resultCode = internalSearchOperation.getResultCode();
        if (resultCode != ResultCode.SUCCESS) {
            jmxClientConnection = null;
            throw new AttributeNotFoundException();
        }
        try {
            return this.getJmxAttribute(string);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "setAttribute", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3342410, this.configEntryDN.toString(), string);
            throw new AttributeNotFoundException();
        }
    }

    private LDAPAttribute getLdapAttributeFromJmx(javax.management.Attribute attribute, ConfigEntry configEntry) throws AttributeNotFoundException, InvalidAttributeValueException {
        ConfigAttribute configAttribute;
        assert (Debug.debugEnter(CLASS_NAME, "getLdapAttributeFromJmx", String.valueOf(attribute)));
        String string = attribute.getName();
        try {
            configAttribute = this.getConfigAttribute(string).duplicate();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "setAttribute", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3342410, this.configEntryDN.toString(), string);
            throw new AttributeNotFoundException();
        }
        try {
            configAttribute.setValue(attribute);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "setAttribute", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3342412, this.configEntryDN.toString(), String.valueOf(exception));
            throw new InvalidAttributeValueException();
        }
        configEntry.putConfigAttribute(configAttribute);
        AttributeType attributeType = DirectoryServer.getAttributeType(string.toLowerCase());
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType(string, configAttribute.getSyntax());
        }
        return new LDAPAttribute(configEntry.getEntry().getAttribute(attributeType).get(0));
    }

    @Override
    public void setAttribute(javax.management.Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException {
        ConfigEntry configEntry;
        assert (Debug.debugEnter(CLASS_NAME, "setAttribute", String.valueOf(attribute)));
        try {
            ConfigEntry configEntry2 = DirectoryServer.getConfigHandler().getConfigEntry(this.configEntryDN);
            configEntry = configEntry2.duplicate();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "setAttribute", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3342411, this.configEntryDN.toString(), String.valueOf(exception));
            throw new AttributeNotFoundException();
        }
        JmxClientConnection jmxClientConnection = this.getClientConnection();
        if (jmxClientConnection == null) {
            throw new AttributeNotFoundException();
        }
        LDAPModification lDAPModification = new LDAPModification(ModificationType.REPLACE, this.getLdapAttributeFromJmx(attribute, configEntry));
        ArrayList<LDAPModification> arrayList = new ArrayList<LDAPModification>();
        arrayList.add(lDAPModification);
        ModifyOperation modifyOperation = jmxClientConnection.processModify(new ASN1OctetString(this.configEntryDN.toString()), arrayList);
        ResultCode resultCode = modifyOperation.getResultCode();
        if (resultCode != ResultCode.SUCCESS) {
            jmxClientConnection = null;
            throw new InvalidAttributeValueException();
        }
        jmxClientConnection = null;
    }

    @Override
    public AttributeList getAttributes(String[] stringArray) {
        LDAPFilter lDAPFilter;
        assert (Debug.debugEnter(CLASS_NAME, "getAttributes", String.valueOf(stringArray)));
        JmxClientConnection jmxClientConnection = this.getClientConnection();
        if (jmxClientConnection == null) {
            return null;
        }
        try {
            lDAPFilter = LDAPFilter.decode("objectclass=*");
        }
        catch (LDAPException lDAPException) {
            return null;
        }
        InternalSearchOperation internalSearchOperation = jmxClientConnection.processSearch(new ASN1OctetString(this.configEntryDN.toString()), SearchScope.BASE_OBJECT, lDAPFilter);
        ResultCode resultCode = internalSearchOperation.getResultCode();
        if (resultCode != ResultCode.SUCCESS) {
            jmxClientConnection = null;
            return null;
        }
        AttributeList attributeList = new AttributeList(stringArray.length);
        block4: for (String string : stringArray) {
            AttributeType attributeType;
            block14: {
                try {
                    javax.management.Attribute attribute = this.getJmxAttribute(string);
                    if (attribute != null) {
                        attributeList.add(attribute);
                        continue;
                    }
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "getAttributes", exception)) break block14;
                    throw new AssertionError();
                }
            }
            if ((attributeType = DirectoryServer.getAttributeType(string.toLowerCase())) == null) {
                attributeType = DirectoryServer.getDefaultAttributeType(string);
            }
            for (MonitorProvider monitorProvider : this.monitorProviders) {
                for (Attribute attribute : monitorProvider.getMonitorData()) {
                    LinkedHashSet<AttributeValue> linkedHashSet;
                    if (!attributeType.equals(attribute.getAttributeType()) || (linkedHashSet = attribute.getValues()).isEmpty()) continue;
                    Iterator iterator = linkedHashSet.iterator();
                    AttributeValue attributeValue = (AttributeValue)iterator.next();
                    if (iterator.hasNext()) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(attributeValue.getStringValue());
                        while (iterator.hasNext()) {
                            attributeValue = (AttributeValue)iterator.next();
                            arrayList.add(attributeValue.getStringValue());
                        }
                        String[] stringArray2 = new String[arrayList.size()];
                        arrayList.toArray(stringArray2);
                        attributeList.add(new javax.management.Attribute(string, stringArray2));
                        continue block4;
                    }
                    attributeList.add(new javax.management.Attribute(string, attributeValue.getStringValue()));
                    continue block4;
                }
            }
        }
        return attributeList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributeList) {
        Object object;
        javax.management.Attribute attribute;
        ConfigEntry configEntry;
        assert (Debug.debugEnter(CLASS_NAME, "setAttributes", String.valueOf(attributeList)));
        AttributeList attributeList2 = new AttributeList();
        try {
            ConfigEntry configEntry2 = DirectoryServer.getConfigHandler().getConfigEntry(this.configEntryDN);
            configEntry = configEntry2.duplicate();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "setAttribute", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3342411, this.configEntryDN.toString(), String.valueOf(exception));
            return attributeList2;
        }
        JmxClientConnection jmxClientConnection = this.getClientConnection();
        if (jmxClientConnection == null) {
            return attributeList2;
        }
        ArrayList<LDAPModification> arrayList = new ArrayList<LDAPModification>();
        for (Object e : attributeList) {
            attribute = (javax.management.Attribute)e;
            try {
                object = new LDAPModification(ModificationType.REPLACE, this.getLdapAttributeFromJmx(attribute, configEntry));
                arrayList.add((LDAPModification)object);
            }
            catch (Exception exception) {}
        }
        jmxClientConnection.processModify(new ASN1OctetString(this.configEntryDN.toString()), arrayList);
        jmxClientConnection = null;
        for (Object e : attributeList) {
            attribute = (javax.management.Attribute)e;
            try {
                object = this.getConfigAttribute(attribute.getName());
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "setAttribute", exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, 3342410, this.configEntryDN.toString(), attribute.getName());
                continue;
            }
            ((ConfigAttribute)object).toJMXAttribute(attributeList2);
        }
        return attributeList2;
    }

    @Override
    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException {
        assert (Debug.debugEnter(CLASS_NAME, "invoke", String.valueOf(string), String.valueOf(objectArray), String.valueOf(stringArray)));
        for (InvokableComponent invokableComponent : this.invokableComponents) {
            for (InvokableMethod invokableMethod : invokableComponent.getOperationSignatures()) {
                if (!invokableMethod.hasSignature(string, stringArray)) continue;
                try {
                    invokableMethod.invoke(invokableComponent, objectArray);
                }
                catch (MBeanException exception) {
                    assert (Debug.debugException(CLASS_NAME, "invoke", exception));
                    throw exception;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "invoke", exception));
                    throw new MBeanException(exception);
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("(");
        if (stringArray.length > 0) {
            stringBuilder.append(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append(", ");
                stringBuilder.append(stringArray[i]);
            }
        }
        stringBuilder.append(")");
        int n = 3342414;
        String string2 = MessageHandler.getMessage(n, stringBuilder.toString(), this.configEntryDN.toString());
        throw new MBeanException(new DirectoryException(ResultCode.NO_SUCH_OPERATION, string2, n));
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanOperationInfo[] mBeanOperationInfoArray;
        assert (Debug.debugEnter(CLASS_NAME, "getMBeanInfo", new String[0]));
        JmxClientConnection jmxClientConnection = this.getClientConnection();
        if (jmxClientConnection == null) {
            return new MBeanInfo(CLASS_NAME, null, null, null, null, null);
        }
        ArrayList<MBeanAttributeInfo> arrayList3 = new ArrayList<MBeanAttributeInfo>();
        for (ConfigurableComponent arrayList22 : this.configurableComponents) {
            for (ConfigAttribute configAttribute : arrayList22.getConfigurationAttributes()) {
                configAttribute.toJMXAttributeInfo(arrayList3);
            }
        }
        for (MonitorProvider monitorProvider : this.monitorProviders) {
            for (Attribute attribute : monitorProvider.getMonitorData()) {
                arrayList3.add(new MBeanAttributeInfo(attribute.getName(), String.class.getName(), null, true, false, false));
            }
        }
        Iterator<Object> iterator = new MBeanAttributeInfo[arrayList3.size()];
        arrayList3.toArray((T[])iterator);
        ArrayList<MBeanNotificationInfo> arrayList = new ArrayList<MBeanNotificationInfo>();
        for (AlertGenerator alertGenerator : this.alertGenerators) {
            mBeanOperationInfoArray = alertGenerator.getClassName();
            LinkedHashMap<String, String> linkedHashMap = alertGenerator.getAlerts();
            for (String string : linkedHashMap.keySet()) {
                String[] stringArray = new String[]{string};
                String string2 = linkedHashMap.get(string);
                arrayList.add(new MBeanNotificationInfo(stringArray, (String)mBeanOperationInfoArray, string2));
            }
        }
        Iterator<Object> iterator2 = new MBeanNotificationInfo[arrayList.size()];
        arrayList.toArray((T[])iterator2);
        ArrayList<MBeanOperationInfo> arrayList2 = new ArrayList<MBeanOperationInfo>();
        for (InvokableComponent invokableComponent : this.invokableComponents) {
            for (InvokableMethod invokableMethod : invokableComponent.getOperationSignatures()) {
                arrayList2.add(invokableMethod.toOperationInfo());
            }
        }
        mBeanOperationInfoArray = new MBeanOperationInfo[arrayList2.size()];
        arrayList2.toArray(mBeanOperationInfoArray);
        MBeanConstructorInfo[] mBeanConstructorInfoArray = new MBeanConstructorInfo[]{};
        return new MBeanInfo(CLASS_NAME, "Configurable Attributes for " + this.configEntryDN.toString(), (MBeanAttributeInfo[])iterator, mBeanConstructorInfoArray, mBeanOperationInfoArray, (MBeanNotificationInfo[])iterator2);
    }

    private JmxClientConnection getClientConnection() {
        AccessControlContext accessControlContext = AccessController.getContext();
        Subject subject = Subject.getSubject(accessControlContext);
        try {
            Set<Credential> set = subject.getPrivateCredentials(Credential.class);
            JmxClientConnection jmxClientConnection = set.iterator().next().getClientConnection();
            return jmxClientConnection;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

