/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanParameterInfo;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerConfigAttribute
extends ConfigAttribute {
    private static final String CLASS_NAME = "org.opends.server.config.IntegerConfigAttribute";
    private List<Long> activeValues;
    private List<Long> pendingValues;
    private boolean hasLowerBound;
    private boolean hasUpperBound;
    private long lowerBound;
    private long upperBound;

    public IntegerConfigAttribute(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, long l, boolean bl5, long l2) {
        super(string, string2, bl, bl2, bl3);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(bl2), String.valueOf(string2), String.valueOf(bl3), String.valueOf(bl4), String.valueOf(l), String.valueOf(bl5), String.valueOf(l2)));
        this.hasLowerBound = bl4;
        this.lowerBound = l;
        this.hasUpperBound = bl5;
        this.upperBound = l2;
        this.activeValues = new ArrayList<Long>();
        this.pendingValues = this.activeValues;
    }

    public IntegerConfigAttribute(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, long l, boolean bl5, long l2, long l3) {
        super(string, string2, bl, bl2, bl3, IntegerConfigAttribute.getValueSet(l3));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(bl2), String.valueOf(string2), String.valueOf(bl3), String.valueOf(bl4), String.valueOf(l), String.valueOf(bl5), String.valueOf(l2), String.valueOf(l3)));
        this.hasLowerBound = bl4;
        this.lowerBound = l;
        this.hasUpperBound = bl5;
        this.upperBound = l2;
        this.activeValues = new ArrayList<Long>(1);
        this.activeValues.add(l3);
        this.pendingValues = this.activeValues;
    }

    public IntegerConfigAttribute(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, long l, boolean bl5, long l2, List<Long> list) {
        super(string, string2, bl, bl2, bl3, IntegerConfigAttribute.getValueSet(list));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(bl2), String.valueOf(string2), String.valueOf(bl3), String.valueOf(bl4), String.valueOf(l), String.valueOf(bl5), String.valueOf(l2), String.valueOf(list)));
        this.hasLowerBound = bl4;
        this.lowerBound = l;
        this.hasUpperBound = bl5;
        this.upperBound = l2;
        if (list == null) {
            this.activeValues = new ArrayList<Long>();
            this.pendingValues = this.activeValues;
        } else {
            this.activeValues = list;
            this.pendingValues = this.activeValues;
        }
    }

    public IntegerConfigAttribute(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, long l, boolean bl5, long l2, List<Long> list, List<Long> list2) {
        super(string, string2, bl, bl2, bl3, IntegerConfigAttribute.getValueSet(list), list2 != null, IntegerConfigAttribute.getValueSet(list2));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(bl2), String.valueOf(string2), String.valueOf(bl3), String.valueOf(bl4), String.valueOf(l), String.valueOf(bl5), String.valueOf(l2), String.valueOf(list), String.valueOf(list2)));
        this.hasLowerBound = bl4;
        this.lowerBound = l;
        this.hasUpperBound = bl5;
        this.upperBound = l2;
        this.activeValues = list == null ? new ArrayList<Long>() : list;
        this.pendingValues = list2 == null ? this.activeValues : list2;
    }

    @Override
    public String getDataType() {
        assert (Debug.debugEnter(CLASS_NAME, "getDataType", new String[0]));
        return "Integer";
    }

    @Override
    public AttributeSyntax getSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntax", new String[0]));
        return DirectoryServer.getDefaultIntegerSyntax();
    }

    public long activeValue() throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "activeValue", new String[0]));
        if (this.activeValues == null || this.activeValues.isEmpty()) {
            int n = 0x330008;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        if (this.activeValues.size() > 1) {
            int n = 0x330009;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        return this.activeValues.get(0);
    }

    public int activeIntValue() throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "activeIntValue", new String[0]));
        if (this.activeValues == null || this.activeValues.isEmpty()) {
            int n = 0x330008;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        if (this.activeValues.size() > 1) {
            int n = 0x330009;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        long l = this.activeValues.get(0);
        int n = (int)l;
        if ((long)n == l) {
            return n;
        }
        int n2 = 0x33000A;
        String string = MessageHandler.getMessage(n2, this.getName());
        throw new ConfigException(n2, string);
    }

    public List<Long> activeValues() {
        assert (Debug.debugEnter(CLASS_NAME, "activeValues", new String[0]));
        return this.activeValues;
    }

    public long pendingValue() throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "pendingValue", new String[0]));
        if (!this.hasPendingValues()) {
            return this.activeValue();
        }
        if (this.pendingValues == null || this.pendingValues.isEmpty()) {
            int n = 0x330008;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        if (this.pendingValues.size() > 1) {
            int n = 0x330009;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        return this.pendingValues.get(0);
    }

    public int pendingIntValue() throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "pendingIntValue", new String[0]));
        if (!this.hasPendingValues()) {
            return this.activeIntValue();
        }
        if (this.pendingValues == null || this.pendingValues.isEmpty()) {
            int n = 0x330008;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        if (this.pendingValues.size() > 1) {
            int n = 0x330009;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        long l = this.pendingValues.get(0);
        int n = (int)l;
        if ((long)n == l) {
            return n;
        }
        int n2 = 0x33000A;
        String string = MessageHandler.getMessage(n2, this.getName());
        throw new ConfigException(n2, string);
    }

    public List<Long> pendingValues() {
        assert (Debug.debugEnter(CLASS_NAME, "pendingValues", new String[0]));
        if (!this.hasPendingValues()) {
            return this.activeValues;
        }
        return this.pendingValues;
    }

    public boolean hasLowerBound() {
        assert (Debug.debugEnter(CLASS_NAME, "hasLowerBound", new String[0]));
        return this.hasLowerBound;
    }

    public long getLowerBound() {
        assert (Debug.debugEnter(CLASS_NAME, "getLowerBound", new String[0]));
        return this.lowerBound;
    }

    public boolean hasUpperBound() {
        assert (Debug.debugEnter(CLASS_NAME, "hasUpperBound", new String[0]));
        return this.hasUpperBound;
    }

    public long getUpperBound() {
        assert (Debug.debugEnter(CLASS_NAME, "getUpperBound", new String[0]));
        return this.upperBound;
    }

    public void setValue(long l) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(l)));
        if (this.hasLowerBound && l < this.lowerBound) {
            int n = 0x33000C;
            String string = MessageHandler.getMessage(n, this.getName(), l, this.lowerBound);
            throw new ConfigException(n, string);
        }
        if (this.hasUpperBound && l > this.upperBound) {
            int n = 0x33000D;
            String string = MessageHandler.getMessage(n, this.getName(), l, this.upperBound);
            throw new ConfigException(n, string);
        }
        if (this.requiresAdminAction()) {
            this.pendingValues = new ArrayList<Long>(1);
            this.pendingValues.add(l);
            this.setPendingValues(IntegerConfigAttribute.getValueSet(l));
        } else {
            this.activeValues.clear();
            this.activeValues.add(l);
            this.pendingValues = this.activeValues;
            this.setActiveValues(IntegerConfigAttribute.getValueSet(l));
        }
    }

    public void setValues(List<Long> list) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "setValues", String.valueOf(list)));
        if (list == null || list.isEmpty()) {
            if (this.isRequired()) {
                int n = 0x330001;
                String string = MessageHandler.getMessage(n, this.getName());
                throw new ConfigException(n, string);
            }
            if (this.requiresAdminAction()) {
                this.setPendingValues(new LinkedHashSet<AttributeValue>(0));
                this.pendingValues = new ArrayList<Long>();
            } else {
                this.setActiveValues(new LinkedHashSet<AttributeValue>(0));
                this.activeValues.clear();
            }
        }
        int n = list.size();
        if (!this.isMultiValued() && n > 1) {
            int n2 = 0x330003;
            String string = MessageHandler.getMessage(n2, this.getName());
            throw new ConfigException(n2, string);
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(n);
        for (long l : list) {
            Object object;
            if (this.hasLowerBound && l < this.lowerBound) {
                int n3 = 0x33000C;
                object = MessageHandler.getMessage(n3, this.getName(), l, this.lowerBound);
                throw new ConfigException(n3, (String)object);
            }
            if (this.hasUpperBound && l > this.upperBound) {
                int n4 = 0x33000D;
                object = MessageHandler.getMessage(n4, this.getName(), l, this.upperBound);
                throw new ConfigException(n4, (String)object);
            }
            String string = String.valueOf(l);
            object = new AttributeValue(new ASN1OctetString(string), (ByteString)new ASN1OctetString(string));
            if (linkedHashSet.contains(object)) {
                int n5 = 0x330005;
                String string2 = MessageHandler.getMessage(n5, this.getName(), string);
                throw new ConfigException(n5, string2);
            }
            linkedHashSet.add((AttributeValue)object);
        }
        if (this.requiresAdminAction()) {
            this.pendingValues = list;
            this.setPendingValues(linkedHashSet);
        } else {
            this.activeValues = list;
            this.pendingValues = this.activeValues;
            this.setActiveValues(linkedHashSet);
        }
    }

    private static LinkedHashSet<AttributeValue> getValueSet(long l) {
        assert (Debug.debugEnter(CLASS_NAME, "getValueSet", String.valueOf(l)));
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        String string = String.valueOf(l);
        linkedHashSet.add(new AttributeValue(new ASN1OctetString(string), (ByteString)new ASN1OctetString(string)));
        return linkedHashSet;
    }

    private static LinkedHashSet<AttributeValue> getValueSet(List<Long> list) {
        assert (Debug.debugEnter(CLASS_NAME, "getValueSet", String.valueOf(list)));
        if (list == null) {
            return null;
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(list.size());
        for (long l : list) {
            String string = String.valueOf(l);
            linkedHashSet.add(new AttributeValue(new ASN1OctetString(string), (ByteString)new ASN1OctetString(string)));
        }
        return linkedHashSet;
    }

    @Override
    public void applyPendingValues() {
        assert (Debug.debugEnter(CLASS_NAME, "applyPendingValues", new String[0]));
        if (!this.hasPendingValues()) {
            return;
        }
        super.applyPendingValues();
        this.activeValues = this.pendingValues;
    }

    @Override
    public boolean valueIsAcceptable(AttributeValue attributeValue, StringBuilder stringBuilder) {
        long l;
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(attributeValue), "java.lang.StringBuilder"));
        String string = attributeValue.getStringValue();
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "valueIsAcceptable", exception));
            stringBuilder.append(MessageHandler.getMessage(0x33000B, string, String.valueOf(exception)));
            return false;
        }
        if (this.hasLowerBound && l < this.lowerBound) {
            stringBuilder.append(MessageHandler.getMessage(0x33000C, this.getName(), l, this.lowerBound));
            return false;
        }
        if (this.hasUpperBound && l > this.upperBound) {
            stringBuilder.append(MessageHandler.getMessage(0x33000D, this.getName(), l, this.upperBound));
            return false;
        }
        return true;
    }

    @Override
    public LinkedHashSet<AttributeValue> stringsToValues(List<String> list, boolean bl) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "stringsToValues", String.valueOf(list), String.valueOf(bl)));
        if (list == null || list.isEmpty()) {
            if (this.isRequired()) {
                int n = 0x330001;
                String string = MessageHandler.getMessage(n, this.getName());
                throw new ConfigException(n, string);
            }
            return new LinkedHashSet<AttributeValue>();
        }
        int n = list.size();
        if (!this.isMultiValued() && n > 1) {
            int n2 = 0x330003;
            String string = MessageHandler.getMessage(n2, this.getName());
            throw new ConfigException(n2, string);
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(n);
        for (String string : list) {
            long l;
            try {
                l = Long.parseLong(string);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "stringsToValues", exception));
                int n3 = 0x33000E;
                String string2 = MessageHandler.getMessage(n3, string, this.getName(), String.valueOf(exception));
                if (bl) {
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, string2, n3);
                    continue;
                }
                throw new ConfigException(n3, string2);
            }
            if (this.hasLowerBound && l < this.lowerBound) {
                int n4 = 0x33000C;
                String string3 = MessageHandler.getMessage(n4, this.getName(), l, this.lowerBound);
                if (bl) {
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, string3, n4);
                    continue;
                }
                throw new ConfigException(n4, string3);
            }
            if (this.hasUpperBound && l > this.upperBound) {
                int n5 = 0x33000D;
                String string4 = MessageHandler.getMessage(n5, this.getName(), l, this.upperBound);
                if (bl) {
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, string4, n5);
                    continue;
                }
                throw new ConfigException(n5, string4);
            }
            linkedHashSet.add(new AttributeValue(new ASN1OctetString(string), (ByteString)new ASN1OctetString(string)));
        }
        if (this.isRequired() && linkedHashSet.isEmpty()) {
            String string;
            int n6 = 0x330001;
            string = MessageHandler.getMessage(n6, this.getName());
            throw new ConfigException(n6, string);
        }
        return linkedHashSet;
    }

    @Override
    public List<String> activeValuesToStrings() {
        assert (Debug.debugEnter(CLASS_NAME, "activeValuesToStrings", new String[0]));
        ArrayList<String> arrayList = new ArrayList<String>(this.activeValues.size());
        for (long l : this.activeValues) {
            arrayList.add(String.valueOf(l));
        }
        return arrayList;
    }

    @Override
    public List<String> pendingValuesToStrings() {
        assert (Debug.debugEnter(CLASS_NAME, "pendingValuesToStrings", new String[0]));
        if (this.hasPendingValues()) {
            ArrayList<String> arrayList = new ArrayList<String>(this.pendingValues.size());
            for (long l : this.pendingValues) {
                arrayList.add(String.valueOf(l));
            }
            return arrayList;
        }
        return null;
    }

    @Override
    public ConfigAttribute getConfigAttribute(List<Attribute> list) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigAttribute", String.valueOf(list)));
        ArrayList<Long> arrayList = null;
        ArrayList<Long> arrayList2 = null;
        for (Attribute object : list) {
            long l;
            Object n3;
            int string;
            LinkedHashSet<AttributeValue> n2;
            if (object.hasOptions()) {
                if (object.hasOption("pending")) {
                    if (arrayList2 != null) {
                        int n7 = 0x330040;
                        String string2 = MessageHandler.getMessage(n7, object.getName());
                        throw new ConfigException(n7, string2);
                    }
                    n2 = object.getValues();
                    if (n2.isEmpty()) {
                        if (this.isRequired()) {
                            string = 0x330001;
                            n3 = MessageHandler.getMessage(string, object.getName());
                            throw new ConfigException(string, (String)n3);
                        }
                        arrayList2 = new ArrayList(0);
                        continue;
                    }
                    string = n2.size();
                    if (string > 1 && !this.isMultiValued()) {
                        int n9 = 0x330003;
                        String string3 = MessageHandler.getMessage(n9, object.getName());
                        throw new ConfigException(n9, string3);
                    }
                    arrayList2 = new ArrayList(string);
                    for (AttributeValue attributeValue : n2) {
                        try {
                            l = Long.parseLong(attributeValue.getStringValue());
                        }
                        catch (Exception n12) {
                            string = 0x33000E;
                            String string4 = MessageHandler.getMessage(string, attributeValue.getStringValue(), object.getName(), String.valueOf(n12));
                            throw new ConfigException(string, string4, n12);
                        }
                        if (this.hasLowerBound && l < this.lowerBound) {
                            int n = 0x33000C;
                            String string5 = MessageHandler.getMessage(n, object.getName(), l, this.lowerBound);
                            throw new ConfigException(n, string5);
                        }
                        if (this.hasUpperBound && l > this.upperBound) {
                            int n = 0x33000D;
                            String string6 = MessageHandler.getMessage(n, object.getName(), l, this.upperBound);
                            throw new ConfigException(n, string6);
                        }
                        arrayList2.add(l);
                    }
                    continue;
                }
                int n8 = 3342366;
                String string7 = MessageHandler.getMessage(n8, object.getName());
                throw new ConfigException(n8, string7);
            }
            if (arrayList != null) {
                int n = 3342401;
                String string8 = MessageHandler.getMessage(n, object.getName());
                throw new ConfigException(n, string8);
            }
            n2 = object.getValues();
            if (n2.isEmpty()) {
                if (this.isRequired()) {
                    string = 0x330001;
                    n3 = MessageHandler.getMessage(string, object.getName());
                    throw new ConfigException(string, (String)n3);
                }
                arrayList = new ArrayList<Long>(0);
                continue;
            }
            string = n2.size();
            if (string > 1 && !this.isMultiValued()) {
                int n = 0x330003;
                String string9 = MessageHandler.getMessage(n, object.getName());
                throw new ConfigException(n, string9);
            }
            arrayList = new ArrayList(string);
            for (AttributeValue attributeValue : n2) {
                try {
                    l = Long.parseLong(attributeValue.getStringValue());
                }
                catch (Exception exception) {
                    int n = 0x33000E;
                    String string10 = MessageHandler.getMessage(n, attributeValue.getStringValue(), object.getName(), String.valueOf(exception));
                    throw new ConfigException(n, string10, exception);
                }
                if (this.hasLowerBound && l < this.lowerBound) {
                    int n = 0x33000C;
                    String string11 = MessageHandler.getMessage(n, object.getName(), l, this.lowerBound);
                    throw new ConfigException(n, string11);
                }
                if (this.hasUpperBound && l > this.upperBound) {
                    int n = 0x33000D;
                    String string12 = MessageHandler.getMessage(n, object.getName(), l, this.upperBound);
                    throw new ConfigException(n, string12);
                }
                arrayList.add(l);
            }
        }
        if (arrayList == null) {
            int n = 3342402;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        if (arrayList2 == null) {
            arrayList2 = arrayList;
        }
        return new IntegerConfigAttribute(this.getName(), this.getDescription(), this.isRequired(), this.isMultiValued(), this.requiresAdminAction(), this.hasLowerBound, this.lowerBound, this.hasUpperBound, this.upperBound, arrayList, arrayList2);
    }

    private javax.management.Attribute _toJMXAttribute(boolean bl) {
        String string;
        List<Long> list;
        assert (Debug.debugEnter(CLASS_NAME, "_toJMXAttribute", new String[0]));
        if (bl) {
            list = this.pendingValues;
            string = this.getName() + ";" + "pending";
        } else {
            list = this.activeValues;
            string = this.getName();
        }
        if (this.isMultiValued()) {
            long[] lArray = new long[list.size()];
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = list.get(i);
            }
            return new javax.management.Attribute(string, lArray);
        }
        if (list.isEmpty()) {
            return null;
        }
        return new javax.management.Attribute(string, list.get(0));
    }

    @Override
    public javax.management.Attribute toJMXAttribute() {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttribute", new String[0]));
        return this._toJMXAttribute(false);
    }

    @Override
    public javax.management.Attribute toJMXAttributePending() {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttributePending", new String[0]));
        return this._toJMXAttribute(true);
    }

    @Override
    public void toJMXAttribute(AttributeList attributeList) {
        Object object;
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttribute", String.valueOf(attributeList)));
        if (this.activeValues.size() > 0) {
            if (this.isMultiValued()) {
                object = new long[this.activeValues.size()];
                for (int i = 0; i < ((long[])object).length; ++i) {
                    object[i] = this.activeValues.get(i);
                }
                attributeList.add(new javax.management.Attribute(this.getName(), object));
            } else {
                attributeList.add(new javax.management.Attribute(this.getName(), this.activeValues.get(0)));
            }
        } else if (this.isMultiValued()) {
            attributeList.add(new javax.management.Attribute(this.getName(), new String[0]));
        } else {
            attributeList.add(new javax.management.Attribute(this.getName(), null));
        }
        if (this.requiresAdminAction() && this.pendingValues != null && this.pendingValues != this.activeValues) {
            object = this.getName() + ";" + "pending";
            if (this.isMultiValued()) {
                long[] lArray = new long[this.pendingValues.size()];
                for (int i = 0; i < lArray.length; ++i) {
                    lArray[i] = this.pendingValues.get(i);
                }
                attributeList.add(new javax.management.Attribute((String)object, lArray));
            } else if (!this.pendingValues.isEmpty()) {
                attributeList.add(new javax.management.Attribute((String)object, this.pendingValues.get(0)));
            }
        }
    }

    @Override
    public void toJMXAttributeInfo(List<MBeanAttributeInfo> list) {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttributeInfo", String.valueOf(list)));
        if (this.isMultiValued()) {
            list.add(new MBeanAttributeInfo(this.getName(), "[J", this.getDescription(), true, true, false));
        } else {
            list.add(new MBeanAttributeInfo(this.getName(), Long.class.getName(), this.getDescription(), true, true, false));
        }
        if (this.requiresAdminAction()) {
            String string = this.getName() + ";" + "pending";
            if (this.isMultiValued()) {
                list.add(new MBeanAttributeInfo(string, "[J", this.getDescription(), true, false, false));
            } else {
                list.add(new MBeanAttributeInfo(string, Long.class.getName(), this.getDescription(), true, false, false));
            }
        }
    }

    @Override
    public MBeanParameterInfo toJMXParameterInfo() {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXParameterInfo", new String[0]));
        if (this.isMultiValued()) {
            return new MBeanParameterInfo(this.getName(), "[J", this.getDescription());
        }
        return new MBeanParameterInfo(this.getName(), Long.TYPE.getName(), this.getDescription());
    }

    @Override
    public void setValue(javax.management.Attribute attribute) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(attribute)));
        Object object = attribute.getValue();
        if (object instanceof Long) {
            this.setValue((Long)object);
        } else if (object instanceof Integer) {
            this.setValue(((Integer)object).intValue());
        } else if (object instanceof String) {
            try {
                this.setValue(Long.parseLong((String)object));
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "setValue", exception));
                int n = 0x33000E;
                String string = MessageHandler.getMessage(n, String.valueOf(object), this.getName(), String.valueOf(exception));
                throw new ConfigException(n, string, exception);
            }
        } else if (object.getClass().isArray()) {
            String string = object.getClass().getComponentType().getName();
            int n = Array.getLength(object);
            try {
                if (string.equals(Long.class.getName())) {
                    ArrayList<Long> arrayList = new ArrayList<Long>();
                    for (int i = 0; i < n; ++i) {
                        arrayList.add(Array.getLong(object, i));
                    }
                    this.setValues(arrayList);
                }
                if (string.equals(Integer.class.getName())) {
                    ArrayList<Long> arrayList = new ArrayList<Long>();
                    for (int i = 0; i < n; ++i) {
                        arrayList.add(Long.valueOf(Array.getInt(object, i)));
                    }
                    this.setValues(arrayList);
                }
                if (string.equals(String.class.getName())) {
                    ArrayList<Long> arrayList = new ArrayList<Long>();
                    for (int i = 0; i < n; ++i) {
                        String string2 = (String)Array.get(object, i);
                        arrayList.add(Long.parseLong(string2));
                    }
                    this.setValues(arrayList);
                }
                int n2 = 0x330044;
                String string3 = MessageHandler.getMessage(n2, string);
                throw new ConfigException(n2, string3);
            }
            catch (ConfigException configException) {
                assert (Debug.debugException(CLASS_NAME, "setValue", configException));
                throw configException;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "setValue", exception));
                int n3 = 0x33000E;
                String string4 = MessageHandler.getMessage(n3, string + "[" + n + "]", this.getName(), String.valueOf(exception));
                throw new ConfigException(n3, string4, exception);
            }
        } else {
            int n = 0x330043;
            String string = MessageHandler.getMessage(n, String.valueOf(object), this.getName(), object.getClass().getName());
            throw new ConfigException(n, string);
        }
    }

    @Override
    public ConfigAttribute duplicate() {
        assert (Debug.debugEnter(CLASS_NAME, "duplicate", new String[0]));
        return new IntegerConfigAttribute(this.getName(), this.getDescription(), this.isRequired(), this.isMultiValued(), this.requiresAdminAction(), this.hasLowerBound, this.lowerBound, this.hasUpperBound, this.upperBound, this.activeValues, this.pendingValues);
    }
}

