/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ObjectClass;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigEntry {
    private static final String CLASS_NAME = "org.opends.server.config.ConfigEntry";
    private ConcurrentHashMap<DN, ConfigEntry> children;
    private ConfigEntry parent;
    private CopyOnWriteArrayList<ConfigAddListener> addListeners;
    private CopyOnWriteArrayList<ConfigChangeListener> changeListeners;
    private CopyOnWriteArrayList<ConfigDeleteListener> deleteListeners;
    private Entry entry;
    private ReentrantLock entryLock;

    public ConfigEntry(Entry entry, ConfigEntry configEntry) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(entry), String.valueOf(configEntry)));
        this.entry = entry;
        this.parent = configEntry;
        this.children = new ConcurrentHashMap();
        this.addListeners = new CopyOnWriteArrayList();
        this.changeListeners = new CopyOnWriteArrayList();
        this.deleteListeners = new CopyOnWriteArrayList();
        this.entryLock = new ReentrantLock();
    }

    public Entry getEntry() {
        assert (Debug.debugEnter(CLASS_NAME, "getEntry", new String[0]));
        return this.entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntry(Entry entry) {
        assert (Debug.debugEnter(CLASS_NAME, "setEntry", String.valueOf(entry)));
        this.entryLock.lock();
        try {
            this.entry = entry;
        }
        finally {
            this.entryLock.unlock();
        }
    }

    public DN getDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getDN", new String[0]));
        return this.entry.getDN();
    }

    public boolean hasObjectClass(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "hasObjectClass", String.valueOf(string)));
        ObjectClass objectClass = DirectoryServer.getObjectClass(string.toLowerCase());
        if (objectClass == null) {
            objectClass = DirectoryServer.getDefaultObjectClass(string);
        }
        return this.entry.hasObjectClass(objectClass);
    }

    public ConfigAttribute getConfigAttribute(ConfigAttribute configAttribute) throws ConfigException {
        List<Attribute> list;
        assert (Debug.debugEnter(CLASS_NAME, "getConfigAttribute", String.valueOf(configAttribute)));
        String string = configAttribute.getName();
        AttributeType attributeType = DirectoryServer.getAttributeType(string.toLowerCase());
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType(string);
        }
        if ((list = this.entry.getAttribute(attributeType)) == null || list.isEmpty()) {
            return null;
        }
        return configAttribute.getConfigAttribute(list);
    }

    public void putConfigAttribute(ConfigAttribute configAttribute) {
        assert (Debug.debugEnter(CLASS_NAME, "putConfigAttribute", String.valueOf(configAttribute)));
        String string = configAttribute.getName();
        AttributeType attributeType = DirectoryServer.getAttributeType(string.toLowerCase());
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType(string, configAttribute.getSyntax());
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(2);
        arrayList.add(new Attribute(attributeType, string, configAttribute.getActiveValues()));
        if (configAttribute.hasPendingValues()) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(1);
            linkedHashSet.add("pending");
            arrayList.add(new Attribute(attributeType, string, linkedHashSet, configAttribute.getPendingValues()));
        }
        this.entry.putAttribute(attributeType, arrayList);
    }

    public boolean removeConfigAttribute(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "removeConfigAttribute", String.valueOf(string)));
        for (AttributeType attributeType : this.entry.getUserAttributes().keySet()) {
            if (!attributeType.hasNameOrOID(string)) continue;
            this.entry.getUserAttributes().remove(attributeType);
            return true;
        }
        for (AttributeType attributeType : this.entry.getOperationalAttributes().keySet()) {
            if (!attributeType.hasNameOrOID(string)) continue;
            this.entry.getOperationalAttributes().remove(attributeType);
            return true;
        }
        return false;
    }

    public ConfigEntry getParent() {
        assert (Debug.debugEnter(CLASS_NAME, "getParent", new String[0]));
        return this.parent;
    }

    public ConcurrentHashMap<DN, ConfigEntry> getChildren() {
        assert (Debug.debugEnter(CLASS_NAME, "getChildren", new String[0]));
        return this.children;
    }

    public boolean hasChildren() {
        assert (Debug.debugEnter(CLASS_NAME, "hasChildren", new String[0]));
        return !this.children.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(ConfigEntry configEntry) throws ConfigException {
        ConfigEntry configEntry2;
        assert (Debug.debugEnter(CLASS_NAME, "addChild", String.valueOf(configEntry)));
        this.entryLock.lock();
        try {
            configEntry2 = this.children.putIfAbsent(configEntry.getDN(), configEntry);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "addChild", exception));
            configEntry2 = null;
        }
        finally {
            this.entryLock.unlock();
        }
        if (configEntry2 != null) {
            int n = 3342359;
            String string = MessageHandler.getMessage(n, configEntry2.getDN().toString(), this.entry.getDN().toString());
            throw new ConfigException(n, string);
        }
    }

    public ConfigEntry removeChild(DN dN) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "removeChild", String.valueOf(dN)));
        this.entryLock.lock();
        try {
            ConfigEntry configEntry = this.children.get(dN);
            if (configEntry == null) {
                int n = 3342360;
                String string = MessageHandler.getMessage(n, dN.toString(), this.entry.getDN().toString());
                throw new ConfigException(n, string);
            }
            if (configEntry.hasChildren()) {
                int n = 3342361;
                String string = MessageHandler.getMessage(n, dN.toString(), this.entry.getDN().toString());
                throw new ConfigException(n, string);
            }
            this.children.remove(dN);
            ConfigEntry configEntry2 = configEntry;
            return configEntry2;
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "removeChild", exception));
            int n = 3342551;
            String string = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(this.entry.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
            throw new ConfigException(n, string, exception);
        }
        finally {
            this.entryLock.unlock();
        }
    }

    public ConfigEntry duplicate() {
        assert (Debug.debugEnter(CLASS_NAME, "duplicate", new String[0]));
        return new ConfigEntry(this.entry.duplicate(), this.parent);
    }

    public CopyOnWriteArrayList<ConfigChangeListener> getChangeListeners() {
        assert (Debug.debugEnter(CLASS_NAME, "getChangeListeners", new String[0]));
        return this.changeListeners;
    }

    public void registerChangeListener(ConfigChangeListener configChangeListener) {
        assert (Debug.debugEnter(CLASS_NAME, "registerChangeListener", String.valueOf(configChangeListener)));
        this.changeListeners.add(configChangeListener);
    }

    public boolean deregisterChangeListener(ConfigChangeListener configChangeListener) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterChangeListener", String.valueOf(configChangeListener)));
        return this.changeListeners.remove(configChangeListener);
    }

    public CopyOnWriteArrayList<ConfigAddListener> getAddListeners() {
        assert (Debug.debugEnter(CLASS_NAME, "getAddListeners", new String[0]));
        return this.addListeners;
    }

    public void registerAddListener(ConfigAddListener configAddListener) {
        assert (Debug.debugEnter(CLASS_NAME, "registerAddListener", String.valueOf(configAddListener)));
        this.addListeners.addIfAbsent(configAddListener);
    }

    public void deregisterAddListener(ConfigAddListener configAddListener) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterAddListener", String.valueOf(configAddListener)));
        this.addListeners.remove(configAddListener);
    }

    public CopyOnWriteArrayList<ConfigDeleteListener> getDeleteListeners() {
        assert (Debug.debugEnter(CLASS_NAME, "getDeleteListeners", new String[0]));
        return this.deleteListeners;
    }

    public void registerDeleteListener(ConfigDeleteListener configDeleteListener) {
        assert (Debug.debugEnter(CLASS_NAME, "registerDeleteListener", String.valueOf(configDeleteListener)));
        this.deleteListeners.addIfAbsent(configDeleteListener);
    }

    public void deregisterDeleteListener(ConfigDeleteListener configDeleteListener) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterDeleteListener", String.valueOf(configDeleteListener)));
        this.deleteListeners.remove(configDeleteListener);
    }
}

