/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.changelog;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeSet;
import org.opends.server.api.MonitorProvider;
import org.opends.server.changelog.AckMessageList;
import org.opends.server.changelog.Changelog;
import org.opends.server.changelog.ChangelogAckMessageList;
import org.opends.server.changelog.ChangelogCache;
import org.opends.server.changelog.ChangelogIterator;
import org.opends.server.changelog.ChangelogIteratorComparator;
import org.opends.server.changelog.MsgQueue;
import org.opends.server.changelog.ProtocolSession;
import org.opends.server.changelog.ServerReader;
import org.opends.server.changelog.ServerWriter;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.synchronization.AckMessage;
import org.opends.server.synchronization.ChangeNumber;
import org.opends.server.synchronization.ChangelogStartMessage;
import org.opends.server.synchronization.ServerStartMessage;
import org.opends.server.synchronization.ServerState;
import org.opends.server.synchronization.SynchronizationMessage;
import org.opends.server.synchronization.UpdateMessage;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerHandler
extends MonitorProvider {
    private short serverId;
    private ProtocolSession session;
    private MsgQueue msgQueue = new MsgQueue();
    private MsgQueue lateQueue = new MsgQueue();
    private Map<ChangeNumber, AckMessageList> waitingAcks = new HashMap<ChangeNumber, AckMessageList>();
    private ChangelogCache changelogCache = null;
    private String serverURL;
    private int outCount = 0;
    private int inCount = 0;
    private int inAckCount = 0;
    private int outAckCount = 0;
    private int maxReceiveQueue = 0;
    private int maxSendQueue = 0;
    private int maxReceiveDelay = 0;
    private int maxSendDelay = 0;
    private int restartReceiveQueue;
    private int restartSendQueue;
    private int restartReceiveDelay;
    private int restartSendDelay;
    private boolean serverIsLDAPserver;
    private boolean following = false;
    private ServerState serverState;
    private boolean active = true;
    private ServerWriter writer = null;
    private DN baseDn = null;
    private static Map<ChangeNumber, ChangelogAckMessageList> changelogsWaitingAcks = new HashMap<ChangeNumber, ChangelogAckMessageList>();

    public ServerHandler(ProtocolSession protocolSession) {
        super("Server Handler");
        this.session = protocolSession;
    }

    public void start(DN dN) {
        try {
            Object object;
            Serializable serializable;
            if (dN != null) {
                this.baseDn = dN;
                this.changelogCache = Changelog.getChangelogCache(dN);
                serializable = this.changelogCache.getDbServerState();
                object = new ChangelogStartMessage(Changelog.getServerId(), Changelog.getServerURL(), dN, (ServerState)serializable);
                this.session.publish((SynchronizationMessage)object);
            }
            if ((serializable = this.session.receive()) instanceof ServerStartMessage) {
                object = (ServerStartMessage)serializable;
                this.serverId = ((ServerStartMessage)object).getServerId();
                this.serverURL = ((ServerStartMessage)object).getServerURL();
                this.baseDn = ((ServerStartMessage)object).getBaseDn();
                this.serverState = ((ServerStartMessage)object).getServerState();
                this.maxReceiveDelay = ((ServerStartMessage)object).getMaxReceiveDelay();
                this.maxReceiveQueue = ((ServerStartMessage)object).getMaxReceiveQueue();
                this.maxSendDelay = ((ServerStartMessage)object).getMaxSendDelay();
                this.maxSendQueue = ((ServerStartMessage)object).getMaxSendQueue();
                this.restartReceiveQueue = this.maxReceiveQueue > 0 ? (this.maxReceiveQueue > 1000 ? this.maxReceiveQueue - 200 : this.maxReceiveQueue * 8 / 10) : 0;
                this.restartSendQueue = this.maxSendQueue > 0 ? (this.maxSendQueue > 1000 ? this.maxSendQueue - 200 : this.maxSendQueue * 8 / 10) : 0;
                this.restartReceiveDelay = this.maxReceiveDelay > 0 ? (this.maxReceiveDelay > 10 ? this.maxReceiveDelay - 1 : this.maxReceiveDelay) : 0;
                this.restartSendDelay = this.maxSendDelay > 0 ? (this.maxSendDelay > 10 ? this.maxSendDelay - 1 : this.maxSendDelay) : 0;
                this.serverIsLDAPserver = true;
                this.changelogCache = Changelog.getChangelogCache(this.baseDn);
                ServerState serverState = this.changelogCache.getDbServerState();
                ChangelogStartMessage changelogStartMessage = new ChangelogStartMessage(Changelog.getServerId(), Changelog.getServerURL(), this.baseDn, serverState);
                this.session.publish(changelogStartMessage);
            } else if (serializable.getClass() == Class.forName("org.opends.server.synchronization.ChangelogStartMessage")) {
                object = (ChangelogStartMessage)serializable;
                this.serverId = ((ChangelogStartMessage)object).getServerId();
                this.serverURL = ((ChangelogStartMessage)object).getServerURL();
                this.serverIsLDAPserver = false;
                this.baseDn = ((ChangelogStartMessage)object).getBaseDn();
                if (dN == null) {
                    this.changelogCache = Changelog.getChangelogCache(this.baseDn);
                    ServerState serverState = this.changelogCache.getDbServerState();
                    ChangelogStartMessage changelogStartMessage = new ChangelogStartMessage(Changelog.getServerId(), Changelog.getServerURL(), this.baseDn, serverState);
                    this.session.publish(changelogStartMessage);
                } else {
                    this.baseDn = dN;
                }
                this.serverState = ((ChangelogStartMessage)object).getServerState();
            } else {
                return;
            }
            this.changelogCache = Changelog.getChangelogCache(this.baseDn);
            if (this.serverIsLDAPserver) {
                this.changelogCache.startServer(this);
            } else {
                this.changelogCache.startChangelog(this);
            }
            this.writer = new ServerWriter(this.session, this.serverId, this, this.changelogCache);
            object = new ServerReader(this.session, this.serverId, this, this.changelogCache);
            ((Thread)object).start();
            this.writer.start();
            DirectoryServer.deregisterMonitorProvider(this.getMonitorInstanceName());
            DirectoryServer.registerMonitorProvider(this);
        }
        catch (Exception exception) {
            int n = 17039390;
            String string = MessageHandler.getMessage(n, this.toString()) + StaticUtils.stackTraceToSingleLineString(exception);
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
            try {
                this.session.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public short getServerId() {
        return this.serverId;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void incrementOutCount() {
        ++this.outCount;
    }

    public void incrementInCount() {
        ++this.inCount;
    }

    public int getInCount() {
        return this.inCount;
    }

    public int getOutCount() {
        return this.outCount;
    }

    public int getInAckCount() {
        return this.inAckCount;
    }

    public int getOutAckCount() {
        return this.outAckCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSaturated(ChangeNumber changeNumber, ServerHandler serverHandler) {
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            UpdateMessage updateMessage;
            int n = this.msgQueue.size();
            if (this.maxReceiveQueue > 0 && n >= this.maxReceiveQueue) {
                return true;
            }
            if (serverHandler.maxSendQueue > 0 && n >= serverHandler.maxSendQueue) {
                return true;
            }
            if (!this.msgQueue.isEmpty() && (updateMessage = this.msgQueue.first()) != null) {
                long l = changeNumber.getTimeSec() - updateMessage.getChangeNumber().getTimeSec();
                if (this.maxReceiveDelay > 0 && l >= (long)this.maxReceiveDelay) {
                    return true;
                }
                if (serverHandler.maxSendDelay > 0 && l >= (long)serverHandler.maxSendDelay) {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restartAfterSaturation(ServerHandler serverHandler) {
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            if (this.msgQueue == null) {
                return true;
            }
            MsgQueue msgQueue2 = this.msgQueue;
            synchronized (msgQueue2) {
                int n = this.msgQueue.size();
                if (this.maxReceiveQueue > 0 && n >= this.restartReceiveQueue) {
                    return false;
                }
                if (serverHandler != null && serverHandler.maxSendQueue > 0 && n >= serverHandler.restartSendQueue) {
                    return false;
                }
                if (!this.msgQueue.isEmpty()) {
                    UpdateMessage updateMessage = this.msgQueue.first();
                    UpdateMessage updateMessage2 = this.msgQueue.last();
                    if (updateMessage != null && updateMessage2 != null) {
                        long l = updateMessage2.getChangeNumber().getTimeSec() - updateMessage.getChangeNumber().getTimeSec();
                        if (this.maxReceiveDelay > 0 && l >= (long)this.restartReceiveDelay) {
                            return false;
                        }
                        if (serverHandler != null && serverHandler.maxSendDelay > 0 && l >= (long)serverHandler.restartSendDelay) {
                            return false;
                        }
                    }
                }
            }
            return true;
        }
    }

    public boolean isChangelogServer() {
        return !this.serverIsLDAPserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRcvMsgQueueSize() {
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            if (this.isFollowing()) {
                return this.msgQueue.size();
            }
            return Integer.MAX_VALUE;
        }
    }

    public long getApproxDelay() {
        long l = this.getOlderUpdateTime();
        if (l == 0L) {
            return 0L;
        }
        long l2 = TimeThread.getTime();
        return (l2 - l) / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOlderUpdateTime() {
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            if (this.isFollowing()) {
                if (this.msgQueue.isEmpty()) {
                    return 0L;
                }
                UpdateMessage updateMessage = this.msgQueue.first();
                return updateMessage.getChangeNumber().getTime();
            }
            if (this.lateQueue.isEmpty()) {
                return 0L;
            }
            UpdateMessage updateMessage = this.lateQueue.first();
            return updateMessage.getChangeNumber().getTime();
        }
    }

    public boolean isFollowing() {
        return this.following;
    }

    public void setFollowing(boolean bl) {
        this.following = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(UpdateMessage updateMessage) {
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            if (this.msgQueue.isEmpty()) {
                this.msgQueue.notify();
            }
            this.msgQueue.add(updateMessage);
            while (this.msgQueue.size() > 10000) {
                this.following = false;
                this.msgQueue.removeFirst();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateMessage take() {
        do {
            UpdateMessage updateMessage;
            Object object;
            if (!this.following) {
                if (this.lateQueue.isEmpty()) {
                    object = new ChangelogIteratorComparator();
                    TreeSet<Object> treeSet = new TreeSet<Object>((Comparator<Object>)object);
                    Object object2 = this.changelogCache.getServers().iterator();
                    while (object2.hasNext()) {
                        ChangeNumber changeNumber;
                        short s = object2.next();
                        ChangelogIterator changelogIterator = this.changelogCache.getChangelogIterator(s, changeNumber = this.serverState.getMaxChangeNumber(s));
                        if (changelogIterator == null || changelogIterator.getChange() == null) continue;
                        treeSet.add(changelogIterator);
                    }
                    while (!treeSet.isEmpty() && this.lateQueue.size() < 100) {
                        object2 = (ChangelogIterator)treeSet.first();
                        treeSet.remove(object2);
                        this.lateQueue.add(((ChangelogIterator)object2).getChange());
                        if (((ChangelogIterator)object2).next()) {
                            treeSet.add(object2);
                            continue;
                        }
                        ((ChangelogIterator)object2).releaseCursor();
                    }
                    for (ChangelogIterator changelogIterator : treeSet) {
                        changelogIterator.releaseCursor();
                    }
                    if (this.lateQueue.isEmpty()) {
                        object2 = this.msgQueue;
                        synchronized (object2) {
                            if (this.msgQueue.size() < 10000) {
                                this.following = true;
                            }
                        }
                    } else {
                        updateMessage = this.lateQueue.first();
                        object2 = this.msgQueue;
                        synchronized (object2) {
                            if (this.msgQueue.contains(updateMessage)) {
                                UpdateMessage updateMessage2;
                                this.following = true;
                                this.lateQueue.clear();
                                do {
                                    updateMessage2 = this.msgQueue.removeFirst();
                                } while (!updateMessage.getChangeNumber().equals(updateMessage2.getChangeNumber()));
                                this.updateServerState(updateMessage);
                                this.incrementOutCount();
                                return updateMessage;
                            }
                        }
                    }
                } else {
                    updateMessage = this.lateQueue.removeFirst();
                    this.updateServerState(updateMessage);
                    this.incrementOutCount();
                    return updateMessage;
                }
            }
            object = this.msgQueue;
            synchronized (object) {
                if (this.following) {
                    try {
                        while (this.msgQueue.isEmpty()) {
                            this.msgQueue.wait(500L);
                            if (this.active) continue;
                            return null;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return null;
                    }
                    updateMessage = this.msgQueue.removeFirst();
                    if (this.updateServerState(updateMessage)) {
                        this.incrementOutCount();
                        return updateMessage;
                    }
                }
            }
        } while (this.active);
        return null;
    }

    public boolean updateServerState(UpdateMessage updateMessage) {
        return this.serverState.update(updateMessage.getChangeNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopHandler() {
        this.active = false;
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            this.msgQueue.clear();
            this.msgQueue.notify();
            this.msgQueue.notifyAll();
        }
        DirectoryServer.deregisterMonitorProvider(this.getMonitorInstanceName());
    }

    public void sendAck(ChangeNumber changeNumber) throws IOException {
        AckMessage ackMessage = new AckMessage(changeNumber);
        this.session.publish(ackMessage);
        ++this.outAckCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(AckMessage ackMessage, short s) {
        boolean bl;
        ChangeNumber changeNumber = ackMessage.getChangeNumber();
        Map<ChangeNumber, AckMessageList> map = this.waitingAcks;
        synchronized (map) {
            AckMessageList ackMessageList = this.waitingAcks.get(changeNumber);
            if (ackMessageList == null) {
                return;
            }
            ackMessageList.addAck(s);
            bl = ackMessageList.completed();
            if (bl) {
                this.waitingAcks.remove(changeNumber);
            }
        }
        if (bl) {
            this.changelogCache.sendAck(changeNumber, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ackChangelog(AckMessage ackMessage, short s) {
        boolean bl;
        ChangelogAckMessageList changelogAckMessageList;
        ChangeNumber changeNumber = ackMessage.getChangeNumber();
        Object object = changelogsWaitingAcks;
        synchronized (object) {
            changelogAckMessageList = changelogsWaitingAcks.get(changeNumber);
            if (changelogAckMessageList == null) {
                return;
            }
            changelogAckMessageList.addAck(s);
            bl = changelogAckMessageList.completed();
            if (bl) {
                changelogsWaitingAcks.remove(changeNumber);
            }
        }
        if (bl) {
            object = changelogAckMessageList.getChangelogCache();
            ((ChangelogCache)object).sendAck(changeNumber, false, changelogAckMessageList.getChangelogServerId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWaitingAck(UpdateMessage updateMessage, int n) {
        AckMessageList ackMessageList = new AckMessageList(updateMessage.getChangeNumber(), n);
        Map<ChangeNumber, AckMessageList> map = this.waitingAcks;
        synchronized (map) {
            this.waitingAcks.put(updateMessage.getChangeNumber(), ackMessageList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addWaitingAck(UpdateMessage updateMessage, short s, ChangelogCache changelogCache, int n) {
        ChangelogAckMessageList changelogAckMessageList = new ChangelogAckMessageList(updateMessage.getChangeNumber(), n, s, changelogCache);
        Map<ChangeNumber, ChangelogAckMessageList> map = changelogsWaitingAcks;
        synchronized (map) {
            changelogsWaitingAcks.put(updateMessage.getChangeNumber(), changelogAckMessageList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWaitingAckSize() {
        Map<ChangeNumber, AckMessageList> map = this.waitingAcks;
        synchronized (map) {
            return this.waitingAcks.size();
        }
    }

    public void incrementInAckCount() {
        ++this.inAckCount;
    }

    public boolean isLDAPserver() {
        return this.serverIsLDAPserver;
    }

    @Override
    public void initializeMonitorProvider(ConfigEntry configEntry) throws ConfigException, InitializationException {
    }

    @Override
    public String getMonitorInstanceName() {
        String string = this.changelogCache.getBaseDn().toString() + " " + this.serverURL + " " + String.valueOf(this.serverId);
        if (this.serverIsLDAPserver) {
            return "LDAP Server " + string;
        }
        return "Changelog Server " + string;
    }

    @Override
    public long getUpdateInterval() {
        return 0L;
    }

    @Override
    public void updateMonitorData() {
    }

    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        if (this.serverIsLDAPserver) {
            arrayList.add(new Attribute("LDAP-Server", this.serverURL));
        } else {
            arrayList.add(new Attribute("Changelog-Server", this.serverURL));
        }
        arrayList.add(new Attribute("server-id", String.valueOf(this.serverId)));
        arrayList.add(new Attribute("base-dn", this.changelogCache.getBaseDn().toString()));
        arrayList.add(new Attribute("waiting-changes", String.valueOf(this.getRcvMsgQueueSize())));
        arrayList.add(new Attribute("update-waiting-acks", String.valueOf(this.getWaitingAckSize())));
        arrayList.add(new Attribute("update-sent", String.valueOf(this.getOutCount())));
        arrayList.add(new Attribute("update-received", String.valueOf(this.getInCount())));
        arrayList.add(new Attribute("ack-sent", String.valueOf(this.getOutAckCount())));
        arrayList.add(new Attribute("ack-received", String.valueOf(this.getInAckCount())));
        arrayList.add(new Attribute("approximate-delay", String.valueOf(this.getApproxDelay())));
        long l = this.getOlderUpdateTime();
        if (l != 0L) {
            Date date = new Date(this.getOlderUpdateTime());
            arrayList.add(new Attribute("older-change-not-synchronized", String.valueOf(date.toString())));
        }
        AttributeType attributeType = DirectoryServer.getDefaultAttributeType("server-state");
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>();
        for (String string : this.serverState.toStringSet()) {
            linkedHashSet.add(new AttributeValue(attributeType, string));
        }
        Attribute attribute = new Attribute(attributeType, "server-state", linkedHashSet);
        arrayList.add(attribute);
        return arrayList;
    }

    public void shutdown() {
        try {
            this.session.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.stopHandler();
    }

    @Override
    public String toString() {
        String string;
        if (this.serverId != 0) {
            string = this.serverIsLDAPserver ? "Directory Server " : "Changelog Server ";
            string = string + this.serverId + " " + this.serverURL + " " + this.baseDn;
        } else {
            string = "Unknown server";
        }
        return string;
    }
}

