/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.changelog;

import com.sleepycat.je.DatabaseException;
import org.opends.server.changelog.ChangelogDB;
import org.opends.server.synchronization.ChangeNumber;
import org.opends.server.synchronization.UpdateMessage;

public class ChangelogIterator {
    private UpdateMessage currentChange = null;
    private ChangelogDB.ChangelogCursor cursor = null;

    public ChangelogIterator(short s, ChangelogDB changelogDB, ChangeNumber changeNumber) throws Exception, DatabaseException {
        this.cursor = changelogDB.openReadCursor(changeNumber);
        if (this.cursor == null) {
            throw new Exception("no new change");
        }
        if (!this.next()) {
            this.cursor.close();
            this.cursor = null;
            throw new Exception("no new change");
        }
    }

    public UpdateMessage getChange() {
        return this.currentChange;
    }

    public boolean next() {
        this.currentChange = this.cursor.next();
        return this.currentChange != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCursor() {
        ChangelogIterator changelogIterator = this;
        synchronized (changelogIterator) {
            if (this.cursor != null) {
                this.cursor.close();
                this.cursor = null;
            }
        }
    }

    protected void finalize() {
        this.releaseCursor();
    }
}

