/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.task;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.DirectoryThread;
import org.opends.server.backends.task.RecurringTask;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskBackend;
import org.opends.server.backends.task.TaskState;
import org.opends.server.backends.task.TaskThread;
import org.opends.server.core.DirectoryException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.InitializationException;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskScheduler
extends DirectoryThread
implements AlertGenerator {
    private static final String CLASS_NAME = "org.opends.server.backends.task.TaskScheduler";
    private static long MAX_SLEEP_TIME = 5000L;
    private boolean isRunning;
    private boolean stopRequested;
    private Entry recurringTaskParentEntry;
    private Entry scheduledTaskParentEntry;
    private Entry taskRootEntry;
    private HashMap<String, RecurringTask> recurringTasks;
    private HashMap<String, Task> tasks;
    private HashMap<String, TaskThread> activeThreads;
    private int nextThreadID;
    private LinkedList<TaskThread> idleThreads;
    private ReentrantLock schedulerLock;
    private TaskBackend taskBackend;
    private Thread schedulerThread;
    private TreeSet<Task> completedTasks;
    private TreeSet<Task> pendingTasks;
    private TreeSet<Task> runningTasks;

    public TaskScheduler(TaskBackend taskBackend) throws InitializationException {
        super("Task Scheduler Thread");
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(taskBackend)));
        this.taskBackend = taskBackend;
        this.schedulerLock = new ReentrantLock();
        this.isRunning = false;
        this.stopRequested = false;
        this.schedulerThread = null;
        this.nextThreadID = 1;
        this.recurringTasks = new HashMap();
        this.tasks = new HashMap();
        this.activeThreads = new HashMap();
        this.idleThreads = new LinkedList();
        this.completedTasks = new TreeSet();
        this.pendingTasks = new TreeSet();
        this.runningTasks = new TreeSet();
        this.taskRootEntry = null;
        this.recurringTaskParentEntry = null;
        this.scheduledTaskParentEntry = null;
        DirectoryServer.registerAlertGenerator(this);
        this.initializeTasksFromBackingFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecurringTask(RecurringTask recurringTask, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "addRecurringTask", String.valueOf(recurringTask), String.valueOf(bl)));
        this.schedulerLock.lock();
        try {
            Task task;
            String string = recurringTask.getRecurringTaskID();
            if (this.recurringTasks.containsKey(string)) {
                int n = 9699461;
                String string2 = MessageHandler.getMessage(n, String.valueOf(string));
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, string2, n);
            }
            this.recurringTasks.put(string, recurringTask);
            if (bl && (task = recurringTask.scheduleNextIteration()) != null) {
                this.scheduleTask(task, false);
            }
            this.writeState();
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecurringTask removeRecurringTask(String string) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "removeRecurringTask", String.valueOf(string)));
        this.schedulerLock.lock();
        try {
            for (Task object2 : this.tasks.values()) {
                if (object2.getRecurringTaskID() == null || !object2.getRecurringTaskID().equals(string) || TaskState.isDone(object2.getTaskState())) continue;
                int n = 9699488;
                String string2 = MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(object2.getTaskID()));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string2, n);
            }
            RecurringTask recurringTask = this.recurringTasks.remove(string);
            this.writeState();
            Object object = recurringTask;
            return object;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTask(Task task, boolean bl) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "scheduleTask", String.valueOf(task)));
        this.schedulerLock.lock();
        try {
            String string = task.getTaskID();
            if (this.tasks.containsKey(string)) {
                int n = 9699462;
                String string2 = MessageHandler.getMessage(n, String.valueOf(string));
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, string2, n);
            }
            this.tasks.put(string, task);
            TaskState taskState = this.shouldStart(task);
            task.setTaskState(taskState);
            if (taskState == TaskState.RUNNING) {
                TaskThread taskThread;
                if (this.idleThreads.isEmpty()) {
                    taskThread = new TaskThread(this, this.nextThreadID++);
                    taskThread.start();
                } else {
                    taskThread = this.idleThreads.removeFirst();
                }
                this.runningTasks.add(task);
                this.activeThreads.put(task.getTaskID(), taskThread);
                taskThread.setTask(task);
            } else {
                this.pendingTasks.add(task);
            }
            if (bl) {
                this.writeState();
            }
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task cancelTask(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "cancelTask", String.valueOf(string)));
        this.schedulerLock.lock();
        try {
            Task task = this.tasks.get(string);
            if (task == null) {
                Task task2 = null;
                return task2;
            }
            if (TaskState.isPending(task.getTaskState())) {
                this.pendingTasks.remove(task);
                task.setTaskState(TaskState.CANCELED_BEFORE_STARTING);
                this.addCompletedTask(task);
                this.writeState();
            }
            Task task3 = task;
            return task3;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    public Task removePendingTask(String string) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "removePendingTask", String.valueOf(string)));
        this.schedulerLock.lock();
        try {
            Task task = this.tasks.get(string);
            if (task == null) {
                int n = 9699489;
                String string2 = MessageHandler.getMessage(n, String.valueOf(string));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string2, n);
            }
            if (TaskState.isPending(task.getTaskState())) {
                this.tasks.remove(string);
                this.pendingTasks.remove(task);
                this.writeState();
                Task task2 = task;
                return task2;
            }
            int n = 9699490;
            String string3 = MessageHandler.getMessage(n, String.valueOf(string));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string3, n);
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    public Task removeCompletedTask(String string) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "removeCompletedTask", String.valueOf(string)));
        this.schedulerLock.lock();
        try {
            Iterator<Task> iterator = this.completedTasks.iterator();
            while (iterator.hasNext()) {
                Task task = iterator.next();
                if (!task.getTaskID().equals(string)) continue;
                iterator.remove();
                this.tasks.remove(string);
                this.writeState();
                Task task2 = task;
                return task2;
            }
            int n = 9699491;
            String string2 = MessageHandler.getMessage(n, String.valueOf(string));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string2, n);
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean threadDone(TaskThread taskThread, Task task) {
        assert (Debug.debugEnter(CLASS_NAME, "threadDone", String.valueOf(taskThread)));
        this.schedulerLock.lock();
        try {
            this.addCompletedTask(task);
            String string = task.getTaskID();
            if (this.activeThreads.remove(string) == null) {
                boolean bl = false;
                return bl;
            }
            String string2 = task.getRecurringTaskID();
            if (string2 != null) {
                RecurringTask recurringTask = this.recurringTasks.get(string2);
                if (recurringTask == null) {
                    int n = 9699463;
                    String string3 = MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(string2));
                    Error.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, string3, n);
                    DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotFindRecurringTask", n, string3);
                } else {
                    Task task2 = recurringTask.scheduleNextIteration();
                    if (task2 != null) {
                        try {
                            this.scheduleTask(task2, false);
                        }
                        catch (DirectoryException directoryException) {
                            assert (Debug.debugException(CLASS_NAME, "threadDone", directoryException));
                            int n = 9699464;
                            String string4 = MessageHandler.getMessage(n, string2, directoryException.getErrorMessage());
                            Error.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, string4, n);
                            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotScheduleRecurringIteration", n, string4);
                        }
                    }
                }
            }
            this.writeState();
            if (this.isRunning) {
                this.idleThreads.add(taskThread);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompletedTask(Task task) {
        assert (Debug.debugEnter(CLASS_NAME, "addCompletedTask", String.valueOf(task)));
        this.schedulerLock.lock();
        try {
            this.completedTasks.add(task);
            this.runningTasks.remove(task);
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    public void stopScheduler() {
        block7: {
            block6: {
                assert (Debug.debugEnter(CLASS_NAME, "stopScheduler", new String[0]));
                this.stopRequested = true;
                try {
                    this.schedulerThread.interrupt();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "stopScheduler", exception)) break block6;
                    throw new AssertionError();
                }
            }
            try {
                this.schedulerThread.join();
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "stopScheduler", exception)) break block7;
                throw new AssertionError();
            }
        }
        this.pendingTasks.clear();
        this.runningTasks.clear();
        this.completedTasks.clear();
        this.tasks.clear();
        for (TaskThread taskThread : this.idleThreads) {
            int n = 0x90009C;
            String string = MessageHandler.getMessage(n);
            taskThread.interruptTask(TaskState.STOPPED_BY_SHUTDOWN, string, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptRunningTasks(TaskState taskState, String string, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "interruptRunningTasks", String.valueOf(bl)));
        LinkedList<TaskThread> linkedList = new LinkedList<TaskThread>();
        this.schedulerLock.lock();
        try {
            linkedList.addAll(this.activeThreads.values());
        }
        finally {
            this.schedulerLock.unlock();
        }
        for (TaskThread taskThread : linkedList) {
            try {
                taskThread.interruptTask(taskState, string, true);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "interruptRunningTasks", exception));
            }
        }
        if (bl) {
            for (TaskThread taskThread : linkedList) {
                try {
                    taskThread.join();
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "interruptRunningTasks", exception));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block20: {
            assert (Debug.debugEnter(CLASS_NAME, "run", new String[0]));
            this.isRunning = true;
            this.schedulerThread = TaskScheduler.currentThread();
            block8: while (true) {
                while (!this.stopRequested) {
                    this.schedulerLock.lock();
                    boolean bl = false;
                    long l = MAX_SLEEP_TIME;
                    try {
                        Iterator<Task> iterator = this.pendingTasks.iterator();
                        while (iterator.hasNext()) {
                            Task task = iterator.next();
                            TaskState taskState = this.shouldStart(task);
                            if (taskState == TaskState.RUNNING) {
                                TaskThread taskThread;
                                if (this.idleThreads.isEmpty()) {
                                    taskThread = new TaskThread(this, this.nextThreadID++);
                                    taskThread.start();
                                } else {
                                    taskThread = this.idleThreads.removeFirst();
                                }
                                this.runningTasks.add(task);
                                this.activeThreads.put(task.getTaskID(), taskThread);
                                taskThread.setTask(task);
                                iterator.remove();
                                bl = true;
                            } else if (taskState == TaskState.WAITING_ON_START_TIME) {
                                long l2 = task.getScheduledStartTime() - TimeThread.getTime();
                                l = Math.min(l, l2);
                            }
                            if (taskState == task.getTaskState()) continue;
                            task.setTaskState(taskState);
                            bl = true;
                        }
                        long l3 = TimeThread.getTime() - this.taskBackend.getRetentionTime();
                        iterator = this.completedTasks.iterator();
                        while (iterator.hasNext()) {
                            Task task = iterator.next();
                            if (task.getCompletionTime() >= l3) continue;
                            iterator.remove();
                            bl = true;
                        }
                        if (bl) {
                            this.writeState();
                        }
                    }
                    finally {
                        this.schedulerLock.unlock();
                    }
                    try {
                        if (l <= 0L) continue block8;
                        Thread.sleep(l);
                        continue block8;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                break block20;
                {
                    continue block8;
                    break;
                }
                break;
            }
            finally {
                this.isRunning = false;
            }
        }
    }

    private TaskState shouldStart(Task task) {
        assert (Debug.debugEnter(CLASS_NAME, "shouldStart", String.valueOf(task)));
        if (!this.isRunning) {
            return TaskState.UNSCHEDULED;
        }
        if (task.getScheduledStartTime() > TimeThread.getTime()) {
            return TaskState.WAITING_ON_START_TIME;
        }
        LinkedList<String> linkedList = task.getDependencyIDs();
        if (linkedList != null) {
            for (String string : task.getDependencyIDs()) {
                Task task2 = this.tasks.get(string);
                if (task2 == null || TaskState.isDone(task2.getTaskState())) continue;
                return TaskState.WAITING_ON_DEPENDENCY;
            }
        }
        return TaskState.RUNNING;
    }

    private void initializeTasksFromBackingFile() throws InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeTasksFromBackingFile", new String[0]));
        String string = this.taskBackend.getTaskBackingFile();
        try {
            File file = StaticUtils.getFileForPath(string);
            if (!file.exists()) {
                this.createNewTaskBackingFile();
                return;
            }
            LDIFImportConfig lDIFImportConfig = new LDIFImportConfig(string);
            LDIFReader lDIFReader = new LDIFReader(lDIFImportConfig);
            this.taskRootEntry = null;
            this.recurringTaskParentEntry = null;
            this.scheduledTaskParentEntry = null;
            while (true) {
                String string2;
                String string3;
                Object object;
                Entry entry;
                try {
                    entry = lDIFReader.readEntry();
                }
                catch (LDIFException lDIFException) {
                    block25: {
                        assert (Debug.debugException(CLASS_NAME, "initializeTasksFromBackingFile", lDIFException));
                        if (lDIFException.canContinueReading()) {
                            int n = 9699465;
                            object = MessageHandler.getMessage(n, string, lDIFException.getLineNumber(), lDIFException.getMessage());
                            Error.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, (String)object, n);
                            continue;
                        }
                        try {
                            lDIFReader.close();
                        }
                        catch (Exception exception) {
                            if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "initializeTasksFromBackingFile", exception)) break block25;
                            throw new AssertionError();
                        }
                    }
                    int n = 9765002;
                    object = MessageHandler.getMessage(n, string, lDIFException.getLineNumber(), lDIFException.getMessage());
                    throw new InitializationException(n, (String)object);
                }
                if (entry == null) break;
                DN dN = entry.getDN();
                if (dN.equals(this.taskBackend.getTaskRootDN())) {
                    this.taskRootEntry = entry;
                    continue;
                }
                if (dN.equals(this.taskBackend.getRecurringTasksParentDN())) {
                    this.recurringTaskParentEntry = entry;
                    continue;
                }
                if (dN.equals(this.taskBackend.getScheduledTasksParentDN())) {
                    this.scheduledTaskParentEntry = entry;
                    continue;
                }
                DN dN2 = dN.getParent();
                if (dN2 == null) {
                    int n = 9699467;
                    string3 = MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(this.taskBackend.getTaskRootDN()));
                    Error.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, string3, n);
                    continue;
                }
                if (dN2.equals(this.taskBackend.getRecurringTasksParentDN())) {
                    try {
                        object = this.entryToRecurringTask(entry);
                        this.addRecurringTask((RecurringTask)object, false);
                    }
                    catch (DirectoryException directoryException) {
                        assert (Debug.debugException(CLASS_NAME, "initializeTasksFromBackingFile", directoryException));
                        int n = 9699468;
                        string2 = MessageHandler.getMessage(n, String.valueOf(dN), directoryException.getErrorMessage());
                        Error.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, string2, n);
                    }
                    continue;
                }
                if (dN2.equals(this.taskBackend.getScheduledTasksParentDN())) {
                    try {
                        object = this.entryToScheduledTask(entry);
                        if (TaskState.isDone(((Task)object).getTaskState())) {
                            this.completedTasks.add((Task)object);
                            continue;
                        }
                        this.scheduleTask((Task)object, false);
                    }
                    catch (DirectoryException directoryException) {
                        assert (Debug.debugException(CLASS_NAME, "initializeTasksFromBackingFile", directoryException));
                        int n = 9699469;
                        string2 = MessageHandler.getMessage(n, String.valueOf(dN), directoryException.getErrorMessage());
                        Error.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, string2, n);
                    }
                    continue;
                }
                int n = 9699470;
                string3 = MessageHandler.getMessage(n, String.valueOf(dN), string);
                Error.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, string3, n);
            }
            lDIFReader.close();
        }
        catch (IOException iOException) {
            assert (Debug.debugException(CLASS_NAME, "initializeTasksFromBackingFile", iOException));
            int n = 9699471;
            String string4 = MessageHandler.getMessage(n, String.valueOf(string), StaticUtils.stackTraceToSingleLineString(iOException));
            throw new InitializationException(n, string4, iOException);
        }
    }

    private void createNewTaskBackingFile() throws InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "createNewTaskBackingFile", new String[0]));
        String string = this.taskBackend.getTaskBackingFile();
        LDIFExportConfig lDIFExportConfig = new LDIFExportConfig(string, ExistingFileBehavior.OVERWRITE);
        try {
            LDIFWriter lDIFWriter = new LDIFWriter(lDIFExportConfig);
            lDIFWriter.writeComment(MessageHandler.getMessage(9437316), 80);
            this.taskRootEntry = StaticUtils.createEntry(this.taskBackend.getTaskRootDN());
            lDIFWriter.writeEntry(this.taskRootEntry);
            this.scheduledTaskParentEntry = StaticUtils.createEntry(this.taskBackend.getScheduledTasksParentDN());
            lDIFWriter.writeEntry(this.scheduledTaskParentEntry);
            this.recurringTaskParentEntry = StaticUtils.createEntry(this.taskBackend.getRecurringTasksParentDN());
            lDIFWriter.writeEntry(this.recurringTaskParentEntry);
            lDIFWriter.close();
        }
        catch (IOException iOException) {
            assert (Debug.debugException(CLASS_NAME, "createNewTaskBackingFile", iOException));
            int n = 0x940090;
            String string2 = MessageHandler.getMessage(n, string, StaticUtils.stackTraceToSingleLineString(iOException));
            throw new InitializationException(n, string2, iOException);
        }
        catch (LDIFException lDIFException) {
            assert (Debug.debugException(CLASS_NAME, "createNewTaskBackingFile", lDIFException));
            int n = 0x940090;
            String string3 = MessageHandler.getMessage(n, string, lDIFException.getMessage());
            throw new InitializationException(n, string3, lDIFException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeState() {
        assert (Debug.debugEnter(CLASS_NAME, "writeState", new String[0]));
        String string = this.taskBackend.getTaskBackingFile();
        String string2 = string + ".tmp";
        LDIFExportConfig lDIFExportConfig = new LDIFExportConfig(string2, ExistingFileBehavior.OVERWRITE);
        this.schedulerLock.lock();
        try {
            File file;
            block25: {
                LDIFWriter lDIFWriter = new LDIFWriter(lDIFExportConfig);
                lDIFWriter.writeComment(MessageHandler.getMessage(9437316), 80);
                lDIFWriter.writeEntry(this.taskRootEntry);
                lDIFWriter.writeEntry(this.scheduledTaskParentEntry);
                lDIFWriter.writeEntry(this.recurringTaskParentEntry);
                for (RecurringTask object2 : this.recurringTasks.values()) {
                    lDIFWriter.writeEntry(object2.getRecurringTaskEntry());
                }
                for (Task string5 : this.tasks.values()) {
                    lDIFWriter.writeEntry(string5.getTaskEntry());
                }
                lDIFWriter.close();
                file = StaticUtils.getFileForPath(string + ".save");
                try {
                    if (file.exists()) {
                        file.delete();
                    }
                }
                catch (Exception string6) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "writeState", string6)) break block25;
                    throw new AssertionError();
                }
            }
            File file2 = StaticUtils.getFileForPath(string);
            try {
                if (file2.exists()) {
                    file2.renameTo(file);
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "writeState", exception));
                int n = 9568408;
                String string3 = MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(file.getAbsolutePath()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_WARNING, string3, n);
                DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotRenameCurrentTaskFile", n, string3);
            }
            File file3 = StaticUtils.getFileForPath(string2);
            try {
                file3.renameTo(file2);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "writeState", exception));
                int n = 0x940099;
                String string4 = MessageHandler.getMessage(n, String.valueOf(string2), String.valueOf(string), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, string4, n);
                DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotRenameNewTaskFile", n, string4);
            }
        }
        catch (IOException iOException) {
            assert (Debug.debugException(CLASS_NAME, "createNewTaskBackingFile", iOException));
            int n = 9699482;
            String string5 = MessageHandler.getMessage(n, string2, StaticUtils.stackTraceToSingleLineString(iOException));
            Error.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, string5, n);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteTaskFile", n, string5);
        }
        catch (LDIFException lDIFException) {
            assert (Debug.debugException(CLASS_NAME, "createNewTaskBackingFile", lDIFException));
            int n = 9699482;
            String string6 = MessageHandler.getMessage(n, string2, lDIFException.getMessage());
            Error.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, string6, n);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteTaskFile", n, string6);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createNewTaskBackingFile", exception));
            int n = 9699482;
            String string7 = MessageHandler.getMessage(n, string2, StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.TASK, ErrorLogSeverity.SEVERE_ERROR, string7, n);
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteTaskFile", n, string7);
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    public Entry getTaskRootEntry() {
        assert (Debug.debugEnter(CLASS_NAME, "getTaskRootEntry", new String[0]));
        return this.taskRootEntry;
    }

    public Entry getScheduledTaskParentEntry() {
        assert (Debug.debugEnter(CLASS_NAME, "getScheduledTaskParentEntry", new String[0]));
        return this.scheduledTaskParentEntry;
    }

    public Entry getRecurringTaskParentEntry() {
        assert (Debug.debugEnter(CLASS_NAME, "getRecurringTaskParentEntry", new String[0]));
        return this.recurringTaskParentEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task getScheduledTask(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getScheduledTask", String.valueOf(string)));
        this.schedulerLock.lock();
        try {
            Task task = this.tasks.get(string);
            return task;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task getScheduledTask(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getScheduledTask", String.valueOf(dN)));
        this.schedulerLock.lock();
        try {
            for (Task task : this.tasks.values()) {
                if (!dN.equals(task.getTaskEntry().getDN())) continue;
                Task task2 = task;
                return task2;
            }
            Iterator<Task> iterator = null;
            return iterator;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getScheduledTaskEntry(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getScheduledTaskEntry", String.valueOf(dN)));
        this.schedulerLock.lock();
        try {
            for (Task task : this.tasks.values()) {
                Entry entry = task.getTaskEntry();
                if (!dN.equals(entry.getDN())) continue;
                Entry entry2 = entry;
                return entry2;
            }
            Iterator<Task> iterator = null;
            return iterator;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean searchScheduledTasks(SearchOperation searchOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "searchScheduledTasks", String.valueOf(searchOperation)));
        SearchFilter searchFilter = searchOperation.getFilter();
        this.schedulerLock.lock();
        try {
            for (Task task : this.tasks.values()) {
                Entry entry = task.getTaskEntry();
                if (!searchFilter.matchesEntry(entry) || searchOperation.returnEntry(entry, null)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecurringTask getRecurringTask(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getRecurringTask", String.valueOf(string)));
        this.schedulerLock.lock();
        try {
            RecurringTask recurringTask = this.recurringTasks.get(string);
            return recurringTask;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecurringTask getRecurringTask(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getRecurringTask", String.valueOf(dN)));
        this.schedulerLock.lock();
        try {
            for (RecurringTask recurringTask : this.recurringTasks.values()) {
                if (!dN.equals(recurringTask.getRecurringTaskEntry().getDN())) continue;
                RecurringTask recurringTask2 = recurringTask;
                return recurringTask2;
            }
            Iterator<RecurringTask> iterator = null;
            return iterator;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getRecurringTaskEntry(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getRecurringTaskEntry", String.valueOf(dN)));
        this.schedulerLock.lock();
        try {
            for (RecurringTask recurringTask : this.recurringTasks.values()) {
                Entry entry = recurringTask.getRecurringTaskEntry();
                if (!dN.equals(entry.getDN())) continue;
                Entry entry2 = entry;
                return entry2;
            }
            Iterator<RecurringTask> iterator = null;
            return iterator;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean searchRecurringTasks(SearchOperation searchOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "searchRecurringTasks", String.valueOf(searchOperation)));
        SearchFilter searchFilter = searchOperation.getFilter();
        this.schedulerLock.lock();
        try {
            for (RecurringTask recurringTask : this.recurringTasks.values()) {
                Entry entry = recurringTask.getRecurringTaskEntry();
                if (!searchFilter.matchesEntry(entry) || searchOperation.returnEntry(entry, null)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    public Task entryToScheduledTask(Entry entry) throws DirectoryException {
        Task task;
        Class<?> clazz;
        List<Attribute> list;
        assert (Debug.debugEnter(CLASS_NAME, "entryToScheduledTask", String.valueOf(entry)));
        AttributeType attributeType = DirectoryServer.getAttributeType("ds-task-class-name".toLowerCase());
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType("ds-task-class-name");
        }
        if ((list = entry.getAttribute(attributeType)) == null || list.isEmpty()) {
            int n = 9699473;
            String string = MessageHandler.getMessage(n, "ds-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
        }
        if (list.size() > 1) {
            int n = 9699474;
            String string = MessageHandler.getMessage(n, "ds-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
        }
        Attribute attribute = list.get(0);
        LinkedHashSet<AttributeValue> linkedHashSet = attribute.getValues();
        if (linkedHashSet == null || linkedHashSet.isEmpty()) {
            int n = 9699475;
            String string = MessageHandler.getMessage(n, "ds-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, string, n);
        }
        Iterator iterator = linkedHashSet.iterator();
        AttributeValue attributeValue = (AttributeValue)iterator.next();
        if (iterator.hasNext()) {
            int n = 0x940094;
            String string = MessageHandler.getMessage(n, "ds-task-id");
            throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, string, n);
        }
        String string = attributeValue.getStringValue();
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "entryToScheduledTask", exception));
            int n = 9699477;
            String string2 = MessageHandler.getMessage(n, String.valueOf(string), "ds-task-class-name", StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string2, n);
        }
        try {
            task = (Task)clazz.newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "entryToScheduledTask", exception));
            int n = 9699478;
            String string3 = MessageHandler.getMessage(n, String.valueOf(string));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string3, n);
        }
        try {
            task.initializeTaskInternal(this, entry);
        }
        catch (InitializationException initializationException) {
            assert (Debug.debugException(CLASS_NAME, "entryToScheduledTask", initializationException));
            int n = 9699479;
            String string4 = MessageHandler.getMessage(n, String.valueOf(string), initializationException.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string4, n);
        }
        catch (Exception exception) {
            int n = 9699479;
            String string5 = MessageHandler.getMessage(n, String.valueOf(string), StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string5, n);
        }
        task.initializeTask();
        return task;
    }

    public RecurringTask entryToRecurringTask(Entry entry) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "entryToRecurringTask", String.valueOf(entry)));
        return new RecurringTask(this, entry);
    }

    @Override
    public DN getComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getComponentEntryDN", new String[0]));
        return this.taskBackend.getConfigEntryDN();
    }

    @Override
    public String getClassName() {
        assert (Debug.debugEnter(CLASS_NAME, "getClassName", new String[0]));
        return CLASS_NAME;
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        assert (Debug.debugEnter(CLASS_NAME, "getAlerts", new String[0]));
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("org.opends.server.CannotFindRecurringTask", "This alert type will be used to notify administrators if the Directory Server is unable to locate a recurring task definition in order to schedule the next iteration once the previous iteration has completed.");
        linkedHashMap.put("org.opends.server.CannotScheduleRecurringIteration", "This alert type will be used to notify administrators if the Directory Server is unable to schedule an iteration of a recurring task.");
        linkedHashMap.put("org.opends.server.CannotRenameCurrentTaskFile", "This alert type will be used to notify administrators if the Directory Server is unable to rename the current tasks backing file in the process of trying to write an updated version.");
        linkedHashMap.put("org.opends.server.CannotRenameNewTaskFile", "This alert type will be used to notify administrators if the Directory Server is unable to rename the new tasks backing file into place.");
        linkedHashMap.put("org.opends.server.CannotWriteTaskFile", "This alert type will be used to notify administrators if the Directory Server is unable to write an updated tasks backing file for some reason.");
        return linkedHashMap;
    }
}

