/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.io.DataInputStream;
import java.io.IOException;

public class Longs {
    private long[] array = null;
    private int count = 0;

    void decode(byte[] byArray) {
        if (byArray == null) {
            this.count = 0;
            return;
        }
        int n = byArray.length / 8;
        this.resize(n);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            long l = 0L;
            l |= ((long)byArray[n2++] & 0xFFL) << 56;
            l |= ((long)byArray[n2++] & 0xFFL) << 48;
            l |= ((long)byArray[n2++] & 0xFFL) << 40;
            l |= ((long)byArray[n2++] & 0xFFL) << 32;
            l |= ((long)byArray[n2++] & 0xFFL) << 24;
            l |= ((long)byArray[n2++] & 0xFFL) << 16;
            l |= ((long)byArray[n2++] & 0xFFL) << 8;
            this.array[i] = l |= (long)byArray[n2++] & 0xFFL;
        }
        this.count = n;
    }

    public int encodedSize() {
        return this.count * 8;
    }

    byte[] encode(byte[] byArray) {
        int n = this.encodedSize();
        if (byArray == null || byArray.length < n) {
            byArray = new byte[n];
        }
        int n2 = 0;
        for (int i = 0; i < this.count; ++i) {
            long l = this.array[i];
            byArray[n2++] = (byte)(l >>> 56 & 0xFFL);
            byArray[n2++] = (byte)(l >>> 48 & 0xFFL);
            byArray[n2++] = (byte)(l >>> 40 & 0xFFL);
            byArray[n2++] = (byte)(l >>> 32 & 0xFFL);
            byArray[n2++] = (byte)(l >>> 24 & 0xFFL);
            byArray[n2++] = (byte)(l >>> 16 & 0xFFL);
            byArray[n2++] = (byte)(l >>> 8 & 0xFFL);
            byArray[n2++] = (byte)(l & 0xFFL);
        }
        return byArray;
    }

    private static int binarySearch(long[] lArray, int n, long l) {
        int n2 = 0;
        int n3 = n - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            long l2 = lArray[n4];
            if (l2 < l) {
                n2 = n4 + 1;
                continue;
            }
            if (l2 > l) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public boolean add(long l) {
        this.resize(this.count + 1);
        if (this.count == 0 || l > this.array[this.count - 1]) {
            this.array[this.count++] = l;
            return true;
        }
        int n = Longs.binarySearch(this.array, this.count, l);
        if (n >= 0) {
            return false;
        }
        n = -(n + 1);
        System.arraycopy(this.array, n, this.array, n + 1, this.count - n);
        this.array[n] = l;
        ++this.count;
        return true;
    }

    public void addAll(Longs longs) {
        int n;
        this.resize(this.count + longs.count);
        if (longs.count == 0) {
            return;
        }
        if (this.count == 0 || longs.array[0] > this.array[this.count - 1]) {
            System.arraycopy(longs.array, 0, this.array, this.count, longs.count);
            this.count += longs.count;
            return;
        }
        if (this.array[0] > longs.array[longs.count - 1]) {
            System.arraycopy(this.array, 0, this.array, longs.count, this.count);
            System.arraycopy(longs.array, 0, this.array, 0, longs.count);
            this.count += longs.count;
            return;
        }
        int n2 = Longs.binarySearch(this.array, this.count, longs.array[0]);
        if (n2 < 0) {
            n2 = -(n2 + 1);
        }
        int n3 = this.count - n2;
        int n4 = n2 + longs.count;
        int n5 = n4 + n3;
        System.arraycopy(this.array, n2, this.array, n4, n3);
        if (this.array[n4] > longs.array[longs.count - 1]) {
            System.arraycopy(longs.array, 0, this.array, n2, longs.count);
            this.count += longs.count;
            return;
        }
        int n6 = 0;
        while (n4 < n5 && n6 < longs.count) {
            if (this.array[n4] < longs.array[n6]) {
                this.array[n2++] = this.array[n4++];
                continue;
            }
            if (this.array[n4] > longs.array[n6]) {
                this.array[n2++] = longs.array[n6++];
                continue;
            }
            this.array[n2++] = this.array[n4++];
            ++n6;
        }
        int n7 = n5 - n4;
        if (n7 > 0) {
            System.arraycopy(this.array, n4, this.array, n2, n7);
            n2 += n7;
        }
        if ((n = longs.count - n6) > 0) {
            System.arraycopy(longs.array, n6, this.array, n2, n);
            n2 += n;
        }
        this.count = n2;
    }

    public void deleteAll(Longs longs) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.count && n3 < longs.count) {
            if (this.array[n2] < longs.array[n3]) {
                this.array[n++] = this.array[n2++];
                continue;
            }
            if (this.array[n2] > longs.array[n3]) {
                ++n3;
                continue;
            }
            ++n2;
            ++n3;
        }
        System.arraycopy(this.array, n2, this.array, n, this.count - n2);
        this.count = n += this.count - n2;
    }

    public int size() {
        return this.count;
    }

    public void decode(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        int n2 = n / 8;
        this.resize(n2);
        for (int i = 0; i < n2; ++i) {
            this.array[i] = dataInputStream.readLong();
        }
        this.count = n2;
    }

    private void resize(int n) {
        if (this.array == null) {
            this.array = new long[n];
        } else if (this.array.length < n) {
            int n2;
            int n3 = n2 = this.array.length == 0 ? 1 : this.array.length;
            while ((n2 *= 2) < n) {
            }
            long[] lArray = new long[n2];
            System.arraycopy(this.array, 0, lArray, 0, this.count);
            this.array = lArray;
        }
    }

    public void clear() {
        this.count = 0;
    }

    public long[] toArray() {
        long[] lArray = new long[this.count];
        System.arraycopy(this.array, 0, lArray, 0, this.count);
        return lArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.count);
        if (this.count > 0) {
            stringBuilder.append('[');
            stringBuilder.append(this.array[0]);
            if (this.count > 1) {
                stringBuilder.append(':');
                stringBuilder.append(this.array[this.count - 1]);
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }
}

