/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.opends.server.api.DirectoryThread;
import org.opends.server.backends.jeb.Config;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.backends.jeb.Longs;
import org.opends.server.backends.jeb.MergeReader;
import org.opends.server.backends.jeb.MergeValue;
import org.opends.server.backends.jeb.OctetStringKeyComparator;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.LDIFImportConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexMergeThread
extends DirectoryThread {
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.IndexMergeThread";
    private static final int INPUT_STREAM_BUFFER_SIZE = 65536;
    Config config;
    LDIFImportConfig ldifImportConfig;
    Indexer indexer;
    Index index;
    int entryLimit;
    String indexName;
    private boolean replaceExisting = false;
    private WeakHashMap<Integer, LinkedList<byte[]>> arrayMap = new WeakHashMap();
    private FilenameFilter filter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return string.startsWith(IndexMergeThread.this.indexName);
        }
    };

    IndexMergeThread(String string, Config config, LDIFImportConfig lDIFImportConfig, Index index, int n) {
        super("Index Merge Thread " + string);
        this.indexName = string;
        this.config = config;
        this.ldifImportConfig = lDIFImportConfig;
        this.indexer = index.indexer;
        this.index = index;
        this.entryLimit = n;
        this.replaceExisting = lDIFImportConfig.appendToExistingData() && lDIFImportConfig.replaceExistingEntries();
    }

    @Override
    public void run() {
        block2: {
            try {
                this.merge();
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "run", exception)) break block2;
                throw new AssertionError();
            }
        }
    }

    public void merge() throws Exception {
        OctetStringKeyComparator octetStringKeyComparator = new OctetStringKeyComparator(this.indexer.getComparator());
        TreeMap<ASN1OctetString, MergeValue> treeMap = new TreeMap<ASN1OctetString, MergeValue>(octetStringKeyComparator);
        File file = new File(this.config.getImportTempDirectory());
        File[] fileArray = file.listFiles(this.filter);
        if (fileArray == null || fileArray.length == 0) {
            int n = 8388706;
            String string = MessageHandler.getMessage(n, this.indexName);
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n);
            return;
        }
        int n = 8388707;
        String string = MessageHandler.getMessage(n, fileArray.length, this.indexName);
        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n);
        MergeReader[] mergeReaderArray = new MergeReader[fileArray.length];
        Transaction transaction = null;
        DatabaseEntry databaseEntry = new DatabaseEntry();
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        byte[] byArray = new byte[]{};
        Longs longs = new Longs();
        try {
            try {
                Object object;
                Object object2;
                Database database = this.index.getDatabase();
                for (int i = 0; i < fileArray.length; ++i) {
                    object2 = new BufferedInputStream(new FileInputStream(fileArray[i]), 65536);
                    object = new DataInputStream((InputStream)object2);
                    mergeReaderArray[i] = new MergeReader((DataInputStream)object);
                    this.readNext(treeMap, mergeReaderArray, i);
                }
                try {
                    block7: while (true) {
                        LinkedList<Object> linkedList;
                        block31: {
                            List<Longs> list;
                            List<Longs> list2;
                            block30: {
                                ASN1OctetString aSN1OctetString = treeMap.firstKey();
                                object2 = (MergeValue)treeMap.remove(aSN1OctetString);
                                object = ((MergeValue)object2).getKey();
                                databaseEntry.setData(object);
                                list2 = ((MergeValue)object2).getAddValues();
                                list = ((MergeValue)object2).getDelValues();
                                longs.clear();
                                if (!this.ldifImportConfig.appendToExistingData() || database.get(transaction, databaseEntry, databaseEntry2, LockMode.RMW) != OperationStatus.SUCCESS) break block30;
                                if (databaseEntry2.getSize() == 0) break block31;
                                longs.decode(databaseEntry2.getData());
                            }
                            for (Longs longs2 : list2) {
                                longs.addAll(longs2);
                            }
                            if (this.replaceExisting) {
                                for (Longs longs2 : list) {
                                    longs.deleteAll(longs2);
                                }
                            }
                            if (longs.size() > this.entryLimit) {
                                this.index.writeKey(transaction, databaseEntry, new EntryIDSet());
                            } else {
                                byArray = longs.encode(byArray);
                                databaseEntry2.setData(byArray);
                                databaseEntry2.setSize(longs.encodedSize());
                                database.put(transaction, databaseEntry, databaseEntry2);
                            }
                            linkedList = this.arrayMap.get(((byte[])object).length);
                            if (linkedList == null) {
                                linkedList = new LinkedList();
                                this.arrayMap.put(((byte[])object).length, linkedList);
                            }
                            linkedList.add(object);
                        }
                        linkedList = (LinkedList<Object>)((MergeValue)object2).getReaders();
                        int n2 = ((Object)linkedList).length;
                        int n3 = 0;
                        while (true) {
                            if (n3 >= n2) continue block7;
                            Object object3 = linkedList[n3];
                            this.readNext(treeMap, mergeReaderArray, (int)object3);
                            ++n3;
                        }
                        break;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    Object var24_29 = null;
                    if (mergeReaderArray != null) {
                        for (MergeReader object4 : mergeReaderArray) {
                            if (object4 == null) continue;
                            object4.dataInputStream.close();
                        }
                    }
                    if (fileArray != null) {
                        for (File file2 : fileArray) {
                            file2.delete();
                        }
                    }
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "run", exception));
                exception.printStackTrace();
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var24_30 = null;
            if (mergeReaderArray != null) {
                for (MergeReader mergeReader : mergeReaderArray) {
                    if (mergeReader == null) continue;
                    mergeReader.dataInputStream.close();
                }
            }
            if (fileArray != null) {
                for (File file3 : fileArray) {
                    file3.delete();
                }
            }
            throw throwable;
        }
        n = 8388708;
        string = MessageHandler.getMessage(n, this.indexName);
        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n);
    }

    private void readNext(TreeMap<ASN1OctetString, MergeValue> treeMap, MergeReader[] mergeReaderArray, int n) throws IOException {
        ASN1OctetString aSN1OctetString;
        MergeValue mergeValue;
        byte[] byArray;
        int n2;
        MergeReader mergeReader = mergeReaderArray[n];
        DataInputStream dataInputStream = mergeReader.dataInputStream;
        try {
            n2 = dataInputStream.readInt();
        }
        catch (EOFException eOFException) {
            return;
        }
        LinkedList<Object> linkedList = this.arrayMap.get(n2);
        if (linkedList == null) {
            byArray = new byte[n2];
            linkedList = new LinkedList();
            this.arrayMap.put(n2, linkedList);
        } else {
            byArray = linkedList.isEmpty() ? new byte[n2] : linkedList.removeFirst();
        }
        dataInputStream.readFully(byArray);
        Longs longs = mergeReader.addData;
        longs.decode(dataInputStream);
        Longs longs2 = mergeReader.delData;
        if (this.replaceExisting) {
            longs2.decode(dataInputStream);
        }
        if ((mergeValue = treeMap.get(aSN1OctetString = new ASN1OctetString(byArray))) == null) {
            mergeValue = new MergeValue(mergeReaderArray.length, this.entryLimit);
            mergeValue.setKey(byArray);
            treeMap.put(aSN1OctetString, mergeValue);
        } else {
            linkedList.add(byArray);
        }
        mergeValue.mergeData(n, longs, longs2);
    }
}

