/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.opends.server.api.DirectoryThread;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.DN2URI;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.ImportContext;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.IndexBuilder;
import org.opends.server.backends.jeb.IndexConfig;
import org.opends.server.loggers.Debug;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Entry;

public class ImportThread
extends DirectoryThread {
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.ImportThread";
    private ImportContext importContext;
    private EntryContainer entryContainer;
    private ID2Entry id2entry;
    private DN2URI dn2uri;
    private ArrayList<IndexBuilder> builders = new ArrayList();
    private BlockingQueue<Entry> queue;
    private int importedCount = 0;
    private int entryInsertCount = 0;
    private boolean stopRequested = false;

    public ImportThread(ImportContext importContext, int n) {
        super("Import Worker Thread " + n);
        this.importContext = importContext;
        this.entryContainer = importContext.getEntryContainer();
        this.queue = importContext.getQueue();
        this.id2entry = this.entryContainer.getID2Entry();
        this.dn2uri = this.entryContainer.getDN2URI();
    }

    public int getImportedCount() {
        return this.importedCount;
    }

    public void stopProcessing() {
        this.stopRequested = true;
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        block21: {
            Iterator<IndexBuilder> databaseException;
            Object object;
            Map<AttributeType, IndexConfig> map = this.importContext.getConfig().getIndexConfigMap();
            int n = 0;
            n += 2;
            for (IndexConfig indexConfig : map.values()) {
                if (indexConfig.isEqualityIndex()) {
                    ++n;
                }
                if (indexConfig.isPresenceIndex()) {
                    ++n;
                }
                if (indexConfig.isSubstringIndex()) {
                    ++n;
                }
                if (!indexConfig.isOrderingIndex()) continue;
                ++n;
            }
            long l = this.importContext.getBufferSize() / (long)n;
            for (IndexConfig object22 : map.values()) {
                object = this.entryContainer.getAttributeIndex(object22.getAttributeType());
                if (object22.isEqualityIndex()) {
                    databaseException = new IndexBuilder(this.importContext, ((AttributeIndex)object).equalityIndex, object22.getEqualityEntryLimit(), l);
                    this.builders.add((IndexBuilder)((Object)databaseException));
                }
                if (object22.isPresenceIndex()) {
                    databaseException = new IndexBuilder(this.importContext, ((AttributeIndex)object).presenceIndex, object22.getPresenceEntryLimit(), l);
                    this.builders.add((IndexBuilder)((Object)databaseException));
                }
                if (object22.isSubstringIndex()) {
                    databaseException = new IndexBuilder(this.importContext, ((AttributeIndex)object).substringIndex, object22.getSubstringEntryLimit(), l);
                    this.builders.add((IndexBuilder)((Object)databaseException));
                }
                if (!object22.isOrderingIndex()) continue;
                databaseException = new IndexBuilder(this.importContext, ((AttributeIndex)object).orderingIndex, object22.getEqualityEntryLimit(), l);
                this.builders.add((IndexBuilder)((Object)databaseException));
            }
            Index index = this.entryContainer.getID2Children();
            IndexBuilder indexBuilder = new IndexBuilder(this.importContext, index, this.importContext.getConfig().getBackendIndexEntryLimit(), l);
            this.builders.add(indexBuilder);
            object = this.entryContainer.getID2Subtree();
            IndexBuilder indexBuilder2 = new IndexBuilder(this.importContext, (Index)object, this.importContext.getConfig().getBackendIndexEntryLimit(), l);
            this.builders.add(indexBuilder2);
            for (IndexBuilder indexBuilder3 : this.builders) {
                indexBuilder3.startProcessing();
            }
            try {
                do {
                    Entry entry;
                    try {
                        entry = this.queue.poll(1000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException iOException) {
                        assert (Debug.debugException(CLASS_NAME, "run", iOException));
                        continue;
                    }
                    if (entry == null) continue;
                    databaseException = null;
                    Object var10_17 = null;
                    EntryID entryID = null;
                    if (entry.getAttachment() instanceof Entry) {
                        Entry entry2 = (Entry)entry.getAttachment();
                        entryID = (EntryID)entry2.getAttachment();
                        this.dn2uri.replaceEntry((Transaction)databaseException, entry2, entry);
                    } else {
                        Object var10_19 = null;
                        ArrayList arrayList = (ArrayList)entry.getAttachment();
                        entryID = (EntryID)arrayList.get(0);
                        ++this.entryInsertCount;
                        this.dn2uri.addEntry((Transaction)databaseException, entry);
                    }
                    this.id2entry.put((Transaction)databaseException, entryID, entry);
                    for (IndexBuilder indexBuilder4 : this.builders) {
                        void var10_20;
                        indexBuilder4.processEntry((Entry)var10_20, entry, entryID);
                    }
                    ++this.importedCount;
                } while (!this.stopRequested);
                for (IndexBuilder indexBuilder5 : this.builders) {
                    indexBuilder5.stopProcessing();
                }
                this.importContext.incrEntryInsertCount(this.entryInsertCount);
            }
            catch (DatabaseException databaseException2) {
                assert (Debug.debugException(CLASS_NAME, "run", databaseException2));
            }
            catch (IOException iOException) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "run", iOException)) break block21;
                throw new AssertionError();
            }
        }
    }
}

